/*
 * objectselectionitem.h
 * Copyright 2015, Thorbjørn Lindeijer <bjorn@lindeijer.nl>
 *
 * This file is part of Tiled.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TILED_INTERNAL_OBJECTSELECTIONITEM_H
#define TILED_INTERNAL_OBJECTSELECTIONITEM_H

#include <QGraphicsObject>
#include <QHash>

namespace Tiled {

class MapObject;

namespace Internal {

class MapDocument;
class MapObjectLabel;
class MapObjectOutline;

class ObjectSelectionItem : public QGraphicsObject
{
    Q_OBJECT

public:
    ObjectSelectionItem(MapDocument *mapDocument);

    // QGraphicsItem interface
    QRectF boundingRect() const override { return QRectF(); }
    void paint(QPainter *, const QStyleOptionGraphicsItem *, QWidget *) override {}


private slots:
    void selectedObjectsChanged();
    void mapChanged();
    void layerChanged(int index);
    void syncOverlayItems(const QList<MapObject *> &objects);

    void objectLabelVisibilityChanged();

private:
    void addRemoveObjectLabels();
    void addRemoveObjectOutlines();

    MapDocument *mMapDocument;
    QHash<MapObject*, MapObjectLabel*> mObjectLabels;
    QHash<MapObject*, MapObjectOutline*> mObjectOutlines;
};

} // namespace Internal
} // namespace Tiled

#endif // TILED_INTERNAL_OBJECTSELECTIONITEM_H
