/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import org.apache.derby.client.am.BatchUpdateException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.CrossConverters;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;

public abstract class Agent {
    public SqlException accumulatedReadExceptions_ = null;
    private boolean enableBatchedExceptionTracking_;
    private int batchedExceptionLabelIndex_;
    private boolean[] batchedExceptionGenerated_;
    Connection connection_;
    public SectionManager sectionManager_ = null;
    public LogWriter logWriter_ = null;
    final CrossConverters crossConverters_;
    SqlException deferredException_;

    void checkForDeferredExceptions() throws SqlException {
        if (this.deferredException_ != null) {
            SqlException sqlException = this.deferredException_;
            this.deferredException_ = null;
            throw sqlException;
        }
    }

    public void accumulateDeferredException(SqlException sqlException) {
        if (this.deferredException_ == null) {
            this.deferredException_ = sqlException;
        } else {
            this.deferredException_.setNextException(sqlException);
        }
    }

    protected Agent(Connection connection, LogWriter logWriter) {
        this.connection_ = connection;
        this.logWriter_ = logWriter;
        this.crossConverters_ = new CrossConverters(this);
    }

    protected void resetAgent(LogWriter logWriter) {
        this.accumulatedReadExceptions_ = null;
        this.enableBatchedExceptionTracking_ = false;
        this.batchedExceptionLabelIndex_ = 0;
        this.batchedExceptionGenerated_ = null;
        this.logWriter_ = logWriter;
        this.deferredException_ = null;
    }

    public void resetAgent(Connection connection, LogWriter logWriter, int n, String string, int n2) throws SqlException {
        this.resetAgent(logWriter);
        this.resetAgent_(logWriter, n, string, n2);
    }

    protected abstract void resetAgent_(LogWriter var1, int var2, String var3, int var4) throws SqlException;

    public final boolean loggingEnabled() {
        return !Configuration.traceSuspended__ && this.logWriter_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogWriter(LogWriter logWriter) {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.logWriter_ != null) {
                this.logWriter_.close();
            }
            this.logWriter_ = logWriter;
        }
    }

    public final PrintWriter getLogWriter() {
        return this.logWriter_ == null ? null : this.logWriter_.printWriter_;
    }

    public abstract LogWriter newLogWriter_(PrintWriter var1, int var2);

    public final void accumulateReadException(SqlException sqlException) {
        if (this.enableBatchedExceptionTracking_) {
            this.batchedExceptionGenerated_[this.batchedExceptionLabelIndex_] = true;
            this.labelAsBatchedException(sqlException, this.batchedExceptionLabelIndex_);
        }
        if (this.accumulatedReadExceptions_ == null) {
            this.accumulatedReadExceptions_ = sqlException;
        } else {
            this.accumulatedReadExceptions_.setNextException(sqlException);
        }
    }

    public final void accumulateDisconnectException(DisconnectException disconnectException) {
        if (this.enableBatchedExceptionTracking_) {
            this.batchedExceptionGenerated_[this.batchedExceptionLabelIndex_] = true;
            this.labelAsBatchedException(disconnectException, this.batchedExceptionLabelIndex_);
        }
        if (this.accumulatedReadExceptions_ != null) {
            disconnectException.setNextException(this.accumulatedReadExceptions_);
        }
        this.accumulatedReadExceptions_ = null;
    }

    public final void accumulateChainBreakingReadExceptionAndThrow(DisconnectException disconnectException) throws DisconnectException {
        this.accumulateDisconnectException(disconnectException);
        this.markChainBreakingException_();
        throw disconnectException;
    }

    protected abstract void markChainBreakingException_();

    public abstract void checkForChainBreakingException_() throws SqlException;

    private final void enableBatchedExceptionTracking(int n) {
        this.enableBatchedExceptionTracking_ = true;
        this.batchedExceptionGenerated_ = new boolean[n];
        this.batchedExceptionLabelIndex_ = 0;
    }

    final void disableBatchedExceptionTracking() {
        this.enableBatchedExceptionTracking_ = false;
    }

    public final void setBatchedExceptionLabelIndex(int n) {
        this.batchedExceptionLabelIndex_ = n;
    }

    private final SqlException labelAsBatchedException(SqlException sqlException, int n) {
        SqlException sqlException2 = sqlException;
        while (sqlException != null) {
            sqlException.setBatchPositionLabel(n);
            sqlException = sqlException.getNextException();
        }
        return sqlException2;
    }

    protected final void checkForExceptions() throws SqlException {
        if (this.accumulatedReadExceptions_ != null) {
            SqlException sqlException = this.accumulatedReadExceptions_;
            this.accumulatedReadExceptions_ = null;
            throw sqlException;
        }
    }

    final boolean batchUpdateExceptionGenerated() {
        return this.batchedExceptionGenerated_[this.batchedExceptionLabelIndex_];
    }

    public final void flow(Statement statement) throws SqlException {
        this.endWriteChain();
        this.flush_();
        this.beginReadChain(statement);
    }

    public final void flowBatch(Statement statement, int n) throws SqlException {
        this.endBatchedWriteChain();
        this.flush_();
        this.beginBatchedReadChain(statement, n);
    }

    public final void flowOutsideUOW() throws SqlException {
        this.endWriteChain();
        this.flush_();
        this.beginReadChainOutsideUOW();
    }

    public abstract void flush_() throws DisconnectException;

    public abstract void close_() throws SqlException;

    public void close() throws SqlException {
        this.close_();
        if (this.logWriter_ != null) {
            this.logWriter_.close();
        }
    }

    public final void disconnectEvent() {
        try {
            this.close();
        }
        catch (SqlException sqlException) {
            // empty catch block
        }
        this.connection_.completeChainBreakingDisconnect();
    }

    public void beginWriteChainOutsideUOW() throws SqlException {
    }

    public void beginWriteChain(Statement statement) throws SqlException {
        this.connection_.writeTransactionStart(statement);
    }

    public final void beginBatchedWriteChain(Statement statement) throws SqlException {
        this.beginWriteChain(statement);
    }

    protected void endWriteChain() {
    }

    protected final void endBatchedWriteChain() {
    }

    protected void beginReadChain(Statement statement) throws SqlException {
        this.connection_.readTransactionStart();
    }

    protected final void beginBatchedReadChain(Statement statement, int n) throws SqlException {
        this.enableBatchedExceptionTracking(n);
        this.beginReadChain(statement);
    }

    protected void beginReadChainOutsideUOW() throws SqlException {
    }

    public void endReadChain() throws SqlException {
        this.checkForExceptions();
    }

    public final void endBatchedReadChain(int[] nArray, SqlException sqlException) throws BatchUpdateException {
        this.disableBatchedExceptionTracking();
        for (int i = 0; i < this.batchedExceptionGenerated_.length; ++i) {
            if (!this.batchedExceptionGenerated_[i]) continue;
            nArray[i] = -3;
        }
        if (sqlException == null) {
            try {
                this.endReadChain();
            }
            catch (SqlException sqlException2) {
                sqlException = sqlException2;
            }
        }
        if (sqlException != null) {
            BatchUpdateException batchUpdateException = new BatchUpdateException(this.logWriter_, new ClientMessageId("XJ208.S"), nArray);
            batchUpdateException.setNextException(sqlException.getSQLException());
            throw batchUpdateException;
        }
    }
}

