/*
 * Copyright (C) 2009-2010  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */

#ifndef DEBUGGERTHREAD_H
#define DEBUGGERTHREAD_H

#include <QObject>
#include <QThread>
#include <QString>

#include <sstream>

#include <srchilite/highlighteventlistener.h>

namespace srchilite {
    class HighlightEvent;
    class SourceHighlight;
    class ParserException;
}

class QMutex;
class StepConditionVariable;

/**
  * The thread listening for highlighting events when debugging.
  *
  * IMPORTANT: this thread must not access the UI (only the UI thread can).
  * All information about debugging will be emitted as signals; also
  * possible exceptions during highlighting.
  */
class DebuggerThread : public QThread, public srchilite::HighlightEventListener
{
      Q_OBJECT
public:
    DebuggerThread(srchilite::SourceHighlight *sourcehighlight_,
                   const QString &langDefFile_,
                   const QString &contents, std::ostringstream *os,
                   QMutex *mutex_, StepConditionVariable *waitCondVariable_);

    virtual void notify(const srchilite::HighlightEvent &event);

public slots:
    void stepDebugging();
    void stopDebugging();

signals:
    void debuggerFileInfo(const QString &file, int line);
    void debuggerRegex(const QString &regex);
    void highlightedSomething();
    void highlightException(const QString &ex);

protected:
    void run();

private:
    void waitForStep();

    srchilite::SourceHighlight *sourcehighlight;

    QString langDefFile;

    QString contentsToHighlight;

    std::istringstream inputBuffer;

    std::ostringstream *outputBuffer;

    QMutex *mutex;

    StepConditionVariable *waitCondVariable;

};

#endif // DEBUGGERTHREAD_H
