8.2 Accords

# Accords

Sonic Pi incorpore le support des noms d'accord, lequel retourne des 
listes. Essayez-le vous-même :

```
play chord(:E3, :minor)
```

Maintenant, nous avons vraiment progressé. Ça parait beaucoup plus 
joli que les listes brutes (et c'est plus facile à lire pour les 
autres). Alors quels autres accords Sonic Pi supporte-t-il ? Eh bien, 
un *tas*. Essayez quelques uns parmi ceux-ci :

* `chord(:E3, :m7)`
* `chord(:E3, :minor)`
* `chord(:E3, :dim7)`
* `chord(:E3, :dom7)`

## Arpèges

Nous pouvons facilement changer les accords en arpèges avec la fonction 
`play_pattern` :

```
play_pattern chord(:E3, :m7)
```

OK, ce n'est pas si plaisant - ça le joue vraiment lentement. 
`play_pattern` va jouer chaque note de la liste en le séparant par un 
appel à `sleep 1` entre chaque appel à `play`. Nous pouvons utiliser 
une autre fonction `play_pattern_timed` pour spécifier nos propres 
durées et accélérer les choses :

```
play_pattern_timed chord(:E3, :m7), 0.25
```

Nous pouvons même passer une liste de durées qui seront traitées de 
façon circulaire :

```
play_pattern_timed chord(:E3, :m13), [0.25, 0.5]
```

Ceci est équivalent à :

```
play 52
sleep 0.25
play 55
sleep 0.5
play 59
sleep 0.25
play 62
sleep 0.5
play 66
sleep 0.25
play 69
sleep 0.5
play 73
```

Que préférez-vous écrire ?
