9.3 Múltiples Bucles en Vivo

# Múltiples Bucles en Vivo 

Considera el siguiente bucle en vivo:

```
live_loop :foo do
  play 50
  sleep 1
end
```
Quizás te preguntas el por qué es importante el nombre `foo`, la respuesta
es que es importante porque significa que este bucle es diferente de TODOS
los otros.

*Nunca pueden haber dos bucles en vivo con el mismo nombre ejecutándose
simultáneamente* 

Esto significa que si queremos múltiples bucles concurrentes, debemos darles
diferentes nombres:

```
live_loop :foo do
  use_synth :prophet
  play :c1, release: 8, cutoff: rrand(70, 130)
  sleep 8
end

live_loop :bar do
  sample :bd_haus
  sleep 0.5
end
```

Ahora puedes actualizar y cambiar cada bucle independientemente y
funcionará siempre.

## Sincronizando bucles en vivo

Una cosa que ya habrás notado es que los bucles en vivo trabajan
automáticamente automáticamente con el mecanismo de marca de hilos
que exploramos anteriormente. Cada bucle en vivo genera un evento `cue`
Gracias a ello podemos sincronizarlos para asegurar bucles sin pausa.

Considera este código mal sincronizado:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.4
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

Veamos si podemos arreglar el timing y sincronizar sin parar. Primero,
arreglemos el bucle `:foo` para hacer el factor de sleep 1 a algo como
`0.5`:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sample :bd_haus
  sleep 1
end
```

Todavía no terminamos, pues notarás que los pulsos no se alinean correctamente.
Esto se debe a que los bucles están desfasados *out of phase*. Arreglemos Esto
sincronizándolos entre sí:

```
live_loop :foo do
  play :e4, release: 0.5
  sleep 0.5
end

live_loop :bar do
  sync :foo
  sample :bd_haus
  sleep 1
end
```

¡Wow, todo está sincronizado ahora y sin parar!

¡Ahora ve y codifica en vivo con bucles en vivo!
