% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\docType{class}
\name{TargetingModel-class}
\alias{TargetingModel-class}
\alias{TargetingModel}
\alias{plot,TargetingModel,missing-method}
\alias{TargetingModel-method}
\title{S4 class defining a targeting model}
\usage{
\S4method{plot}{TargetingModel,missing}(x, y, ...)
}
\arguments{
\item{x}{\code{TargetingModel} object.}

\item{y}{ignored.}

\item{...}{arguments to pass to \link{plotMutability}.}
}
\description{
\code{TargetingModel} defines a common data structure for mutability, substitution and
targeting of immunoglobulin (Ig) sequencing data in a 5-mer microsequence context.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the model.}

\item{\code{description}}{Description of the model and its source data.}

\item{\code{species}}{Genus and species of the source sequencing data.}

\item{\code{date}}{Date the model was built.}

\item{\code{citation}}{Publication source.}

\item{\code{substitution}}{Normalized rates of the center nucleotide of a given 5-mer 
mutating to a different nucleotide. The substitution model 
is stored as a 5x3125 matrix of rates. Rows define
the mutated nucleotide at the center of each 5-mer, one of 
\code{c("A", "C", "G", "T", "N")}, and columns define the 
complete 5-mer of the unmutated nucleotide sequence.}

\item{\code{mutability}}{Normalized rates of a given 5-mer being mutated. The 
mutability model is stored as a numeric vector of length 3125 
with mutability rates for each 5-mer. Note that "normalized" 
means that the mutability rates for the 1024 5-mers that 
contain no "N" at any position sums up to 1 (as opposed to 
the entire vector summing up to 1).}

\item{\code{targeting}}{Rate matrix of a given mutation occurring, defined as 
\eqn{mutability * substitution}. The targeting model 
is stored as a 5x3125 matrix. Rows define
the mutated nucleotide at the center of each 5-mer, one of 
\code{c("A", "C", "G", "T", "N")}, and columns define the complete 5-mer 
of the unmutated nucleotide sequence.}

\item{\code{numMutS}}{number indicating the number of silent mutations used for 
estimating mutability.}

\item{\code{numMutR}}{number indicating the number of replacement mutations used 
for estimating mutability.}
}}

\seealso{
See \link{createTargetingModel} building models from sequencing data.
}
