/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __GLOBAL__
#define __GLOBAL__

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>

//types scalaires de base
typedef int Entier;
typedef double Reel;
typedef char Caractere;
typedef char* Chaine;
typedef char* Texte;
typedef void* Pointeur;

//precision sur certains concepts

typedef Entier Indice;
typedef Entier Taille;
typedef Entier IdNoeud;
typedef char* NomNoeud;
//identifiant lisible d'un noeud
typedef Entier IdIdee;
//indice dans la liste d'idees et identifiant d'une idee
typedef Entier Pertinence;
//sert a quantifier la pertinence d'une liaison dans un graphe
typedef Entier NiveauHierarchique;
//precise le niveau hierarchique d'un noeud d'un graphe
//cela a une consequence sur la sortie du plan

typedef Chaine NomFichier;
//Nom de fichier, avec le chemin.

typedef FILE* DescripteurFichier;
//Descripteur de fichier, utilis pour les entres sorties.

typedef Chaine NomOption;
//Nom d'option.

typedef Chaine NomMacro;
//Nom de macro.

typedef Chaine Label;
//Label utilis dans la commande de slection d'options.

//types particuliers
typedef enum {RESULTAT_OK , RESULTAT_ERREUR , RESULTAT_ERREUR_DEPASSEMENT , RESULTAT_ERREUR_DOMAINE , RESULTAT_ERREUR_MEMOIRE , RESULTAT_ERREUR_TAILLE , RESULTAT_ERREUR_NONTROUVE , RESULTAT_ERREUR_PASORPHELINES , RESULTAT_ERREUR_TROPORPHELINES , RESULTAT_ERREUR_PASDIDEES} Resultat;

typedef enum {FAUX , VRAI} Booleen;

typedef enum {IDEE_VIDE , IDEE_PRESENTE , IDEE_MANQUANTE , IDEE_GENERIQUE , IDEE_RACINE} TypeIdee;

typedef enum {REFERENCE_INDEFINIE , REFERENCE_REDUCTIBLE , REFERENCE_IRREDUCTIBLE} TypeReference;

typedef struct
{
	Indice referencesreductibles;
	Indice referencesirreductibles;
} References;

typedef struct
{
	Indice nombreideestotal;
	Indice nombreideesmanquantes;
	Indice nombreideesgeneralites;
	Indice nombrereferencestotal;
	Indice nombrereferencesirreductibles;
} Statistiques;

//raz le bol...
#define DEBUTZONESECURISEE	{ Resultat _resultat_;
#define SECURISE(appel)	if((_resultat_=(appel))!=RESULTAT_OK) return _resultat_
// /!\ au ;
#define FINZONESECURISEE	}

#endif
