************************************************************************
* This file is part of OpenMolcas.                                     *
*                                                                      *
* OpenMolcas is free software; you can redistribute it and/or modify   *
* it under the terms of the GNU Lesser General Public License, v. 2.1. *
* OpenMolcas is distributed in the hope that it will be useful, but it *
* is provided "as is" and without any express or implied warranties.   *
* For more details see the full text of the license in the file        *
* LICENSE or in <http://www.gnu.org/licenses/>.                        *
*                                                                      *
* Copyright (C) 2004, Alexander Wolf                                   *
*               2004,2007, Markus Reiher                               *
************************************************************************
      subroutine u_create (uused,unumber,utimes,uorder,umult,u,uscrleng,
     *                     uscrchar,no_u)
c
c******************************************************************************
c
c   This SR belongs to dkhparser_symbolic (dkhparser1).
c
c   written by:  Alexander Wolf and Markus Reiher  (Univ. Jena)
c
c   version:  2.1.0
c
c   last modified: 15.01.2007 (M. Reiher, ETH Zurich)
c
c   first version: 10.04.2004  (Theoretical Chemistry, Univ. Bonn)
c
c******************************************************************************
c
      implicit none
#include "dkhparameters.fh"
c
      integer uused,unumber,utimes(maxunumber),uorder(maxunumber,3),
     *        umult(maxunumber),uscrleng(maxunumber)
      character*(4) u(maxunumber)
      character*(3) uscrchar(maxunumber)
c
      integer j,k
      character*(3) dkh_int2char
      logical no_u
c
c
      if (no_u) then
        uused=0
      else
        uused=484
      end if
      do 10 j=1,uused
        utimes(j)=0
        umult(j)=0
        u(j)='    '
        uscrchar(j)='   '
        uscrleng(j)=0
  10  continue
      unumber=0
      do 20 j=1,uused
        u(j)(1:4)='U'//dkh_int2char(j)
 20   continue
      uscrchar(1)  ='VQV'
      uscrchar(2)  ='VQN'
      uscrchar(3)  ='VQF'
      uscrchar(4)  ='VQG'
      uscrchar(5)  ='VQD'
      uscrchar(6)  ='VQY'
      uscrchar(7)  ='VQX'
      uscrchar(8)  ='VQI'
      uscrchar(9)  ='VQJ'
      uscrchar(10) ='VQK'
      uscrchar(11) ='VQL'
      uscrchar(12) ='VQM'
      uscrchar(13) ='VZV'
      uscrchar(14) ='VZN'
      uscrchar(15) ='VZF'
      uscrchar(16) ='VZG'
      uscrchar(17) ='VZD'
      uscrchar(18) ='VZY'
      uscrchar(19) ='VZX'
      uscrchar(20) ='VZI'
      uscrchar(21) ='VZJ'
      uscrchar(22) ='VZK'
      uscrchar(23) ='VZL'
      uscrchar(24) ='VZM'
      uscrchar(25) ='FQV'
      uscrchar(26) ='FQN'
      uscrchar(27) ='FQF'
      uscrchar(28) ='FQG'
      uscrchar(29) ='FQD'
      uscrchar(30) ='FQY'
      uscrchar(31) ='FQX'
      uscrchar(32) ='FQI'
      uscrchar(33) ='FQJ'
      uscrchar(34) ='FQK'
      uscrchar(35) ='FQL'
      uscrchar(36) ='FQM'
      uscrchar(37) ='FZV'
      uscrchar(38) ='FZN'
      uscrchar(39) ='FZF'
      uscrchar(40) ='FZG'
      uscrchar(41) ='FZD'
      uscrchar(42) ='FZY'
      uscrchar(43) ='FZX'
      uscrchar(44) ='FZI'
      uscrchar(45) ='FZJ'
      uscrchar(46) ='FZK'
      uscrchar(47) ='FZL'
      uscrchar(48) ='FZM'
      uscrchar(49) ='DQV'
      uscrchar(50) ='DQN'
      uscrchar(51) ='DQF'
      uscrchar(52) ='DQG'
      uscrchar(53) ='DQD'
      uscrchar(54) ='DQY'
      uscrchar(55) ='DQX'
      uscrchar(56) ='DQI'
      uscrchar(57) ='DQJ'
      uscrchar(58) ='DQK'
      uscrchar(59) ='DQL'
      uscrchar(60) ='DQM'
      uscrchar(61) ='DZV'
      uscrchar(62) ='DZN'
      uscrchar(63) ='DZF'
      uscrchar(64) ='DZG'
      uscrchar(65) ='DZD'
      uscrchar(66) ='DZY'
      uscrchar(67) ='DZX'
      uscrchar(68) ='DZI'
      uscrchar(69) ='DZJ'
      uscrchar(70) ='DZK'
      uscrchar(71) ='DZL'
      uscrchar(72) ='DZM'
      uscrchar(73) ='NQV'
      uscrchar(74) ='NQN'
      uscrchar(75) ='NQF'
      uscrchar(76) ='NQG'
      uscrchar(77) ='NQD'
      uscrchar(78) ='NQY'
      uscrchar(79) ='NQX'
      uscrchar(80) ='NQI'
      uscrchar(81) ='NQJ'
      uscrchar(82) ='NQK'
      uscrchar(83) ='NQL'
      uscrchar(84) ='NQM'
      uscrchar(85) ='NZV'
      uscrchar(86) ='NZN'
      uscrchar(87) ='NZF'
      uscrchar(88) ='NZG'
      uscrchar(89) ='NZD'
      uscrchar(90) ='NZY'
      uscrchar(91) ='NZX'
      uscrchar(92) ='NZI'
      uscrchar(93) ='NZJ'
      uscrchar(94) ='NZK'
      uscrchar(95) ='NZL'
      uscrchar(96) ='NZM'
      uscrchar(97) ='GQV'
      uscrchar(98) ='GQN'
      uscrchar(99) ='GQF'
      uscrchar(100)='GQG'
      uscrchar(101)='GQD'
      uscrchar(102)='GQY'
      uscrchar(103)='GQX'
      uscrchar(104)='GQI'
      uscrchar(105)='GQJ'
      uscrchar(106)='GQK'
      uscrchar(107)='GQL'
      uscrchar(108)='GQM'
      uscrchar(109)='GZV'
      uscrchar(110)='GZN'
      uscrchar(111)='GZF'
      uscrchar(112)='GZG'
      uscrchar(113)='GZD'
      uscrchar(114)='GZY'
      uscrchar(115)='GZX'
      uscrchar(116)='GZI'
      uscrchar(117)='GZJ'
      uscrchar(118)='GZK'
      uscrchar(119)='GZL'
      uscrchar(120)='GZM'
      uscrchar(121)='YQV'
      uscrchar(122)='YQN'
      uscrchar(123)='YQF'
      uscrchar(124)='YQG'
      uscrchar(125)='YQD'
      uscrchar(126)='YQY'
      uscrchar(127)='YQX'
      uscrchar(128)='YQI'
      uscrchar(129)='YQJ'
      uscrchar(130)='YQK'
      uscrchar(131)='YQL'
      uscrchar(132)='YQM'
      uscrchar(133)='YZV'
      uscrchar(134)='YZN'
      uscrchar(135)='YZF'
      uscrchar(136)='YZG'
      uscrchar(137)='YZD'
      uscrchar(138)='YZY'
      uscrchar(139)='YZX'
      uscrchar(140)='YZI'
      uscrchar(141)='YZJ'
      uscrchar(142)='YZK'
      uscrchar(143)='YZL'
      uscrchar(144)='YZM'
      uscrchar(145)='XQV'
      uscrchar(146)='XQN'
      uscrchar(147)='XQF'
      uscrchar(148)='XQG'
      uscrchar(149)='XQD'
      uscrchar(150)='XQY'
      uscrchar(151)='XQX'
      uscrchar(152)='XQI'
      uscrchar(153)='XQJ'
      uscrchar(154)='XQK'
      uscrchar(155)='XQL'
      uscrchar(156)='XQM'
      uscrchar(157)='XZV'
      uscrchar(158)='XZN'
      uscrchar(159)='XZF'
      uscrchar(160)='XZG'
      uscrchar(161)='XZD'
      uscrchar(162)='XZY'
      uscrchar(163)='XZX'
      uscrchar(164)='XZI'
      uscrchar(165)='XZJ'
      uscrchar(166)='XZK'
      uscrchar(167)='XZL'
      uscrchar(168)='XZM'
      uscrchar(169)='IQV'
      uscrchar(170)='IQN'
      uscrchar(171)='IQF'
      uscrchar(172)='IQG'
      uscrchar(173)='IQD'
      uscrchar(174)='IQY'
      uscrchar(175)='IQX'
      uscrchar(176)='IQI'
      uscrchar(177)='IQJ'
      uscrchar(178)='IQK'
      uscrchar(179)='IQL'
      uscrchar(180)='IQM'
      uscrchar(181)='IZV'
      uscrchar(182)='IZN'
      uscrchar(183)='IZF'
      uscrchar(184)='IZG'
      uscrchar(185)='IZD'
      uscrchar(186)='IZY'
      uscrchar(187)='IZX'
      uscrchar(188)='IZI'
      uscrchar(189)='IZJ'
      uscrchar(190)='IZK'
      uscrchar(191)='IZL'
      uscrchar(192)='IZM'
      uscrchar(193)='JQV'
      uscrchar(194)='JQN'
      uscrchar(195)='JQF'
      uscrchar(196)='JQG'
      uscrchar(197)='JQD'
      uscrchar(198)='JQY'
      uscrchar(199)='JQX'
      uscrchar(200)='JQI'
      uscrchar(201)='JQJ'
      uscrchar(202)='JQK'
      uscrchar(203)='JQL'
      uscrchar(204)='JQM'
      uscrchar(205)='JZV'
      uscrchar(206)='JZN'
      uscrchar(207)='JZF'
      uscrchar(208)='JZG'
      uscrchar(209)='JZD'
      uscrchar(210)='JZY'
      uscrchar(211)='JZX'
      uscrchar(212)='JZI'
      uscrchar(213)='JZJ'
      uscrchar(214)='JZK'
      uscrchar(215)='JZL'
      uscrchar(216)='JZM'
      uscrchar(217)='KQV'
      uscrchar(218)='KQN'
      uscrchar(219)='KQF'
      uscrchar(220)='KQG'
      uscrchar(221)='KQD'
      uscrchar(222)='KQY'
      uscrchar(223)='KQX'
      uscrchar(224)='KQI'
      uscrchar(225)='KQJ'
      uscrchar(226)='KQK'
      uscrchar(227)='KQL'
      uscrchar(228)='KQM'
      uscrchar(229)='KZV'
      uscrchar(230)='KZN'
      uscrchar(231)='KZF'
      uscrchar(232)='KZG'
      uscrchar(233)='KZD'
      uscrchar(234)='KZY'
      uscrchar(235)='KZX'
      uscrchar(236)='KZI'
      uscrchar(237)='KZJ'
      uscrchar(238)='KZK'
      uscrchar(239)='KZL'
      uscrchar(240)='KZM'
      uscrchar(241)='LQV'
      uscrchar(242)='LQN'
      uscrchar(243)='LQF'
      uscrchar(244)='LQG'
      uscrchar(245)='LQD'
      uscrchar(246)='LQY'
      uscrchar(247)='LQX'
      uscrchar(248)='LQI'
      uscrchar(249)='LQJ'
      uscrchar(250)='LQK'
      uscrchar(251)='LQL'
      uscrchar(252)='LQM'
      uscrchar(253)='LZV'
      uscrchar(254)='LZN'
      uscrchar(255)='LZF'
      uscrchar(256)='LZG'
      uscrchar(257)='LZD'
      uscrchar(258)='LZY'
      uscrchar(259)='LZX'
      uscrchar(260)='LZI'
      uscrchar(261)='LZJ'
      uscrchar(262)='LZK'
      uscrchar(263)='LZL'
      uscrchar(264)='LZM'
      uscrchar(265)='MQV'
      uscrchar(266)='MQN'
      uscrchar(267)='MQF'
      uscrchar(268)='MQG'
      uscrchar(269)='MQD'
      uscrchar(270)='MQY'
      uscrchar(271)='MQX'
      uscrchar(272)='MQI'
      uscrchar(273)='MQJ'
      uscrchar(274)='MQK'
      uscrchar(275)='MQL'
      uscrchar(276)='MQM'
      uscrchar(277)='MZV'
      uscrchar(278)='MZN'
      uscrchar(279)='MZF'
      uscrchar(280)='MZG'
      uscrchar(281)='MZD'
      uscrchar(282)='MZY'
      uscrchar(283)='MZX'
      uscrchar(284)='MZI'
      uscrchar(285)='MZJ'
      uscrchar(286)='MZK'
      uscrchar(287)='MZL'
      uscrchar(288)='MZM'
      uscrchar(289)='VV '
      uscrchar(290)='VN '
      uscrchar(291)='VF '
      uscrchar(292)='VG '
      uscrchar(293)='VD '
      uscrchar(294)='VY '
      uscrchar(295)='VQ '
      uscrchar(296)='VZ '
      uscrchar(297)='VX '
      uscrchar(298)='VI '
      uscrchar(299)='VJ '
      uscrchar(300)='VK '
      uscrchar(301)='VL '
      uscrchar(302)='VM '
      uscrchar(303)='FV '
      uscrchar(304)='FN '
      uscrchar(305)='FF '
      uscrchar(306)='FG '
      uscrchar(307)='FD '
      uscrchar(308)='FY '
      uscrchar(309)='FQ '
      uscrchar(310)='FZ '
      uscrchar(311)='FX '
      uscrchar(312)='FI '
      uscrchar(313)='FJ '
      uscrchar(314)='FK '
      uscrchar(315)='FL '
      uscrchar(316)='FM '
      uscrchar(317)='DV '
      uscrchar(318)='DN '
      uscrchar(319)='DF '
      uscrchar(320)='DG '
      uscrchar(321)='DD '
      uscrchar(322)='DY '
      uscrchar(323)='DQ '
      uscrchar(324)='DZ '
      uscrchar(325)='DX '
      uscrchar(326)='DI '
      uscrchar(327)='DJ '
      uscrchar(328)='DK '
      uscrchar(329)='DL '
      uscrchar(330)='DM '
      uscrchar(331)='QV '
      uscrchar(332)='QN '
      uscrchar(333)='QF '
      uscrchar(334)='QG '
      uscrchar(335)='QD '
      uscrchar(336)='QY '
      uscrchar(337)='QQ '
      uscrchar(338)='QZ '
      uscrchar(339)='QX '
      uscrchar(340)='QI '
      uscrchar(341)='QJ '
      uscrchar(342)='QK '
      uscrchar(343)='QL '
      uscrchar(344)='QM '
      uscrchar(345)='NV '
      uscrchar(346)='NN '
      uscrchar(347)='NF '
      uscrchar(348)='NG '
      uscrchar(349)='ND '
      uscrchar(350)='NY '
      uscrchar(351)='NQ '
      uscrchar(352)='NZ '
      uscrchar(353)='NX '
      uscrchar(354)='NI '
      uscrchar(355)='NJ '
      uscrchar(356)='NK '
      uscrchar(357)='NL '
      uscrchar(358)='NM '
      uscrchar(359)='GV '
      uscrchar(360)='GN '
      uscrchar(361)='GF '
      uscrchar(362)='GG '
      uscrchar(363)='GD '
      uscrchar(364)='GY '
      uscrchar(365)='GQ '
      uscrchar(366)='GZ '
      uscrchar(367)='GX '
      uscrchar(368)='GI '
      uscrchar(369)='GJ '
      uscrchar(370)='GK '
      uscrchar(371)='GL '
      uscrchar(372)='GM '
      uscrchar(373)='YV '
      uscrchar(374)='YN '
      uscrchar(375)='YF '
      uscrchar(376)='YG '
      uscrchar(377)='YD '
      uscrchar(378)='YY '
      uscrchar(379)='YQ '
      uscrchar(380)='YZ '
      uscrchar(381)='YX '
      uscrchar(382)='YI '
      uscrchar(383)='YJ '
      uscrchar(384)='YK '
      uscrchar(385)='YL '
      uscrchar(386)='YM '
      uscrchar(387)='ZV '
      uscrchar(388)='ZN '
      uscrchar(389)='ZF '
      uscrchar(390)='ZG '
      uscrchar(391)='ZD '
      uscrchar(392)='ZY '
      uscrchar(393)='ZQ '
      uscrchar(394)='ZZ '
      uscrchar(395)='ZX '
      uscrchar(396)='ZI '
      uscrchar(397)='ZJ '
      uscrchar(398)='ZK '
      uscrchar(399)='ZL '
      uscrchar(400)='ZM '
      uscrchar(401)='XV '
      uscrchar(402)='XN '
      uscrchar(403)='XF '
      uscrchar(404)='XG '
      uscrchar(405)='XD '
      uscrchar(406)='XY '
      uscrchar(407)='XQ '
      uscrchar(408)='XZ '
      uscrchar(409)='XX '
      uscrchar(410)='XI '
      uscrchar(411)='XJ '
      uscrchar(412)='XK '
      uscrchar(413)='XL '
      uscrchar(414)='XM '
      uscrchar(415)='IV '
      uscrchar(416)='IN '
      uscrchar(417)='IF '
      uscrchar(418)='IG '
      uscrchar(419)='ID '
      uscrchar(420)='IY '
      uscrchar(421)='IQ '
      uscrchar(422)='IZ '
      uscrchar(423)='IX '
      uscrchar(424)='II '
      uscrchar(425)='IJ '
      uscrchar(426)='IK '
      uscrchar(427)='IL '
      uscrchar(428)='IM '
      uscrchar(429)='JV '
      uscrchar(430)='JN '
      uscrchar(431)='JF '
      uscrchar(432)='JG '
      uscrchar(433)='JD '
      uscrchar(434)='JY '
      uscrchar(435)='JQ '
      uscrchar(436)='JZ '
      uscrchar(437)='JX '
      uscrchar(438)='JI '
      uscrchar(439)='JJ '
      uscrchar(440)='JK '
      uscrchar(441)='JL '
      uscrchar(442)='JM '
      uscrchar(443)='KV '
      uscrchar(444)='KN '
      uscrchar(445)='KF '
      uscrchar(446)='KG '
      uscrchar(447)='KD '
      uscrchar(448)='KY '
      uscrchar(449)='KQ '
      uscrchar(450)='KZ '
      uscrchar(451)='KX '
      uscrchar(452)='KI '
      uscrchar(453)='KJ '
      uscrchar(454)='KK '
      uscrchar(455)='KL '
      uscrchar(456)='KM '
      uscrchar(457)='LV '
      uscrchar(458)='LN '
      uscrchar(459)='LF '
      uscrchar(460)='LG '
      uscrchar(461)='LD '
      uscrchar(462)='LY '
      uscrchar(463)='LQ '
      uscrchar(464)='LZ '
      uscrchar(465)='LX '
      uscrchar(466)='LI '
      uscrchar(467)='LJ '
      uscrchar(468)='LK '
      uscrchar(469)='LL '
      uscrchar(470)='LM '
      uscrchar(471)='MV '
      uscrchar(472)='MN '
      uscrchar(473)='MF '
      uscrchar(474)='MG '
      uscrchar(475)='MD '
      uscrchar(476)='MY '
      uscrchar(477)='MQ '
      uscrchar(478)='MZ '
      uscrchar(479)='MX '
      uscrchar(480)='MI '
      uscrchar(481)='MJ '
      uscrchar(482)='MK '
      uscrchar(483)='ML '
      uscrchar(484)='MM '
      do 30 j=1,uused
        if (uscrchar(j)(3:3).eq.' ') then
          uscrleng(j)=2
        else
          uscrleng(j)=3
        endif
  30  continue
      do 40 k=1,uused
        if (uscrleng(k).eq.2) umult(k)=1
        if (uscrleng(k).eq.3) umult(k)=2
  40  continue
c
      if (dbgflg.ge.1) then
        write (dbgunit,1001) uused
1001    format (/2X,'Creation and initialization of scratch arrays ',
     *          '"u" successful.',5X,'(uused=',I3,')')
      endif
      do 50 j=1,uused
c   Initialize uorder(j,k)
        do 51 k=1,3
          uorder(j,k)=0
  51    continue
        do 60 k=1,uscrleng(j)
          if (uscrchar(j)(k:K).eq.'V'.or.uscrchar(j)(k:K).eq.'N'.or.
     *        uscrchar(j)(k:K).eq.'D'.or.uscrchar(j)(k:K).eq.'Y'.or.
     *        uscrchar(j)(k:K).eq.'F'.or.uscrchar(j)(k:K).eq.'G')
     *                                         uorder(j,1)=uorder(j,1)+1
          if (uscrchar(j)(k:K).eq.'X'.or.uscrchar(j)(k:K).eq.'I'.or.
     *        uscrchar(j)(k:K).eq.'J'.or.uscrchar(j)(k:K).eq.'K'.or.
     *        uscrchar(j)(k:K).eq.'L'.or.uscrchar(j)(k:k).eq.'M')
     *                                         uorder(j,2)=uorder(j,2)+1
  60    continue
        uorder(j,3)=uorder(j,1)+uorder(j,2)
  50  continue
c
      if (dbgflg.ge.3) then
         write (dbgunit,1156) uused
 1156    format (/2X,'The following ',I3,' Uxxx-matrices have been set',
     *           ' up:',//2X,'Uxxx',2X,'uscrchar',2X,'uorder',1X,
     *           'uorder',1X,'uorder',2X,'umult',2X,
     *           'uscrleng',/20X,'(V)',3X,'(X)',3X,'(tot)',/)
         do 6298 k=1,uused
           write (dbgunit,8877) u(k),uscrchar(k),uorder(k,1),
     *                          uorder(k,2),uorder(k,3),umult(k),
     *                          uscrleng(k)
8877       format (2X,A4,4X,A3,7X,I2,4X,I2,5X,I2,6X,I2,6X,I2)
6298     continue
      endif
c
      return
      end
