/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "ValueEntry.h"

#include "../Value.h"

using namespace GTLCore::Metadata;

struct ValueEntry::Private {
  GTLCore::Value value;
};

ValueEntry::ValueEntry( const GTLCore::String& _name, const GTLCore::Value& _value ) : Entry(_name), d(new Private)
{
  d->value = _value;
}

ValueEntry::~ValueEntry()
{
  delete d;
}

const GTLCore::Value& ValueEntry::value() const
{
  return d->value;
}

const ValueEntry* ValueEntry::asValueEntry() const
{
  return this;
}
