# {%= name %} {%= badge("fury") %} {%= badge("travis") %}

> {%= description %}

## Install
{%= include("install-npm", {save: true}) %}

## Usage

```js
var pascalcase = require('{%= name %}');

pascalcase('a');
//=> 'A'

pascalcase('foo bar baz');
//=> 'FooBarBaz'

pascalcase('foo_bar-baz');
//=> 'FooBarBaz'

pascalcase('foo.bar.baz');
//=> 'FooBarBaz'

pascalcase('foo/bar/baz');
//=> 'FooBarBaz'

pascalcase('foo[bar)baz');
//=> 'FooBarBaz'

pascalcase('#foo+bar*baz');
//=> 'FooBarBaz'

pascalcase('$foo~bar`baz');
//=> 'FooBarBaz'

pascalcase('_foo_bar-baz-');
//=> 'FooBarBaz'
```

## Related projects
{%= related(verb.related.list) %}  

## Running tests
{%= include("tests") %}

## Contributing
{%= include("contributing") %}

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
