/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File BaseTextEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef BaseTextEditor_H
#define BaseTextEditor_H

#ifndef InternalEditor_H
#include "InternalEditor.h"
#endif

#include "UITextEditor.h"

class BaseTextEditor : public XEditor<UITextEditor_c> {
public:

// -- Exceptions
	// None

// -- Contructors

	BaseTextEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~BaseTextEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	bool modified_;

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods

	virtual void reset();
	virtual void close();
	virtual void modifiedCB(Widget,XtPointer);

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	BaseTextEditor(const BaseTextEditor&);
	BaseTextEditor& operator=(const BaseTextEditor&);

// -- Members


// -- Methods
	// None

// -- Overridden methods

	virtual void apply();
	virtual void merge(IconObject*);
	virtual void replace(IconObject*);
	virtual bool modified();
	virtual string alternateEditor();


// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const BaseTextEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(BaseTextEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(BaseTextEditor);
//#endif

#endif
