FIND_PATH(LIBPNG_INCLUDE_DIR png.h
  /usr/local/include
  /usr/include
  /opt/local/include
)

SET(LIBPNG_NAMES ${LIBPNG_NAMES} png)
FIND_LIBRARY(LIBPNG_LIBRARY NAMES ${LIBPNG_NAMES} )

# handle the QUIETLY and REQUIRED arguments and set LIBPNG_FOUND to TRUE if 
# all listed variables are TRUE
INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LIBPNG  DEFAULT_MSG  LIBPNG_LIBRARY  LIBPNG_INCLUDE_DIR)

IF(LIBPNG_FOUND)
  SET( LIBPNG_LIBRARIES ${LIBPNG_LIBRARY} )
  IF(NOT LIBPNG_FIND_QUIETLY)
    MESSAGE(STATUS "Found libpng (LIBPNG_LIBRARIES = ${LIBPNG_LIBRARIES})")
    MESSAGE(STATUS "Found libpng (LIBPNG_INCLUDE_DIR = ${LIBPNG_INCLUDE_DIR})")
  ENDIF(NOT LIBPNG_FIND_QUIETLY)
ELSE(LIBPNG_FOUND)
  IF(LIBPNG_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find libpng")
  ENDIF(LIBPNG_FIND_REQUIRED)
ENDIF(LIBPNG_FOUND)



MARK_AS_ADVANCED(LIBPNG_INCLUDE_DIR LIBPNG_LIBRARY)

