#!/usr/bin/env python
# Copyright © 2022 Christian Persch
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

import sys

quadrants = [u'\u00a0', u'\u2598', u'\u259d', u'\u2580',
             u'\u2596', u'\u258c', u'\u259e', u'\u259b',
             u'\u2597', u'\u259a', u'\u2590', u'\u259c',
             u'\u2584', u'\u2599', u'\u259f', u'\u2588']

separated_quadrants = [u'\u00a0',     u'\U0001cc21', u'\U0001cc22', u'\U0001cc23',
                       u'\U0001cc24', u'\U0001cc25', u'\U0001cc26', u'\U0001cc27',
                       u'\U0001cc28', u'\U0001cc29', u'\U0001cc2a', u'\U0001cc2b',
                       u'\U0001cc2c', u'\U0001cc2d', u'\U0001cc2e', u'\U0001cc2f',]

sextants = [0xa0] + list(range(0x1fb00, 0x1fb13 + 1, 1)) + [0x258c] + list(range(0x1fb14, 0x1fb27 + 1, 1)) + [0x2590] + list(range(0x1fb28, 0x1fb3b + 1, 1)) + [0x2588]

separated_sextants = [0xA0] + list(range(0x1ce51, 0x1ce8f + 1, 1))

sys.stdout.write('Quadrants:\n')

sys.stdout.write('  contiguous:')
for q in quadrants:
    sys.stdout.write(f' {q}')

sys.stdout.write('\n\n')

sys.stdout.write('  separated: ')
for q in separated_quadrants:
    sys.stdout.write(f' {q}')

sys.stdout.write('\n\n')


sys.stdout.write('Sextants:\n')

sys.stdout.write('  contiguous:')
n=0
for q in sextants:
    sys.stdout.write(f' {chr(q)}')
    n=n+1
    if n % 16 == 0:
        sys.stdout.write('\n\n             ')

sys.stdout.write('\n\n')

sys.stdout.write('  separated: ')
n=0
for s in separated_sextants:
    sys.stdout.write(f' {chr(s)}')
    n=n+1
    if n % 16 == 0:
        sys.stdout.write('\n\n             ')

sys.stdout.write('\n\n')

octants = [
    0x000A0, # 00000000: U+00A0 NO-BREAK SPACE
    0x1CEA8, # 00000001: U+1CEA8 LEFT HALF UPPER ONE QUARTER BLOCK
    0x1CEAB, # 00000010: U+1CEAB RIGHT HALF UPPER ONE QUARTER BLOCK
    0x1FB82, # 00000011: U+1FB82 UPPER ONE QUARTER BLOCK
    0x1CD00, # 00000100: U+1CD00 BLOCK OCTANT-3
    0x02598, # 00000101: U+2598 QUADRANT UPPER LEFT
    0x1CD01, # 00000110: U+1CD01 BLOCK OCTANT-23
    0x1CD02, # 00000111: U+1CD02 BLOCK OCTANT-123
    0x1CD03, # 00001000: U+1CD03 BLOCK OCTANT-4
    0x1CD04, # 00001001: U+1CD04 BLOCK OCTANT-14
    0x0259D, # 00001010: U+259D QUADRANT UPPER RIGHT
    0x1CD05, # 00001011: U+1CD05 BLOCK OCTANT-124
    0x1CD06, # 00001100: U+1CD06 BLOCK OCTANT-34
    0x1CD07, # 00001101: U+1CD07 BLOCK OCTANT-134
    0x1CD08, # 00001110: U+1CD08 BLOCK OCTANT-234
    0x02580, # 00001111: U+2580 UPPER HALF BLOCK
    0x1CD09, # 00010000: U+1CD09 BLOCK OCTANT-5
    0x1CD0A, # 00010001: U+1CD0A BLOCK OCTANT-15
    0x1CD0B, # 00010010: U+1CD0B BLOCK OCTANT-25
    0x1CD0C, # 00010011: U+1CD0C BLOCK OCTANT-125
    0x1FBE6, # 00010100: U+1FBE6 MIDDLE LEFT ONE QUARTER BLOCK
    0x1CD0D, # 00010101: U+1CD0D BLOCK OCTANT-135
    0x1CD0E, # 00010110: U+1CD0E BLOCK OCTANT-235
    0x1CD0F, # 00010111: U+1CD0F BLOCK OCTANT-1235
    0x1CD10, # 00011000: U+1CD10 BLOCK OCTANT-45
    0x1CD11, # 00011001: U+1CD11 BLOCK OCTANT-145
    0x1CD12, # 00011010: U+1CD12 BLOCK OCTANT-245
    0x1CD13, # 00011011: U+1CD13 BLOCK OCTANT-1245
    0x1CD14, # 00011100: U+1CD14 BLOCK OCTANT-345
    0x1CD15, # 00011101: U+1CD15 BLOCK OCTANT-1345
    0x1CD16, # 00011110: U+1CD16 BLOCK OCTANT-2345
    0x1CD17, # 00011111: U+1CD17 BLOCK OCTANT-12345
    0x1CD18, # 00100000: U+1CD18 BLOCK OCTANT-6
    0x1CD19, # 00100001: U+1CD19 BLOCK OCTANT-16
    0x1CD1A, # 00100010: U+1CD1A BLOCK OCTANT-26
    0x1CD1B, # 00100011: U+1CD1B BLOCK OCTANT-126
    0x1CD1C, # 00100100: U+1CD1C BLOCK OCTANT-36
    0x1CD1D, # 00100101: U+1CD1D BLOCK OCTANT-136
    0x1CD1E, # 00100110: U+1CD1E BLOCK OCTANT-236
    0x1CD1F, # 00100111: U+1CD1F BLOCK OCTANT-1236
    0x1FBE7, # 00101000: U+1FBE7 MIDDLE RIGHT ONE QUARTER BLOCK
    0x1CD20, # 00101001: U+1CD20 BLOCK OCTANT-146
    0x1CD21, # 00101010: U+1CD21 BLOCK OCTANT-246
    0x1CD22, # 00101011: U+1CD22 BLOCK OCTANT-1246
    0x1CD23, # 00101100: U+1CD23 BLOCK OCTANT-346
    0x1CD24, # 00101101: U+1CD24 BLOCK OCTANT-1346
    0x1CD25, # 00101110: U+1CD25 BLOCK OCTANT-2346
    0x1CD26, # 00101111: U+1CD26 BLOCK OCTANT-12346
    0x1CD27, # 00110000: U+1CD27 BLOCK OCTANT-56
    0x1CD28, # 00110001: U+1CD28 BLOCK OCTANT-156
    0x1CD29, # 00110010: U+1CD29 BLOCK OCTANT-256
    0x1CD2A, # 00110011: U+1CD2A BLOCK OCTANT-1256
    0x1CD2B, # 00110100: U+1CD2B BLOCK OCTANT-356
    0x1CD2C, # 00110101: U+1CD2C BLOCK OCTANT-1356
    0x1CD2D, # 00110110: U+1CD2D BLOCK OCTANT-2356
    0x1CD2E, # 00110111: U+1CD2E BLOCK OCTANT-12356
    0x1CD2F, # 00111000: U+1CD2F BLOCK OCTANT-456
    0x1CD30, # 00111001: U+1CD30 BLOCK OCTANT-1456
    0x1CD31, # 00111010: U+1CD31 BLOCK OCTANT-2456
    0x1CD32, # 00111011: U+1CD32 BLOCK OCTANT-12456
    0x1CD33, # 00111100: U+1CD33 BLOCK OCTANT-3456
    0x1CD34, # 00111101: U+1CD34 BLOCK OCTANT-13456
    0x1CD35, # 00111110: U+1CD35 BLOCK OCTANT-23456
    0x1FB85, # 00111111: U+1FB85 UPPER THREE QUARTERS BLOCK
    0x1CEA3, # 01000000: U+1CEA3 LEFT HALF LOWER ONE QUARTER BLOCK
    0x1CD36, # 01000001: U+1CD36 BLOCK OCTANT-17
    0x1CD37, # 01000010: U+1CD37 BLOCK OCTANT-27
    0x1CD38, # 01000011: U+1CD38 BLOCK OCTANT-127
    0x1CD39, # 01000100: U+1CD39 BLOCK OCTANT-37
    0x1CD3A, # 01000101: U+1CD3A BLOCK OCTANT-137
    0x1CD3B, # 01000110: U+1CD3B BLOCK OCTANT-237
    0x1CD3C, # 01000111: U+1CD3C BLOCK OCTANT-1237
    0x1CD3D, # 01001000: U+1CD3D BLOCK OCTANT-47
    0x1CD3E, # 01001001: U+1CD3E BLOCK OCTANT-147
    0x1CD3F, # 01001010: U+1CD3F BLOCK OCTANT-247
    0x1CD40, # 01001011: U+1CD40 BLOCK OCTANT-1247
    0x1CD41, # 01001100: U+1CD41 BLOCK OCTANT-347
    0x1CD42, # 01001101: U+1CD42 BLOCK OCTANT-1347
    0x1CD43, # 01001110: U+1CD43 BLOCK OCTANT-2347
    0x1CD44, # 01001111: U+1CD44 BLOCK OCTANT-12347
    0x02596, # 01010000: U+2596 QUADRANT LOWER LEFT
    0x1CD45, # 01010001: U+1CD45 BLOCK OCTANT-157
    0x1CD46, # 01010010: U+1CD46 BLOCK OCTANT-257
    0x1CD47, # 01010011: U+1CD47 BLOCK OCTANT-1257
    0x1CD48, # 01010100: U+1CD48 BLOCK OCTANT-357
    0x0258C, # 01010101: U+258C LEFT HALF BLOCK
    0x1CD49, # 01010110: U+1CD49 BLOCK OCTANT-2357
    0x1CD4A, # 01010111: U+1CD4A BLOCK OCTANT-12357
    0x1CD4B, # 01011000: U+1CD4B BLOCK OCTANT-457
    0x1CD4C, # 01011001: U+1CD4C BLOCK OCTANT-1457
    0x0259E, # 01011010: U+259E QUADRANT UPPER RIGHT AND LOWER LEFT
    0x1CD4D, # 01011011: U+1CD4D BLOCK OCTANT-12457
    0x1CD4E, # 01011100: U+1CD4E BLOCK OCTANT-3457
    0x1CD4F, # 01011101: U+1CD4F BLOCK OCTANT-13457
    0x1CD50, # 01011110: U+1CD50 BLOCK OCTANT-23457
    0x0259B, # 01011111: U+259B QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT
    0x1CD51, # 01100000: U+1CD51 BLOCK OCTANT-67
    0x1CD52, # 01100001: U+1CD52 BLOCK OCTANT-167
    0x1CD53, # 01100010: U+1CD53 BLOCK OCTANT-267
    0x1CD54, # 01100011: U+1CD54 BLOCK OCTANT-1267
    0x1CD55, # 01100100: U+1CD55 BLOCK OCTANT-367
    0x1CD56, # 01100101: U+1CD56 BLOCK OCTANT-1367
    0x1CD57, # 01100110: U+1CD57 BLOCK OCTANT-2367
    0x1CD58, # 01100111: U+1CD58 BLOCK OCTANT-12367
    0x1CD59, # 01101000: U+1CD59 BLOCK OCTANT-467
    0x1CD5A, # 01101001: U+1CD5A BLOCK OCTANT-1467
    0x1CD5B, # 01101010: U+1CD5B BLOCK OCTANT-2467
    0x1CD5C, # 01101011: U+1CD5C BLOCK OCTANT-12467
    0x1CD5D, # 01101100: U+1CD5D BLOCK OCTANT-3467
    0x1CD5E, # 01101101: U+1CD5E BLOCK OCTANT-13467
    0x1CD5F, # 01101110: U+1CD5F BLOCK OCTANT-23467
    0x1CD60, # 01101111: U+1CD60 BLOCK OCTANT-123467
    0x1CD61, # 01110000: U+1CD61 BLOCK OCTANT-567
    0x1CD62, # 01110001: U+1CD62 BLOCK OCTANT-1567
    0x1CD63, # 01110010: U+1CD63 BLOCK OCTANT-2567
    0x1CD64, # 01110011: U+1CD64 BLOCK OCTANT-12567
    0x1CD65, # 01110100: U+1CD65 BLOCK OCTANT-3567
    0x1CD66, # 01110101: U+1CD66 BLOCK OCTANT-13567
    0x1CD67, # 01110110: U+1CD67 BLOCK OCTANT-23567
    0x1CD68, # 01110111: U+1CD68 BLOCK OCTANT-123567
    0x1CD69, # 01111000: U+1CD69 BLOCK OCTANT-4567
    0x1CD6A, # 01111001: U+1CD6A BLOCK OCTANT-14567
    0x1CD6B, # 01111010: U+1CD6B BLOCK OCTANT-24567
    0x1CD6C, # 01111011: U+1CD6C BLOCK OCTANT-124567
    0x1CD6D, # 01111100: U+1CD6D BLOCK OCTANT-34567
    0x1CD6E, # 01111101: U+1CD6E BLOCK OCTANT-134567
    0x1CD6F, # 01111110: U+1CD6F BLOCK OCTANT-234567
    0x1CD70, # 01111111: U+1CD70 BLOCK OCTANT-1234567
    0x1CEA0, # 10000000: U+1CEA0 RIGHT HALF LOWER ONE QUARTER BLOCK
    0x1CD71, # 10000001: U+1CD71 BLOCK OCTANT-18
    0x1CD72, # 10000010: U+1CD72 BLOCK OCTANT-28
    0x1CD73, # 10000011: U+1CD73 BLOCK OCTANT-128
    0x1CD74, # 10000100: U+1CD74 BLOCK OCTANT-38
    0x1CD75, # 10000101: U+1CD75 BLOCK OCTANT-138
    0x1CD76, # 10000110: U+1CD76 BLOCK OCTANT-238
    0x1CD77, # 10000111: U+1CD77 BLOCK OCTANT-1238
    0x1CD78, # 10001000: U+1CD78 BLOCK OCTANT-48
    0x1CD79, # 10001001: U+1CD79 BLOCK OCTANT-148
    0x1CD7A, # 10001010: U+1CD7A BLOCK OCTANT-248
    0x1CD7B, # 10001011: U+1CD7B BLOCK OCTANT-1248
    0x1CD7C, # 10001100: U+1CD7C BLOCK OCTANT-348
    0x1CD7D, # 10001101: U+1CD7D BLOCK OCTANT-1348
    0x1CD7E, # 10001110: U+1CD7E BLOCK OCTANT-2348
    0x1CD7F, # 10001111: U+1CD7F BLOCK OCTANT-12348
    0x1CD80, # 10010000: U+1CD80 BLOCK OCTANT-58
    0x1CD81, # 10010001: U+1CD81 BLOCK OCTANT-158
    0x1CD82, # 10010010: U+1CD82 BLOCK OCTANT-258
    0x1CD83, # 10010011: U+1CD83 BLOCK OCTANT-1258
    0x1CD84, # 10010100: U+1CD84 BLOCK OCTANT-358
    0x1CD85, # 10010101: U+1CD85 BLOCK OCTANT-1358
    0x1CD86, # 10010110: U+1CD86 BLOCK OCTANT-2358
    0x1CD87, # 10010111: U+1CD87 BLOCK OCTANT-12358
    0x1CD88, # 10011000: U+1CD88 BLOCK OCTANT-458
    0x1CD89, # 10011001: U+1CD89 BLOCK OCTANT-1458
    0x1CD8A, # 10011010: U+1CD8A BLOCK OCTANT-2458
    0x1CD8B, # 10011011: U+1CD8B BLOCK OCTANT-12458
    0x1CD8C, # 10011100: U+1CD8C BLOCK OCTANT-3458
    0x1CD8D, # 10011101: U+1CD8D BLOCK OCTANT-13458
    0x1CD8E, # 10011110: U+1CD8E BLOCK OCTANT-23458
    0x1CD8F, # 10011111: U+1CD8F BLOCK OCTANT-123458
    0x02597, # 10100000: U+2597 QUADRANT LOWER RIGHT
    0x1CD90, # 10100001: U+1CD90 BLOCK OCTANT-168
    0x1CD91, # 10100010: U+1CD91 BLOCK OCTANT-268
    0x1CD92, # 10100011: U+1CD92 BLOCK OCTANT-1268
    0x1CD93, # 10100100: U+1CD93 BLOCK OCTANT-368
    0x0259A, # 10100101: U+259A QUADRANT UPPER LEFT AND LOWER RIGHT
    0x1CD94, # 10100110: U+1CD94 BLOCK OCTANT-2368
    0x1CD95, # 10100111: U+1CD95 BLOCK OCTANT-12368
    0x1CD96, # 10101000: U+1CD96 BLOCK OCTANT-468
    0x1CD97, # 10101001: U+1CD97 BLOCK OCTANT-1468
    0x02590, # 10101010: U+2590 RIGHT HALF BLOCK
    0x1CD98, # 10101011: U+1CD98 BLOCK OCTANT-12468
    0x1CD99, # 10101100: U+1CD99 BLOCK OCTANT-3468
    0x1CD9A, # 10101101: U+1CD9A BLOCK OCTANT-13468
    0x1CD9B, # 10101110: U+1CD9B BLOCK OCTANT-23468
    0x0259C, # 10101111: U+259C QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT
    0x1CD9C, # 10110000: U+1CD9C BLOCK OCTANT-568
    0x1CD9D, # 10110001: U+1CD9D BLOCK OCTANT-1568
    0x1CD9E, # 10110010: U+1CD9E BLOCK OCTANT-2568
    0x1CD9F, # 10110011: U+1CD9F BLOCK OCTANT-12568
    0x1CDA0, # 10110100: U+1CDA0 BLOCK OCTANT-3568
    0x1CDA1, # 10110101: U+1CDA1 BLOCK OCTANT-13568
    0x1CDA2, # 10110110: U+1CDA2 BLOCK OCTANT-23568
    0x1CDA3, # 10110111: U+1CDA3 BLOCK OCTANT-123568
    0x1CDA4, # 10111000: U+1CDA4 BLOCK OCTANT-4568
    0x1CDA5, # 10111001: U+1CDA5 BLOCK OCTANT-14568
    0x1CDA6, # 10111010: U+1CDA6 BLOCK OCTANT-24568
    0x1CDA7, # 10111011: U+1CDA7 BLOCK OCTANT-124568
    0x1CDA8, # 10111100: U+1CDA8 BLOCK OCTANT-34568
    0x1CDA9, # 10111101: U+1CDA9 BLOCK OCTANT-134568
    0x1CDAA, # 10111110: U+1CDAA BLOCK OCTANT-234568
    0x1CDAB, # 10111111: U+1CDAB BLOCK OCTANT-1234568
    0x02582, # 11000000: U+2582 LOWER ONE QUARTER BLOCK
    0x1CDAC, # 11000001: U+1CDAC BLOCK OCTANT-178
    0x1CDAD, # 11000010: U+1CDAD BLOCK OCTANT-278
    0x1CDAE, # 11000011: U+1CDAE BLOCK OCTANT-1278
    0x1CDAF, # 11000100: U+1CDAF BLOCK OCTANT-378
    0x1CDB0, # 11000101: U+1CDB0 BLOCK OCTANT-1378
    0x1CDB1, # 11000110: U+1CDB1 BLOCK OCTANT-2378
    0x1CDB2, # 11000111: U+1CDB2 BLOCK OCTANT-12378
    0x1CDB3, # 11001000: U+1CDB3 BLOCK OCTANT-478
    0x1CDB4, # 11001001: U+1CDB4 BLOCK OCTANT-1478
    0x1CDB5, # 11001010: U+1CDB5 BLOCK OCTANT-2478
    0x1CDB6, # 11001011: U+1CDB6 BLOCK OCTANT-12478
    0x1CDB7, # 11001100: U+1CDB7 BLOCK OCTANT-3478
    0x1CDB8, # 11001101: U+1CDB8 BLOCK OCTANT-13478
    0x1CDB9, # 11001110: U+1CDB9 BLOCK OCTANT-23478
    0x1CDBA, # 11001111: U+1CDBA BLOCK OCTANT-123478
    0x1CDBB, # 11010000: U+1CDBB BLOCK OCTANT-578
    0x1CDBC, # 11010001: U+1CDBC BLOCK OCTANT-1578
    0x1CDBD, # 11010010: U+1CDBD BLOCK OCTANT-2578
    0x1CDBE, # 11010011: U+1CDBE BLOCK OCTANT-12578
    0x1CDBF, # 11010100: U+1CDBF BLOCK OCTANT-3578
    0x1CDC0, # 11010101: U+1CDC0 BLOCK OCTANT-13578
    0x1CDC1, # 11010110: U+1CDC1 BLOCK OCTANT-23578
    0x1CDC2, # 11010111: U+1CDC2 BLOCK OCTANT-123578
    0x1CDC3, # 11011000: U+1CDC3 BLOCK OCTANT-4578
    0x1CDC4, # 11011001: U+1CDC4 BLOCK OCTANT-14578
    0x1CDC5, # 11011010: U+1CDC5 BLOCK OCTANT-24578
    0x1CDC6, # 11011011: U+1CDC6 BLOCK OCTANT-124578
    0x1CDC7, # 11011100: U+1CDC7 BLOCK OCTANT-34578
    0x1CDC8, # 11011101: U+1CDC8 BLOCK OCTANT-134578
    0x1CDC9, # 11011110: U+1CDC9 BLOCK OCTANT-234578
    0x1CDCA, # 11011111: U+1CDCA BLOCK OCTANT-1234578
    0x1CDCB, # 11100000: U+1CDCB BLOCK OCTANT-678
    0x1CDCC, # 11100001: U+1CDCC BLOCK OCTANT-1678
    0x1CDCD, # 11100010: U+1CDCD BLOCK OCTANT-2678
    0x1CDCE, # 11100011: U+1CDCE BLOCK OCTANT-12678
    0x1CDCF, # 11100100: U+1CDCF BLOCK OCTANT-3678
    0x1CDD0, # 11100101: U+1CDD0 BLOCK OCTANT-13678
    0x1CDD1, # 11100110: U+1CDD1 BLOCK OCTANT-23678
    0x1CDD2, # 11100111: U+1CDD2 BLOCK OCTANT-123678
    0x1CDD3, # 11101000: U+1CDD3 BLOCK OCTANT-4678
    0x1CDD4, # 11101001: U+1CDD4 BLOCK OCTANT-14678
    0x1CDD5, # 11101010: U+1CDD5 BLOCK OCTANT-24678
    0x1CDD6, # 11101011: U+1CDD6 BLOCK OCTANT-124678
    0x1CDD7, # 11101100: U+1CDD7 BLOCK OCTANT-34678
    0x1CDD8, # 11101101: U+1CDD8 BLOCK OCTANT-134678
    0x1CDD9, # 11101110: U+1CDD9 BLOCK OCTANT-234678
    0x1CDDA, # 11101111: U+1CDDA BLOCK OCTANT-1234678
    0x02584, # 11110000: U+2584 LOWER HALF BLOCK
    0x1CDDB, # 11110001: U+1CDDB BLOCK OCTANT-15678
    0x1CDDC, # 11110010: U+1CDDC BLOCK OCTANT-25678
    0x1CDDD, # 11110011: U+1CDDD BLOCK OCTANT-125678
    0x1CDDE, # 11110100: U+1CDDE BLOCK OCTANT-35678
    0x02599, # 11110101: U+2599 QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT
    0x1CDDF, # 11110110: U+1CDDF BLOCK OCTANT-235678
    0x1CDE0, # 11110111: U+1CDE0 BLOCK OCTANT-1235678
    0x1CDE1, # 11111000: U+1CDE1 BLOCK OCTANT-45678
    0x1CDE2, # 11111001: U+1CDE2 BLOCK OCTANT-145678
    0x0259F, # 11111010: U+259F QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT
    0x1CDE3, # 11111011: U+1CDE3 BLOCK OCTANT-1245678
    0x02586, # 11111100: U+2586 LOWER THREE QUARTERS BLOCK
    0x1CDE4, # 11111101: U+1CDE4 BLOCK OCTANT-1345678
    0x1CDE5, # 11111110: U+1CDE5 BLOCK OCTANT-2345678
    0x02588, # 11111111: U+2588 FULL BLOCK
]

sys.stdout.write('Octants:\n')

sys.stdout.write('  contiguous:')

n=0
for u in octants:
    sys.stdout.write(f' {chr(u)}')
    n=n+1
    if n % 16 == 0:
        sys.stdout.write('\n\n             ')

sys.stdout.write('\n\n')

sys.stdout.write('Sixteenths:\n\n')

for i in range(0x1ce90, 0x1ceb0):
    sys.stdout.write(f'  {chr(i)}')
    if i % 16 == 15:
        sys.stdout.write('\n\n')

sys.stdout.write('Scanlines: \u23ba \u23bb \u2500 \u23bc \u23bd\n\n')

sys.stdout.write('Box drawing:\n\n')

sys.stdout.write('\U0001ce16\u23ba\U0001ce18\n\u2502 \u2502\n\U0001ce17\u23bd\U0001ce19\n\n')

sys.stdout.write(' ' + '\u2500' + '\U0001cc1c' + '\n')
sys.stdout.write(' ' + ' '      + '\u23b9'     + '\n')
sys.stdout.write(' ' + '\u2500' + '\U0001cc1b' + '\n')

sys.stdout.write('\n')
sys.stdout.write(' \U0001cc1d\u23ba \U0001cc1e\u23bd\n')
sys.stdout.write('\n')

sys.stdout.write('Circles:\n')

for i in range(0x1cc30, 0x1cc40):
    if i % 4 == 0:
        sys.stdout.write('\n ')
    sys.stdout.write(chr(i))

sys.stdout.write('\n')
