------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-date-internal.adb,v 1.1 2008/02/11 08:52:33 vagul Exp $

package body OCI.Thick.Date.Internal is

   function SysDate return Date_Time is
   begin
      return To_Oracle (SysDate);
   end SysDate;

   function To_Ada (DT : in Date_Time) return Ada.Calendar.Time is
      use type Ub1;
   begin
      return Ada.Calendar.Time_Of
         (Year    => Integer (DT (0) - 100) * 100 + Integer (DT (1) - 100),
          Month   => Integer (DT (2)),
          Day     => Integer (DT (3)),
          Seconds => Duration
                       (Natural (DT (6) - 1)
                        + 60 * (Natural (DT (5) - 1)
                                + 60 * Natural (DT (4) - 1))));
   end To_Ada;

   function To_Date (Item : String; Format : String) return Date_Time is
   begin
      return To_Oracle (To_Date (Item, Format));
   end To_Date;

   function To_OCI (DT : in Date_Time) return OCIDate is
      use type Sb2;
      use type Ub1;
   begin
      return (OCIDateYYYY => Sb2 (DT (0) - 100) * 100 + Sb2 (DT (1) - 100),
              OCIDateMM   => DT (2),
              OCIDateDD   => DT (3),
              OCIDateTime => (OCITimeHH => DT (4) - 1,
                              OCITimeMI => DT (5) - 1,
                              OCITimeSS => DT (6) - 1));
   end To_OCI;

   ---------------
   -- To_Oracle --
   ---------------

   function To_Oracle (DT : in OCIDate) return Date_Time is
      use type Ub1;
      use type Sb2;
   begin
      return (0 => 100 + Ub1 (DT.OCIDateYYYY / 100),
              1 => 100 + Ub1 (DT.OCIDateYYYY mod 100),
              2 => DT.OCIDateMM,
              3 => DT.OCIDateDD,
              4 => DT.OCIDateTime.OCITimeHH + 1,
              5 => DT.OCIDateTime.OCITimeMI + 1,
              6 => DT.OCIDateTime.OCITimeSS + 1);
   end To_Oracle;

   function To_Oracle (DT : in Ada.Calendar.Time) return Date_Time is
      use Ada.Calendar;

      Year    : Year_Number;
      Month   : Month_Number;
      Day     : Day_Number;
      Seconds : Day_Duration;
      Secs    : Natural;
   begin
      Split (DT, Year, Month, Day, Seconds);

      if Seconds = 0.0 then
         Secs := 0;
      else
         Secs := Natural (Seconds - 0.5);
      end if;

      return (0 => Ub1 (100 + Year / 100),
              1 => Ub1 (100 + Year mod 100),
              2 => Ub1 (Month),
              3 => Ub1 (Day),
              4 => Ub1 (Secs / 3600 + 1),
              5 => Ub1 (Secs / 60 rem 60 + 1),
              6 => Ub1 (Secs rem 60 + 1));
   end To_Oracle;

   function To_String (From : Date_Time; Format : String) return String is
   begin
      return To_String (To_OCI (From), Format);
   end To_String;

end OCI.Thick.Date.Internal;
