from Date import Date
import calendar


#
# Class for recurrences of events.
#
class Recurrences:

    DAY = 0
    WEEK = 1
    MONTH = 2
    YEAR = 3


    def __init__(self):

        self.__dates = {}
        self.__exdates = {}
        
        self.__rules = []



    def add_date(self, date): self.__dates[date] = 1
    def remove_date(self, date): del self.__dates[date]
    def get_dates(self): return self.__dates.keys()



    def add_exdate(self, date): self.__exdates[date] = 1
    def remove_exdate(self, date): del self.__exdates[date]
    def get_exdates(self): return self.__exdates.keys()

    def is_excluded(self, date):

        y, m, d = date.get_day()
        tmp = Date(y, m, d, 0, 0, 0)
        return self.__exdates.has_key(tmp)



    def add_rule(self, rule): self.__rules.append(rule)
    def remove_rule(self, rule): self.__rules.remove(rule)
    def get_rules(self): return self.__rules



    #
    # Returns a list of all recurrences in the given year.
    #
    # TODO: Rewrite! This method is ugly.
    #
    def get_recurrences(self, dtstart, of_year):

        all_recs = []
        syear, smonth, sday = dtstart.get_day()

        if (not self.get_rules()):
            # include start date if available
            if (syear and syear == of_year): all_recs.append(dtstart.copy())



        # for every rule
        for rule in self.get_rules():
            freq = rule.get_frequency()
            count = rule.get_count()
            until = rule.get_until()
            recs = []

            # include start date if available
            if (syear): recs.append(dtstart.copy())


            # compute all recurrences
            next = dtstart.copy()
            while (1):
                year, month, day = next.get_day()
                
                # check termination conditions
                if (year > of_year):
                    break

                # process daily events
                if (freq == rule.DAY
                    and year <= of_year):
                    recs.append(next.copy())

                # process weekly events
                elif (freq == rule.WEEK
                      and year <= of_year):
                    weekdays = self.__make_weekdays(next,
                                                    rule.get_by(rule.DAY))
                    for w in self.__pos_filter(weekdays,
                                               rule.get_by(rule.SETPOS)):
                        y, m, d = w.get_day()
                        if (y <= of_year): recs.append(w.copy())
                    #end for

                # process monthly events
                elif (freq == rule.MONTH
                      and year <= of_year):
                    monthdays = self.__make_monthdays(next,
                                                    rule.get_by(rule.MONTHDAY),
                                                    rule.get_by(rule.DAY))
                    for md in self.__pos_filter(monthdays,
                                                rule.get_by(rule.SETPOS)):
                        y, m, d = md.get_day()
                        if (y <= of_year): recs.append(md.copy())
                    #end for

                # process yearly events
                elif (freq == rule.YEAR
                      and year <= of_year):
                    recs.append(next.copy())
                    
                #end if

                # add time interval
                next.add_time(rule.get_delta(rule.YEAR),
                              rule.get_delta(rule.MONTH),
                              rule.get_delta(rule.DAY))
            #end while


            # filter out unwanted events
            recs.sort()
            cnt = 0
            prev = None
            for date in recs:
                # ignore duplicates
                if (prev and prev == date): continue
                # check termination conditions
                elif ((count and cnt == count) or (until and  date > until)):
                    break
                elif (date < dtstart):
                    continue
                # remove excluded recurrences
                elif (self.is_excluded(date)):
                    continue
                # we need to take the recurrences of the year before, too,
                # so that bloating events works correctly over a year change
                if (of_year - 1 <= date.get_day()[0] <= of_year):
                    all_recs.append(date.copy())
                cnt += 1
                prev = date
            #end for

        #end for

        return all_recs



    def __pos_filter(self, set, bypos):

        if (not bypos): return set

        ret = []
        for p in bypos:
            if (p > 0): p -= 1
            ret.append(set[p])
        #end for

        return ret








    #
    # Converts the given weekday into a list of monthdays.
    #
    def __weekday2monthdays(self, year, month, day):

        if (day < 0):
            reverse = 1
            day = -day
        else:
            reverse = 0

        mrange = calendar.monthrange(year, month)[1]
        weekday = day % 10
        weekno = (day - weekday) / 10

        if (weekno == 0): weeks = [0, 1, 2, 3, 4]
        else: weeks = [weekno - 1]

        tmp = range(7) * 2
        if (reverse):
            firstday = 7 - calendar.weekday(year, month, mrange)
            tmp.reverse()
            oneweek = tmp[firstday:firstday + 7]

        else:
            firstday = calendar.weekday(year, month, 1)
            oneweek = tmp[firstday:firstday + 7]        


        ret = []
        for w in weeks:
            index = (w * 7 + oneweek.index(weekday)) + 1
            if (reverse): index = mrange - index
            if (0 < index <= mrange): ret.append(index)

        return ret



    #
    # TODO: implement
    #
    def __weekno2yeardays(self, weekno):

        return []




    #
    # Returns the specified days.
    #
    def __make_weekdays(self, date, bydays):

        if (not bydays): return [date.copy()]

        year, month, day = date.get_day()
        weekday = calendar.weekday(year, month, day)

        ret = []
        for d in bydays:
            diff = d - weekday
            new_date = date.copy()
            new_date.add_time(0, 0, diff)
            ret.append(new_date)

        return ret



    #
    # Returns the specified month days.
    #
    def __make_monthdays(self, date, bymonthdays, bydays):

        if (not bymonthdays and not bydays): return [date.copy()]

        year, month, day = date.get_day()
        if (not bymonthdays):
            bymonthdays = []
            for d in bydays:
                bymonthdays += self.__weekday2monthdays(year, month, d)
        #end if

        mrange = calendar.monthrange(year, month)[1]
        firstday = Date(year, month, 1, 0, 0, 0)
        lastday = Date(year, month, mrange, 0, 0, 0)

        ret = []
        for d in bymonthdays:
            if (0 < d <= mrange):
                day = firstday.copy()
                day.add_time(0, 0, d - 1)
                ret.append(day)
            elif (-mrange <= d < 0):
                day = lastday.copy()
                day.add_time(0, 0, d + 1)
                ret.append(day)
        #end for

        return ret
