/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy.util;

import java.io.File;
import java.util.Locale;

public class FileID {
    public static boolean isWebArchive(File path) {
        if (path.isFile()) {
            String name = path.getName().toLowerCase(Locale.ENGLISH);
            return name.endsWith(".war") || name.endsWith(".jar");
        }
        File webInf = new File(path, "WEB-INF");
        File webXml = new File(webInf, "web.xml");
        return webXml.exists() && webXml.isFile();
    }

    public static boolean isWebArchiveFile(File path) {
        if (!path.isFile()) {
            return false;
        }
        String name = path.getName().toLowerCase(Locale.ENGLISH);
        return name.endsWith(".war") || name.endsWith(".jar");
    }

    public static boolean isXmlFile(File path) {
        if (!path.isFile()) {
            return false;
        }
        String name = path.getName().toLowerCase(Locale.ENGLISH);
        return name.endsWith(".xml");
    }
}

