/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.util.SortedSet;
import nu.validator.source.SourceHandler;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.XhtmlSaxEmitter;
import org.xml.sax.SAXException;

public class XhtmlExtractHandler
implements SourceHandler {
    private static final char[] NEWLINE_SUBSTITUTE = new char[]{'\u21a9'};
    private static final char[] ELLIPSIS = new char[]{'\u2026'};
    private final XhtmlSaxEmitter emitter;
    private static final AttributesImpl LINE_BREAK_ATTRS = new AttributesImpl();

    public XhtmlExtractHandler(XhtmlSaxEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (length < 200) {
            this.emitter.characters(ch, start, length);
        } else {
            this.emitter.characters(ch, start, 100);
            this.emitter.startElementWithClass("span", "snip");
            this.emitter.characters(ELLIPSIS);
            this.emitter.endElement("span");
            this.emitter.characters(ch, start + length - 100, 100);
        }
    }

    @Override
    public void endSource() throws SAXException {
    }

    @Override
    public void endCharHilite() throws SAXException {
        this.emitter.endElement("b");
    }

    @Override
    public void endRange() throws SAXException {
        this.emitter.endElement("b");
    }

    @Override
    public void newLine() throws SAXException {
        this.emitter.startElement("span", LINE_BREAK_ATTRS);
        this.emitter.characters(NEWLINE_SUBSTITUTE);
        this.emitter.endElement("span");
    }

    @Override
    public void startSource(String type, String encoding) throws SAXException {
    }

    @Override
    public void startCharHilite(int oneBasedLine, int oneBasedColumn) throws SAXException {
        this.emitter.startElement("b");
    }

    @Override
    public void startRange(int oneBasedLine, int oneBasedColumn) throws SAXException {
        this.emitter.startElement("b");
    }

    @Override
    public void setLineErrors(SortedSet<Integer> oneBasedLineErrors) throws SAXException {
    }

    static {
        LINE_BREAK_ATTRS.addAttribute("class", "lf");
        LINE_BREAK_ATTRS.addAttribute("title", "Line break");
    }
}

