'''OpenGL extension OES.EGL_image_external_essl3

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.EGL_image_external_essl3 to provide a more 
Python-friendly API

Overview (from the spec)
	
	OES_EGL_image_external provides a mechanism for creating EGLImage texture
	targets from EGLImages, but only specified language interactions for the
	OpenGL ES Shading Language version 1.0. This extension adds support for
	versions 3.x of the OpenGL ES Shading Language.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/EGL_image_external_essl3.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.EGL_image_external_essl3 import *
from OpenGL.raw.GLES2.OES.EGL_image_external_essl3 import _EXTENSION_NAME

def glInitEglImageExternalEssl3OES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION