/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.job;

import com.projectlibre1.job.ExtendedProgressMonitor;
import com.projectlibre1.job.JobCanceledException;
import com.projectlibre1.job.JobMutex;
import com.projectlibre1.job.JobQueue;
import com.projectlibre1.job.JobRunnable;
import com.projectlibre1.job.Mutex;
import com.projectlibre1.server.access.ErrorLogger;
import com.projectlibre1.util.Alert;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.Closure;

public class Job
extends Thread {
    protected float progress;
    protected float progressStart;
    protected float weight = 0.0f;
    protected boolean canceled = false;
    protected long jobId;
    protected long t;
    protected ExtendedProgressMonitor progressMonitor = null;
    protected Thread monitorChecker = null;
    protected Closure cancelMonitorClosure = null;
    protected JobQueue jobQueue;
    protected String title;
    protected boolean showProgess;
    protected boolean sync;
    protected List runnables = new ArrayList();
    protected InternalRunnable exceptionHandlerRunnable;
    protected JobMutex mutex;
    protected Mutex globalMutex;
    protected Mutex groupMutex;
    protected InternalRunnable previousRunnable = null;
    protected boolean queued = true;
    protected boolean customCriticalSection;
    protected Component monitorComponent;
    private final Hashtable times = new Hashtable();
    private JobRunnable lastFinishedRunnable = null;
    ListIterator runnableIterator;
    InternalRunnable freeRunnable = null;
    InternalRunnable lastRunnable = null;

    public Job(JobQueue jobQueue, String string, String string2, boolean bl) {
        this(jobQueue, string, string2, bl, null);
    }

    public Job(JobQueue jobQueue, String string, String string2, boolean bl, Component component) {
        super((ThreadGroup)jobQueue, string);
        this.jobQueue = jobQueue;
        this.title = string2;
        this.showProgess = bl;
        this.sync = false;
        this.jobId = System.currentTimeMillis();
        this.mutex = new JobMutex("JobMutex");
        this.globalMutex = new Mutex("GlobalMutex");
        this.groupMutex = new Mutex("GroupMutex");
        this.progress = 0.0f;
        this.monitorComponent = component;
    }

    public void log(String string) {
    }

    public void logBegin(String string) {
        this.log(string + "...");
        this.times.put(string, new Long(System.currentTimeMillis()));
    }

    public void logEnd(String string) {
        Long l = (Long)this.times.get(string);
        if (l == null) {
            this.log(string + "...end");
        } else {
            this.log(string + "...end, " + (System.currentTimeMillis() - l) + " ms");
        }
    }

    @Override
    public long getId() {
        return this.hashCode();
    }

    public JobQueue getJobQueue() {
        return this.jobQueue;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public boolean isCustomCriticalSection() {
        return this.customCriticalSection;
    }

    public void setCustomCriticalSection(boolean bl) {
        this.customCriticalSection = bl;
    }

    public void setQueued(boolean bl) {
        this.queued = bl;
    }

    public void setCancelMonitorClosure(Closure closure) {
        this.cancelMonitorClosure = closure;
    }

    public synchronized float getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(float f, JobRunnable jobRunnable) {
        this.setProgress(f, null, jobRunnable);
    }

    public synchronized void setProgress(float f, final String string, JobRunnable jobRunnable) {
        this.log("setProgress(" + f + "," + string + "," + jobRunnable.getName() + "): progress=" + this.progress + ", weight=" + jobRunnable.getWeight() + "/" + this.weight + ", lastFinishedRunnable=" + (this.lastFinishedRunnable == null ? null : this.lastFinishedRunnable.getName()) + ", progressStart=" + this.progressStart);
        if (this.canceled || jobRunnable == this.lastFinishedRunnable) {
            return;
        }
        float f2 = f * jobRunnable.getWeight() / this.getWeight();
        if (this.progressStart + f2 > this.progress) {
            this.progress = this.progressStart + f2;
            if (this.showProgess && this.progressMonitor != null) {
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ Job this$0;
                    {
                        this.this$0 = job;
                    }

                    @Override
                    public void run() {
                        this.this$0.progressMonitor.setProgress(Math.round(this.this$0.getProgress() * 10000.0f));
                        this.this$0.progressMonitor.setNote(string);
                    }
                });
            }
            if (f == 1.0f && jobRunnable != this.lastFinishedRunnable) {
                this.lastFinishedRunnable = jobRunnable;
                this.progressStart += f2;
            }
        }
        this.log("\tsetProgress: progress=" + this.progress + ", lastFinishedRunnable=" + (this.lastFinishedRunnable == null ? null : this.lastFinishedRunnable.getName()) + ", progressStart=" + this.progressStart);
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public synchronized void cancel() {
        this.canceled = true;
        if (this.showProgess && this.progressMonitor != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Job.this.progressMonitor.close();
                }
            });
        }
    }

    public synchronized boolean isCanceled() {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            this.canceled = true;
        }
        return this.canceled;
    }

    protected void end() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        boolean bl = false;
        try {
            InternalRunnable internalRunnable;
            this.jobQueue.addExecutingJob(this);
            this.runnableIterator = this.runnables.listIterator();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            while (this.runnableIterator.hasNext()) {
                internalRunnable = (InternalRunnable)this.runnableIterator.next();
                if (internalRunnable.isExceptionHandler()) continue;
                if (internalRunnable.isSync()) {
                    bl2 = true;
                    this.lastRunnable = internalRunnable;
                    continue;
                }
                this.runnableIterator.previous();
                break;
            }
            while (this.runnableIterator.hasNext()) {
                internalRunnable = (InternalRunnable)this.runnableIterator.next();
                if (internalRunnable.isExceptionHandler()) continue;
                if (!internalRunnable.isSync()) {
                    bl4 = true;
                    this.freeRunnable = internalRunnable;
                    if (internalRunnable.isSwing()) continue;
                    this.lastRunnable = internalRunnable;
                    continue;
                }
                this.runnableIterator.previous();
                this.freeRunnable = null;
                break;
            }
            if (this.runnableIterator.hasNext() && !(internalRunnable = (InternalRunnable)this.runnableIterator.next()).isExceptionHandler()) {
                this.lastRunnable = internalRunnable;
                bl3 = true;
            }
            if (this.lastRunnable != null && !this.isCustomCriticalSection()) {
                this.jobQueue.beginCriticalSection(this);
            }
            this.globalMutex.lock();
            this.logBegin("global");
            this.runnableIterator = this.runnables.listIterator();
            if (this.isCanceled()) {
                this.log("Job canceled");
                return;
            }
            if (bl2) {
                if (bl4) {
                    this.groupMutex.lock();
                }
                this.run(true);
                if (bl4) {
                    this.groupMutex.waitUntilUnlocked();
                }
            }
            if (bl4) {
                if (this.isCanceled()) {
                    this.log("Job canceled");
                    return;
                }
                if (bl3) {
                    this.groupMutex.lock();
                }
                bl = true;
                this.start();
                if (bl3) {
                    this.groupMutex.waitUntilUnlocked();
                    if (this.isCanceled()) {
                        this.log("Job canceled");
                        return;
                    }
                    this.run(true);
                }
            }
        }
        finally {
            this.logEnd("global");
            this.globalMutex.unlock();
            if (!bl) {
                this.jobQueue.removeExecutingJob(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean bl) {
        try {
            JobQueue jobQueue = this.getJobQueue();
            if (this.showProgess) {
                this.progressMonitor = jobQueue.getProgressMonitor(this.title, this.monitorComponent);
                if (this.progressMonitor != null && this.cancelMonitorClosure != null && this.monitorChecker == null) {
                    this.monitorChecker = new Thread(this.getName() + "_cancelMonitor"){

                        @Override
                        public void run() {
                            if (this.isInterrupted() || Job.this.isCanceled()) {
                                return;
                            }
                            while (true) {
                                if (Job.this.progressMonitor.isCanceled()) {
                                    Job.this.cancelMonitorClosure.execute(null);
                                    break;
                                }
                                if (Job.this.progressMonitor.isClosed()) break;
                                try {
                                    3.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    };
                    this.monitorChecker.start();
                }
            }
            while (this.runnableIterator.hasNext()) {
                if (this.isInterrupted() || this.isCanceled()) {
                    this.log("Job canceled");
                    return;
                }
                InternalRunnable internalRunnable = (InternalRunnable)this.runnableIterator.next();
                if (this.previousRunnable == null || this.previousRunnable.getException() == null ? internalRunnable.isExceptionHandler() : !internalRunnable.isExceptionHandler()) continue;
                if (internalRunnable.isSync() != bl) {
                    this.runnableIterator.previous();
                } else {
                    JobMutex jobMutex;
                    boolean bl2 = !bl && internalRunnable != this.freeRunnable;
                    this.log(internalRunnable.runnable.getName() + ": lock=" + bl2);
                    if (bl2) {
                        jobMutex = this.mutex;
                        jobMutex.lock();
                    } else {
                        jobMutex = null;
                        this.groupMutex.unlock();
                    }
                    internalRunnable.setPrevious(this.previousRunnable);
                    this.runThread(internalRunnable, jobMutex);
                    this.previousRunnable = internalRunnable;
                    if (jobMutex != null && bl2) {
                        jobMutex.waitUntilUnlocked();
                    }
                    if (this.isInterrupted() || this.isCanceled()) {
                        this.log("Job canceled");
                        return;
                    }
                    if (internalRunnable.getException() != null) {
                        this.log(internalRunnable.runnable.getName() + ": Aborting job, exception=" + internalRunnable.getException().getMessage());
                    }
                    if (!internalRunnable.isExceptionHandler()) continue;
                }
                break;
            }
        }
        finally {
            this.groupMutex.unlock();
            this.jobQueue.removeExecutingJob(this);
        }
    }

    @Override
    public void run() {
        this.run(false);
    }

    private void runThread(final InternalRunnable internalRunnable, final JobMutex jobMutex) {
        if (internalRunnable.isCreateThread()) {
            Thread thread = new Thread(this){
                final /* synthetic */ Job this$0;
                {
                    this.this$0 = job;
                }

                @Override
                public void run() {
                    this.this$0.runSwing(internalRunnable, jobMutex);
                }
            };
            thread.setDaemon(this.isDaemon());
            thread.start();
        } else {
            this.runSwing(internalRunnable, jobMutex);
        }
    }

    private void runSwing(final InternalRunnable internalRunnable, final JobMutex jobMutex) {
        if (internalRunnable.isSwing()) {
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ Job this$0;
                {
                    this.this$0 = job;
                }

                @Override
                public void run() {
                    try {
                        if (this.this$0.isInterrupted() || this.this$0.isCanceled()) {
                            return;
                        }
                        this.this$0.logBegin("running " + internalRunnable.runnable.getName());
                        internalRunnable.run();
                        if (internalRunnable.getException() != null) {
                            this.this$0.cancel();
                        }
                    }
                    finally {
                        this.this$0.logEnd("running " + internalRunnable.runnable.getName());
                        if (jobMutex != null) {
                            jobMutex.unlock();
                        }
                        if (!(this.this$0.isCustomCriticalSection() || internalRunnable != this.this$0.lastRunnable && internalRunnable.getException() == null)) {
                            this.this$0.jobQueue.endCriticalSection(this.this$0);
                        }
                    }
                }
            });
        } else {
            if (this.isInterrupted() || this.isCanceled()) {
                return;
            }
            try {
                this.logBegin("running " + internalRunnable.runnable.getName());
                internalRunnable.run();
                if (internalRunnable.getException() != null) {
                    this.cancel();
                }
            }
            finally {
                this.logEnd("running " + internalRunnable.runnable.getName());
                if (jobMutex != null) {
                    jobMutex.unlock();
                }
                if (!(this.isCustomCriticalSection() || internalRunnable != this.lastRunnable && internalRunnable.getException() == null)) {
                    this.jobQueue.endCriticalSection(this);
                }
            }
        }
    }

    public void warm(final String string, boolean bl) {
        final Mutex mutex = new Mutex();
        if (bl) {
            mutex.lock();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Alert.warn(string);
                mutex.unlock();
            }
        });
        if (bl) {
            mutex.waitUntilUnlocked();
        }
    }

    public void error(final String string, boolean bl) {
        final Mutex mutex = new Mutex();
        if (bl) {
            mutex.lock();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Alert.error(string);
                mutex.unlock();
            }
        });
        if (bl) {
            mutex.waitUntilUnlocked();
        }
    }

    public int confirm(final String string, boolean bl) {
        final Mutex mutex = new Mutex();
        final IntResultHolder intResultHolder = new IntResultHolder();
        if (bl) {
            mutex.lock();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                intResultHolder.result = Alert.confirm(string);
                mutex.unlock();
            }
        });
        if (bl) {
            mutex.waitUntilUnlocked();
        }
        return intResultHolder.result;
    }

    public boolean okCancel(final String string, boolean bl) {
        final Mutex mutex = new Mutex();
        final BooleanResultHolder booleanResultHolder = new BooleanResultHolder();
        if (bl) {
            mutex.lock();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                booleanResultHolder.result = Alert.okCancel(string);
                mutex.unlock();
            }
        });
        if (bl) {
            mutex.waitUntilUnlocked();
        }
        return booleanResultHolder.result;
    }

    public String renameProject(final String string, final Set set, boolean bl, final boolean bl2) {
        final Mutex mutex = new Mutex();
        final StringResultHolder stringResultHolder = new StringResultHolder();
        if (bl) {
            mutex.lock();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                stringResultHolder.result = Alert.renameProject(string, set, bl2);
                mutex.unlock();
            }
        });
        if (bl) {
            mutex.waitUntilUnlocked();
        }
        return stringResultHolder.result;
    }

    protected Object getResult() {
        return this.previousRunnable == null ? null : this.previousRunnable.getResult();
    }

    public Object waitResult() throws Exception {
        this.globalMutex.waitUntilUnlocked();
        if (this.previousRunnable == null) {
            return null;
        }
        if (this.previousRunnable.getException() != null) {
            throw this.previousRunnable.getException();
        }
        return this.previousRunnable.getResult();
    }

    public void logDuration(String string) {
        long l = System.currentTimeMillis();
        this.log(string + ": " + (l - this.t) + "ms");
        this.t = l;
    }

    public void addRunnable(JobRunnable jobRunnable, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.runnables.add(new InternalRunnable(jobRunnable, bl, bl2, bl3, bl4));
        jobRunnable.setJob(this);
        this.weight += jobRunnable.getWeight();
    }

    public void addRunnable(JobRunnable jobRunnable, boolean bl) {
        this.runnables.add(new InternalRunnable(jobRunnable, bl, false, false, false));
        jobRunnable.setJob(this);
        this.weight += jobRunnable.getWeight();
    }

    public void addSwingRunnable(JobRunnable jobRunnable, boolean bl) {
        this.runnables.add(new InternalRunnable(jobRunnable, bl, false, true, false));
        jobRunnable.setJob(this);
        this.weight += jobRunnable.getWeight();
    }

    public void addRunnable(JobRunnable jobRunnable) {
        this.addRunnable(jobRunnable, false, false, false, false);
    }

    public void addSwingRunnable(JobRunnable jobRunnable) {
        this.addRunnable(jobRunnable, false, false, true, false);
    }

    public void addSync() {
        this.addRunnable(new JobRunnable("Sync: " + this.getName()){

            @Override
            public Object run() throws Exception {
                return Job.this.getResult();
            }
        }, true, false, false, false);
    }

    public void addExceptionRunnable(JobRunnable jobRunnable) {
        this.runnables.add(new InternalRunnable(jobRunnable, false, false, true, true));
        this.weight += jobRunnable.getWeight();
    }

    public void addJob(Job job) {
        for (InternalRunnable internalRunnable : job.runnables) {
            internalRunnable.getRunnable().setJob(this);
            this.runnables.add(internalRunnable);
            this.weight += internalRunnable.getRunnable().getWeight();
        }
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    private class InternalRunnable
    implements Runnable {
        protected boolean sync = false;
        protected boolean createThread = false;
        protected boolean swing = false;
        protected boolean exceptionHandler = false;
        protected JobRunnable runnable;
        protected Object result = null;
        protected Exception exception = null;
        protected InternalRunnable previous = null;

        public InternalRunnable(JobRunnable jobRunnable, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.sync = bl;
            this.createThread = bl2;
            this.swing = bl3;
            this.exceptionHandler = bl4;
            this.runnable = jobRunnable;
        }

        public boolean isCreateThread() {
            return this.createThread;
        }

        public void setCreateThread(boolean bl) {
            this.createThread = bl;
        }

        public boolean isSwing() {
            return this.swing;
        }

        public void setSwing(boolean bl) {
            this.swing = bl;
        }

        public boolean isExceptionHandler() {
            return this.exceptionHandler;
        }

        public void setExceptionHandler(boolean bl) {
            this.exceptionHandler = bl;
        }

        public JobRunnable getRunnable() {
            return this.runnable;
        }

        public void setRunnable(JobRunnable jobRunnable) {
            this.runnable = jobRunnable;
        }

        public boolean isSync() {
            return this.sync;
        }

        public void setSync(boolean bl) {
            this.sync = bl;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.result = this.runnable.run();
                }
                catch (Exception exception) {
                    this.exception = exception;
                    if (exception instanceof JobCanceledException) break block2;
                    exception.printStackTrace();
                    ErrorLogger.log("Job Exception: " + Job.this.getName(), exception);
                }
            }
        }

        public Exception getException() {
            return this.exception;
        }

        public Object getResult() {
            return this.result;
        }

        public Object getPreviousResult() {
            return Job.this.previousRunnable == null ? null : Job.this.previousRunnable.getResult();
        }

        public Exception getPreviousException() {
            return Job.this.previousRunnable == null ? null : Job.this.previousRunnable.getException();
        }

        public InternalRunnable getPrevious() {
            return this.previous;
        }

        public void setPrevious(InternalRunnable internalRunnable) {
            this.previous = internalRunnable;
            if (internalRunnable != null) {
                this.runnable.setPreviousResult(internalRunnable.getResult());
                this.runnable.setPreviousException(internalRunnable.getException());
            }
        }
    }

    private static class IntResultHolder {
        int result;

        private IntResultHolder() {
        }
    }

    private static class BooleanResultHolder {
        boolean result;

        private BooleanResultHolder() {
        }
    }

    private static class StringResultHolder {
        String result;

        private StringResultHolder() {
        }
    }
}

