/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec4(16u, 24u, 23u, 25u) << 0u) => uvec4(16u, 24u, 23u, 25u)
 * (uvec4(16u, 24u, 23u, 25u) << 1u) => uvec4(32u, 48u, 46u, 50u)
 * (uvec4(16u, 24u, 23u, 25u) << 2u) => uvec4(64u, 96u, 92u, 100u)
 * (uvec4(16u, 24u, 23u, 25u) << 5u) => uvec4(512u, 768u, 736u, 800u)
 * (uvec4(16u, 24u, 23u, 25u) << 25u) => uvec4(536870912u, 805306368u, 771751936u, 838860800u)
 * (uvec4(16u, 24u, 23u, 25u) << 31u) => uvec4(0u, 0u, 2147483648u, 2147483648u)
 * (uvec4(23u, 12u, 14u, 19u) << 0u) => uvec4(23u, 12u, 14u, 19u)
 * (uvec4(23u, 12u, 14u, 19u) << 1u) => uvec4(46u, 24u, 28u, 38u)
 * (uvec4(23u, 12u, 14u, 19u) << 2u) => uvec4(92u, 48u, 56u, 76u)
 * (uvec4(23u, 12u, 14u, 19u) << 5u) => uvec4(736u, 384u, 448u, 608u)
 * (uvec4(23u, 12u, 14u, 19u) << 25u) => uvec4(771751936u, 402653184u, 469762048u, 637534208u)
 * (uvec4(23u, 12u, 14u, 19u) << 31u) => uvec4(2147483648u, 0u, 0u, 2147483648u)
 */
#version 130

void main()
{
  float[all(equal((uvec4(16u, 24u, 23u, 25u) << 0u), uvec4(16u, 24u, 23u, 25u))) ? 1 : -1] array0;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) << 1u), uvec4(32u, 48u, 46u, 50u))) ? 1 : -1] array1;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) << 2u), uvec4(64u, 96u, 92u, 100u))) ? 1 : -1] array2;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) << 5u), uvec4(512u, 768u, 736u, 800u))) ? 1 : -1] array3;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) << 25u), uvec4(536870912u, 805306368u, 771751936u, 838860800u))) ? 1 : -1] array4;
  float[all(equal((uvec4(16u, 24u, 23u, 25u) << 31u), uvec4(0u, 0u, 2147483648u, 2147483648u))) ? 1 : -1] array5;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) << 0u), uvec4(23u, 12u, 14u, 19u))) ? 1 : -1] array6;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) << 1u), uvec4(46u, 24u, 28u, 38u))) ? 1 : -1] array7;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) << 2u), uvec4(92u, 48u, 56u, 76u))) ? 1 : -1] array8;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) << 5u), uvec4(736u, 384u, 448u, 608u))) ? 1 : -1] array9;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) << 25u), uvec4(771751936u, 402653184u, 469762048u, 637534208u))) ? 1 : -1] array10;
  float[all(equal((uvec4(23u, 12u, 14u, 19u) << 31u), uvec4(2147483648u, 0u, 0u, 2147483648u))) ? 1 : -1] array11;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
