/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.functions;

import de.focus_shift.jollyday.core.spi.FixedWeekdayInMonth;
import de.focus_shift.jollyday.core.spi.Occurrence;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Year;
import java.time.temporal.TemporalAdjusters;
import java.util.function.Function;

public class FindWeekDayInMonth
implements Function<FixedWeekdayInMonth, LocalDate> {
    private final Year year;

    public FindWeekDayInMonth(Year year) {
        this.year = year;
    }

    @Override
    public LocalDate apply(FixedWeekdayInMonth fixedWeekdayInMonth) {
        LocalDate date = LocalDate.of(this.year.getValue(), fixedWeekdayInMonth.month(), 1);
        DayOfWeek weekday = fixedWeekdayInMonth.weekday();
        if (Occurrence.LAST == fixedWeekdayInMonth.which()) {
            return date.with(TemporalAdjusters.lastInMonth(weekday));
        }
        return date.with(TemporalAdjusters.dayOfWeekInMonth(fixedWeekdayInMonth.which().ordinal() + 1, weekday));
    }
}

