/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.icon.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.ui.icon.AbstractResourceIconProvider;
import org.openhab.core.ui.icon.IconProvider;
import org.openhab.core.ui.icon.IconSet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IconProvider.class})
@NonNullByDefault
public class CustomIconProvider
extends AbstractResourceIconProvider {
    @Activate
    public CustomIconProvider(@Reference TranslationProvider i18nProvider) {
        super(i18nProvider);
    }

    private @Nullable Path getIconFile(String filename, String iconSetId) {
        Path folder = Path.of(OpenHAB.getConfigFolder(), "icons", iconSetId);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<Path> stream = Files.walk(folder, FileVisitOption.FOLLOW_LINKS);){
                return stream.filter(file -> !Files.isDirectory(file, new LinkOption[0]) && filename.equals(file.getFileName().toString())).findAny().orElse(null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected @Nullable InputStream getResource(String iconSetId, String resourceName) {
        Path file = this.getIconFile(resourceName, iconSetId);
        if (file != null) {
            try {
                return Files.newInputStream(file, new OpenOption[0]);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    protected boolean hasResource(String iconSetId, String resourceName) {
        return this.getIconFile(resourceName, iconSetId) != null;
    }

    @Override
    public Set<IconSet> getIconSets(@Nullable Locale locale) {
        return Set.of();
    }

    @Override
    protected Integer getPriority() {
        return 5;
    }
}

