/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import jakarta.persistence.TemporalType;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Calendar;
import java.util.TimeZone;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterTemporal;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampUtcAsJdbcTimestampJdbcType
implements JdbcType {
    public static final TimestampUtcAsJdbcTimestampJdbcType INSTANCE = new TimestampUtcAsJdbcTimestampJdbcType();
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    @Override
    public int getJdbcTypeCode() {
        return 93;
    }

    @Override
    public int getDefaultSqlTypeCode() {
        return 3003;
    }

    @Override
    public String getFriendlyName() {
        return "TIMESTAMP_UTC";
    }

    public String toString() {
        return "TimestampUtcDescriptor";
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer length, Integer scale, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Instant.class));
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return Instant.class;
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new JdbcLiteralFormatterTemporal<T>(javaType, TemporalType.TIMESTAMP);
    }

    @Override
    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Instant instant = javaType.unwrap(value, Instant.class, options);
                st.setTimestamp(index, Timestamp.from(instant), UTC_CALENDAR);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Instant instant = javaType.unwrap(value, Instant.class, options);
                st.setTimestamp(name, Timestamp.from(instant), UTC_CALENDAR);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                Timestamp timestamp = rs.getTimestamp(paramIndex, UTC_CALENDAR);
                return javaType.wrap(timestamp == null ? null : timestamp.toInstant(), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                Timestamp timestamp = statement.getTimestamp(index, UTC_CALENDAR);
                return javaType.wrap(timestamp == null ? null : timestamp.toInstant(), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                Timestamp timestamp = statement.getTimestamp(name, UTC_CALENDAR);
                return javaType.wrap(timestamp == null ? null : timestamp.toInstant(), options);
            }
        };
    }
}

