/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;

public class DuplicatedWayNodes
extends Test {
    protected static final int DUPLICATE_WAY_NODE = 501;

    public DuplicatedWayNodes() {
        super(I18n.tr("Duplicated way nodes", new Object[0]), I18n.tr("Checks for ways with identical consecutive nodes.", new Object[0]));
    }

    @Override
    public void visit(Way w) {
        if (!w.isUsable()) {
            return;
        }
        Node lastN = null;
        for (Node n : w.getNodes()) {
            if (lastN == null) {
                lastN = n;
                continue;
            }
            if (lastN == n) {
                this.errors.add(TestError.builder(this, Severity.ERROR, 501).message(I18n.tr("Duplicated way nodes", new Object[0])).primitives(w).highlight(n).build());
                break;
            }
            lastN = n;
        }
    }

    @Override
    public Command fixError(TestError testError) {
        Iterator<? extends OsmPrimitive> it = testError.getPrimitives().iterator();
        if (it.hasNext()) {
            Way w = (Way)it.next();
            Node lastN = null;
            ArrayList<Node> modNodes = new ArrayList<Node>();
            for (Node n : w.getNodes()) {
                if (n != lastN) {
                    modNodes.add(n);
                }
                lastN = n;
            }
            if (modNodes.size() < 2) {
                return this.deletePrimitivesIfNeeded(Collections.singleton(w));
            }
            return new ChangeNodesCommand(w, (List<Node>)modNodes);
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError.getTester() instanceof DuplicatedWayNodes;
    }
}

