/* Premake's Lua scripts, as static data buffers for release mode builds */
/* DO NOT EDIT - this file is autogenerated - see BUILD.txt */
/* To regenerate this file, run: premake4 embed */ 

const char* builtin_scripts[] = {
	/* base/os.lua */
	"function os.executef(cmd, ...)\ncmd = string.format(cmd, unpack(arg))\nreturn os.execute(cmd)\nend\nlocal function parse_ld_so_conf(conf_file)\nlocal first, last\nlocal dirs = { }\nlocal file = io.open(conf_file)\nif file == nil then\nreturn dirs\nend\nfor line in file:lines() do\nfirst = line:find(\"#\", 1, true)\nif first ~= nil then\nline = line:sub(1, first - 1)\nend\nif line ~= \"\" then\nfirst, last = line:find(\"include%s+\")\nif first ~= nil then\nlocal include_glob = line:sub(last + 1)\nlocal includes = os.matchfiles(include_glob)\nfor _, v in ipairs(includes) do\ndirs = table.join(dirs, parse_ld_so_conf(v))\nend\nelse\ntable.insert(dirs, line)\nend\nend\nend\nreturn dirs\nend\nfunction os.findlib(libname)\nlibname = libname:gsub(\"^lib\", \"\")\nlocal file = io.popen(\"ldconfig -r\", \"r\")\nfor line in file:lines() do\n        _, last = line:find(\":-l\" .. libname .. \".%d+.%d+ => \")\nif last then\nreturn line:sub(last + 1)\nend\nend\n        end\nfunction os.get()\nreturn _OPTIONS.os or _OS\nend"
	"\nfunction os.is(id)\nreturn (os.get():lower() == id:lower())\nend\nlocal _64BitHostTypes = {\n\"x86_64\",\n\"ia64\",\n\"amd64\",\n\"ppc64\",\n\"powerpc64\",\n\"sparc64\"\n}\nfunction os.is64bit()\nif (os._is64bit()) then\nreturn true\nend\nlocal arch\nif _OS == \"windows\" then\narch = os.getenv(\"PROCESSOR_ARCHITECTURE\")\nelseif _OS == \"macosx\" then\narch = os.outputof(\"echo $HOSTTYPE\")\nelse\narch = os.outputof(\"uname -m\")\nend\narch = arch:lower()\nfor _, hosttype in ipairs(_64BitHostTypes) do\nif arch:find(hosttype) then\nreturn true\nend\nend\nreturn false\nend\nlocal function domatch(result, mask, wantfiles)\nif mask:startswith(\"./\") then\nmask = mask:sub(3)\nend\nlocal basedir = mask\nlocal starpos = mask:find(\"%*\")\nif starpos then\nbasedir = basedir:sub(1, starpos - 1)\nend\nbasedir = path.getdirectory(basedir)\nif (basedir == \".\") then basedir = \"\" end\nlocal recurse = mask:find(\"**\", nil, true)\nmask = path.wildcards(mask)\nlocal function matchwalker(basedir)\nlocal wildcard = path"
	".join(basedir, \"*\")\nlocal m = os.matchstart(wildcard)\nwhile (os.matchnext(m)) do\nlocal isfile = os.matchisfile(m)\nif ((wantfiles and isfile) or (not wantfiles and not isfile)) then\nlocal fname = path.join(basedir, os.matchname(m))\nif fname:match(mask) == fname then\ntable.insert(result, fname)\nend\nend\nend\nos.matchdone(m)\nif recurse then\nm = os.matchstart(wildcard)\nwhile (os.matchnext(m)) do\nif not os.matchisfile(m) then\nlocal dirname = os.matchname(m)\nmatchwalker(path.join(basedir, dirname))\nend\nend\nos.matchdone(m)\nend\nend\nmatchwalker(basedir)\nend\nfunction os.matchdirs(...)\nlocal result = { }\nfor _, mask in ipairs(arg) do\ndomatch(result, mask, false)\nend\nreturn result\nend\nfunction os.matchfiles(...)\nlocal result = { }\nfor _, mask in ipairs(arg) do\ndomatch(result, mask, true)\nend\nreturn result\nend\nlocal builtin_mkdir = os.mkdir\nfunction os.mkdir(p)\nlocal dir = iif(p:startswith(\"/\"), \"/\", \"\")\nfor part in p:gmatch(\"[^/]+\") do\ndir = dir .. part\nif (part ~= \"\" "
	"and not path.isabsolute(part) and not os.isdir(dir)) then\nlocal ok, err = builtin_mkdir(dir)\nif (not ok) then\nreturn nil, err\nend\nend\ndir = dir .. \"/\"\nend\nreturn true\nend\nfunction os.outputof(cmd)\nlocal pipe = io.popen(cmd)\nlocal result = pipe:read('*a')\npipe:close()\nreturn result\nend\nlocal builtin_rmdir = os.rmdir\nfunction os.rmdir(p)\nlocal dirs = os.matchdirs(p .. \"/*\")\nfor _, dname in ipairs(dirs) do\nos.rmdir(dname)\nend\nlocal files = os.matchfiles(p .. \"/*\")\nfor _, fname in ipairs(files) do\nos.remove(fname)\nend\nbuiltin_rmdir(p)\nend\n",

	/* base/path.lua */
	"function path.getabsolute(p)\np = path.translate(p, \"/\")\nif (p == \"\") then p = \".\" end\nlocal result = iif (path.isabsolute(p), nil, os.getcwd())\nfor n, part in ipairs(p:explode(\"/\", true)) do\nif (part == \"\" and n == 1) then\nresult = \"/\"\nelseif (part == \"..\") then\nresult = path.getdirectory(result)\nelseif (part ~= \".\") then\nif (part:startswith(\"$\") and n > 1) then\nresult = result .. \"/\" .. part\nelse\nresult = path.join(result, part)\nend\nend\nend\nresult = iif(result:endswith(\"/\"), result:sub(1, -2), result)\nreturn result\nend\nfunction path.getbasename(p)\nlocal name = path.getname(p)\nlocal i = name:findlast(\".\", true)\nif (i) then\nreturn name:sub(1, i - 1)\nelse\nreturn name\nend\nend\nfunction path.getdirectory(p)\nlocal i = p:findlast(\"/\", true)\nif (i) then\nif i > 1 then i = i - 1 end\nreturn p:sub(1, i)\nelse\nreturn \".\"\nend\nend\nfunction path.getdrive(p)\nlocal ch1 = p:sub(1,1)\nlocal ch2 = p:sub(2,2)\nif ch2 == \":\" then\nreturn ch1\nend\nend\nfunction path"
	".getextension(p)\nlocal i = p:findlast(\".\", true)\nif (i) then\nreturn p:sub(i)\nelse\nreturn \"\"\nend\nend\nfunction path.getname(p)\nlocal i = p:findlast(\"[/\\\\]\")\nif (i) then\nreturn p:sub(i + 1)\nelse\nreturn p\nend\nend\nfunction path.getrelative(src, dst)\nsrc = path.getabsolute(src)\ndst = path.getabsolute(dst)\nif (src == dst) then\nreturn \".\"\nend\nif dst:startswith(\"$\") then\nreturn dst\nend\nsrc = src .. \"/\"\ndst = dst .. \"/\"\nlocal idx = 0\nwhile (true) do\nlocal tst = src:find(\"/\", idx + 1, true)\nif tst then\nif src:sub(1,tst) == dst:sub(1,tst) then\nidx = tst\nelse\nbreak\nend\nelse\nbreak\nend\nend\nlocal first = src:find(\"/\", 0, true)\nif idx <= first then\nreturn dst:sub(1, -2)\nend\nsrc = src:sub(idx + 1)\ndst = dst:sub(idx + 1)\nlocal result = \"\"\nidx = src:find(\"/\")\nwhile (idx) do\nresult = result .. \"../\"\nidx = src:find(\"/\", idx + 1)\nend\nresult = result .. dst\nreturn result:sub(1, -2)\nend\nfunction path.iscfile(fname)\nlocal extensions = { \".c\", \".s\", "
	"\".m\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions, ext)\nend\nfunction path.iscppfile(fname)\nlocal extensions = { \".cc\", \".cpp\", \".cxx\", \".c\", \".s\", \".m\", \".mm\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions, ext)\nend\nfunction path.iscppheader(fname)\nlocal extensions = { \".h\", \".hh\", \".hpp\", \".hxx\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions, ext)\nend\nfunction path.isresourcefile(fname)\nlocal extensions = { \".rc\" }\nlocal ext = path.getextension(fname):lower()\nreturn table.contains(extensions, ext)\nend\nfunction path.join(...)\nlocal numargs = select(\"#\", ...)\nif numargs == 0 then\nreturn \"\";\nend\nlocal allparts = {}\nfor i = numargs, 1, -1 do\nlocal part = select(i, ...)\nif part and #part > 0 and part ~= \".\" then\nwhile part:endswith(\"/\") do\npart = part:sub(1, -2)\nend\ntable.insert(allparts, 1, part)\nif path.isabsolute(part) then\nbreak\nend\nend\nend\n"
	"return table.concat(allparts, \"/\")\nend\nfunction path.rebase(p, oldbase, newbase)\np = path.getabsolute(path.join(oldbase, p))\np = path.getrelative(newbase, p)\nreturn p\nend\nfunction path.translate(p, sep)\nif (type(p) == \"table\") then\nlocal result = { }\nfor _, value in ipairs(p) do\ntable.insert(result, path.translate(value))\nend\nreturn result\nelse\nif (not sep) then\nif (os.is(\"windows\")) then\nsep = \"\\\\\"\nelse\nsep = \"/\"\nend\nend\nlocal result = p:gsub(\"[/\\\\]\", sep)\nreturn result\nend\nend\nfunction path.wildcards(pattern)\npattern = pattern:gsub(\"([%+%.%-%^%$%(%)%%])\", \"%%%1\")\npattern = pattern:gsub(\"%*%*\", \"\\001\")\npattern = pattern:gsub(\"%*\", \"\\002\")\npattern = pattern:gsub(\"\\001\", \".*\")\npattern = pattern:gsub(\"\\002\", \"[^/]*\")\nreturn pattern\nend\n",

	/* base/string.lua */
	"function string.explode(s, pattern, plain)\nif (pattern == '') then return false end\nlocal pos = 0\nlocal arr = { }\nfor st,sp in function() return s:find(pattern, pos, plain) end do\ntable.insert(arr, s:sub(pos, st-1))\npos = sp + 1\nend\ntable.insert(arr, s:sub(pos))\nreturn arr\nend\nfunction string.findlast(s, pattern, plain)\nlocal curr = 0\nrepeat\nlocal next = s:find(pattern, curr + 1, plain)\nif (next) then curr = next end\nuntil (not next)\nif (curr > 0) then\nreturn curr\nend\nend\nfunction string.startswith(haystack, needle)\nreturn (haystack:find(needle, 1, true) == 1)\nend\n",

	/* base/table.lua */
	"function table.contains(t, value)\nfor _,v in pairs(t) do\nif (v == value) then\nreturn true\nend\nend\nreturn false\nend\nfunction table.extract(arr, fname)\nlocal result = { }\nfor _,v in ipairs(arr) do\ntable.insert(result, v[fname])\nend\nreturn result\nend\nfunction table.flatten(arr)\nlocal result = { }\nlocal function flatten(arr)\nfor _, v in ipairs(arr) do\nif type(v) == \"table\" then\nflatten(v)\nelse\ntable.insert(result, v)\nend\nend\nend\nflatten(arr)\nreturn result\nend\nfunction table.implode(arr, before, after, between)\nlocal result = \"\"\nfor _,v in ipairs(arr) do\nif (result ~= \"\" and between) then\nresult = result .. between\nend\nresult = result .. before .. v .. after\nend\nreturn result\nend\nfunction table.insertflat(tbl, values)\nif type(values) == \"table\" then\nfor _, value in ipairs(values) do\ntable.insertflat(tbl, value)\nend\nelse\ntable.insert(tbl, values)\nend\nend\nfunction table.isempty(t)\nreturn next(t) == nil\nend\nfunction table.join(...)\nlocal result = { }\nfor _,t"
	" in ipairs(arg) do\nif type(t) == \"table\" then\nfor _,v in ipairs(t) do\ntable.insert(result, v)\nend\nelse\ntable.insert(result, t)\nend\nend\nreturn result\nend\nfunction table.keys(tbl)\nlocal keys = {}\nfor k, _ in pairs(tbl) do\ntable.insert(keys, k)\nend\nreturn keys\nend\nfunction table.merge(...)\nlocal result = { }\nfor _,t in ipairs(arg) do\nif type(t) == \"table\" then\nfor k,v in pairs(t) do\nresult[k] = v\nend\nelse\nerror(\"invalid value\")\nend\nend\nreturn result\nend\nfunction table.translate(arr, translation)\nlocal result = { }\nfor _, value in ipairs(arr) do\nlocal tvalue\nif type(translation) == \"function\" then\ntvalue = translation(value)\nelse\ntvalue = translation[value]\nend\nif (tvalue) then\ntable.insert(result, tvalue)\nend\nend\nreturn result\nend\n",

	/* base/io.lua */
	"function io.capture()\nio.captured = ''\nend\nfunction io.endcapture()\nlocal captured = io.captured\nio.captured = nil\nreturn captured\nend\nlocal builtin_open = io.open\nfunction io.open(fname, mode)\nif (mode) then\nif (mode:find(\"w\")) then\nlocal dir = path.getdirectory(fname)\nok, err = os.mkdir(dir)\nif (not ok) then\nerror(err, 0)\nend\nend\nend\nreturn builtin_open(fname, mode)\nend\nfunction io.printf(msg, ...)\nif not io.eol then\nio.eol = \"\\n\"\nend\nif not io.indent then\nio.indent = \"\\t\"\nend\nif type(msg) == \"number\" then\ns = string.rep(io.indent, msg) .. string.format(unpack(arg))\nelse\ns = string.format(msg, unpack(arg))\nend\nif io.captured then\nio.captured = io.captured .. s .. io.eol\nelse\nio.write(s)\nio.write(io.eol)\nend\nend\n_p = io.printf\n",

	/* base/globals.lua */
	"premake = { }\npremake.platforms = \n{\nNative = \n{ \ncfgsuffix       = \"\",\n},\nx32 = \n{ \ncfgsuffix       = \"32\",\n},\nx64 = \n{ \ncfgsuffix       = \"64\",\n},\nUniversal = \n{ \ncfgsuffix       = \"univ\",\n},\nUniversal32 = \n{ \ncfgsuffix       = \"univ32\",\n},\nUniversal64 = \n{ \ncfgsuffix       = \"univ64\",\n},\nPS3 = \n{ \ncfgsuffix       = \"ps3\",\niscrosscompiler = true,\nnosharedlibs    = true,\nnamestyle       = \"PS3\",\n},\nWiiDev =\n{\ncfgsuffix       = \"wii\",\niscrosscompiler = true,\nnamestyle       = \"PS3\",\n},\nXbox360 = \n{ \ncfgsuffix       = \"xbox360\",\niscrosscompiler = true,\nnamestyle       = \"windows\",\n},\n}\nlocal builtin_dofile = dofile\nfunction dofile(fname)\nlocal oldcwd = os.getcwd()\nlocal oldfile = _SCRIPT\nif (not os.isfile(fname)) then\nlocal path = os.pathsearch(fname, _OPTIONS[\"scripts\"], os.getenv(\"PREMAKE_PATH\"))\nif (path) then\nfname = path..\"/\"..fname\nend\nend\n_SCRIPT = path.getabsolute(fname)\nlocal newcwd = path.getdirectory(_SCRIPT)\nos."
	"chdir(newcwd)\nlocal a, b, c, d, e, f = builtin_dofile(_SCRIPT)\n_SCRIPT = oldfile\nos.chdir(oldcwd)\nreturn a, b, c, d, e, f\nend\nfunction iif(expr, trueval, falseval)\nif (expr) then\nreturn trueval\nelse\nreturn falseval\nend\nend\nfunction include(fname)\nreturn dofile(fname .. \"/premake4.lua\")\nend\nfunction printf(msg, ...)\nprint(string.format(msg, unpack(arg)))\nend\nlocal builtin_type = type\nfunction type(t)\nlocal mt = getmetatable(t)\nif (mt) then\nif (mt.__type) then\nreturn mt.__type\nend\nend\nreturn builtin_type(t)\nend\n",

	/* base/action.lua */
	"premake.action = { }\npremake.action.list = { }\nfunction premake.action.add(a)\nlocal missing\nfor _, field in ipairs({\"description\", \"trigger\"}) do\nif (not a[field]) then\nmissing = field\nend\nend\nif (missing) then\nerror(\"action needs a \" .. missing, 3)\nend\npremake.action.list[a.trigger] = a\nend\nfunction premake.action.call(name)\nlocal a = premake.action.list[name]\nfor sln in premake.solution.each() do\nif a.onsolution then\na.onsolution(sln)\nend\nfor prj in premake.solution.eachproject(sln) do\nif a.onproject then\na.onproject(prj)\nend\nend\nend\nif a.execute then\na.execute()\nend\nend\nfunction premake.action.current()\nreturn premake.action.get(_ACTION)\nend\nfunction premake.action.get(name)\nreturn premake.action.list[name]\nend\nfunction premake.action.each()\nlocal keys = { }\nfor _, action in pairs(premake.action.list) do\ntable.insert(keys, action.trigger)\nend\ntable.sort(keys)\nlocal i = 0\nreturn function()\ni = i + 1\nreturn premake.action.list[keys[i]]\nend\nend\nfunction pre"
	"make.action.set(name)\n_ACTION = name\nlocal action = premake.action.get(name)\nif action then\n_OS = action.os or _OS\nend\nend\nfunction premake.action.supports(action, feature)\nif not action then\nreturn false\nend\nif action.valid_languages then\nif table.contains(action.valid_languages, feature) then\nreturn true\nend\nend\nif action.valid_kinds then\nif table.contains(action.valid_kinds, feature) then\nreturn true\nend\nend\nreturn false\nend\n",

	/* base/option.lua */
	"premake.option = { }\npremake.option.list = { }\nfunction premake.option.add(opt)\nlocal missing\nfor _, field in ipairs({ \"description\", \"trigger\" }) do\nif (not opt[field]) then\nmissing = field\nend\nend\nif (missing) then\nerror(\"option needs a \" .. missing, 3)\nend\npremake.option.list[opt.trigger] = opt\nend\nfunction premake.option.get(name)\nreturn premake.option.list[name]\nend\nfunction premake.option.each()\nlocal keys = { }\nfor _, option in pairs(premake.option.list) do\ntable.insert(keys, option.trigger)\nend\ntable.sort(keys)\nlocal i = 0\nreturn function()\ni = i + 1\nreturn premake.option.list[keys[i]]\nend\nend\nfunction premake.option.validate(values)\nfor key, value in pairs(values) do\nlocal opt = premake.option.get(key)\nif (not opt) then\nreturn false, \"invalid option '\" .. key .. \"'\"\nend\nif (opt.value and value == \"\") then\nreturn false, \"no value specified for option '\" .. key .. \"'\"\nend\nif opt.allowed then\nlocal found = false\nfor _, match in ipairs(opt.allowed) d"
	"o\nif match[1] == value then\nfound = true\nbreak\nend\nend\nif not found then\nreturn false, string.format(\"invalid value '%s' for option '%s'\", value, key)\nend\nend\nend\nreturn true\nend\n",

	/* base/tree.lua */
	"premake.tree = { }\nlocal tree = premake.tree\nfunction premake.tree.new(n)\nlocal t = {\nname = n,\nchildren = { }\n}\nreturn t\nend\nfunction premake.tree.add(tr, p, onaddfunc)\nif p == \".\" then\nreturn tr\nend\nlocal parentnode = tree.add(tr, path.getdirectory(p), onaddfunc)\nlocal childname = path.getname(p)\nif childname == \"..\" then\nreturn parentnode\nend\nlocal childnode = parentnode.children[childname]\nif not childnode or childnode.path ~= p then\nchildnode = tree.insert(parentnode, tree.new(childname))\nchildnode.path = p\nif onaddfunc then\nonaddfunc(childnode)\nend\nend\nreturn childnode\nend\nfunction premake.tree.insert(parent, child)\ntable.insert(parent.children, child)\nif child.name then\nparent.children[child.name] = child\nend\nchild.parent = parent\nreturn child\nend\nfunction premake.tree.getlocalpath(node)\nif node.parent.path then\nreturn node.name\nelseif node.cfg then\nreturn node.cfg.name\nelse\nreturn node.path\nend\nend\nfunction premake.tree.remove(node)\nlocal children = nod"
	"e.parent.children\nfor i = 1, #children do\nif children[i] == node then\ntable.remove(children, i)\nend\nend\nnode.children = {}\nend\nfunction premake.tree.sort(tr)\ntree.traverse(tr, {\nonnode = function(node)\ntable.sort(node.children, function(a,b)\nreturn a.name < b.name\nend)\nend\n}, true)\nend\nfunction premake.tree.traverse(t, fn, includeroot, initialdepth)\nlocal donode, dochildren\ndonode = function(node, fn, depth)\nif node.isremoved then \nreturn \nend\nif fn.onnode then \nfn.onnode(node, depth) \nend\nif #node.children > 0 then\nif fn.onbranchenter then\nfn.onbranchenter(node, depth)\nend\nif fn.onbranch then \nfn.onbranch(node, depth) \nend\ndochildren(node, fn, depth + 1)\nif fn.onbranchexit then\nfn.onbranchexit(node, depth)\nend\nelse\nif fn.onleaf then \nfn.onleaf(node, depth) \nend\nend\nend\ndochildren = function(parent, fn, depth)\nlocal i = 1\nwhile i <= #parent.children do\nlocal node = parent.children[i]\ndonode(node, fn, depth)\nif node == parent.children[i] then\ni = i + 1\nend\nend"
	"\nend\nif not initialdepth then\ninitialdepth = 0\nend\nif includeroot then\ndonode(t, fn, initialdepth)\nelse\ndochildren(t, fn, initialdepth)\nend\nend\n",

	/* base/solution.lua */
	"premake.solution = { }\npremake.solution.list = { }\nfunction premake.solution.new(name)\nlocal sln = { }\ntable.insert(premake.solution.list, sln)\npremake.solution.list[name] = sln\nsetmetatable(sln, { __type=\"solution\" })\nsln.name           = name\nsln.basedir        = os.getcwd()\nsln.projects       = { }\nsln.blocks         = { }\nsln.configurations = { }\nreturn sln\nend\nfunction premake.solution.each()\nlocal i = 0\nreturn function ()\ni = i + 1\nif i <= #premake.solution.list then\nreturn premake.solution.list[i]\nend\nend\nend\nfunction premake.solution.eachproject(sln)\nlocal i = 0\nreturn function ()\ni = i + 1\nif (i <= #sln.projects) then\nreturn premake.solution.getproject(sln, i)\nend\nend\nend\nfunction premake.solution.get(key)\nreturn premake.solution.list[key]\nend\nfunction premake.solution.getproject(sln, idx)\nlocal prj = sln.projects[idx]\nlocal cfg = premake.getconfig(prj)\ncfg.name = prj.name\nreturn cfg\nend\n",

	/* base/project.lua */
	"premake.project = { }\nfunction premake.project.buildsourcetree(prj)\nlocal tr = premake.tree.new(prj.name)\ntr.project = prj\nlocal isvpath\nlocal function onadd(node)\nnode.isvpath = isvpath\nend\nfor fcfg in premake.project.eachfile(prj) do\nisvpath = (fcfg.name ~= fcfg.vpath)\nlocal node = premake.tree.add(tr, fcfg.vpath, onadd)\nnode.cfg = fcfg\nend\npremake.tree.sort(tr)\nreturn tr\nend\nfunction premake.eachconfig(prj, platform)\nif prj.project then prj = prj.project end\nlocal cfgs = prj.solution.configurations\nlocal i = 0\nreturn function ()\ni = i + 1\nif i <= #cfgs then\nreturn premake.getconfig(prj, cfgs[i], platform)\nend\nend\nend\nfunction premake.project.eachfile(prj)\nif not prj.project then prj = premake.getconfig(prj) end\nlocal i = 0\nlocal t = prj.files\nreturn function ()\ni = i + 1\nif (i <= #t) then\nlocal fcfg = prj.__fileconfigs[t[i]]\nfcfg.vpath = premake.project.getvpath(prj, fcfg.name)\nreturn fcfg\nend\nend\nend\nfunction premake.esc(value)\nif (type(value) == \"table\") then\nlo"
	"cal result = { }\nfor _,v in ipairs(value) do\ntable.insert(result, premake.esc(v))\nend\nreturn result\nelse\nvalue = value:gsub('&',  \"&amp;\")\nvalue = value:gsub('\"',  \"&quot;\")\nvalue = value:gsub(\"'\",  \"&apos;\")\nvalue = value:gsub('<',  \"&lt;\")\nvalue = value:gsub('>',  \"&gt;\")\nvalue = value:gsub('\\r', \"&#x0D;\")\nvalue = value:gsub('\\n', \"&#x0A;\")\nreturn value\nend\nend\nfunction premake.filterplatforms(sln, map, default)\nlocal result = { }\nlocal keys = { }\nif sln.platforms then\nfor _, p in ipairs(sln.platforms) do\nif map[p] and not table.contains(keys, map[p]) then\ntable.insert(result, p)\ntable.insert(keys, map[p])\nend\nend\nend\nif #result == 0 and default then\ntable.insert(result, default)\nend\nreturn result\nend\nfunction premake.findproject(name)\nfor sln in premake.solution.each() do\nfor prj in premake.solution.eachproject(sln) do\nif (prj.name == name) then\nreturn  prj\nend\nend\nend\nend\nfunction premake.findfile(prj, extension)\nfor _, fname in ipairs(prj.files)"
	" do\nif fname:endswith(extension) then return fname end\nend\nend\nfunction premake.getconfig(prj, cfgname, pltname)\nprj = prj.project or prj\nif pltname == \"Native\" or not table.contains(prj.solution.platforms or {}, pltname) then\npltname = nil\nend\nlocal key = (cfgname or \"\")\nif pltname then key = key .. pltname end\nreturn prj.__configs[key]\nend\nfunction premake.getconfigname(cfgname, platform, useshortname)\nif cfgname then\nlocal name = cfgname\nif platform and platform ~= \"Native\" then\nif useshortname then\nname = name .. premake.platforms[platform].cfgsuffix\nelse\nname = name .. \"|\" .. platform\nend\nend\nreturn iif(useshortname, name:lower(), name)\nend\nend\nfunction premake.getdependencies(prj)\nprj = prj.project or prj\nlocal results = { }\nfor _, cfg in pairs(prj.__configs) do\nfor _, link in ipairs(cfg.links) do\nlocal dep = premake.findproject(link)\nif dep and not table.contains(results, dep) then\ntable.insert(results, dep)\nend\nend\nend\nreturn results\nend\nfunction premake.p"
	"roject.getbasename(prjname, pattern)\nreturn pattern:gsub(\"%%%%\", prjname)\nend\nfunction premake.project.getfilename(prj, pattern)\nlocal fname = premake.project.getbasename(prj.name, pattern)\nfname = path.join(prj.location, fname)\nreturn path.getrelative(os.getcwd(), fname)\nend\n function premake.getlinks(cfg, kind, part)\nlocal result = iif (part == \"directory\" and kind == \"all\", cfg.libdirs, {})\nlocal cfgname = iif(cfg.name == cfg.project.name, \"\", cfg.name)\nlocal pathstyle = premake.getpathstyle(cfg)\nlocal namestyle = premake.getnamestyle(cfg)\nlocal function canlink(source, target)\nif (target.kind ~= \"SharedLib\" and target.kind ~= \"StaticLib\") then\nreturn false\nend\nif premake.iscppproject(source) then\nreturn premake.iscppproject(target)\nelseif premake.isdotnetproject(source) then\nreturn premake.isdotnetproject(target)\nend\nend\nfor _, link in ipairs(cfg.links) do\nlocal item\nlocal prj = premake.findproject(link)\nif prj and kind ~= \"system\" then\nlocal prjcfg = premake.getcon"
	"fig(prj, cfgname, cfg.platform)\nif kind == \"dependencies\" or canlink(cfg, prjcfg) then\nif (part == \"directory\") then\nitem = path.rebase(prjcfg.linktarget.directory, prjcfg.location, cfg.location)\nelseif (part == \"basename\") then\nitem = prjcfg.linktarget.basename\nelseif (part == \"fullpath\") then\nitem = path.rebase(prjcfg.linktarget.fullpath, prjcfg.location, cfg.location)\nelseif (part == \"object\") then\nitem = prjcfg\nend\nend\nelseif not prj and (kind == \"system\" or kind == \"all\") then\nif (part == \"directory\") then\nitem = path.getdirectory(link)\nelseif (part == \"fullpath\") then\nitem = link\nif namestyle == \"windows\" then\nif premake.iscppproject(cfg) then\nitem = item .. \".lib\"\nelseif premake.isdotnetproject(cfg) then\nitem = item .. \".dll\"\nend\nend\nelseif part == \"name\" then\nitem = path.getname(link)\nelseif part == \"basename\" then\nitem = path.getbasename(link)\nelse\nitem = link\nend\nif item:find(\"/\", nil, true) then\nitem = path.getrelative(cfg.project.locatio"
	"n, item)\nend\nend\nif item then\nif pathstyle == \"windows\" and part ~= \"object\" then\nitem = path.translate(item, \"\\\\\")\nend\nif not table.contains(result, item) then\ntable.insert(result, item)\nend\nend\nend\nreturn result\nend\nfunction premake.getnamestyle(cfg)\nreturn premake.platforms[cfg.platform].namestyle or premake.gettool(cfg).namestyle or \"posix\"\nend\nfunction premake.getpathstyle(cfg)\nif premake.action.current().os == \"windows\" then\nreturn \"windows\"\nelse\nreturn \"posix\"\nend\nend\nfunction premake.gettarget(cfg, direction, pathstyle, namestyle, system)\nif system == \"bsd\" or system == \"solaris\" then\nsystem = \"linux\"\nend\nlocal kind = cfg.kind\nif premake.iscppproject(cfg) then\nif (namestyle == \"windows\" or system == \"windows\")\nand kind == \"SharedLib\" and direction == \"link\"\nand not cfg.flags.NoImportLib\nthen\nkind = \"StaticLib\"\nend\nif namestyle == \"posix\" and system == \"windows\" and kind ~= \"StaticLib\" then\nnamestyle = \"windows\"\nend\nend\nloca"
	"l field   = \"build\"\nif direction == \"link\" and cfg.kind == \"SharedLib\" then\nfield = \"implib\"\nend\nlocal name    = cfg[field..\"name\"] or cfg.targetname or cfg.project.name\nlocal dir     = cfg[field..\"dir\"] or cfg.targetdir or path.getrelative(cfg.location, cfg.basedir)\nlocal prefix  = \"\"\nlocal suffix  = \"\"\nlocal ext     = \"\"\nlocal bundlepath, bundlename\nif namestyle == \"windows\" then\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".exe\"\nelseif kind == \"SharedLib\" then\next = \".dll\"\nelseif kind == \"StaticLib\" then\next = \".lib\"\nend\nelseif namestyle == \"posix\" then\nif kind == \"WindowedApp\" and system == \"macosx\" then\nbundlename = name .. \".app\"\nbundlepath = path.join(dir, bundlename)\ndir = path.join(bundlepath, \"Contents/MacOS\")\nelseif kind == \"SharedLib\" then\nprefix = \"lib\"\next = iif(system == \"macosx\", \".dylib\", \".so\")\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nelseif namestyle == \"PS3\" then"
	"\nif kind == \"ConsoleApp\" or kind == \"WindowedApp\" then\next = \".elf\"\nelseif kind == \"StaticLib\" then\nprefix = \"lib\"\next = \".a\"\nend\nend\nprefix = cfg[field..\"prefix\"] or cfg.targetprefix or prefix\nsuffix = cfg[field..\"suffix\"] or cfg.targetsuffix or suffix\next    = cfg[field..\"extension\"] or cfg.targetextension or ext\nlocal result = { }\nresult.basename   = name .. suffix\nresult.name       = prefix .. name .. suffix .. ext\nresult.directory  = dir\nresult.prefix     = prefix\nresult.suffix     = suffix\nresult.fullpath   = path.join(result.directory, result.name)\nresult.bundlepath = bundlepath or result.fullpath\nif pathstyle == \"windows\" then\nresult.directory = path.translate(result.directory, \"\\\\\")\nresult.fullpath  = path.translate(result.fullpath,  \"\\\\\")\nend\nreturn result\nend\nfunction premake.gettool(cfg)\nif premake.iscppproject(cfg) then\nif _OPTIONS.cc then\nreturn premake[_OPTIONS.cc]\nend\nlocal action = premake.action.current()\nif action.valid_tools then\nr"
	"eturn premake[action.valid_tools.cc[1]]\nend\nreturn premake.gcc\nelse\nreturn premake.dotnet\nend\nend\nfunction premake.project.getvpath(prj, abspath)\nlocal vpath = abspath\nlocal fname = path.getname(abspath)\nlocal max = abspath:len() - fname:len()\nfor replacement, patterns in pairs(prj.vpaths or {}) do\nfor _, pattern in ipairs(patterns) do\nlocal i = abspath:find(path.wildcards(pattern))\nif i == 1 then\ni = pattern:find(\"*\", 1, true) or (pattern:len() + 1)\nlocal leaf\nif i < max then\nleaf = abspath:sub(i)\nelse\nleaf = fname\nend\nif leaf:startswith(\"/\") then\nleaf = leaf:sub(2)\nend\nlocal stem = \"\"\nif replacement:len() > 0 then\nstem, stars = replacement:gsub(\"%*\", \"\")\nif stars == 0 then\nleaf = path.getname(leaf)\nend\nelse\nleaf = path.getname(leaf)\nend\nvpath = path.join(stem, leaf)\nend\nend\nend\nlocal changed\nrepeat\nchanged = true\nif vpath:startswith(\"./\") then\nvpath = vpath:sub(3)\nelseif vpath:startswith(\"../\") then\nvpath = vpath:sub(4)\nelse\nchanged = false\nend\nun"
	"til not changed\nreturn vpath\nend\nfunction premake.hascppproject(sln)\nfor prj in premake.solution.eachproject(sln) do\nif premake.iscppproject(prj) then\nreturn true\nend\nend\nend\nfunction premake.hasdotnetproject(sln)\nfor prj in premake.solution.eachproject(sln) do\nif premake.isdotnetproject(prj) then\nreturn true\nend\nend\nend\nfunction premake.project.iscproject(prj)\nreturn prj.language == \"C\"\nend\nfunction premake.iscppproject(prj)\nreturn (prj.language == \"C\" or prj.language == \"C++\")\nend\nfunction premake.isdotnetproject(prj)\nreturn (prj.language == \"C#\")\nend\n",

	/* base/config.lua */
	"premake.config = { }\nlocal config = premake.config\nfunction premake.config.isdebugbuild(cfg)\nif cfg.flags.Optimize or cfg.flags.OptimizeSize or cfg.flags.OptimizeSpeed then\nreturn false\nend\nif not cfg.flags.Symbols then\nreturn false\nend\nreturn true\nend\nfunction premake.config.isincrementallink(cfg)\nif cfg.kind == \"StaticLib\" \nor config.isoptimizedbuild(cfg.flags)\nor cfg.flags.NoIncrementalLink then\nreturn false\nend\nreturn true\nend\nfunction premake.config.isoptimizedbuild(flags)\nreturn flags.Optimize or flags.OptimizeSize or flags.OptimizeSpeed\nend\n",

	/* base/bake.lua */
	"premake.bake = { }\nlocal bake = premake.bake\nlocal nocopy = \n{\nblocks    = true,\nkeywords  = true,\nprojects  = true,\n__configs = true,\n}\nlocal nocascade = \n{\nmakesettings = true,\n}\nlocal keeprelative =\n{\nbasedir  = true,\nlocation = true,\n}\nfunction premake.getactiveterms()\nlocal terms = { _action = _ACTION:lower(), os = os.get() }\nfor key, value in pairs(_OPTIONS) do\nif value ~= \"\" then\ntable.insert(terms, value:lower())\nelse\ntable.insert(terms, key:lower())\nend\nend\nreturn terms\nend\nfunction premake.iskeywordmatch(keyword, terms)\nif keyword:startswith(\"not \") then\nreturn not premake.iskeywordmatch(keyword:sub(5), terms)\nend\nfor _, pattern in ipairs(keyword:explode(\" or \")) do\nfor termkey, term in pairs(terms) do\nif term:match(pattern) == term then\nreturn termkey\nend\nend\nend\nend\nfunction premake.iskeywordsmatch(keywords, terms)\nlocal hasrequired = false\nfor _, keyword in ipairs(keywords) do\nlocal matched = premake.iskeywordmatch(keyword, terms)\nif not matched t"
	"hen\nreturn false\nend\nif matched == \"required\" then\nhasrequired = true\nend\nend\nif terms.required and not hasrequired then\nreturn false\nelse\nreturn true\nend\nend\nlocal function adjustpaths(location, obj)\nfunction adjustpathlist(list)\nfor i, p in ipairs(list) do\nlist[i] = path.getrelative(location, p) \nend\nend\nfor name, value in pairs(obj) do\nlocal field = premake.fields[name]\nif field and value and not keeprelative[name] then\nif field.kind == \"path\" then\nobj[name] = path.getrelative(location, value) \nelseif field.kind == \"dirlist\" or field.kind == \"filelist\" then\nadjustpathlist(value)\nelseif field.kind == \"keypath\" then\nfor k,v in pairs(value) do\nadjustpathlist(v)\nend\nend\nend\nend\nend\nlocal function mergefield(kind, dest, src)\nlocal tbl = dest or { }\nif kind == \"keyvalue\" or kind == \"keypath\" then\nfor key, value in pairs(src) do\ntbl[key] = mergefield(\"list\", tbl[key], value)\nend\nelse\nfor _, item in ipairs(src) do\nif not tbl[item] then\ntable.insert(tbl, ite"
	"m)\ntbl[item] = item\nend\nend\nend\nreturn tbl\nend\nlocal function mergeobject(dest, src)\nif not src then \nreturn \nend\nfor fieldname, value in pairs(src) do\nif not nocopy[fieldname] then\nlocal field = premake.fields[fieldname]\nif field then\nif type(value) == \"table\" then\ndest[fieldname] = mergefield(field.kind, dest[fieldname], value)\nelse\ndest[fieldname] = value\nend\nelse\ndest[fieldname] = value\nend\nend\nend\nend\nlocal function merge(dest, obj, basis, terms, cfgname, pltname)\nlocal key = cfgname or \"\"\npltname = pltname or \"Native\"\nif pltname ~= \"Native\" then\nkey = key .. pltname\nend\nterms.config = (cfgname or \"\"):lower()\nterms.platform = pltname:lower()\nlocal cfg = {}\nmergeobject(cfg, basis[key])\nadjustpaths(obj.location, cfg)\nmergeobject(cfg, obj)\nif (cfg.kind) then \nterms['kind']=cfg.kind:lower()\nend\nfor _, blk in ipairs(obj.blocks) do\nif (premake.iskeywordsmatch(blk.keywords, terms))then\nmergeobject(cfg, blk)\nif (cfg.kind and not cfg.terms.kind) then \ncfg.term"
	"s['kind'] = cfg.kind:lower()\nterms['kind'] = cfg.kind:lower()\nend\nend\nend\ncfg.name      = cfgname\ncfg.platform  = pltname\nfor k,v in pairs(terms) do\ncfg.terms[k] =v\nend\ndest[key] = cfg\nend\nlocal function collapse(obj, basis)\nlocal result = {}\nbasis = basis or {}\nlocal sln = obj.solution or obj\nlocal terms = premake.getactiveterms()\nmerge(result, obj, basis, terms)--this adjusts terms\nfor _, cfgname in ipairs(sln.configurations) do\nlocal terms_local = {}\nfor k,v in pairs(terms)do terms_local[k]=v end\nmerge(result, obj, basis, terms_local, cfgname, \"Native\")--terms cam also be adjusted here\nfor _, pltname in ipairs(sln.platforms or {}) do\nif pltname ~= \"Native\" then\nmerge(result, obj, basis,terms_local, cfgname, pltname)--terms also here\nend\nend\nend\nreturn result\nend\nlocal function builduniquedirs()\nlocal num_variations = 4\nlocal cfg_dirs = {}\nlocal hit_counts = {}\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs"
	") do\nlocal dirs = { }\ndirs[1] = path.getabsolute(path.join(cfg.location, cfg.objdir or cfg.project.objdir or \"obj\"))\ndirs[2] = path.join(dirs[1], iif(cfg.platform == \"Native\", \"\", cfg.platform))\ndirs[3] = path.join(dirs[2], cfg.name)\ndirs[4] = path.join(dirs[3], cfg.project.name)\ncfg_dirs[cfg] = dirs\nlocal start = iif(cfg.name, 2, 1)\nfor v = start, num_variations do\nlocal d = dirs[v]\nhit_counts[d] = (hit_counts[d] or 0) + 1\nend\nend\nend\nend\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal dir\nlocal start = iif(cfg.name, 2, 1)\nfor v = start, num_variations do\ndir = cfg_dirs[cfg][v]\nif hit_counts[dir] == 1 then break end\nend\ncfg.objectsdir = path.getrelative(cfg.location, dir)\nend\nend\nend\nend\nlocal function buildtargets()\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nfor _, cfg in pairs(prj.__configs) do\nlocal pathstyle = premake.getpathstyle(cfg)\nlocal namestyle = premake.g"
	"etnamestyle(cfg)\ncfg.buildtarget = premake.gettarget(cfg, \"build\", pathstyle, namestyle, cfg.system)\ncfg.linktarget  = premake.gettarget(cfg, \"link\",  pathstyle, namestyle, cfg.system)\nif pathstyle == \"windows\" then\ncfg.objectsdir = path.translate(cfg.objectsdir, \"\\\\\")\nend\nend\nend\nend\nend\n  local function getCfgKind(cfg)\n  if(cfg.kind) then\n  return cfg.kind;\n  end\n  \n  if(cfg.project.__configs[\"\"] and cfg.project.__configs[\"\"].kind) then\n  return cfg.project.__configs[\"\"].kind;\n  end\n  \n  return nil\n  end\n  \n  local function getprojrec(dstArray, foundList, cfg, cfgname, searchField, bLinkage)\n  if(not cfg) then return end\n  \n  local foundUsePrjs = {};\n  for _, useName in ipairs(cfg[searchField]) do\n  local testName = useName:lower();\n  if((not foundList[testName])) then\n  local theProj = nil;\n  local theUseProj = nil;\n  for _, prj in ipairs(cfg.project.solution.projects) do\n  if (prj.name:lower() == testName) then\n  if(prj.usage) then\n  theUseProj = prj;\n  el"
	"se\n  theProj = prj;\n  end\n  end\n  end\n  \n  --Must connect to a usage project.\n  if(theUseProj) then\n  foundList[testName] = true;\n  local prjEntry = {\n  name = testName,\n  proj = theProj,\n  usageProj = theUseProj,\n  bLinkageOnly = bLinkage,\n  };\n  dstArray[testName] = prjEntry;\n  table.insert(foundUsePrjs, theUseProj);\n  end\n  end\n  end\n  \n  for _, usePrj in ipairs(foundUsePrjs) do\n  --Links can only recurse through static libraries.\n  if((searchField ~= \"links\") or\n  (getCfgKind(usePrj.__configs[cfgname]) == \"StaticLib\")) then\n  getprojrec(dstArray, foundList, usePrj.__configs[cfgname],\n  cfgname, searchField, bLinkage);\n  end\n  end\n  end\n  \n  --\n  -- This function will recursively get all projects that the given configuration has in its \"uses\"\n  -- field. The return values are a list of tables. Each table in that list contains the following:\n  --name = The lowercase name of the project.\n  --proj = The project. Can be nil if it is usage-only.\n  --usageProj = The usage"
	" project. Can't be nil, as using a project that has no\n  -- usage project is not put into the list.\n  --bLinkageOnly = If this is true, then only the linkage information should be copied.\n  -- The recursion will only look at the \"uses\" field on *usage* projects.\n  -- This function will also add projects to the list that are mentioned in the \"links\"\n  -- field of usage projects. These will only copy linker information, but they will recurse.\n  -- through other \"links\" fields.\n  --\n  local function getprojectsconnections(cfg, cfgname)\n  local dstArray = {};\n  local foundList = {};\n  foundList[cfg.project.name:lower()] = true;\n  \n  --First, follow the uses recursively.\n  getprojrec(dstArray, foundList, cfg, cfgname, \"uses\", false);\n  \n  --Next, go through all of the usage projects and recursively get their links.\n  --But only if they're not already there. Get the links as linkage-only.\n  local linkArray = {};\n  for prjName, prjEntry in pairs(dstArray) do\n  getprojrec(linkArray, foundLi"
	"st, prjEntry.usageProj.__configs[cfgname], cfgname, \n  \"links\", true);\n  end\n  \n  --Copy from linkArray into dstArray.\n  for prjName, prjEntry in pairs(linkArray) do\n  dstArray[prjName] = prjEntry;\n  end\n  \n  return dstArray;\n  end\n  \n  \n  local function isnameofproj(cfg, strName)\n  local sln = cfg.project.solution;\n  local strTest = strName:lower();\n  for prjIx, prj in ipairs(sln.projects) do\n  if (prj.name:lower() == strTest) then\n  return true;\n  end\n  end\n  \n  return false;\n  end\n  --\n  -- Copies the field from dstCfg to srcCfg.\n  --\n  local function copydependentfield(srcCfg, dstCfg, strSrcField)\n  local srcField = premake.fields[strSrcField];\n  local strDstField = strSrcField;\n  \n  if type(srcCfg[strSrcField]) == \"table\" then\n  --handle paths.\n  if (srcField.kind == \"dirlist\" or srcField.kind == \"filelist\") and\n  (not keeprelative[strSrcField]) then\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  table.insert(dstCfg[strDstField],\n  path.rebase(p, srcCfg.project."
	"location, dstCfg.project.location))\n  end\n  else\n  if(strSrcField == \"links\") then\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  if(not isnameofproj(dstCfg, p)) then\n  table.insert(dstCfg[strDstField], p)\n  else\n  printf(\"Failed to copy '%s' from proj '%s'.\",\n  p, srcCfg.project.name);\n  end\n  end\n  else\n  for i,p in ipairs(srcCfg[strSrcField]) do\n  table.insert(dstCfg[strDstField], p)\n  end\n  end\n  end\n  else\n  if(srcField.kind == \"path\" and (not keeprelative[strSrcField])) then\n  dstCfg[strDstField] = path.rebase(srcCfg[strSrcField],\n  prj.location, dstCfg.project.location);\n  else\n  dstCfg[strDstField] = srcCfg[strSrcField];\n  end\n  end\n  end\n  \n  --\n  -- This function will take the list of project entries and apply their usage project data\n  -- to the given configuration. It will copy compiling information for the projects that are\n  -- not listed as linkage-only. It will copy the linking information for projects only if\n  -- the source project is not a static library."
	" It won't copy linking information\n  -- if the project is in this solution; instead it will add that project to the configuration's\n  -- links field, expecting that Premake will handle the rest.\n  --\n  local function copyusagedata(cfg, cfgname, linkToProjs)\n  local myPrj = cfg.project;\n  local bIsStaticLib = (getCfgKind(cfg) == \"StaticLib\");\n  \n  for prjName, prjEntry in pairs(linkToProjs) do\n  local srcPrj = prjEntry.usageProj;\n  local srcCfg = srcPrj.__configs[cfgname];\n  \n  for name, field in pairs(premake.fields) do\n  if(srcCfg[name]) then\n  if(field.usagecopy) then\n  if(not prjEntry.bLinkageOnly) then\n  copydependentfield(srcCfg, cfg, name)\n  end\n  elseif(field.linkagecopy) then\n  --Copy the linkage data if we're building a non-static thing\n  --and this is a pure usage project. If it's not pure-usage, then\n  --we will simply put the project's name in the links field later.\n  if((not bIsStaticLib) and (not prjEntry.proj)) then\n  copydependentfield(srcCfg, cfg, name)\n  end\n  end\n"
	"  end\n  end\n  \n  if((not bIsStaticLib) and prjEntry.proj) then\n  table.insert(cfg.links, prjEntry.proj.name);\n  end\n  end\n  end\nfunction premake.bake.buildconfigs()\nfor sln in premake.solution.each() do\nfor _, prj in ipairs(sln.projects) do\nprj.location = prj.location or sln.location or prj.basedir\nadjustpaths(prj.location, prj)\nfor _, blk in ipairs(prj.blocks) do\nadjustpaths(prj.location, blk)\nend\nend\nsln.location = sln.location or sln.basedir\nend\nfor sln in premake.solution.each() do\nlocal basis = collapse(sln)\nfor _, prj in ipairs(sln.projects) do\nprj.__configs = collapse(prj, basis)\nfor _, cfg in pairs(prj.__configs) do\nbake.postprocess(prj, cfg)\nend\nend\nend\nfor sln in premake.solution.each() do\nfor prjIx, prj in ipairs(sln.projects) do\nif(not prj.usage) then\nfor cfgname, cfg in pairs(prj.__configs) do\nlocal usesPrjs = getprojectsconnections(cfg, cfgname);\ncopyusagedata(cfg, cfgname, usesPrjs)\nend\nend\nend\nend\nfor sln in premake.solution.each() do\nlocal removeList = {}"
	";\nfor index, prj in ipairs(sln.projects) do\nif(prj.usage) then\ntable.insert(removeList, 1, index); --Add in reverse order.\nend\nend\nfor _, index in ipairs(removeList) do\ntable.remove(sln.projects, index);\nend\nend\nbuilduniquedirs()\nbuildtargets(cfg)\nend\nfunction premake.bake.postprocess(prj, cfg)\ncfg.project   = prj\ncfg.shortname = premake.getconfigname(cfg.name, cfg.platform, true)\ncfg.longname  = premake.getconfigname(cfg.name, cfg.platform)\ncfg.location = cfg.location or cfg.basedir\nlocal platform = premake.platforms[cfg.platform]\nif platform.iscrosscompiler then\ncfg.system = cfg.platform\nelse\ncfg.system = os.get()\nend\nif cfg.kind == \"SharedLib\" and platform.nosharedlibs then\ncfg.kind = \"StaticLib\"\nend\nlocal files = { }\nfor _, fname in ipairs(cfg.files) do\nlocal excluded = false\nfor _, exclude in ipairs(cfg.excludes) do\nexcluded = (fname == exclude)\nif (excluded) then break end\nend\nif (not excluded) then\ntable.insert(files, fname)\nend\nend\ncfg.files = files\nfor name, "
	"field in pairs(premake.fields) do\nif field.isflags then\nlocal values = cfg[name]\nfor _, flag in ipairs(values) do values[flag] = true end\nend\nend\ncfg.__fileconfigs = { }\nfor _, fname in ipairs(cfg.files) do\ncfg.terms.required = fname:lower()\nlocal fcfg = {}\nfor _, blk in ipairs(cfg.project.blocks) do\nif (premake.iskeywordsmatch(blk.keywords, cfg.terms)) then\nmergeobject(fcfg, blk)\nend\nend\nfcfg.name = fname\ncfg.__fileconfigs[fname] = fcfg\ntable.insert(cfg.__fileconfigs, fcfg)\nend\nend\n",

	/* base/api.lua */
	"premake.fields =\n{\nbasedir =\n{\nkind  = \"path\",\nscope = \"container\",\n},\nbuildaction =\n{\nkind  = \"string\",\nscope = \"config\",\nallowed = {\n\"Compile\",\n\"Copy\",\n\"Embed\",\n\"None\"\n}\n},\nbuildoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nconfigurations =\n{\nkind  = \"list\",\nscope = \"solution\",\n},\ndebugargs =\n{\nkind = \"list\",\nscope = \"config\",\n},\ndebugdir =\n{\nkind = \"path\",\nscope = \"config\",\n},\ndebugenvs  =\n{\nkind = \"list\",\nscope = \"config\",\n},\ndefines =\n{\nkind  = \"list\",\nscope = \"config\",\n},\ndeploymentoptions =\n{\nkind  = \"list\",\nscope = \"config\",\nusagecopy = true,\n},\nexcludes =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nfiles =\n{\nkind  = \"filelist\",\nscope = \"config\",\n},\nflags =\n{\nkind  = \"list\",\nscope = \"config\",\nisflags = true,\nusagecopy = true,\nallowed = function(value)\nlocal allowed_flags = {\nATL = 1,\nDebugEnvsDontMerge = 1,\nDebugEnvsInherit = 1,\nEnableSSE = 1,\nEnableSSE2 = 1,\nExtraWarni"
	"ngs = 1,\nFatalWarnings = 1,\nFloatFast = 1,\nFloatStrict = 1,\nManaged = 1,\nMFC = 1,\nNativeWChar = 1,\nNo64BitChecks = 1,\nNoEditAndContinue = 1,\nNoExceptions = 1,\nNoFramePointer = 1,\nNoImportLib = 1,\nNoIncrementalLink = 1,\nNoManifest = 1,\nNoMinimalRebuild = 1,\nNoNativeWChar = 1,\nNoPCH = 1,\nNoRTTI = 1,\nOptimize = 1,\nOptimizeSize = 1,\nOptimizeSpeed = 1,\nSEH = 1,\nStaticATL = 1,\nStaticRuntime = 1,\nSymbols = 1,\nUnicode = 1,\nUnsafe = 1,\nWinMain = 1\n}\nlocal englishToAmericanSpelling =\n{\noptimise = 'optimize',\noptimisesize = 'optimizesize',\noptimisespeed = 'optimizespeed',\n}\nlocal lowervalue = value:lower()\nlowervalue = englishToAmericanSpelling[lowervalue] or lowervalue\nfor v, _ in pairs(allowed_flags) do\nif v:lower() == lowervalue then\nreturn v\nend\nend\nreturn nil, \"invalid flag\"\nend,\n},\nframework =\n{\nkind = \"string\",\nscope = \"container\",\nallowed = {\n\"1.0\",\n\"1.1\",\n\"2.0\",\n\"3.0\",\n\"3.5\",\n\"4.0\",\n\"4.5\",\n}\n},\nimagepath =\n{\nkind = \"path\",\nscope "
	"= \"config\",\n},\nimageoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nimplibdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\nimplibextension =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nimplibname =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nimplibprefix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nimplibsuffix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\nincludedirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\nusagecopy = true,\n},\nkind =\n{\nkind  = \"string\",\nscope = \"config\",\nallowed = {\n\"ConsoleApp\",\n\"WindowedApp\",\n\"StaticLib\",\n\"SharedLib\"\n}\n},\nlanguage =\n{\nkind  = \"string\",\nscope = \"container\",\nallowed = {\n\"C\",\n\"C++\",\n\"C#\"\n}\n},\nlibdirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\nlinkagecopy = true,\n},\nlinkoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nlinks =\n{\nkind  = \"list\",\nscope = \"config\",\nallowed = function(value)\nif value:find('/', nil, true) then\nvalue = path.getabsolute(value)\ne"
	"nd\nreturn value\nend,\nlinkagecopy = true,\n},\nlocation =\n{\nkind  = \"path\",\nscope = \"container\",\n},\nmakesettings =\n{\nkind = \"list\",\nscope = \"config\",\n},\nobjdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\npchheader =\n{\nkind  = \"string\",\nscope = \"config\",\n},\npchsource =\n{\nkind  = \"path\",\nscope = \"config\",\n},\nplatforms =\n{\nkind  = \"list\",\nscope = \"solution\",\nallowed = table.keys(premake.platforms),\n},\npostbuildcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nprebuildcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nprelinkcommands =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nresdefines =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nresincludedirs =\n{\nkind  = \"dirlist\",\nscope = \"config\",\n},\nresoptions =\n{\nkind  = \"list\",\nscope = \"config\",\n},\ntargetdir =\n{\nkind  = \"path\",\nscope = \"config\",\n},\ntargetextension =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetname =\n{\nkind  = \"string\",\nscope = \"co"
	"nfig\",\n},\ntargetprefix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntargetsuffix =\n{\nkind  = \"string\",\nscope = \"config\",\n},\ntrimpaths =\n{\nkind = \"dirlist\",\nscope = \"config\",\n},\nuuid =\n{\nkind  = \"string\",\nscope = \"container\",\nallowed = function(value)\nlocal ok = true\nif (#value ~= 36) then ok = false end\nfor i=1,36 do\nlocal ch = value:sub(i,i)\nif (not ch:find(\"[ABCDEFabcdef0123456789-]\")) then ok = false end\nend\nif (value:sub(9,9) ~= \"-\")   then ok = false end\nif (value:sub(14,14) ~= \"-\") then ok = false end\nif (value:sub(19,19) ~= \"-\") then ok = false end\nif (value:sub(24,24) ~= \"-\") then ok = false end\nif (not ok) then\nreturn nil, \"invalid UUID\"\nend\nreturn value:upper()\nend\n},\nuses =\n{\nkind  = \"list\",\nscope = \"config\",\n},\nvpaths =\n{\nkind = \"keypath\",\nscope = \"container\",\n},\n}\nfunction premake.checkvalue(value, allowed)\nif (allowed) then\nif (type(allowed) == \"function\") then\nreturn allowed(value)\nelse\nfor _,v in ipairs(a"
	"llowed) do\nif (value:lower() == v:lower()) then\nreturn v\nend\nend\nreturn nil, \"invalid value '\" .. value .. \"'\"\nend\nelse\nreturn value\nend\nend\nfunction premake.getobject(t)\nlocal container\nif (t == \"container\" or t == \"solution\") then\ncontainer = premake.CurrentContainer\nelse\ncontainer = premake.CurrentConfiguration\nend\nif t == \"solution\" then\nif type(container) == \"project\" then\ncontainer = container.solution\nend\nif type(container) ~= \"solution\" then\ncontainer = nil\nend\nend\nlocal msg\nif (not container) then\nif (t == \"container\") then\nmsg = \"no active solution or project\"\nelseif (t == \"solution\") then\nmsg = \"no active solution\"\nelse\nmsg = \"no active solution, project, or configuration\"\nend\nend\nreturn container, msg\nend\nfunction premake.setarray(ctype, fieldname, value, allowed)\nlocal container, err = premake.getobject(ctype)\nif (not container) then\nerror(err, 4)\nend\nif (not container[fieldname]) then\ncontainer[fieldname] = { }\nend\nlocal functi"
	"on doinsert(value, depth)\nif (type(value) == \"table\") then\nfor _,v in ipairs(value) do\ndoinsert(v, depth + 1)\nend\nelse\nvalue, err = premake.checkvalue(value, allowed)\nif (not value) then\nerror(err, depth)\nend\ntable.insert(container[fieldname], value)\nend\nend\nif (value) then\ndoinsert(value, 5)\nend\nreturn container[fieldname]\nend\nlocal function domatchedarray(ctype, fieldname, value, matchfunc)\nlocal result = { }\nfunction makeabsolute(value, depth)\nif (type(value) == \"table\") then\nfor _, item in ipairs(value) do\nmakeabsolute(item, depth + 1)\nend\nelseif type(value) == \"string\" then\nif value:find(\"*\") then\nmakeabsolute(matchfunc(value), depth + 1)\nelse\ntable.insert(result, path.getabsolute(value))\nend\nelse\nerror(\"Invalid value in list: expected string, got \" .. type(value), depth)\nend\nend\nmakeabsolute(value, 3)\nreturn premake.setarray(ctype, fieldname, result)\nend\nfunction premake.setdirarray(ctype, fieldname, value)\nreturn domatchedarray(ctype, fieldname, value, os"
	".matchdirs)\nend\nfunction premake.setfilearray(ctype, fieldname, value)\nreturn domatchedarray(ctype, fieldname, value, os.matchfiles)\nend\nfunction premake.setkeyvalue(ctype, fieldname, values)\nlocal container, err = premake.getobject(ctype)\nif not container then\nerror(err, 4)\nend\nif not container[fieldname] then\ncontainer[fieldname] = {}\nend\nif type(values) ~= \"table\" then\nerror(\"invalid value; table expected\", 4)\nend\nlocal field = container[fieldname]\nfor key,value in pairs(values) do\nif not field[key] then\nfield[key] = {}\nend\ntable.insertflat(field[key], value)\nend\nreturn field\nend\nfunction premake.setstring(ctype, fieldname, value, allowed)\nlocal container, err = premake.getobject(ctype)\nif (not container) then\nerror(err, 4)\nend\nif (value) then\nvalue, err = premake.checkvalue(value, allowed)\nif (not value) then\nerror(err, 4)\nend\ncontainer[fieldname] = value\nend\nreturn container[fieldname]\nend\nlocal function accessor(name, value)\nlocal kind    = premake.fields[name]"
	".kind\nlocal scope   = premake.fields[name].scope\nlocal allowed = premake.fields[name].allowed\nif (kind == \"string\" or kind == \"path\") and value then\nif type(value) ~= \"string\" then\nerror(\"string value expected\", 3)\nend\nend\nif kind == \"string\" then\nreturn premake.setstring(scope, name, value, allowed)\nelseif kind == \"path\" then\nif value then value = path.getabsolute(value) end\nreturn premake.setstring(scope, name, value)\nelseif kind == \"list\" then\nreturn premake.setarray(scope, name, value, allowed)\nelseif kind == \"dirlist\" then\nreturn premake.setdirarray(scope, name, value)\nelseif kind == \"filelist\" then\nreturn premake.setfilearray(scope, name, value)\nelseif kind == \"keyvalue\" or kind == \"keypath\" then\nreturn premake.setkeyvalue(scope, name, value)\nend\nend\nfor name,_ in pairs(premake.fields) do\n_G[name] = function(value)\nreturn accessor(name, value)\nend\nend\nfunction configuration(terms)\nif not terms then\nreturn premake.CurrentConfiguration\nend\nlocal contain"
	"er, err = premake.getobject(\"container\")\nif (not container) then\nerror(err, 2)\nend\nlocal cfg = { }\ncfg.terms = table.flatten({terms})\ntable.insert(container.blocks, cfg)\npremake.CurrentConfiguration = cfg\ncfg.keywords = { }\nfor _, word in ipairs(cfg.terms) do\ntable.insert(cfg.keywords, path.wildcards(word):lower())\nend\nfor name, field in pairs(premake.fields) do\nif (field.kind ~= \"string\" and field.kind ~= \"path\") then\ncfg[name] = { }\nend\nend\nreturn cfg\nend\nlocal function createproject(name, sln, isUsage)\nlocal prj = {}\nsetmetatable(prj, {\n__type = \"project\",\n})\ntable.insert(sln.projects, prj)\nif(isUsage) then\nif(sln.projects[name]) then\nsln.projects[name].usageProj = prj;\nelse\nsln.projects[name] = prj\nend\nelse\nif(sln.projects[name]) then\nprj.usageProj = sln.projects[name];\nend\nsln.projects[name] = prj\nend\nprj.solution       = sln\nprj.name           = name\nprj.basedir        = os.getcwd()\nprj.uuid           = os.uuid()\nprj.blocks         = { }\nprj.usage   = isU"
	"sage;\nreturn prj;\nend\nfunction usage(name)\nif (not name) then\nif(type(premake.CurrentContainer) ~= \"project\") then return nil end\nif(not premake.CurrentContainer.usage) then return nil end\nreturn premake.CurrentContainer\nend\nlocal sln\nif (type(premake.CurrentContainer) == \"project\") then\nsln = premake.CurrentContainer.solution\nelse\nsln = premake.CurrentContainer\nend\nif (type(sln) ~= \"solution\") then\nerror(\"no active solution\", 2)\nend\n  -- if this is a new project, or the project in that slot doesn't have a usage, create it\n  if((not sln.projects[name]) or\n  ((not sln.projects[name].usage) and (not sln.projects[name].usageProj))) then\n  premake.CurrentContainer = createproject(name, sln, true)\n  else\n  premake.CurrentContainer = iff(sln.projects[name].usage,\n  sln.projects[name], sln.projects[name].usageProj)\n  end\n  -- add an empty, global configuration to the project\n  configuration { }\n  return premake.CurrentContainer\n  end\n  function project(name)\n  if (not name) then"
	"\n  --Only return non-usage projects\n  if(type(premake.CurrentContainer) ~= \"project\") then return nil end\n  if(premake.CurrentContainer.usage) then return nil end\n  return premake.CurrentContainer\nend\n  -- identify the parent solution\n  local sln\n  if (type(premake.CurrentContainer) == \"project\") then\n  sln = premake.CurrentContainer.solution\n  else\n  sln = premake.CurrentContainer\n  end\n  if (type(sln) ~= \"solution\") then\n  error(\"no active solution\", 2)\n  end\n  -- if this is a new project, or the old project is a usage project, create it\n  if((not sln.projects[name]) or sln.projects[name].usage) then\n  premake.CurrentContainer = createproject(name, sln)\n  else\n  premake.CurrentContainer = sln.projects[name];\n  end\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction solution(name)\nif not name then\nif type(premake.CurrentContainer) == \"project\" then\nreturn premake.CurrentContainer.solution\nelse\nreturn premake.CurrentContainer\nend\nend\npremake.CurrentContaine"
	"r = premake.solution.get(name)\nif (not premake.CurrentContainer) then\npremake.CurrentContainer = premake.solution.new(name)\nend\nconfiguration { }\nreturn premake.CurrentContainer\nend\nfunction newaction(a)\npremake.action.add(a)\nend\nfunction newoption(opt)\npremake.option.add(opt)\nend\n",

	/* base/cmdline.lua */
	"newoption \n{\ntrigger     = \"cc\",\nvalue       = \"VALUE\",\ndescription = \"Choose a C/C++ compiler set\",\nallowed = {\n{ \"gcc\", \"GNU GCC (gcc/g++)\" },\n{ \"ow\",  \"OpenWatcom\"        },\n}\n}\nnewoption\n{\ntrigger     = \"dotnet\",\nvalue       = \"VALUE\",\ndescription = \"Choose a .NET compiler set\",\nallowed = {\n{ \"msnet\",   \"Microsoft .NET (csc)\" },\n{ \"mono\",    \"Novell Mono (mcs)\"    },\n{ \"pnet\",    \"Portable.NET (cscc)\"  },\n}\n}\nnewoption\n{\ntrigger     = \"file\",\nvalue       = \"FILE\",\ndescription = \"Read FILE as a Premake script; default is 'premake4.lua'\"\n}\nnewoption\n{\ntrigger     = \"help\",\ndescription = \"Display this information\"\n}\nnewoption\n{\ntrigger     = \"os\",\nvalue       = \"VALUE\",\ndescription = \"Generate files for a different operating system\",\nallowed = {\n{ \"bsd\",      \"OpenBSD, NetBSD, or FreeBSD\" },\n{ \"haiku\",    \"Haiku\" },\n{ \"linux\",    \"Linux\" },\n{ \"macosx\",   \"Apple Mac OS X\" },\n{ \"solaris\",  \"Solaris\" },"
	"\n{ \"windows\",  \"Microsoft Windows\" },\n}\n}\nnewoption\n{\ntrigger     = \"platform\",\nvalue       = \"VALUE\",\ndescription = \"Add target architecture (if supported by action)\",\nallowed = {\n{ \"x32\",         \"32-bit\" },\n{ \"x64\",         \"64-bit\" },\n{ \"universal\",   \"Mac OS X Universal, 32- and 64-bit\" },\n{ \"universal32\", \"Mac OS X Universal, 32-bit only\" },\n{ \"universal64\", \"Mac OS X Universal, 64-bit only\" },\n{ \"ps3\",         \"Playstation 3 (experimental)\" },\n{ \"xbox360\",     \"Xbox 360 (experimental)\" },\n}\n}\nnewoption\n{\ntrigger     = \"scripts\",\nvalue       = \"path\",\ndescription = \"Search for additional scripts on the given path\"\n}\nnewoption\n{\ntrigger     = \"version\",\ndescription = \"Display version information\"\n}\n",

	/* tools/dotnet.lua */
	"premake.dotnet = { }\npremake.dotnet.namestyle = \"windows\"\nlocal flags =\n{\nFatalWarning   = \"/warnaserror\",\nOptimize       = \"/optimize\",\nOptimizeSize   = \"/optimize\",\nOptimizeSpeed  = \"/optimize\",\nSymbols        = \"/debug\",\nUnsafe         = \"/unsafe\"\n}\nfunction premake.dotnet.getbuildaction(fcfg)\nlocal ext = path.getextension(fcfg.name):lower()\nif fcfg.buildaction == \"Compile\" or ext == \".cs\" then\nreturn \"Compile\"\nelseif fcfg.buildaction == \"Embed\" or ext == \".resx\" then\nreturn \"EmbeddedResource\"\nelseif fcfg.buildaction == \"Copy\" or ext == \".asax\" or ext == \".aspx\" then\nreturn \"Content\"\nelse\nreturn \"None\"\nend\nend\nfunction premake.dotnet.getcompilervar(cfg)\nif (_OPTIONS.dotnet == \"msnet\") then\nreturn \"csc\"\nelseif (_OPTIONS.dotnet == \"mono\") then\nif (cfg.framework <= \"1.1\") then\nreturn \"mcs\"\nelseif (cfg.framework >= \"4.0\") then\nreturn \"dmcs\"\nelse \nreturn \"gmcs\"\nend\nelse\nreturn \"cscc\"\nend\nend\nfunction premake.dotnet.getfla"
	"gs(cfg)\nlocal result = table.translate(cfg.flags, flags)\nreturn result\nend\nfunction premake.dotnet.getkind(cfg)\nif (cfg.kind == \"ConsoleApp\") then\nreturn \"Exe\"\nelseif (cfg.kind == \"WindowedApp\") then\nreturn \"WinExe\"\nelseif (cfg.kind == \"SharedLib\") then\nreturn \"Library\"\nend\nend",

	/* tools/gcc.lua */
	"premake.gcc = { }\npremake.gcc.cc     = \"gcc\"\npremake.gcc.cxx    = \"g++\"\npremake.gcc.ar     = \"ar\"\nlocal cflags =\n{\nEnableSSE      = \"-msse\",\nEnableSSE2     = \"-msse2\",\nExtraWarnings  = \"-Wall -Wextra\",\nFatalWarnings  = \"-Werror\",\nFloatFast      = \"-ffast-math\",\nFloatStrict    = \"-ffloat-store\",\nNoFramePointer = \"-fomit-frame-pointer\",\nOptimize       = \"-O2\",\nOptimizeSize   = \"-Os\",\nOptimizeSpeed  = \"-O3\",\nSymbols        = \"-g\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"-fno-exceptions\",\nNoRTTI         = \"-fno-rtti\",\n}\npremake.gcc.platforms =\n{\nNative = {\ncppflags = \"-MMD\",\n},\nx32 = {\ncppflags = \"-MMD\",\nflags    = \"-m32\",\nldflags  = \"-L/usr/lib32\",\n},\nx64 = {\ncppflags = \"-MMD\",\nflags    = \"-m64\",\nldflags  = \"-L/usr/lib64\",\n},\nUniversal = {\ncppflags = \"\",\nflags    = \"-arch i386 -arch x86_64 -arch ppc -arch ppc64\",\n},\nUniversal32 = {\ncppflags = \"\",\nflags    = \"-arch i386 -arch ppc\",\n},\nUniversal64 = {\ncppflags = \"\""
	",\nflags    = \"-arch x86_64 -arch ppc64\",\n},\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD\",\n},\nWiiDev = {\ncppflags    = \"-MMD -MP -I$(LIBOGC_INC) $(MACHDEP)\",\nldflags= \"-L$(LIBOGC_LIB) $(MACHDEP)\",\ncfgsettings = [[\n  ifeq ($(strip $(DEVKITPPC)),)\n    $(error \"DEVKITPPC environment variable is not set\")'\n  endif\n  include $(DEVKITPPC)/wii_rules']],\n},\n}\nlocal platforms = premake.gcc.platforms\nfunction premake.gcc.getcppflags(cfg)\nlocal flags = { }\ntable.insert(flags, platforms[cfg.platform].cppflags)\nif flags[1]:startswith(\"-MMD\") and cfg.system ~= \"haiku\" then\ntable.insert(flags, \"-MP\")\nend\nreturn flags\nend\nfunction premake.gcc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.system ~= \"windows\" and cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.gcc.getcxxflags"
	"(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.gcc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\nif cfg.system == \"macosx\" then\ntable.insert(result, \"-Wl,-x\")\nelse\ntable.insert(result, \"-s\")\nend\nend\nif cfg.kind == \"SharedLib\" then\nif cfg.system == \"macosx\" then\ntable.insert(result, \"-dynamiclib\")\nelse\ntable.insert(result, \"-shared\")\nend\nif cfg.system == \"windows\" and not cfg.flags.NoImportLib then\ntable.insert(result, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nif cfg.kind == \"WindowedApp\" and cfg.system == \"windows\" then\ntable.insert(result, \"-mwindows\")\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.gcc.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L' .. _MAKE.esc(value))\n"
	"end\nreturn result\nend\nfunction premake.gcc.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"name\")) do\nif path.getextension(value) == \".framework\" then\ntable.insert(result, '-framework ' .. _MAKE.esc(path.getbasename(value)))\nelse\ntable.insert(result, '-l' .. _MAKE.esc(value))\nend\nend\nreturn result\nend\nfunction premake.gcc.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.gcc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\" .. _MAKE.esc(dir))\nend\nreturn result\nend\nfunction premake.gcc.getcfgsettings(cfg)\nreturn platforms[cfg.platform].cfgsettings\nend\n",

	/* tools/msc.lua */
	"premake.msc = { }\npremake.msc.namestyle = \"windows\"\n",

	/* tools/ow.lua */
	"premake.ow = { }\npremake.ow.namestyle = \"windows\"\npremake.ow.cc     = \"WCL386\"\npremake.ow.cxx    = \"WCL386\"\npremake.ow.ar     = \"ar\"\nlocal cflags =\n{\nExtraWarnings  = \"-wx\",\nFatalWarning   = \"-we\",\nFloatFast      = \"-omn\",\nFloatStrict    = \"-op\",\nOptimize       = \"-ox\",\nOptimizeSize   = \"-os\",\nOptimizeSpeed  = \"-ot\",\nSymbols        = \"-d2\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"-xd\",\nNoRTTI         = \"-xr\",\n}\npremake.ow.platforms = \n{\nNative = { \nflags = \"\" \n},\n}\nfunction premake.ow.getcppflags(cfg)\nreturn {}\nend\nfunction premake.ow.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\nif (cfg.flags.Symbols) then\ntable.insert(result, \"-hw\")   -- Watcom debug format for Watcom debugger\nend\nreturn result\nend\nfunction premake.ow.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction premake.ow.getldflags(cfg)\nlocal result = { }\nif (cfg.flags.Symbols) then\ntable.insert(result, \"op symf"
	"\")\nend\nreturn result\nend\nfunction premake.ow.getlinkflags(cfg)\nlocal result = { }\nreturn result\nend\nfunction premake.ow.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction premake.ow.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, '-I \"' .. dir .. '\"')\nend\nreturn result\nend\n",

	/* tools/snc.lua */
	"premake.snc = { }\npremake.snc.cc     = \"snc\"\npremake.snc.cxx    = \"g++\"\npremake.snc.ar     = \"ar\"\nlocal cflags =\n{\nExtraWarnings  = \"-Xdiag=2\",\nFatalWarnings  = \"-Xquit=2\",\n}\nlocal cxxflags =\n{\nNoExceptions   = \"\", -- No exceptions is the default in the SNC compiler.\nNoRTTI         = \"-Xc-=rtti\",\n}\npremake.snc.platforms = \n{\nPS3 = {\ncc         = \"ppu-lv2-g++\",\ncxx        = \"ppu-lv2-g++\",\nar         = \"ppu-lv2-ar\",\ncppflags   = \"-MMD -MP\",\n}\n}\nlocal platforms = premake.snc.platforms\nfunction premake.snc.getcppflags(cfg)\nlocal result = { }\ntable.insert(result, platforms[cfg.platform].cppflags)\nreturn result\nend\nfunction premake.snc.getcflags(cfg)\nlocal result = table.translate(cfg.flags, cflags)\ntable.insert(result, platforms[cfg.platform].flags)\nif cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-fPIC\")\nend\nreturn result\nend\nfunction premake.snc.getcxxflags(cfg)\nlocal result = table.translate(cfg.flags, cxxflags)\nreturn result\nend\nfunction pr"
	"emake.snc.getldflags(cfg)\nlocal result = { }\nif not cfg.flags.Symbols then\ntable.insert(result, \"-s\")\nend\nif cfg.kind == \"SharedLib\" then\ntable.insert(result, \"-shared\")\nif not cfg.flags.NoImportLib then\ntable.insert(result, '-Wl,--out-implib=\"' .. cfg.linktarget.fullpath .. '\"')\nend\nend\nlocal platform = platforms[cfg.platform]\ntable.insert(result, platform.flags)\ntable.insert(result, platform.ldflags)\nreturn result\nend\nfunction premake.snc.getlibdirflags(cfg)\nlocal result = { }\nfor _, value in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\ntable.insert(result, '-L' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.snc.getlinkflags(cfg)\nlocal result = {}\nfor _, value in ipairs(premake.getlinks(cfg, \"system\", \"name\")) do\ntable.insert(result, '-l' .. _MAKE.esc(value))\nend\nreturn result\nend\nfunction premake.snc.getdefines(defines)\nlocal result = { }\nfor _,def in ipairs(defines) do\ntable.insert(result, '-D' .. def)\nend\nreturn result\nend\nfunction "
	"premake.snc.getincludedirs(includedirs)\nlocal result = { }\nfor _,dir in ipairs(includedirs) do\ntable.insert(result, \"-I\" .. _MAKE.esc(dir))\nend\nreturn result\nend\n",

	/* base/validate.lua */
	"function premake.checkprojects()\nlocal action = premake.action.current()\nfor sln in premake.solution.each() do\nif (#sln.projects == 0) then\nreturn nil, \"solution '\" .. sln.name .. \"' needs at least one project\"\nend\nif (#sln.configurations == 0) then\nreturn nil, \"solution '\" .. sln.name .. \"' needs configurations\"\nend\nfor prj in premake.solution.eachproject(sln) do\nif (not prj.language) then\nreturn nil, \"project '\" ..prj.name .. \"' needs a language\"\nend\nif (action.valid_languages) then\nif (not table.contains(action.valid_languages, prj.language)) then\nreturn nil, \"the \" .. action.shortname .. \" action does not support \" .. prj.language .. \" projects\"\nend\nend\nfor cfg in premake.eachconfig(prj) do\nif (not cfg.kind) then\nreturn nil, \"project '\" ..prj.name .. \"' needs a kind in configuration '\" .. cfg.name .. \"'\"\nend\nif (action.valid_kinds) then\nif (not table.contains(action.valid_kinds, cfg.kind)) then\nreturn nil, \"the \" .. action.shortname .. \" action does not su"
	"pport \" .. cfg.kind .. \" projects\"\nend\nend\nend\nif action.oncheckproject then\naction.oncheckproject(prj)\nend\nend\nend\nreturn true\nend\nfunction premake.checktools()\nlocal action = premake.action.current()\nif (not action.valid_tools) then \nreturn true \nend\nfor tool, values in pairs(action.valid_tools) do\nif (_OPTIONS[tool]) then\nif (not table.contains(values, _OPTIONS[tool])) then\nreturn nil, \"the \" .. action.shortname .. \" action does not support /\" .. tool .. \"=\" .. _OPTIONS[tool] .. \" (yet)\"\nend\nelse\n_OPTIONS[tool] = values[1]\nend\nend\nreturn true\nend\n",

	/* base/help.lua */
	"function premake.showhelp()\nprintf(\"Premake %s, a build script generator\", _PREMAKE_VERSION)\nprintf(_PREMAKE_COPYRIGHT)\nprintf(\"%s %s\", _VERSION, _COPYRIGHT)\nprintf(\"\")\nprintf(\"Usage: premake4 [options] action [arguments]\")\nprintf(\"\")\nprintf(\"OPTIONS\")\nprintf(\"\")\nfor option in premake.option.each() do\nlocal trigger = option.trigger\nlocal description = option.description\nif (option.value) then trigger = trigger .. \"=\" .. option.value end\nif (option.allowed) then description = description .. \"; one of:\" end\nprintf(\" --%-15s %s\", trigger, description) \nif (option.allowed) then\nfor _, value in ipairs(option.allowed) do\nprintf(\"     %-14s %s\", value[1], value[2])\nend\nend\nprintf(\"\")\nend\nprintf(\"ACTIONS\")\nprintf(\"\")\nfor action in premake.action.each() do\nprintf(\" %-17s %s\", action.trigger, action.description)\nend\nprintf(\"\")\nprintf(\"For additional information, see http://industriousone.com/premake\")\nend\n",

	/* base/premake.lua */
	"function premake.generate(obj, filename, callback)\nfilename = premake.project.getfilename(obj, filename)\nprintf(\"Generating %s...\", filename)\nlocal f, err = io.open(filename, \"wb\")\nif (not f) then\nerror(err, 0)\nend\nio.output(f)\ncallback(obj)\nf:close()\nend\n",

	/* actions/codeblocks/_codeblocks.lua */
	"premake.codeblocks = { }\nnewaction {\ntrigger         = \"codeblocks\",\nshortname       = \"Code::Blocks\",\ndescription     = \"Generate Code::Blocks project files\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc   = { \"gcc\", \"ow\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.workspace\", premake.codeblocks.workspace)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.cbp\", premake.codeblocks.cbp)\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, \"%%.workspace\")\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, \"%%.cbp\")\npremake.clean.file(prj, \"%%.depend\")\npremake.clean.file(prj, \"%%.layout\")\nend\n}\n",

	/* actions/codeblocks/codeblocks_workspace.lua */
	"function premake.codeblocks.workspace(sln)\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>')\n_p('<CodeBlocks_workspace_file>')\n_p(1,'<Workspace title=\"%s\">', sln.name)\nfor prj in premake.solution.eachproject(sln) do\nlocal fname = path.join(path.getrelative(sln.location, prj.location), prj.name)\nlocal active = iif(prj.project == sln.projects[1], ' active=\"1\"', '')\n_p(2,'<Project filename=\"%s.cbp\"%s>', fname, active)\nfor _,dep in ipairs(premake.getdependencies(prj)) do\n_p(3,'<Depends filename=\"%s.cbp\" />', path.join(path.getrelative(sln.location, dep.location), dep.name))\nend\n_p(2,'</Project>')\nend\n_p(1,'</Workspace>')\n_p('</CodeBlocks_workspace_file>')\nend\n",

	/* actions/codeblocks/codeblocks_cbp.lua */
	"local codeblocks = premake.codeblocks\nfunction codeblocks.files(prj)\nlocal pchheader\nif (prj.pchheader) then\npchheader = path.getrelative(prj.location, prj.pchheader)\nend\nfor fcfg in premake.project.eachfile(prj) do\n_p(2,'<Unit filename=\"%s\">', premake.esc(fcfg.name))\nif fcfg.name ~= fcfg.vpath then\n_p(3,'<Option virtualFolder=\"%s\" />', path.getdirectory(fcfg.vpath))\nend\nif path.isresourcefile(fcfg.name) then\n_p(3,'<Option compilerVar=\"WINDRES\" />')\nelseif path.iscfile(fcfg.name) and prj.language == \"C++\" then\n_p(3,'<Option compilerVar=\"CC\" />')\nend\nif not prj.flags.NoPCH and fcfg.name == pchheader then\n_p(3,'<Option compilerVar=\"%s\" />', iif(prj.language == \"C\", \"CC\", \"CPP\"))\n_p(3,'<Option compile=\"1\" />')\n_p(3,'<Option weight=\"0\" />')\n_p(3,'<Add option=\"-x c++-header\" />')\nend\n_p(2,'</Unit>')\nend\nend\nfunction premake.codeblocks.debugenvs(cfg)\nif premake.gettool(cfg) == premake.gcc then\n_p(3,'<debugger>')\n_p(4,'<remote_debugging target=\"%s\">', premake.esc("
	"cfg.longname))\nlocal args = ''\nlocal sz = #cfg.debugenvs\nfor idx, v in ipairs(cfg.debugenvs) do\nargs = args .. 'set env ' .. v \nif sz ~= idx then args = args .. '&#x0A;' end\nend\n_p(5,'<options additional_cmds_before=\"%s\" />',args)\n_p(4,'</remote_debugging>')\n_p(3,'</debugger>')\nelse\n error('Sorry at this moment there is no support for debug environment variables with this debugger and codeblocks')\nend\nend\nfunction premake.codeblocks.cbp(prj)\nlocal cc = premake.gettool(prj)\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>')\n_p('<CodeBlocks_project_file>')\n_p(1,'<FileVersion major=\"1\" minor=\"6\" />')\n_p(1,'<Project>')\n_p(2,'<Option title=\"%s\" />', premake.esc(prj.name))\n_p(2,'<Option pch_mode=\"2\" />')\n_p(2,'<Option compiler=\"%s\" />', _OPTIONS.cc)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\nfor i = #platforms, 1, -1 do\nif premake.platforms[platforms[i]].iscrosscompiler then\ntable.remove(platforms, i)\nend\nend \n_p(2,'<Bu"
	"ild>')\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\n_p(3,'<Target title=\"%s\">', premake.esc(cfg.longname))\n_p(4,'<Option output=\"%s\" prefix_auto=\"0\" extension_auto=\"0\" />', premake.esc(cfg.buildtarget.fullpath))\nif cfg.debugdir then\n_p(4,'<Option working_dir=\"%s\" />', premake.esc(cfg.debugdir))\nend\n_p(4,'<Option object_output=\"%s\" />', premake.esc(cfg.objectsdir))\nlocal types = { WindowedApp = 0, ConsoleApp = 1, StaticLib = 2, SharedLib = 3 }\n_p(4,'<Option type=\"%d\" />', types[cfg.kind])\n_p(4,'<Option compiler=\"%s\" />', _OPTIONS.cc)\nif (cfg.kind == \"SharedLib\") then\n_p(4,'<Option createDefFile=\"0\" />')\n_p(4,'<Option createStaticLib=\"%s\" />', iif(cfg.flags.NoImportLib, 0, 1))\nend\n_p(4,'<Compiler>')\nfor _,flag in ipairs(table.join(cc.getcflags(cfg), cc.getcxxflags(cfg), cc.getdefines(cfg.defines), cfg.buildoptions)) do\n_p(5,'<Add option=\"%s\" />', premake.esc(flag))\nend\nif not cfg.flags.NoPCH and cfg.pchheader then\n_p(5,'<Add "
	"option=\"-Winvalid-pch\" />')\n_p(5,'<Add option=\"-include &quot;%s&quot;\" />', premake.esc(cfg.pchheader))\nend\nfor _,v in ipairs(cfg.includedirs) do\n_p(5,'<Add directory=\"%s\" />', premake.esc(v))\nend\n_p(4,'</Compiler>')\n_p(4,'<Linker>')\nfor _,flag in ipairs(table.join(cc.getldflags(cfg), cfg.linkoptions)) do\n_p(5,'<Add option=\"%s\" />', premake.esc(flag))\nend\nfor _,v in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\n_p(5,'<Add directory=\"%s\" />', premake.esc(v))\nend\nfor _,v in ipairs(premake.getlinks(cfg, \"all\", \"basename\")) do\n_p(5,'<Add library=\"%s\" />', premake.esc(v))\nend\n_p(4,'</Linker>')\nif premake.findfile(cfg, \".rc\") then\n_p(4,'<ResourceCompiler>')\nfor _,v in ipairs(cfg.includedirs) do\n_p(5,'<Add directory=\"%s\" />', premake.esc(v))\nend\nfor _,v in ipairs(cfg.resincludedirs) do\n_p(5,'<Add directory=\"%s\" />', premake.esc(v))\nend\n_p(4,'</ResourceCompiler>')\nend\nif #cfg.prebuildcommands > 0 or #cfg.postbuildcommands > 0 then\n_p(4,'<ExtraCommands>')\n"
	"for _,v in ipairs(cfg.prebuildcommands) do\n_p(5,'<Add before=\"%s\" />', premake.esc(v))\nend\nfor _,v in ipairs(cfg.postbuildcommands) do\n_p(5,'<Add after=\"%s\" />', premake.esc(v))\nend\n_p(4,'</ExtraCommands>')\nend\n_p(3,'</Target>')\nend\nend\n_p(2,'</Build>')\ncodeblocks.files(prj)\n_p(2,'<Extensions>')\n        for _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\nif cfg.debugenvs and #cfg.debugenvs > 0 then\npremake.codeblocks.debugenvs(cfg)\nend\nend\nend\n_p(2,'</Extensions>')\n_p(1,'</Project>')\n_p('</CodeBlocks_project_file>')\n_p('')\nend\n",

	/* actions/codelite/_codelite.lua */
	"premake.codelite = { }\nnewaction {\ntrigger         = \"codelite\",\nshortname       = \"CodeLite\",\ndescription     = \"Generate CodeLite project files\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc   = { \"gcc\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.workspace\", premake.codelite.workspace)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.project\", premake.codelite.project)\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, \"%%.workspace\")\npremake.clean.file(sln, \"%%_wsp.mk\")\npremake.clean.file(sln, \"%%.tags\")\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, \"%%.project\")\npremake.clean.file(prj, \"%%.mk\")\npremake.clean.file(prj, \"%%.list\")\npremake.clean.file(prj, \"%%.out\")\nend\n}\n",

	/* actions/codelite/codelite_workspace.lua */
	"function premake.codelite.workspace(sln)\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\n_p('<CodeLite_Workspace Name=\"%s\" Database=\"./%s.tags\">', premake.esc(sln.name), premake.esc(sln.name))\nfor i,prj in ipairs(sln.projects) do\nlocal name = premake.esc(prj.name)\nlocal fname = path.join(path.getrelative(sln.location, prj.location), prj.name)\nlocal active = iif(i==1, \"Yes\", \"No\")\n_p('  <Project Name=\"%s\" Path=\"%s.project\" Active=\"%s\" />', name, fname, active)\nend\nlocal platforms = premake.filterplatforms(sln, premake[_OPTIONS.cc].platforms, \"Native\")\nfor i = #platforms, 1, -1 do\nif premake.platforms[platforms[i]].iscrosscompiler then\ntable.remove(platforms, i)\nend\nend \n_p('  <BuildMatrix>')\nfor _, platform in ipairs(platforms) do\nfor _, cfgname in ipairs(sln.configurations) do\nlocal name = premake.getconfigname(cfgname, platform):gsub(\"|\",\"_\")\n_p('    <WorkspaceConfiguration Name=\"%s\" Selected=\"yes\">', name)\nfor _,prj in ipairs(sln.projects) do\n_p('      <Project N"
	"ame=\"%s\" ConfigName=\"%s\"/>', prj.name, name)\nend\n_p('    </WorkspaceConfiguration>')\nend\nend\n_p('  </BuildMatrix>')\n_p('</CodeLite_Workspace>')\nend\n",

	/* actions/codelite/codelite_project.lua */
	"local codelite = premake.codelite\nlocal tree = premake.tree\nfunction codelite.files(prj)\nlocal tr = premake.project.buildsourcetree(prj)\ntree.traverse(tr, {\nonbranchenter = function(node, depth)\n_p(depth, '<VirtualDirectory Name=\"%s\">', node.name)\nend,\nonbranchexit = function(node, depth)\n_p(depth, '</VirtualDirectory>')\nend,\nonleaf = function(node, depth)\n_p(depth, '<File Name=\"%s\"/>', node.cfg.name)\nend,\n}, true, 1)\nend\nfunction premake.codelite.project(prj)\nio.indent = \"  \"\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\n_p('<CodeLite_Project Name=\"%s\">', premake.esc(prj.name))\ncodelite.files(prj)\nlocal types = { \nConsoleApp  = \"Executable\", \nWindowedApp = \"Executable\", \nStaticLib   = \"Static Library\",\nSharedLib   = \"Dynamic Library\",\n}\n_p('  <Settings Type=\"%s\">', types[prj.kind])\nlocal platforms = premake.filterplatforms(prj.solution, premake[_OPTIONS.cc].platforms, \"Native\")\nfor i = #platforms, 1, -1 do\nif premake.platforms[platforms[i]].iscrosscompiler "
	"then\ntable.remove(platforms, i)\nend\nend \nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\nlocal name = premake.esc(cfg.longname):gsub(\"|\",\"_\")\nlocal compiler = iif(cfg.language == \"C\", \"gcc\", \"g++\")\n_p('    <Configuration Name=\"%s\" CompilerType=\"gnu %s\" DebuggerType=\"GNU gdb debugger\" Type=\"%s\">', name, compiler, types[cfg.kind])\nlocal fname  = premake.esc(cfg.buildtarget.fullpath)\nlocal objdir = premake.esc(cfg.objectsdir)\nlocal runcmd = cfg.buildtarget.name\nlocal rundir = cfg.debugdir or cfg.buildtarget.directory\nlocal runargs = table.concat(cfg.debugargs, \" \")\nlocal pause  = iif(cfg.kind == \"WindowedApp\", \"no\", \"yes\")\n_p('      <General OutputFile=\"%s\" IntermediateDirectory=\"%s\" Command=\"./%s\" CommandArguments=\"%s\" WorkingDirectory=\"%s\" PauseExecWhenProcTerminates=\"%s\"/>', fname, objdir, runcmd, runargs, rundir, pause)\nlocal flags = premake.esc(table.join(premake.gcc.getcflags(cfg), premake.gcc.getcxxflags(cfg), cfg"
	".buildoptions))\n_p('      <Compiler Required=\"yes\" Options=\"%s\">', table.concat(flags, \";\"))\nfor _,v in ipairs(cfg.includedirs) do\n_p('        <IncludePath Value=\"%s\"/>', premake.esc(v))\nend\nfor _,v in ipairs(cfg.defines) do\n_p('        <Preprocessor Value=\"%s\"/>', premake.esc(v))\nend\n_p('      </Compiler>')\nflags = premake.esc(table.join(premake.gcc.getldflags(cfg), cfg.linkoptions))\n_p('      <Linker Required=\"yes\" Options=\"%s\">', table.concat(flags, \";\"))\nfor _,v in ipairs(premake.getlinks(cfg, \"all\", \"directory\")) do\n_p('        <LibraryPath Value=\"%s\" />', premake.esc(v))\nend\nfor _,v in ipairs(premake.getlinks(cfg, \"all\", \"basename\")) do\n_p('        <Library Value=\"%s\" />', premake.esc(v))\nend\n_p('      </Linker>')\nif premake.findfile(cfg, \".rc\") then\nlocal defines = table.implode(table.join(cfg.defines, cfg.resdefines), \"-D\", \";\", \"\")\nlocal options = table.concat(cfg.resoptions, \";\")\n_p('      <ResourceCompiler Required=\"yes\" Options=\"%s%s\">'"
	", defines, options)\nfor _,v in ipairs(table.join(cfg.includedirs, cfg.resincludedirs)) do\n_p('        <IncludePath Value=\"%s\"/>', premake.esc(v))\nend\n_p('      </ResourceCompiler>')\nelse\n_p('      <ResourceCompiler Required=\"no\" Options=\"\"/>')\nend\nif #cfg.prebuildcommands > 0 then\n_p('      <PreBuild>')\nfor _,v in ipairs(cfg.prebuildcommands) do\n_p('        <Command Enabled=\"yes\">%s</Command>', premake.esc(v))\nend\n_p('      </PreBuild>')\nend\nif #cfg.postbuildcommands > 0 then\n_p('      <PostBuild>')\nfor _,v in ipairs(cfg.postbuildcommands) do\n_p('        <Command Enabled=\"yes\">%s</Command>', premake.esc(v))\nend\n_p('      </PostBuild>')\nend\n_p('      <CustomBuild Enabled=\"no\">')\n_p('        <CleanCommand></CleanCommand>')\n_p('        <BuildCommand></BuildCommand>')\n_p('        <SingleFileCommand></SingleFileCommand>')\n_p('        <MakefileGenerationCommand></MakefileGenerationCommand>')\n_p('        <ThirdPartyToolName>None</ThirdPartyToolName>')\n_p('        <WorkingDirect"
	"ory></WorkingDirectory>')\n_p('      </CustomBuild>')\n_p('      <AdditionalRules>')\n_p('        <CustomPostBuild></CustomPostBuild>')\n_p('        <CustomPreBuild></CustomPreBuild>')\n_p('      </AdditionalRules>')\n_p('    </Configuration>')\nend\nend\n_p('  </Settings>')\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\n_p('  <Dependencies name=\"%s\">', cfg.longname:gsub(\"|\",\"_\"))\nfor _,dep in ipairs(premake.getdependencies(prj)) do\n_p('    <Project Name=\"%s\"/>', dep.name)\nend\n_p('  </Dependencies>')\nend\nend\n_p('</CodeLite_Project>')\nend\n",

	/* actions/make/_make.lua */
	"_MAKE = { }\npremake.make = { }\nlocal make = premake.make\nfunction _MAKE.esc(value)\nlocal result\nif (type(value) == \"table\") then\nresult = { }\nfor _,v in ipairs(value) do\ntable.insert(result, _MAKE.esc(v))\nend\nreturn result\nelse\nresult = value:gsub(\"\\\\\", \"\\\\\\\\\")\nresult = result:gsub(\" \", \"\\\\ \")\nresult = result:gsub(\"%(\", \"\\\\%(\")\nresult = result:gsub(\"%)\", \"\\\\%)\")\nresult = result:gsub(\"$\\\\%((.-)\\\\%)\", \"$%(%1%)\")\nreturn result\nend\nend\nfunction premake.make_copyrule(source, target)\n_p('%s: %s', target, source)\n_p('\\t@echo Copying $(notdir %s)', target)\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) cp -fR %s %s', source, target)\n_p('else')\n_p('\\t$(SILENT) copy /Y $(subst /,\\\\\\\\,%s) $(subst /,\\\\\\\\,%s)', source, target)\n_p('endif')\nend\nfunction premake.make_mkdirrule(var)\n_p('\\t@echo Creating %s', var)\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) mkdir -p %s', var)\n_p('else')\n_p('\\t$(SILENT) mkdir $(subst /,\\\\\\\\,%s)', var)"
	"\n_p('endif')\n_p('')\nend\nfunction make.list(value)\nif #value > 0 then\nreturn \" \" .. table.concat(value, \" \")\nelse\nreturn \"\"\nend\nend\nfunction _MAKE.getmakefilename(this, searchprjs)\nlocal count = 0\nfor sln in premake.solution.each() do\nif (sln.location == this.location) then count = count + 1 end\nif (searchprjs) then\nfor _,prj in ipairs(sln.projects) do\nif (prj.location == this.location) then count = count + 1 end\nend\nend\nend\nif (count == 1) then\nreturn \"Makefile\"\nelse\nreturn this.name .. \".make\"\nend\nend\nfunction _MAKE.getnames(tbl)\nlocal result = table.extract(tbl, \"name\")\nfor k,v in pairs(result) do\nresult[k] = _MAKE.esc(v)\nend\nreturn result\nend\nfunction make.settings(cfg, cc)\nif #cfg.makesettings > 0 then\nfor _, value in ipairs(cfg.makesettings) do\n_p(value)\nend\nend\nlocal toolsettings = cc.platforms[cfg.platform].cfgsettings\nif toolsettings then\n_p(toolsettings)\nend\nend\nnewaction {\ntrigger         = \"gmake\",\nshortname       = \"GNU Make\",\ndescript"
	"ion     = \"Generate GNU makefiles for POSIX, MinGW, and Cygwin\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\ndotnet = { \"mono\", \"msnet\", \"pnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, _MAKE.getmakefilename(sln, false), premake.make_solution)\nend,\nonproject = function(prj)\nlocal makefile = _MAKE.getmakefilename(prj, true)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, makefile, premake.make_csharp)\nelse\npremake.generate(prj, makefile, premake.make_cpp)\nend\nend,\noncleansolution = function(sln)\npremake.clean.file(sln, _MAKE.getmakefilename(sln, false))\nend,\noncleanproject = function(prj)\npremake.clean.file(prj, _MAKE.getmakefilename(prj, true))\nend\n}\n",

	/* actions/make/make_solution.lua */
	"function premake.make_solution(sln)\nlocal cc = premake[_OPTIONS.cc]\nlocal platforms = premake.filterplatforms(sln, cc.platforms, \"Native\")\n_p('# %s solution makefile autogenerated by Premake', premake.action.current().shortname)\n_p('# Type \"make help\" for usage help')\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(sln.configurations[1], platforms[1], true)))\n_p('endif')\n_p('export config')\n_p('')\n_p('PROJECTS := %s', table.concat(_MAKE.esc(table.extract(sln.projects, \"name\")), \" \"))\n_p('')\n_p('.PHONY: all clean help $(PROJECTS)')\n_p('')\n_p('all: $(PROJECTS)')\n_p('')\nfor _, prj in ipairs(sln.projects) do\n_p('%s: %s', _MAKE.esc(prj.name), table.concat(_MAKE.esc(table.extract(premake.getdependencies(prj), \"name\")), \" \"))\n_p('\\t@echo \"==== Building %s ($(config)) ====\"', prj.name)\n_p('\\t@${MAKE} --no-print-directory -C %s -f %s', _MAKE.esc(path.getrelative(sln.location, prj.location)), _MAKE.esc(_MAKE.getmakefilename(prj, true)))\n_p('')\nend\n_p('c"
	"lean:')\nfor _ ,prj in ipairs(sln.projects) do\n_p('\\t@${MAKE} --no-print-directory -C %s -f %s clean', _MAKE.esc(path.getrelative(sln.location, prj.location)), _MAKE.esc(_MAKE.getmakefilename(prj, true)))\nend\n_p('')\n_p('help:')\n_p(1,'@echo \"Usage: make [config=name] [target]\"')\n_p(1,'@echo \"\"')\n_p(1,'@echo \"CONFIGURATIONS:\"')\nlocal cfgpairs = { }\nfor _, platform in ipairs(platforms) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p(1,'@echo \"   %s\"', premake.getconfigname(cfgname, platform, true))\nend\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"TARGETS:\"')\n_p(1,'@echo \"   all (default)\"')\n_p(1,'@echo \"   clean\"')\nfor _, prj in ipairs(sln.projects) do\n_p(1,'@echo \"   %s\"', prj.name)\nend\n_p(1,'@echo \"\"')\n_p(1,'@echo \"For more information, see http://industriousone.com/premake/quick-start\"')\nend\n",

	/* actions/make/make_cpp.lua */
	"premake.make.cpp = { }\nlocal cpp = premake.make.cpp\nlocal make = premake.make\nfunction premake.make_cpp(prj)\nlocal cc = premake.gettool(prj)\nlocal platforms = premake.filterplatforms(prj.solution, cc.platforms, \"Native\")\npremake.gmake_cpp_header(prj, cc, platforms)\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.gmake_cpp_config(cfg, cc)\nend\nend\n_p('OBJECTS := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.iscppfile(file) then\n_p('\\t$(OBJDIR)/%s.o \\\\', _MAKE.esc(path.getbasename(file)))\nend\nend\n_p('')\n_p('RESOURCES := \\\\')\nfor _, file in ipairs(prj.files) do\nif path.isresourcefile(file) then\n_p('\\t$(OBJDIR)/%s.res \\\\', _MAKE.esc(path.getbasename(file)))\nend\nend\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\nif os.is(\"MacO"
	"SX\") and prj.kind == \"WindowedApp\" then\n_p('all: $(TARGETDIR) $(OBJDIR) prebuild prelink $(TARGET) $(dir $(TARGETDIR))PkgInfo $(dir $(TARGETDIR))Info.plist')\nelse\n_p('all: $(TARGETDIR) $(OBJDIR) prebuild prelink $(TARGET)')\nend\n_p('\\t@:')\n_p('')\n_p('$(TARGET): $(GCH) $(OBJECTS) $(LDDEPS) $(RESOURCES)')\n_p('\\t@echo Linking %s', prj.name)\n_p('\\t$(SILENT) $(LINKCMD)')\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIR):')\npremake.make_mkdirrule(\"$(OBJDIR)\")\nif os.is(\"MacOSX\") and prj.kind == \"WindowedApp\" then\n_p('$(dir $(TARGETDIR))PkgInfo:')\n_p('$(dir $(TARGETDIR))Info.plist:')\n_p('')\nend\n_p('clean:')\n_p('\\t@echo Cleaning %s', prj.name)\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f  $(TARGET)')\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGET)) del $(subst /,\\\\\\\\,$(TARGET))')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /"
	",\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\ncpp.pchrules(prj)\ncpp.fileRules(prj)\n_p('-include $(OBJECTS:%%.o=%%.d)')\n_p('ifneq (,$(PCH))')\n_p('  -include $(OBJDIR)/$(notdir $(PCH)).d')\n_p('endif')\nend\nfunction premake.gmake_cpp_header(prj, cc, platforms)\n_p('# %s project makefile autogenerated by Premake', premake.action.current().shortname)\n_p('ifndef config')\n_p('  config=%s', _MAKE.esc(premake.getconfigname(prj.solution.configurations[1], platforms[1], true)))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('CC = %s', cc.cc)\n_p('CXX = %s', cc.cxx)\n_p('AR = %s', cc.ar)\n_p('')\n_p('ifndef RESCOMP')\n_p('  ifdef WINDRES')\n_p('    RESCOMP = $(WINDRES)')\n_p('  else')\n_p('    RESCOMP = windres')\n_p('  endif')\n_p('endif')\n_p('')\nend\nfunction premake.gmake_cpp_config(cfg, cc)\n_p('ifeq ($(config),%s)', _MAKE.esc(cfg.shortname))\ncpp.platformtools(cfg, cc)"
	"\n_p('  OBJDIR     = %s', _MAKE.esc(cfg.objectsdir))\n_p('  TARGETDIR  = %s', _MAKE.esc(cfg.buildtarget.directory))\n_p('  TARGET     = $(TARGETDIR)/%s', _MAKE.esc(cfg.buildtarget.name))\n_p('  DEFINES   +=%s', make.list(cc.getdefines(cfg.defines)))\n_p('  INCLUDES  +=%s', make.list(cc.getincludedirs(cfg.includedirs)))\ncpp.pchconfig(cfg)\ncpp.flags(cfg, cc)\ncpp.linker(cfg, cc)\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\nmake.settings(cfg, cc)\n_p('endif')\n_p"
	"('')\nend\nfunction cpp.platformtools(cfg, cc)\nlocal platform = cc.platforms[cfg.platform]\nif platform.cc then\n_p('  CC         = %s', platform.cc)\nend\nif platform.cxx then\n_p('  CXX        = %s', platform.cxx)\nend\nif platform.ar then\n_p('  AR         = %s', platform.ar)\nend\nend\nfunction cpp.flags(cfg, cc)\nif cfg.pchheader and not cfg.flags.NoPCH then\n_p('  FORCE_INCLUDE += -include $(OBJDIR)/$(notdir $(PCH))')\nend\n_p('  ALL_CPPFLAGS  += $(CPPFLAGS) %s $(DEFINES) $(INCLUDES)', table.concat(cc.getcppflags(cfg), \" \"))\n_p('  ALL_CFLAGS    += $(CFLAGS) $(ALL_CPPFLAGS) $(ARCH)%s', make.list(table.join(cc.getcflags(cfg), cfg.buildoptions)))\n_p('  ALL_CXXFLAGS  += $(CXXFLAGS) $(ALL_CFLAGS)%s', make.list(cc.getcxxflags(cfg)))\n_p('  ALL_RESFLAGS  += $(RESFLAGS) $(DEFINES) $(INCLUDES)%s',\n        make.list(table.join(cc.getdefines(cfg.resdefines),\n                                cc.getincludedirs(cfg.resincludedirs), cfg.resoptions)))\nend\nfunction cpp.linker(cfg, cc)\n_p('  ALL_LDFLAGS   += $(LD"
	"FLAGS)%s', make.list(table.join(cc.getlibdirflags(cfg), cc.getldflags(cfg), cfg.linkoptions)))\n_p('  LDDEPS    +=%s', make.list(_MAKE.esc(premake.getlinks(cfg, \"siblings\", \"fullpath\"))))\n_p('  LIBS      += $(LDDEPS)%s', make.list(cc.getlinkflags(cfg)))\nif cfg.kind == \"StaticLib\" then\nif cfg.platform:startswith(\"Universal\") then\n_p('  LINKCMD    = libtool -o $(TARGET) $(OBJECTS)')\nelse\n_p('  LINKCMD    = $(AR) -rcs $(TARGET) $(OBJECTS)')\nend\nelse\nlocal tool = iif(cfg.language == \"C\", \"CC\", \"CXX\")\n_p('  LINKCMD    = $(%s) -o $(TARGET) $(OBJECTS) $(RESOURCES) $(ARCH) $(ALL_LDFLAGS) $(LIBS)', tool)\nend\nend\nfunction cpp.pchconfig(cfg)\nif not cfg.pchheader or cfg.flags.NoPCH then\nreturn\nend\nlocal pch = cfg.pchheader\nfor _, incdir in ipairs(cfg.includedirs) do\nlocal abspath = path.getabsolute(path.join(cfg.project.location, incdir))\nlocal testname = path.join(abspath, pch)\nif os.isfile(testname) then\npch = path.getrelative(cfg.location, testname)\nbreak\nend\nend\n_p('  PCH       "
	" = %s', _MAKE.esc(pch))\n_p('  GCH        = $(OBJDIR)/$(notdir $(PCH)).gch')\nend\nfunction cpp.pchrules(prj)\n_p('ifneq (,$(PCH))')\n_p('$(GCH): $(PCH)')\n_p('\\t@echo $(notdir $<)')\nlocal cmd = iif(prj.language == \"C\", \"$(CC) -x c-header $(ALL_CFLAGS)\", \"$(CXX) -x c++-header $(ALL_CXXFLAGS)\")\n_p('\\t$(SILENT) %s -MMD -MP $(DEFINES) $(INCLUDES) -o \"$@\" -MF \"$(@:%%.gch=%%.d)\" -c \"$<\"', cmd)\n_p('endif')\n_p('')\nend\nfunction cpp.fileRules(prj)\nfor _, file in ipairs(prj.files or {}) do\nif path.iscppfile(file) then\n_p('$(OBJDIR)/%s.o: %s', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file))\n_p('\\t@echo $(notdir $<)')\ncpp.buildcommand(path.iscfile(file), \"o\")\n_p('')\nelseif (path.getextension(file) == \".rc\") then\n_p('$(OBJDIR)/%s.res: %s', _MAKE.esc(path.getbasename(file)), _MAKE.esc(file))\n_p('\\t@echo $(notdir $<)')\n_p('\\t$(SILENT) $(RESCOMP) $< -O coff -o \"$@\" $(ALL_RESFLAGS)')\n_p('')\nend\nend\nend\nfunction cpp.buildcommand(iscfile, objext)\nlocal flags = iif(iscfile, '$(CC) "
	"$(ALL_CFLAGS)', '$(CXX) $(ALL_CXXFLAGS)')\n_p('\\t$(SILENT) %s $(FORCE_INCLUDE) -o \"$@\" -MF $(@:%%.%s=%%.d) -c \"$<\"', flags, objext)\nend\n",

	/* actions/make/make_csharp.lua */
	"local function getresourcefilename(cfg, fname)\nif path.getextension(fname) == \".resx\" then\n    local name = cfg.buildtarget.basename .. \".\"\n    local dir = path.getdirectory(fname)\n    if dir ~= \".\" then \nname = name .. path.translate(dir, \".\") .. \".\"\nend\nreturn \"$(OBJDIR)/\" .. _MAKE.esc(name .. path.getbasename(fname)) .. \".resources\"\nelse\nreturn fname\nend\nend\nfunction premake.make_csharp(prj)\nlocal csc = premake.dotnet\nlocal cfglibs = { }\nlocal cfgpairs = { }\nlocal anycfg\nfor cfg in premake.eachconfig(prj) do\nanycfg = cfg\ncfglibs[cfg] = premake.getlinks(cfg, \"siblings\", \"fullpath\")\ncfgpairs[cfg] = { }\nfor _, fname in ipairs(cfglibs[cfg]) do\nif path.getdirectory(fname) ~= cfg.buildtarget.directory then\ncfgpairs[cfg][\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fname))] = _MAKE.esc(fname)\nend\nend\nend\nlocal sources = {}\nlocal embedded = { }\nlocal copypairs = { }\nfor fcfg in premake.project.eachfile(prj) do\nlocal action = csc.getbuildaction(fcfg)\nif action == \"Co"
	"mpile\" then\ntable.insert(sources, fcfg.name)\nelseif action == \"EmbeddedResource\" then\ntable.insert(embedded, fcfg.name)\nelseif action == \"Content\" then\ncopypairs[\"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(fcfg.name))] = _MAKE.esc(fcfg.name)\nelseif path.getname(fcfg.name):lower() == \"app.config\" then\ncopypairs[\"$(TARGET).config\"] = _MAKE.esc(fcfg.name)\nend\nend\nlocal paths = table.translate(prj.libdirs, function(v) return path.join(prj.basedir, v) end)\npaths = table.join({prj.basedir}, paths)\nfor _, libname in ipairs(premake.getlinks(prj, \"system\", \"fullpath\")) do\nlocal libdir = os.pathsearch(libname..\".dll\", unpack(paths))\nif (libdir) then\nlocal target = \"$(TARGETDIR)/\" .. _MAKE.esc(path.getname(libname))\nlocal source = path.getrelative(prj.basedir, path.join(libdir, libname))..\".dll\"\ncopypairs[target] = _MAKE.esc(source)\nend\nend\n_p('# %s project makefile autogenerated by Premake', premake.action.current().shortname)\n_p('')\n_p('ifndef config')\n_p('  config=%s', _MAKE.e"
	"sc(prj.configurations[1]:lower()))\n_p('endif')\n_p('')\n_p('ifndef verbose')\n_p('  SILENT = @')\n_p('endif')\n_p('')\n_p('ifndef CSC')\n_p('  CSC=%s', csc.getcompilervar(prj))\n_p('endif')\n_p('')\n_p('ifndef RESGEN')\n_p('  RESGEN=resgen')\n_p('endif')\n_p('')\nlocal platforms = premake.filterplatforms(prj.solution, premake[_OPTIONS.cc].platforms)\ntable.insert(platforms, 1, \"\")\nfor cfg in premake.eachconfig(prj) do\npremake.gmake_cs_config(cfg, csc, cfglibs)\nend\n_p('# To maintain compatibility with VS.NET, these values must be set at the project level')\n_p('TARGET     := $(TARGETDIR)/%s', _MAKE.esc(prj.buildtarget.name))\n_p('FLAGS      += /t:%s %s', csc.getkind(prj):lower(), table.implode(_MAKE.esc(prj.libdirs), \"/lib:\", \"\", \" \"))\n_p('REFERENCES += %s', table.implode(_MAKE.esc(premake.getlinks(prj, \"system\", \"basename\")), \"/r:\", \".dll\", \" \"))\n_p('')\n_p('SOURCES := \\\\')\nfor _, fname in ipairs(sources) do\n_p('\\t%s \\\\', _MAKE.esc(path.translate(fname)))\nend\n_p('')\n_p('EMBED"
	"FILES := \\\\')\nfor _, fname in ipairs(embedded) do\n_p('\\t%s \\\\', getresourcefilename(prj, fname))\nend\n_p('')\n_p('COPYFILES += \\\\')\nfor target, source in pairs(cfgpairs[anycfg]) do\n_p('\\t%s \\\\', target)\nend\nfor target, source in pairs(copypairs) do\n_p('\\t%s \\\\', target)\nend\n_p('')\n_p('SHELLTYPE := msdos')\n_p('ifeq (,$(ComSpec)$(COMSPEC))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('ifeq (/bin,$(findstring /bin,$(SHELL)))')\n_p('  SHELLTYPE := posix')\n_p('endif')\n_p('')\n_p('.PHONY: clean prebuild prelink')\n_p('')\n_p('all: $(TARGETDIR) $(OBJDIR) prebuild $(EMBEDFILES) $(COPYFILES) prelink $(TARGET)')\n_p('')\n_p('$(TARGET): $(SOURCES) $(EMBEDFILES) $(DEPENDS)')\n_p('\\t$(SILENT) $(CSC) /nologo /out:$@ $(FLAGS) $(REFERENCES) $(SOURCES) $(patsubst %%,/resource:%%,$(EMBEDFILES))')\n_p('\\t$(POSTBUILDCMDS)')\n_p('')\n_p('$(TARGETDIR):')\npremake.make_mkdirrule(\"$(TARGETDIR)\")\n_p('$(OBJDIR):')\npremake.make_mkdirrule(\"$(OBJDIR)\")\n_p('clean:')\n_p('\\t@echo Cleaning %s', prj.name"
	")\n_p('ifeq (posix,$(SHELLTYPE))')\n_p('\\t$(SILENT) rm -f $(TARGETDIR)/%s.* $(COPYFILES)', prj.buildtarget.basename)\n_p('\\t$(SILENT) rm -rf $(OBJDIR)')\n_p('else')\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(TARGETDIR)/%s.*) del $(subst /,\\\\\\\\,$(TARGETDIR)/%s.*)', prj.buildtarget.basename, prj.buildtarget.basename)\nfor target, source in pairs(cfgpairs[anycfg]) do\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,%s) del $(subst /,\\\\\\\\,%s)', target, target)\nend\nfor target, source in pairs(copypairs) do\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,%s) del $(subst /,\\\\\\\\,%s)', target, target)\nend\n_p('\\t$(SILENT) if exist $(subst /,\\\\\\\\,$(OBJDIR)) rmdir /s /q $(subst /,\\\\\\\\,$(OBJDIR))')\n_p('endif')\n_p('')\n_p('prebuild:')\n_p('\\t$(PREBUILDCMDS)')\n_p('')\n_p('prelink:')\n_p('\\t$(PRELINKCMDS)')\n_p('')\n_p('# Per-configuration copied file rules')\nfor cfg in premake.eachconfig(prj) do\n_p('ifneq (,$(findstring %s,$(config)))', _MAKE.esc(cfg.name:lower()))\nfor target, source in pai"
	"rs(cfgpairs[cfg]) do\npremake.make_copyrule(source, target)\nend\n_p('endif')\n_p('')\nend\n_p('# Copied file rules')\nfor target, source in pairs(copypairs) do\npremake.make_copyrule(source, target)\nend\n_p('# Embedded file rules')\nfor _, fname in ipairs(embedded) do \nif path.getextension(fname) == \".resx\" then\n_p('%s: %s', getresourcefilename(prj, fname), _MAKE.esc(fname))\n_p('\\t$(SILENT) $(RESGEN) $^ $@')\nend\n_p('')\nend\nend\nfunction premake.gmake_cs_config(cfg, csc, cfglibs)\n_p('ifneq (,$(findstring %s,$(config)))', _MAKE.esc(cfg.name:lower()))\n_p('  TARGETDIR  := %s', _MAKE.esc(cfg.buildtarget.directory))\n_p('  OBJDIR     := %s', _MAKE.esc(cfg.objectsdir))\n_p('  DEPENDS    := %s', table.concat(_MAKE.esc(premake.getlinks(cfg, \"dependencies\", \"fullpath\")), \" \"))\n_p('  REFERENCES := %s', table.implode(_MAKE.esc(cfglibs[cfg]), \"/r:\", \"\", \" \"))\n_p('  FLAGS      += %s %s', table.implode(cfg.defines, \"/d:\", \"\", \" \"), table.concat(table.join(csc.getflags(cfg), cfg.buildoptions)"
	", \" \"))\n_p('  define PREBUILDCMDS')\nif #cfg.prebuildcommands > 0 then\n_p('\\t@echo Running pre-build commands')\n_p('\\t%s', table.implode(cfg.prebuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define PRELINKCMDS')\nif #cfg.prelinkcommands > 0 then\n_p('\\t@echo Running pre-link commands')\n_p('\\t%s', table.implode(cfg.prelinkcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('  define POSTBUILDCMDS')\nif #cfg.postbuildcommands > 0 then\n_p('\\t@echo Running post-build commands')\n_p('\\t%s', table.implode(cfg.postbuildcommands, \"\", \"\", \"\\n\\t\"))\nend\n_p('  endef')\n_p('endif')\n_p('')\nend\n",

	/* actions/vstudio/_vstudio.lua */
	"premake.vstudio = { }\nlocal vstudio = premake.vstudio\nvstudio.platforms = {\nany     = \"Any CPU\",\nmixed   = \"Mixed Platforms\",\nNative  = \"Win32\",\nx86     = \"x86\",\nx32     = \"Win32\",\nx64     = \"x64\",\nPS3     = \"PS3\",\nXbox360 = \"Xbox 360\",\n}\nfunction vstudio.arch(prj)\nif (prj.language == \"C#\") then\nif (_ACTION < \"vs2005\") then\nreturn \".NET\"\nelse\nreturn \"Any CPU\"\nend\nelse\nreturn \"Win32\"\nend\nend\nfunction vstudio.buildconfigs(sln)\nlocal cfgs = { }\nlocal platforms = premake.filterplatforms(sln, vstudio.platforms, \"Native\")\nlocal hascpp    = premake.hascppproject(sln)\nlocal hasdotnet = premake.hasdotnetproject(sln)\nif hasdotnet and (_ACTION > \"vs2008\" or hascpp) then\ntable.insert(platforms, 1, \"mixed\")\nend\nif hasdotnet and (_ACTION < \"vs2010\" or not hascpp) then\ntable.insert(platforms, 1, \"any\")\nend\nif _ACTION > \"vs2008\" then\nlocal platforms2010 = { }\nfor _, platform in ipairs(platforms) do\nif vstudio.platforms[platform] == \"Win32\" then\nif h"
	"ascpp then\ntable.insert(platforms2010, platform)\nend\nif hasdotnet then\ntable.insert(platforms2010, \"x86\")\nend\nelse\ntable.insert(platforms2010, platform)\nend\nend\nplatforms = platforms2010\nend\nfor _, buildcfg in ipairs(sln.configurations) do\nfor _, platform in ipairs(platforms) do\nlocal entry = { }\nentry.src_buildcfg = buildcfg\nentry.src_platform = platform\nif platform ~= \"PS3\" or _ACTION > \"vs2008\" then\nentry.buildcfg = buildcfg\nentry.platform = vstudio.platforms[platform]\nelse\nentry.buildcfg = platform .. \" \" .. buildcfg\nentry.platform = \"Win32\"\nend\nentry.name = entry.buildcfg .. \"|\" .. entry.platform\nentry.isreal = (platform ~= \"any\" and platform ~= \"mixed\")\ntable.insert(cfgs, entry)\nend\nend\nreturn cfgs\nend\nfunction vstudio.cleansolution(sln)\npremake.clean.file(sln, \"%%.sln\")\npremake.clean.file(sln, \"%%.suo\")\npremake.clean.file(sln, \"%%.ncb\")\npremake.clean.file(sln, \"%%.userprefs\")\npremake.clean.file(sln, \"%%.usertasks\")\nend\nfunction vstudio.clea"
	"nproject(prj)\nlocal fname = premake.project.getfilename(prj, \"%%\")\nos.remove(fname .. \".vcproj\")\nos.remove(fname .. \".vcproj.user\")\nos.remove(fname .. \".vcxproj\")\nos.remove(fname .. \".vcxproj.user\")\nos.remove(fname .. \".vcxproj.filters\")\nos.remove(fname .. \".csproj\")\nos.remove(fname .. \".csproj.user\")\nos.remove(fname .. \".pidb\")\nos.remove(fname .. \".sdf\")\nend\nfunction vstudio.cleantarget(name)\nos.remove(name .. \".pdb\")\nos.remove(name .. \".idb\")\nos.remove(name .. \".ilk\")\nos.remove(name .. \".vshost.exe\")\nos.remove(name .. \".exe.manifest\")\nend\nfunction vstudio.projectfile(prj)\nlocal pattern\nif prj.language == \"C#\" then\npattern = \"%%.csproj\"\nelse\npattern = iif(_ACTION > \"vs2008\", \"%%.vcxproj\", \"%%.vcproj\")\nend\nlocal fname = premake.project.getbasename(prj.name, pattern)\nfname = path.join(prj.location, fname)\nreturn fname\nend\nfunction vstudio.tool(prj)\nif (prj.language == \"C#\") then\nreturn \"FAE04EC0-301F-11D3-BF4B-00C04F79EFBC\"\nelse\nretur"
	"n \"8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942\"\nend\nend\nnewaction {\ntrigger         = \"vs2002\",\nshortname       = \"Visual Studio 2002\",\ndescription     = \"Generate Microsoft Visual Studio 2002 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2002.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2002.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2002.generate_user)\nelse\npremake.generate(prj, \"%%.vcproj\", vstudio.vc200x.generate)\npremake.generate(prj, \"%%.vcproj.user\", vstudio.vc200x.generate_user)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = pr"
	"emake.vstudio.cleantarget,\nvstudio = {}\n}\nnewaction {\ntrigger         = \"vs2003\",\nshortname       = \"Visual Studio 2003\",\ndescription     = \"Generate Microsoft Visual Studio 2003 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2003.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2002.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2002.generate_user)\nelse\npremake.generate(prj, \"%%.vcproj\", vstudio.vc200x.generate)\npremake.generate(prj, \"%%.vcproj.user\", vstudio.vc200x.generate_user)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vst"
	"udio.cleantarget,\nvstudio = {}\n}\nnewaction {\ntrigger         = \"vs2005\",\nshortname       = \"Visual Studio 2005\",\ndescription     = \"Generate Microsoft Visual Studio 2005 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcproj\", vstudio.vc200x.generate)\npremake.generate(prj, \"%%.vcproj.user\", vstudio.vc200x.generate_user)\nend\nend,\noncleansolution = vstudio.cleansolution,\noncleanproject  = vstudio.cleanproject,\noncleantarget   = vstudio.cleantarget,\nvstudio = {\np"
	"roductVersion  = \"8.0.50727\",\nsolutionVersion = \"9\",\n}\n}\nnewaction {\ntrigger         = \"vs2008\",\nshortname       = \"Visual Studio 2008\",\ndescription     = \"Generate Microsoft Visual Studio 2008 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\" },\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcproj\", vstudio.vc200x.generate)\npremake.generate(prj, \"%%.vcproj.user\", vstudio.vc200x.generate_user)\nend\nend,\noncleansolution = vstudio.cleansolution,\noncleanproject  = vstudio.cleanproject,\noncleantarget   = vstudio"
	".cleantarget,\nvstudio = {\nproductVersion  = \"9.0.21022\",\nsolutionVersion = \"10\",\ntoolsVersion    = \"3.5\",\n}\n}\nnewaction\n{\ntrigger         = \"vs2010\",\nshortname       = \"Visual Studio 2010\",\ndescription     = \"Generate Microsoft Visual Studio 2010 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vcxproj.filters\", vstudio.vc2010."
	"generate_filters)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nproductVersion  = \"8.0.30703\",\nsolutionVersion = \"11\",\ntargetFramework = \"4.0\",\ntoolsVersion    = \"4.0\",\n}\n}\n",

	/* actions/vstudio/vs2002_solution.lua */
	"premake.vstudio.sln2002 = { }\nlocal vstudio = premake.vstudio\nlocal sln2002 = premake.vstudio.sln2002\nfunction sln2002.generate(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio.buildconfigs(sln)\n_p('Microsoft Visual Studio Solution File, Format Version 7.00')\nfor prj in premake.solution.eachproject(sln) do\nlocal projpath = path.translate(path.getrelative(sln.location, vstudio.projectfile(prj)))\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', vstudio.tool(prj), prj.name, projpath, prj.uuid)\n_p('EndProject')\nend\n_p('Global')\n_p(1,'GlobalSection(SolutionConfiguration) = preSolution')\nfor i, cfgname in ipairs(sln.configurations) do\n_p(2,'ConfigName.%d = %s', i - 1, cfgname)\nend\n_p(1,'EndGlobalSection')\n_p(1,'GlobalSection(ProjectDependencies) = postSolution')\n_p(1,'EndGlobalSection')\n_p(1,'GlobalSection(ProjectConfiguration) = postSolution')\nfor prj in premake.solution.eachproject(sln) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p(2,'{%s}.%s.ActiveCfg = %s|%s', prj.uui"
	"d, cfgname, cfgname, vstudio.arch(prj))\n_p(2,'{%s}.%s.Build.0 = %s|%s', prj.uuid, cfgname, cfgname, vstudio.arch(prj))\nend\nend\n_p(1,'EndGlobalSection')\n_p(1,'GlobalSection(ExtensibilityGlobals) = postSolution')\n_p(1,'EndGlobalSection')\n_p(1,'GlobalSection(ExtensibilityAddIns) = postSolution')\n_p(1,'EndGlobalSection')\n_p('EndGlobal')\nend\n",

	/* actions/vstudio/vs2002_csproj.lua */
	"premake.vstudio.cs2002 = { }\nlocal vstudio = premake.vstudio\nlocal cs2002 = premake.vstudio.cs2002\nlocal function getelements(prj, action, fname)\nif action == \"Compile\" and fname:endswith(\".cs\") then\nreturn \"SubTypeCode\"\nend\nif action == \"EmbeddedResource\" and fname:endswith(\".resx\") then\nlocal basename = fname:sub(1, -6)\nlocal testname = path.getname(basename .. \".cs\")\nif premake.findfile(prj, testname) then\nreturn \"Dependency\", testname\nend\nend\nreturn \"None\"\nend\nfunction cs2002.Files(prj)\nlocal tr = premake.project.buildsourcetree(prj)\npremake.tree.traverse(tr, {\nonleaf = function(node)\nlocal action = premake.dotnet.getbuildaction(node.cfg)\nlocal fname  = path.translate(premake.esc(node.cfg.name), \"\\\\\")\nlocal elements, dependency = getelements(prj, action, node.path)\n_p(4,'<File')\n_p(5,'RelPath = \"%s\"', fname)\n_p(5,'BuildAction = \"%s\"', action)\nif dependency then\n_p(5,'DependentUpon = \"%s\"', premake.esc(path.translate(dependency, \"\\\\\")))\nend\nif eleme"
	"nts == \"SubTypeCode\" then\n_p(5,'SubType = \"Code\"')\nend\n_p(4,'/>')\nend\n}, false)\nend\nfunction cs2002.generate(prj)\nio.eol = \"\\r\\n\"\n_p('<VisualStudioProject>')\n_p(1,'<CSHARP')\n_p(2,'ProjectType = \"Local\"')\n_p(2,'ProductVersion = \"%s\"', iif(_ACTION == \"vs2002\", \"7.0.9254\", \"7.10.3077\"))\n_p(2,'SchemaVersion = \"%s\"', iif(_ACTION == \"vs2002\", \"1.0\", \"2.0\"))\n_p(2,'ProjectGuid = \"{%s}\"', prj.uuid)\n_p(1,'>')\n_p(2,'<Build>')\n_p(3,'<Settings')\n_p(4,'ApplicationIcon = \"\"')\n_p(4,'AssemblyKeyContainerName = \"\"')\n_p(4,'AssemblyName = \"%s\"', prj.buildtarget.basename)\n_p(4,'AssemblyOriginatorKeyFile = \"\"')\n_p(4,'DefaultClientScript = \"JScript\"')\n_p(4,'DefaultHTMLPageLayout = \"Grid\"')\n_p(4,'DefaultTargetSchema = \"IE50\"')\n_p(4,'DelaySign = \"false\"')\nif _ACTION == \"vs2002\" then\n_p(4,'NoStandardLibraries = \"false\"')\nend\n_p(4,'OutputType = \"%s\"', premake.dotnet.getkind(prj))\nif _ACTION == \"vs2003\" then\n_p(4,'PreBuildEvent = \"\"')\n_p(4,'PostBuildEve"
	"nt = \"\"')\nend\n_p(4,'RootNamespace = \"%s\"', prj.buildtarget.basename)\nif _ACTION == \"vs2003\" then\n_p(4,'RunPostBuildEvent = \"OnBuildSuccess\"')\nend\n_p(4,'StartupObject = \"\"')\n_p(3,'>')\nfor cfg in premake.eachconfig(prj) do\n_p(4,'<Config')\n_p(5,'Name = \"%s\"', premake.esc(cfg.name))\n_p(5,'AllowUnsafeBlocks = \"%s\"', iif(cfg.flags.Unsafe, \"true\", \"false\"))\n_p(5,'BaseAddress = \"285212672\"')\n_p(5,'CheckForOverflowUnderflow = \"false\"')\n_p(5,'ConfigurationOverrideFile = \"\"')\n_p(5,'DefineConstants = \"%s\"', premake.esc(table.concat(cfg.defines, \";\")))\n_p(5,'DocumentationFile = \"\"')\n_p(5,'DebugSymbols = \"%s\"', iif(cfg.flags.Symbols, \"true\", \"false\"))\n_p(5,'FileAlignment = \"4096\"')\n_p(5,'IncrementalBuild = \"false\"')\nif _ACTION == \"vs2003\" then\n_p(5,'NoStdLib = \"false\"')\n_p(5,'NoWarn = \"\"')\nend\n_p(5,'Optimize = \"%s\"', iif(cfg.flags.Optimize or cfg.flags.OptimizeSize or cfg.flags.OptimizeSpeed, \"true\", \"false\"))\n_p(5,'OutputPath = \"%s\"', premake.es"
	"c(cfg.buildtarget.directory))\n_p(5,'RegisterForComInterop = \"false\"')\n_p(5,'RemoveIntegerChecks = \"false\"')\n_p(5,'TreatWarningsAsErrors = \"%s\"', iif(cfg.flags.FatalWarnings, \"true\", \"false\"))\n_p(5,'WarningLevel = \"4\"')\n_p(4,'/>')\nend\n_p(3,'</Settings>')\n_p(3,'<References>')\nfor _, ref in ipairs(premake.getlinks(prj, \"siblings\", \"object\")) do\n_p(4,'<Reference')\n_p(5,'Name = \"%s\"', ref.buildtarget.basename)\n_p(5,'Project = \"{%s}\"', ref.uuid)\n_p(5,'Package = \"{%s}\"', vstudio.tool(ref))\n_p(4,'/>')\nend\nfor _, linkname in ipairs(premake.getlinks(prj, \"system\", \"fullpath\")) do\n_p(4,'<Reference')\n_p(5,'Name = \"%s\"', path.getbasename(linkname))\n_p(5,'AssemblyName = \"%s\"', path.getname(linkname))\nif path.getdirectory(linkname) ~= \".\" then\n_p(5,'HintPath = \"%s\"', path.translate(linkname, \"\\\\\"))\nend\n_p(4,'/>')\nend\n_p(3,'</References>')\n_p(2,'</Build>')\n_p(2,'<Files>')\n_p(3,'<Include>')\ncs2002.Files(prj)\n_p(3,'</Include>')\n_p(2,'</Files>')\n_p(1,'</CSHARP"
	">')\n_p('</VisualStudioProject>')\nend\n",

	/* actions/vstudio/vs2002_csproj_user.lua */
	"local cs2002 = premake.vstudio.cs2002\nfunction cs2002.generate_user(prj)\nio.eol = \"\\r\\n\"\n_p('<VisualStudioProject>')\n_p(1,'<CSHARP>')\n_p(2,'<Build>')\nlocal refpaths = table.translate(prj.libdirs, function(v) return path.getabsolute(prj.location .. \"/\" .. v) end)\n_p(3,'<Settings ReferencePath = \"%s\">', path.translate(table.concat(refpaths, \";\"), \"\\\\\"))\nfor cfg in premake.eachconfig(prj) do\n_p(4,'<Config')\n_p(5,'Name = \"%s\"', premake.esc(cfg.name))\n_p(5,'EnableASPDebugging = \"false\"')\n_p(5,'EnableASPXDebugging = \"false\"')\n_p(5,'EnableUnmanagedDebugging = \"false\"')\n_p(5,'EnableSQLServerDebugging = \"false\"')\n_p(5,'RemoteDebugEnabled = \"false\"')\n_p(5,'RemoteDebugMachine = \"\"')\n_p(5,'StartAction = \"Project\"')\n_p(5,'StartArguments = \"\"')\n_p(5,'StartPage = \"\"')\n_p(5,'StartProgram = \"\"')\n_p(5,'StartURL = \"\"')\n_p(5,'StartWorkingDirectory = \"\"')\n_p(5,'StartWithIE = \"false\"')\n_p(4,'/>')\nend\n_p(3,'</Settings>')\n_p(2,'</Build>')\n_p(2,'<OtherProjectSetting"
	"s')\n_p(3,'CopyProjectDestinationFolder = \"\"')\n_p(3,'CopyProjectUncPath = \"\"')\n_p(3,'CopyProjectOption = \"0\"')\n_p(3,'ProjectView = \"ProjectFiles\"')\n_p(3,'ProjectTrust = \"0\"')\n_p(2,'/>')\n_p(1,'</CSHARP>')\n_p('</VisualStudioProject>')\nend\n",

	/* actions/vstudio/vs200x_vcproj.lua */
	"premake.vstudio.vc200x = { }\nlocal vc200x = premake.vstudio.vc200x\nlocal tree = premake.tree\nlocal function bool(value)\nif (_ACTION < \"vs2005\") then\nreturn iif(value, \"TRUE\", \"FALSE\")\nelse\nreturn iif(value, \"true\", \"false\")\nend\nend\nfunction vc200x.optimization(cfg)\nlocal result = 0\nfor _, value in ipairs(cfg.flags) do\nif (value == \"Optimize\") then\nresult = 3\nelseif (value == \"OptimizeSize\") then\nresult = 1\nelseif (value == \"OptimizeSpeed\") then\nresult = 2\nend\nend\nreturn result\nend\nfunction vc200x.header(element)\nio.eol = \"\\r\\n\"\n_p('<?xml version=\"1.0\" encoding=\"Windows-1252\"?>')\n_p('<%s', element)\n_p(1,'ProjectType=\"Visual C++\"')\nif _ACTION == \"vs2002\" then\n_p(1,'Version=\"7.00\"')\nelseif _ACTION == \"vs2003\" then\n_p(1,'Version=\"7.10\"')\nelseif _ACTION == \"vs2005\" then\n_p(1,'Version=\"8.00\"')\nelseif _ACTION == \"vs2008\" then\n_p(1,'Version=\"9.00\"')\nend\nend\nfunction vc200x.Configuration(name, cfg)\n_p(2,'<Configuration')\n_p(3,'Name=\"%s\""
	"', premake.esc(name))\n_p(3,'OutputDirectory=\"%s\"', premake.esc(cfg.buildtarget.directory))\n_p(3,'IntermediateDirectory=\"%s\"', premake.esc(cfg.objectsdir))\nlocal cfgtype\nif (cfg.kind == \"SharedLib\") then\ncfgtype = 2\nelseif (cfg.kind == \"StaticLib\") then\ncfgtype = 4\nelse\ncfgtype = 1\nend\n_p(3,'ConfigurationType=\"%s\"', cfgtype)\nif (cfg.flags.MFC) then\n_p(3, 'UseOfMFC=\"%d\"', iif(cfg.flags.StaticRuntime, 1, 2))\nend  \nif (cfg.flags.ATL or cfg.flags.StaticATL) then\n_p(3, 'UseOfATL=\"%d\"', iif(cfg.flags.StaticATL, 1, 2))\nend\n_p(3,'CharacterSet=\"%s\"', iif(cfg.flags.Unicode, 1, 2))\nif cfg.flags.Managed then\n_p(3,'ManagedExtensions=\"1\"')\nend\n_p(3,'>')\nend\nfunction vc200x.Files(prj)\nlocal tr = premake.project.buildsourcetree(prj)\ntree.traverse(tr, {\nonbranchenter = function(node, depth)\n_p(depth, '<Filter')\n_p(depth, '\\tName=\"%s\"', node.name)\n_p(depth, '\\tFilter=\"\"')\n_p(depth, '\\t>')\nend,\nonbranchexit = function(node, depth)\n_p(depth, '</Filter>')\nend,\nonleaf = fu"
	"nction(node, depth)\nlocal fname = node.cfg.name\n_p(depth, '<File')\n_p(depth, '\\tRelativePath=\"%s\"', path.translate(fname, \"\\\\\"))\n_p(depth, '\\t>')\ndepth = depth + 1\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nif cfginfo.isreal then\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nlocal usePCH = (not prj.flags.NoPCH and prj.pchsource == node.cfg.name)\nlocal isSourceCode = path.iscppfile(fname)\nlocal needsCompileAs = (path.iscfile(fname) ~= premake.project.iscproject(prj))\nif usePCH or (isSourceCode and needsCompileAs) then\n_p(depth, '<FileConfiguration')\n_p(depth, '\\tName=\"%s\"', cfginfo.name)\n_p(depth, '\\t>')\n_p(depth, '\\t<Tool')\n_p(depth, '\\t\\tName=\"%s\"', iif(cfg.system == \"Xbox360\", \n                                 \"VCCLX360CompilerTool\", \n                                 \"VCCLCompilerTool\"))\nif needsCompileAs then\n_p(depth, '\\t\\tCompileAs=\"%s\"', iif(path.iscfile(fname), 1, 2))\nend\nif usePCH then\nif cfg.system == \""
	"PS3\" then\nlocal options = table.join(premake.snc.getcflags(cfg), \n                           premake.snc.getcxxflags(cfg), \n                           cfg.buildoptions)\noptions = table.concat(options, \" \");\noptions = options .. ' --create_pch=\"$(IntDir)/$(TargetName).pch\"'                    \n_p(depth, '\\t\\tAdditionalOptions=\"%s\"', premake.esc(options))\nelse\n_p(depth, '\\t\\tUsePrecompiledHeader=\"1\"')\nend\nend\n_p(depth, '\\t/>')\n_p(depth, '</FileConfiguration>')\nend\nend\nend\ndepth = depth - 1\n_p(depth, '</File>')\nend,\n}, false, 2)\nend\nfunction vc200x.Platforms(prj)\nlocal used = { }\n_p(1,'<Platforms>')\nfor _, cfg in ipairs(prj.solution.vstudio_configs) do\nif cfg.isreal and not table.contains(used, cfg.platform) then\ntable.insert(used, cfg.platform)\n_p(2,'<Platform')\n_p(3,'Name=\"%s\"', cfg.platform)\n_p(2,'/>')\nend\nend\n_p(1,'</Platforms>')\nend\nfunction vc200x.Symbols(cfg)\nif (not cfg.flags.Symbols) then\nreturn 0\nelse\nif cfg.flags.NoEditAndContinue or \n   vc200x.opt"
	"imization(cfg) ~= 0 or \n   cfg.flags.Managed or \n   cfg.platform == \"x64\" then\nreturn 3\nelse\nreturn 4\nend\nend\nend\nfunction vc200x.VCCLCompilerTool(cfg)\n_p(3,'<Tool')\n_p(4,'Name=\"%s\"', iif(cfg.platform ~= \"Xbox360\", \"VCCLCompilerTool\", \"VCCLX360CompilerTool\"))\nif #cfg.buildoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.buildoptions), \" \"))\nend\n_p(4,'Optimization=\"%s\"', vc200x.optimization(cfg))\nif cfg.flags.NoFramePointer then\n_p(4,'OmitFramePointers=\"%s\"', bool(true))\nend\nif #cfg.includedirs > 0 then\n_p(4,'AdditionalIncludeDirectories=\"%s\"', premake.esc(path.translate(table.concat(cfg.includedirs, \";\"), '\\\\')))\nend\nif #cfg.defines > 0 then\n_p(4,'PreprocessorDefinitions=\"%s\"', premake.esc(table.concat(cfg.defines, \";\")))\nend\nif premake.config.isdebugbuild(cfg) and not cfg.flags.NoMinimalRebuild and not cfg.flags.Managed then\n_p(4,'MinimalRebuild=\"%s\"', bool(true))\nend\nif cfg.flags.NoExceptions then\n_p(4,'ExceptionHandling="
	"\"%s\"', iif(_ACTION < \"vs2005\", \"FALSE\", 0))\nelseif cfg.flags.SEH and _ACTION > \"vs2003\" then\n_p(4,'ExceptionHandling=\"2\"')\nend\nif vc200x.optimization(cfg) == 0 and not cfg.flags.Managed then\n_p(4,'BasicRuntimeChecks=\"3\"')\nend\nif vc200x.optimization(cfg) ~= 0 then\n_p(4,'StringPooling=\"%s\"', bool(true))\nend\nlocal runtime\nif premake.config.isdebugbuild(cfg) then\nruntime = iif(cfg.flags.StaticRuntime, 1, 3)\nelse\nruntime = iif(cfg.flags.StaticRuntime, 0, 2)\nend\n_p(4,'RuntimeLibrary=\"%s\"', runtime)\n_p(4,'EnableFunctionLevelLinking=\"%s\"', bool(true))\nif _ACTION > \"vs2003\" and cfg.platform ~= \"Xbox360\" and cfg.platform ~= \"x64\" then\nif cfg.flags.EnableSSE then\n_p(4,'EnableEnhancedInstructionSet=\"1\"')\nelseif cfg.flags.EnableSSE2 then\n_p(4,'EnableEnhancedInstructionSet=\"2\"')\nend\nend\nif _ACTION < \"vs2005\" then\nif cfg.flags.FloatFast then\n_p(4,'ImproveFloatingPointConsistency=\"%s\"', bool(false))\nelseif cfg.flags.FloatStrict then\n_p(4,'ImproveFloatingPointConsist"
	"ency=\"%s\"', bool(true))\nend\nelse\nif cfg.flags.FloatFast then\n_p(4,'FloatingPointModel=\"2\"')\nelseif cfg.flags.FloatStrict then\n_p(4,'FloatingPointModel=\"1\"')\nend\nend\nif _ACTION < \"vs2005\" and not cfg.flags.NoRTTI then\n_p(4,'RuntimeTypeInfo=\"%s\"', bool(true))\nelseif _ACTION > \"vs2003\" and cfg.flags.NoRTTI and not cfg.flags.Managed then\n_p(4,'RuntimeTypeInfo=\"%s\"', bool(false))\nend\nif cfg.flags.NativeWChar then\n_p(4,'TreatWChar_tAsBuiltInType=\"%s\"', bool(true))\nelseif cfg.flags.NoNativeWChar then\n_p(4,'TreatWChar_tAsBuiltInType=\"%s\"', bool(false))\nend\nif not cfg.flags.NoPCH and cfg.pchheader then\n_p(4,'UsePrecompiledHeader=\"%s\"', iif(_ACTION < \"vs2005\", 3, 2))\n_p(4,'PrecompiledHeaderThrough=\"%s\"', cfg.pchheader)\nelse\n_p(4,'UsePrecompiledHeader=\"%s\"', iif(_ACTION > \"vs2003\" or cfg.flags.NoPCH, 0, 2))\nend\n_p(4,'WarningLevel=\"%s\"', iif(cfg.flags.ExtraWarnings, 4, 3))\nif cfg.flags.FatalWarnings then\n_p(4,'WarnAsError=\"%s\"', bool(true))\nend\nif _ACTION < \"vs"
	"2008\" and not cfg.flags.Managed then\n_p(4,'Detect64BitPortabilityProblems=\"%s\"', bool(not cfg.flags.No64BitChecks))\nend\n_p(4,'ProgramDataBaseFileName=\"$(OutDir)\\\\%s.pdb\"', path.getbasename(cfg.buildtarget.name))\n_p(4,'DebugInformationFormat=\"%s\"', vc200x.Symbols(cfg))\nif cfg.language == \"C\" then\n_p(4, 'CompileAs=\"1\"')\nend\n_p(3,'/>')\nend\nfunction vc200x.VCLinkerTool(cfg)\n_p(3,'<Tool')\nif cfg.kind ~= \"StaticLib\" then\n_p(4,'Name=\"%s\"', iif(cfg.platform ~= \"Xbox360\", \"VCLinkerTool\", \"VCX360LinkerTool\"))\nif cfg.flags.NoImportLib then\n_p(4,'IgnoreImportLibrary=\"%s\"', bool(true))\nend\nif #cfg.linkoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.linkoptions), \" \"))\nend\nif #cfg.links > 0 then\n_p(4,'AdditionalDependencies=\"%s\"', table.concat(premake.getlinks(cfg, \"all\", \"fullpath\"), \" \"))\nend\n_p(4,'OutputFile=\"$(OutDir)\\\\%s\"', cfg.buildtarget.name)\n_p(4,'LinkIncremental=\"%s\"', \niif(premake.config.isincrementallink(cfg) , 2, 1)"
	")\n_p(4,'AdditionalLibraryDirectories=\"%s\"', table.concat(premake.esc(path.translate(cfg.libdirs, '\\\\')) , \";\"))\nlocal deffile = premake.findfile(cfg, \".def\")\nif deffile then\n_p(4,'ModuleDefinitionFile=\"%s\"', deffile)\nend\nif cfg.flags.NoManifest then\n_p(4,'GenerateManifest=\"%s\"', bool(false))\nend\n_p(4,'GenerateDebugInformation=\"%s\"', bool(vc200x.Symbols(cfg) ~= 0))\nif vc200x.Symbols(cfg) ~= 0 then\n_p(4,'ProgramDataBaseFileName=\"$(OutDir)\\\\%s.pdb\"', path.getbasename(cfg.buildtarget.name))\nend\n_p(4,'SubSystem=\"%s\"', iif(cfg.kind == \"ConsoleApp\", 1, 2))\nif vc200x.optimization(cfg) ~= 0 then\n_p(4,'OptimizeReferences=\"2\"')\n_p(4,'EnableCOMDATFolding=\"2\"')\nend\nif (cfg.kind == \"ConsoleApp\" or cfg.kind == \"WindowedApp\") and not cfg.flags.WinMain then\n_p(4,'EntryPointSymbol=\"mainCRTStartup\"')\nend\nif cfg.kind == \"SharedLib\" then\nlocal implibname = cfg.linktarget.fullpath\n_p(4,'ImportLibrary=\"%s\"', iif(cfg.flags.NoImportLib, cfg.objectsdir .. \"\\\\\" .. path.getna"
	"me(implibname), implibname))\nend\n_p(4,'TargetMachine=\"%d\"', iif(cfg.platform == \"x64\", 17, 1))\nelse\n_p(4,'Name=\"VCLibrarianTool\"')\nif #cfg.links > 0 then\n_p(4,'AdditionalDependencies=\"%s\"', table.concat(premake.getlinks(cfg, \"all\", \"fullpath\"), \" \"))\nend\n_p(4,'OutputFile=\"$(OutDir)\\\\%s\"', cfg.buildtarget.name)\nif #cfg.libdirs > 0 then\n_p(4,'AdditionalLibraryDirectories=\"%s\"', premake.esc(path.translate(table.concat(cfg.libdirs , \";\"))))\nend\nlocal addlOptions = {}\nif cfg.platform == \"x32\" then\ntable.insert(addlOptions, \"/MACHINE:X86\")\nelseif cfg.platform == \"x64\" then\ntable.insert(addlOptions, \"/MACHINE:X64\")\nend\naddlOptions = table.join(addlOptions, cfg.linkoptions)\nif #addlOptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(addlOptions), \" \"))\nend\nend\n_p(3,'/>')\nend\nfunction vc200x.VCCLCompilerTool_PS3(cfg)\n_p(3,'<Tool')\n_p(4,'Name=\"VCCLCompilerTool\"')\nlocal buildoptions = table.join(premake.snc.getcflags(cfg), premake.snc.ge"
	"tcxxflags(cfg), cfg.buildoptions)\nif not cfg.flags.NoPCH and cfg.pchheader then\n_p(4,'UsePrecompiledHeader=\"%s\"', iif(_ACTION < \"vs2005\", 3, 2))\n_p(4,'PrecompiledHeaderThrough=\"%s\"', path.getname(cfg.pchheader))\ntable.insert(buildoptions, '--use_pch=\"$(IntDir)/$(TargetName).pch\"')\nelse\n_p(4,'UsePrecompiledHeader=\"%s\"', iif(_ACTION > \"vs2003\" or cfg.flags.NoPCH, 0, 2))\nend\n_p(4,'AdditionalOptions=\"%s\"', premake.esc(table.concat(buildoptions, \" \")))\nif #cfg.includedirs > 0 then\n_p(4,'AdditionalIncludeDirectories=\"%s\"', premake.esc(path.translate(table.concat(cfg.includedirs, \";\"), '\\\\')))\nend\nif #cfg.defines > 0 then\n_p(4,'PreprocessorDefinitions=\"%s\"', table.concat(premake.esc(cfg.defines), \";\"))\nend\n_p(4,'ProgramDataBaseFileName=\"$(OutDir)\\\\%s.pdb\"', path.getbasename(cfg.buildtarget.name))\n_p(4,'DebugInformationFormat=\"0\"')\n_p(4,'CompileAs=\"0\"')\n_p(3,'/>')\nend\nfunction vc200x.VCLinkerTool_PS3(cfg)\n_p(3,'<Tool')\nif cfg.kind ~= \"StaticLib\" then\n_p(4,'Nam"
	"e=\"VCLinkerTool\"')\nlocal buildoptions = table.join(premake.snc.getldflags(cfg), cfg.linkoptions)\nif #buildoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', premake.esc(table.concat(buildoptions, \" \")))\nend\nif #cfg.links > 0 then\n_p(4,'AdditionalDependencies=\"%s\"', table.concat(premake.getlinks(cfg, \"all\", \"fullpath\"), \" \"))\nend\n_p(4,'OutputFile=\"$(OutDir)\\\\%s\"', cfg.buildtarget.name)\n_p(4,'LinkIncremental=\"0\"')\n_p(4,'AdditionalLibraryDirectories=\"%s\"', table.concat(premake.esc(path.translate(cfg.libdirs, '\\\\')) , \";\"))\n_p(4,'GenerateManifest=\"%s\"', bool(false))\n_p(4,'ProgramDatabaseFile=\"\"')\n_p(4,'RandomizedBaseAddress=\"1\"')\n_p(4,'DataExecutionPrevention=\"0\"')\nelse\n_p(4,'Name=\"VCLibrarianTool\"')\nlocal buildoptions = table.join(premake.snc.getldflags(cfg), cfg.linkoptions)\nif #buildoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', premake.esc(table.concat(buildoptions, \" \")))\nend\nif #cfg.links > 0 then\n_p(4,'AdditionalDependencies=\"%s\"', table.concat(p"
	"remake.getlinks(cfg, \"all\", \"fullpath\"), \" \"))\nend\n_p(4,'OutputFile=\"$(OutDir)\\\\%s\"', cfg.buildtarget.name)\nif #cfg.libdirs > 0 then\n_p(4,'AdditionalLibraryDirectories=\"%s\"', premake.esc(path.translate(table.concat(cfg.libdirs , \";\"))))\nend\nend\n_p(3,'/>')\nend\nfunction vc200x.VCResourceCompilerTool(cfg)\n_p(3,'<Tool')\n_p(4,'Name=\"VCResourceCompilerTool\"')\nif #cfg.resoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.resoptions), \" \"))\nend\nif #cfg.defines > 0 or #cfg.resdefines > 0 then\n_p(4,'PreprocessorDefinitions=\"%s\"', table.concat(premake.esc(table.join(cfg.defines, cfg.resdefines)), \";\"))\nend\nif #cfg.includedirs > 0 or #cfg.resincludedirs > 0 then\nlocal dirs = table.join(cfg.includedirs, cfg.resincludedirs)\n_p(4,'AdditionalIncludeDirectories=\"%s\"', premake.esc(path.translate(table.concat(dirs, \";\"), '\\\\')))\nend\n_p(3,'/>')\nend\nfunction vc200x.VCManifestTool(cfg)\nlocal manifests = { }\nfor _, fname in ipairs(cfg.files) do\nif pat"
	"h.getextension(fname) == \".manifest\" then\ntable.insert(manifests, fname)\nend\nend\n_p(3,'<Tool')\n_p(4,'Name=\"VCManifestTool\"')\nif #manifests > 0 then\n_p(4,'AdditionalManifestFiles=\"%s\"', premake.esc(table.concat(manifests, \";\")))\nend\n_p(3,'/>')\nend\nfunction vc200x.VCMIDLTool(cfg)\n_p(3,'<Tool')\n_p(4,'Name=\"VCMIDLTool\"')\nif cfg.platform == \"x64\" then\n_p(4,'TargetEnvironment=\"3\"')\nend\n_p(3,'/>')\nend\nfunction vc200x.buildstepsblock(name, steps)\n_p(3,'<Tool')\n_p(4,'Name=\"%s\"', name)\nif #steps > 0 then\n_p(4,'CommandLine=\"%s\"', premake.esc(table.implode(steps, \"\", \"\", \"\\r\\n\")))\nend\n_p(3,'/>')\nend\nlocal blockmap = \n{\nVCCLCompilerTool       = vc200x.VCCLCompilerTool,\nVCCLCompilerTool_PS3   = vc200x.VCCLCompilerTool_PS3,\nVCLinkerTool           = vc200x.VCLinkerTool,\nVCLinkerTool_PS3       = vc200x.VCLinkerTool_PS3,\nVCManifestTool         = vc200x.VCManifestTool,\nVCMIDLTool             = vc200x.VCMIDLTool,\nVCResourceCompilerTool = vc200x.VCResourceCompilerTool,\n"
	"}\nlocal function getsections(version, platform)\nif version == \"vs2002\" then\nreturn {\n\"VCCLCompilerTool\",\n\"VCCustomBuildTool\",\n\"VCLinkerTool\",\n\"VCMIDLTool\",\n\"VCPostBuildEventTool\",\n\"VCPreBuildEventTool\",\n\"VCPreLinkEventTool\",\n\"VCResourceCompilerTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCWebDeploymentTool\"\n}\nend\nif version == \"vs2003\" then\nreturn {\n\"VCCLCompilerTool\",\n\"VCCustomBuildTool\",\n\"VCLinkerTool\",\n\"VCMIDLTool\",\n\"VCPostBuildEventTool\",\n\"VCPreBuildEventTool\",\n\"VCPreLinkEventTool\",\n\"VCResourceCompilerTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCXMLDataGeneratorTool\",\n\"VCWebDeploymentTool\",\n\"VCManagedWrapperGeneratorTool\",\n\"VCAuxiliaryManagedWrapperGeneratorTool\"\n}\nend\nif platform == \"Xbox360\" then\nreturn {\n\"VCPreBuildEventTool\",\n\"VCCustomBuildTool\",\n\"VCXMLDataGeneratorTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCMIDLTool\",\n\"VCCLCompilerTool\",\n\"VCManagedResourceCompilerTool\",\n\"VCResourceCompilerTool\","
	"\n\"VCPreLinkEventTool\",\n\"VCLinkerTool\",\n\"VCALinkTool\",\n\"VCX360ImageTool\",\n\"VCBscMakeTool\",\n\"VCX360DeploymentTool\",\n\"VCPostBuildEventTool\",\n\"DebuggerTool\",\n}\nend\nif platform == \"PS3\" then\nreturn {\n\"VCPreBuildEventTool\",\n\"VCCustomBuildTool\",\n\"VCXMLDataGeneratorTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCMIDLTool\",\n\"VCCLCompilerTool_PS3\",\n\"VCManagedResourceCompilerTool\",\n\"VCResourceCompilerTool\",\n\"VCPreLinkEventTool\",\n\"VCLinkerTool_PS3\",\n\"VCALinkTool\",\n\"VCManifestTool\",\n\"VCXDCMakeTool\",\n\"VCBscMakeTool\",\n\"VCFxCopTool\",\n\"VCAppVerifierTool\",\n\"VCWebDeploymentTool\",\n\"VCPostBuildEventTool\"\n}\nelse\nreturn {\n\"VCPreBuildEventTool\",\n\"VCCustomBuildTool\",\n\"VCXMLDataGeneratorTool\",\n\"VCWebServiceProxyGeneratorTool\",\n\"VCMIDLTool\",\n\"VCCLCompilerTool\",\n\"VCManagedResourceCompilerTool\",\n\"VCResourceCompilerTool\",\n\"VCPreLinkEventTool\",\n\"VCLinkerTool\",\n\"VCALinkTool\",\n\"VCManifestTool\",\n\"VCXDCMakeTool\",\n\"VCBscMak"
	"eTool\",\n\"VCFxCopTool\",\n\"VCAppVerifierTool\",\n\"VCWebDeploymentTool\",\n\"VCPostBuildEventTool\"\n}\nend\nend\nfunction vc200x.generate(prj)\nvc200x.header('VisualStudioProject')\n_p(1,'Name=\"%s\"', premake.esc(prj.name))\n_p(1,'ProjectGUID=\"{%s}\"', prj.uuid)\nif _ACTION > \"vs2003\" then\n_p(1,'RootNamespace=\"%s\"', prj.name)\nend\n_p(1,'Keyword=\"%s\"', iif(prj.flags.Managed, \"ManagedCProj\", \"Win32Proj\"))\n_p(1,'>')\nvc200x.Platforms(prj)\nif _ACTION > \"vs2003\" then\n_p(1,'<ToolFiles>')\n_p(1,'</ToolFiles>')\nend\n_p(1,'<Configurations>')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nif cfginfo.isreal then\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nvc200x.Configuration(cfginfo.name, cfg)\nfor _, block in ipairs(getsections(_ACTION, cfginfo.src_platform)) do\nif blockmap[block] then\nblockmap[block](cfg)\nelseif block == \"VCPreBuildEventTool\" then\nvc200x.buildstepsblock(\"VCPreBuildEventTool\", cfg.prebuildcommands)\nelseif block == \"VCPr"
	"eLinkEventTool\" then\nvc200x.buildstepsblock(\"VCPreLinkEventTool\", cfg.prelinkcommands)\nelseif block == \"VCPostBuildEventTool\" then\nvc200x.buildstepsblock(\"VCPostBuildEventTool\", cfg.postbuildcommands)\nelseif block == \"VCX360DeploymentTool\" then\n_p(3,'<Tool')\n_p(4,'Name=\"VCX360DeploymentTool\"')\n_p(4,'DeploymentType=\"0\"')\nif #cfg.deploymentoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.deploymentoptions), \" \"))\nend\n_p(3,'/>')\nelseif block == \"VCX360ImageTool\" then\n_p(3,'<Tool')\n_p(4,'Name=\"VCX360ImageTool\"')\nif #cfg.imageoptions > 0 then\n_p(4,'AdditionalOptions=\"%s\"', table.concat(premake.esc(cfg.imageoptions), \" \"))\nend\nif cfg.imagepath ~= nil then\n_p(4,'OutputFileName=\"%s\"', premake.esc(path.translate(cfg.imagepath)))\nend\n_p(3,'/>')\nelseif block == \"DebuggerTool\" then\n_p(3,'<DebuggerTool')\n_p(3,'/>')\nelse\n_p(3,'<Tool')\n_p(4,'Name=\"%s\"', block)\n_p(3,'/>')\nend\nend\n_p(2,'</Configuration>')\nend\nend\n_p(1,'</Configurations"
	">')\n_p(1,'<References>')\n_p(1,'</References>')\n_p(1,'<Files>')\nvc200x.Files(prj)\n_p(1,'</Files>')\n_p(1,'<Globals>')\n_p(1,'</Globals>')\n_p('</VisualStudioProject>')\nend\n",

	/* actions/vstudio/vs200x_vcproj_user.lua */
	"local vc200x = premake.vstudio.vc200x\nfunction vc200x.generate_user(prj)\nvc200x.header('VisualStudioUserFile')\n_p(1,'ShowAllFiles=\"false\"')\n_p(1,'>')\n_p(1,'<Configurations>')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nif cfginfo.isreal then\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(2,'<Configuration')\n_p(3,'Name=\"%s\"', premake.esc(cfginfo.name))\n_p(3,'>')\nvc200x.debugdir(cfg)\n_p(2,'</Configuration>')\nend\nend\n_p(1,'</Configurations>')\n_p('</VisualStudioUserFile>')\nend\nfunction vc200x.environmentargs(cfg)\nif cfg.environmentargs and #cfg.environmentargs > 0 then\n_p(4,'Environment=\"%s\"', string.gsub(table.concat(cfg.environmentargs, \"&#x0A;\"),'\"','&quot;'))\nif cfg.flags.EnvironmentArgsDontMerge then\n_p(4,'EnvironmentMerge=\"false\"')\nend\nend\nend\nfunction vc200x.debugdir(cfg)\n_p(3,'<DebugSettings')\nif cfg.debugdir then\n_p(4,'WorkingDirectory=\"%s\"', path.translate(cfg.debugdir, '\\\\'))\nend\nif #cfg.debugargs > 0 then\n_"
	"p(4,'CommandArguments=\"%s\"', table.concat(cfg.debugargs, \" \"))\nend\nvc200x.environmentargs(cfg)\n_p(3,'/>')\nend\n",

	/* actions/vstudio/vs2003_solution.lua */
	"premake.vstudio.sln2003 = { }\nlocal vstudio = premake.vstudio\nlocal sln2003 = premake.vstudio.sln2003\nfunction sln2003.generate(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio.buildconfigs(sln)\n_p('Microsoft Visual Studio Solution File, Format Version 8.00')\nfor prj in premake.solution.eachproject(sln) do\nlocal projpath = path.translate(path.getrelative(sln.location, vstudio.projectfile(prj)))\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', vstudio.tool(prj), prj.name, projpath, prj.uuid)\nlocal deps = premake.getdependencies(prj)\nif #deps > 0 then\n_p('\\tProjectSection(ProjectDependencies) = postProject')\nfor _, dep in ipairs(deps) do\n_p('\\t\\t{%s} = {%s}', dep.uuid, dep.uuid)\nend\n_p('\\tEndProjectSection')\nend\n_p('EndProject')\nend\n_p('Global')\n_p('\\tGlobalSection(SolutionConfiguration) = preSolution')\nfor _, cfgname in ipairs(sln.configurations) do\n_p('\\t\\t%s = %s', cfgname, cfgname)\nend\n_p('\\tEndGlobalSection')\n_p('\\tGlobalSection(ProjectDependencies) = postSol"
	"ution')\n_p('\\tEndGlobalSection')\n_p('\\tGlobalSection(ProjectConfiguration) = postSolution')\nfor prj in premake.solution.eachproject(sln) do\nfor _, cfgname in ipairs(sln.configurations) do\n_p('\\t\\t{%s}.%s.ActiveCfg = %s|%s', prj.uuid, cfgname, cfgname, vstudio.arch(prj))\n_p('\\t\\t{%s}.%s.Build.0 = %s|%s', prj.uuid, cfgname, cfgname, vstudio.arch(prj))\nend\nend\n_p('\\tEndGlobalSection')\n_p('\\tGlobalSection(ExtensibilityGlobals) = postSolution')\n_p('\\tEndGlobalSection')\n_p('\\tGlobalSection(ExtensibilityAddIns) = postSolution')\n_p('\\tEndGlobalSection')\n_p('EndGlobal')\nend\n",

	/* actions/vstudio/vs2005_solution.lua */
	"premake.vstudio.sln2005 = { }\nlocal vstudio = premake.vstudio\nlocal sln2005 = premake.vstudio.sln2005\nfunction sln2005.generate(sln)\nio.eol = '\\r\\n'\nsln.vstudio_configs = premake.vstudio.buildconfigs(sln)\n_p('\\239\\187\\191')\nsln2005.header(sln)\nfor prj in premake.solution.eachproject(sln) do\nsln2005.project(prj)\nend\n_p('Global')\nsln2005.platforms(sln)\nsln2005.project_platforms(sln)\nsln2005.properties(sln)\n_p('EndGlobal')\nend\nfunction sln2005.header(sln)\nlocal action = premake.action.current()\n_p('Microsoft Visual Studio Solution File, Format Version %d.00', action.vstudio.solutionVersion)\n_p('# Visual Studio %s', _ACTION:sub(3))\nend\nfunction sln2005.project(prj)\nlocal projpath = path.translate(path.getrelative(prj.solution.location, vstudio.projectfile(prj)), \"\\\\\")\n_p('Project(\"{%s}\") = \"%s\", \"%s\", \"{%s}\"', vstudio.tool(prj), prj.name, projpath, prj.uuid)\nsln2005.projectdependencies(prj)\n_p('EndProject')\nend\nfunction sln2005.projectdependencies(prj)\nlocal deps = pre"
	"make.getdependencies(prj)\nif #deps > 0 then\n_p('\\tProjectSection(ProjectDependencies) = postProject')\nfor _, dep in ipairs(deps) do\n_p('\\t\\t{%s} = {%s}', dep.uuid, dep.uuid)\nend\n_p('\\tEndProjectSection')\nend\nend\nfunction sln2005.platforms(sln)\n_p('\\tGlobalSection(SolutionConfigurationPlatforms) = preSolution')\nfor _, cfg in ipairs(sln.vstudio_configs) do\n_p('\\t\\t%s = %s', cfg.name, cfg.name)\nend\n_p('\\tEndGlobalSection')\nend\nfunction sln2005.project_platforms(sln)\n_p('\\tGlobalSection(ProjectConfigurationPlatforms) = postSolution')\nfor prj in premake.solution.eachproject(sln) do\nfor _, cfg in ipairs(sln.vstudio_configs) do\nlocal mapped\nif premake.isdotnetproject(prj) then\nmapped = \"Any CPU\"\nelse\nif cfg.platform == \"Any CPU\" or cfg.platform == \"Mixed Platforms\" then\nmapped = sln.vstudio_configs[3].platform\nelse\nmapped = cfg.platform\nend\nend\n_p('\\t\\t{%s}.%s.ActiveCfg = %s|%s', prj.uuid, cfg.name, cfg.buildcfg, mapped)\nif mapped == cfg.platform or cfg.platform == \"Mi"
	"xed Platforms\" then\n_p('\\t\\t{%s}.%s.Build.0 = %s|%s',  prj.uuid, cfg.name, cfg.buildcfg, mapped)\nend\nend\nend\n_p('\\tEndGlobalSection')\nend\nfunction sln2005.properties(sln)\n_p('\\tGlobalSection(SolutionProperties) = preSolution')\n_p('\\t\\tHideSolutionNode = FALSE')\n_p('\\tEndGlobalSection')\nend\n",

	/* actions/vstudio/vs2005_csproj.lua */
	"premake.vstudio.cs2005 = { }\nlocal vstudio = premake.vstudio\nlocal cs2005  = premake.vstudio.cs2005\nlocal function getelements(prj, action, fname)\nif action == \"Compile\" and fname:endswith(\".cs\") then\nif fname:endswith(\".Designer.cs\") then\nlocal basename = fname:sub(1, -13)\nlocal testname = basename .. \".cs\"\nif premake.findfile(prj, testname) then\nreturn \"Dependency\", testname\nend\ntestname = basename .. \".resx\"\nif premake.findfile(prj, testname) then\nreturn \"AutoGen\", testname\nend\nelse\nlocal basename = fname:sub(1, -4)\nlocal testname = basename .. \".Designer.cs\"\nif premake.findfile(prj, testname) then\nreturn \"SubTypeForm\"\nend\nend\nend\nif action == \"EmbeddedResource\" and fname:endswith(\".resx\") then\nlocal basename = fname:sub(1, -6)\nlocal testname = path.getname(basename .. \".cs\")\nif premake.findfile(prj, testname) then\nif premake.findfile(prj, basename .. \".Designer.cs\") then\nreturn \"DesignerType\", testname\nelse\nreturn \"Dependency\", testname\nend\nelse"
	"\ntestname = path.getname(basename .. \".Designer.cs\")\nif premake.findfile(prj, testname) then\nreturn \"AutoGenerated\"\nend\nend\nend\nif action == \"Content\" then\nreturn \"CopyNewest\"\nend\nreturn \"None\"\nend\nfunction cs2005.arch(prj)\nreturn \"AnyCPU\"\nend\nfunction cs2005.files(prj)\nlocal tr = premake.project.buildsourcetree(prj)\npremake.tree.traverse(tr, {\nonleaf = function(node)\nlocal action = premake.dotnet.getbuildaction(node.cfg)\nlocal fname  = path.translate(premake.esc(node.cfg.name), \"\\\\\")\nlocal elements, dependency = getelements(prj, action, node.path)\nif elements == \"None\" then\n_p('    <%s Include=\"%s\" />', action, fname)\nelse\n_p('    <%s Include=\"%s\">', action, fname)\nif elements == \"AutoGen\" then\n_p('      <AutoGen>True</AutoGen>')\nelseif elements == \"AutoGenerated\" then\n_p('      <SubType>Designer</SubType>')\n_p('      <Generator>ResXFileCodeGenerator</Generator>')\n_p('      <LastGenOutput>%s.Designer.cs</LastGenOutput>', premake.esc(path.getbasename(nod"
	"e.name)))\nelseif elements == \"SubTypeDesigner\" then\n_p('      <SubType>Designer</SubType>')\nelseif elements == \"SubTypeForm\" then\n_p('      <SubType>Form</SubType>')\nelseif elements == \"PreserveNewest\" then\n_p('      <CopyToOutputDirectory>PreserveNewest</CopyToOutputDirectory>')\nend\nif dependency then\n_p('      <DependentUpon>%s</DependentUpon>', path.translate(premake.esc(dependency), \"\\\\\"))\nend\n_p('    </%s>', action)\nend\nend\n}, false)\nend\nfunction cs2005.projectelement(prj)\nlocal action = premake.action.current()\nlocal toolversion = ''\nif action.vstudio.toolsVersion then\ntoolversion = string.format(' ToolsVersion=\"%s\"', action.vstudio.toolsVersion)\nend\nif _ACTION > \"vs2008\" then\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\nend\n_p('<Project%s DefaultTargets=\"Build\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">', toolversion)\nend\nfunction cs2005.projectsettings(prj)\n_p('  <PropertyGroup>')\n_p('    <Configuration Condition=\" \\'$(Configuration"
	")\\' == \\'\\' \">%s</Configuration>', premake.esc(prj.solution.configurations[1]))\n_p('    <Platform Condition=\" \\'$(Platform)\\' == \\'\\' \">%s</Platform>', cs2005.arch(prj))\nlocal action = premake.action.current()\nif action.vstudio.productVersion then\n_p('    <ProductVersion>%s</ProductVersion>', action.vstudio.productVersion)\nend\nif _ACTION < \"vs2012\" then\n_p('    <SchemaVersion>2.0</SchemaVersion>')\nend\n_p('    <ProjectGuid>{%s}</ProjectGuid>', prj.uuid)\n_p('    <OutputType>%s</OutputType>', premake.dotnet.getkind(prj))\n_p('    <AppDesignerFolder>Properties</AppDesignerFolder>')\n_p('    <RootNamespace>%s</RootNamespace>', prj.buildtarget.basename)\n_p('    <AssemblyName>%s</AssemblyName>', prj.buildtarget.basename)\nlocal framework = prj.framework or action.vstudio.targetFramework\nif framework then\n_p('    <TargetFrameworkVersion>v%s</TargetFrameworkVersion>', framework)\nend\nif _ACTION == 'vs2010' then\n_p('    <TargetFrameworkProfile></TargetFrameworkProfile>')\nend\nif _ACTION >= \""
	"vs2010\" then\n_p('    <FileAlignment>512</FileAlignment>')\nend\n_p('  </PropertyGroup>')\nend\nfunction cs2005.propertygroup(cfg)\n_p('  <PropertyGroup Condition=\" \\'$(Configuration)|$(Platform)\\' == \\'%s|%s\\' \">', premake.esc(cfg.name), cs2005.arch(cfg))\nif _ACTION > \"vs2008\" then\n_p('    <PlatformTarget>%s</PlatformTarget>', cs2005.arch(cfg))\nend\nend\nfunction cs2005.generate(prj)\nio.eol = \"\\r\\n\"\ncs2005.projectelement(prj)\nif _ACTION > \"vs2010\" then\n_p('  <Import Project=\"$(MSBuildExtensionsPath)\\\\$(MSBuildToolsVersion)\\\\Microsoft.Common.props\" Condition=\"Exists(\\'$(MSBuildExtensionsPath)\\\\$(MSBuildToolsVersion)\\\\Microsoft.Common.props\\')\" />')\nend\ncs2005.projectsettings(prj)\nfor cfg in premake.eachconfig(prj) do\ncs2005.propertygroup(cfg)\nif cfg.flags.Symbols then\n_p('    <DebugSymbols>true</DebugSymbols>')\n_p('    <DebugType>full</DebugType>')\nelse\n_p('    <DebugType>pdbonly</DebugType>')\nend\n_p('    <Optimize>%s</Optimize>', iif(cfg.flags.Optimize or cfg.fla"
	"gs.OptimizeSize or cfg.flags.OptimizeSpeed, \"true\", \"false\"))\n_p('    <OutputPath>%s</OutputPath>', cfg.buildtarget.directory)\n_p('    <DefineConstants>%s</DefineConstants>', table.concat(premake.esc(cfg.defines), \";\"))\n_p('    <ErrorReport>prompt</ErrorReport>')\n_p('    <WarningLevel>4</WarningLevel>')\nif cfg.flags.Unsafe then\n_p('    <AllowUnsafeBlocks>true</AllowUnsafeBlocks>')\nend\nif cfg.flags.FatalWarnings then\n_p('    <TreatWarningsAsErrors>true</TreatWarningsAsErrors>')\nend\n_p('  </PropertyGroup>')\nend\n_p('  <ItemGroup>')\nfor _, ref in ipairs(premake.getlinks(prj, \"siblings\", \"object\")) do\n_p('    <ProjectReference Include=\"%s\">', path.translate(path.getrelative(prj.location, vstudio.projectfile(ref)), \"\\\\\"))\n_p('      <Project>{%s}</Project>', ref.uuid)\n_p('      <Name>%s</Name>', premake.esc(ref.name))\n_p('    </ProjectReference>')\nend\nfor _, linkname in ipairs(premake.getlinks(prj, \"system\", \"basename\")) do\n_p('    <Reference Include=\"%s\" />', premake.esc(li"
	"nkname))\nend\n_p('  </ItemGroup>')\n_p('  <ItemGroup>')\ncs2005.files(prj)\n_p('  </ItemGroup>')\nlocal msbuild = iif(_ACTION < \"vs2012\", \"Bin\", \"Tools\")\n_p('  <Import Project=\"$(MSBuild%sPath)\\\\Microsoft.CSharp.targets\" />', msbuild)\n_p('  <!-- To modify your build process, add your task inside one of the targets below and uncomment it.')\n_p('       Other similar extension points exist, see Microsoft.Common.targets.')\n_p('  <Target Name=\"BeforeBuild\">')\n_p('  </Target>')\n_p('  <Target Name=\"AfterBuild\">')\n_p('  </Target>')\n_p('  -->')\n_p('</Project>')\nend\n",

	/* actions/vstudio/vs2005_csproj_user.lua */
	"local cs2005 = premake.vstudio.cs2005\nfunction cs2005.generate_user(prj)\nio.eol = \"\\r\\n\"\n_p('<Project xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">')\n_p('  <PropertyGroup>')\nlocal refpaths = table.translate(prj.libdirs, function(v) return path.getabsolute(prj.location .. \"/\" .. v) end)\n_p('    <ReferencePath>%s</ReferencePath>', path.translate(table.concat(refpaths, \";\"), \"\\\\\"))\n_p('  </PropertyGroup>')\n_p('</Project>')\nend\n",

	/* actions/vstudio/vs2010_vcxproj.lua */
	"premake.vstudio.vc2010 = { }\nlocal vc2010 = premake.vstudio.vc2010\nlocal vstudio = premake.vstudio\nlocal function vs2010_config(prj)\n_p(1,'<ItemGroup Label=\"ProjectConfigurations\">')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\n_p(2,'<ProjectConfiguration Include=\"%s\">', premake.esc(cfginfo.name))\n_p(3,'<Configuration>%s</Configuration>',cfginfo.buildcfg)\n_p(3,'<Platform>%s</Platform>',cfginfo.platform)\n_p(2,'</ProjectConfiguration>')\nend\n_p(1,'</ItemGroup>')\nend\nlocal function vs2010_globals(prj)\n_p(1,'<PropertyGroup Label=\"Globals\">')\n_p(2,'<ProjectGuid>{%s}</ProjectGuid>',prj.uuid)\n_p(2,'<RootNamespace>%s</RootNamespace>',prj.name)\nif prj.flags and prj.flags.Managed then\n_p(2,'<TargetFrameworkVersion>v4.0</TargetFrameworkVersion>')\n_p(2,'<Keyword>ManagedCProj</Keyword>')\nelse\n_p(2,'<Keyword>Win32Proj</Keyword>')\nend\n_p(1,'</PropertyGroup>')\nend\nfunction vc2010.config_type(config)\nlocal t =\n{\nSharedLib = \"DynamicLibrary\",\nStaticLib = \"StaticLibrary\",\nConso"
	"leApp = \"Application\",\nWindowedApp = \"Application\"\n}\nreturn t[config.kind]\nend\nlocal function if_config_and_platform()\nreturn 'Condition=\"\\'$(Configuration)|$(Platform)\\'==\\'%s\\'\"'\nend\nlocal function optimisation(cfg)\nlocal result = \"Disabled\"\nfor _, value in ipairs(cfg.flags) do\nif (value == \"Optimize\") then\nresult = \"Full\"\nelseif (value == \"OptimizeSize\") then\nresult = \"MinSpace\"\nelseif (value == \"OptimizeSpeed\") then\nresult = \"MaxSpeed\"\nend\nend\nreturn result\nend\nfunction vc2010.configurationPropertyGroup(cfg, cfginfo)\n_p(1,'<PropertyGroup '..if_config_and_platform() ..' Label=\"Configuration\">'\n, premake.esc(cfginfo.name))\n_p(2,'<ConfigurationType>%s</ConfigurationType>',vc2010.config_type(cfg))\n_p(2,'<UseDebugLibraries>%s</UseDebugLibraries>', iif(optimisation(cfg) == \"Disabled\",\"true\",\"false\"))\n_p(2,'<CharacterSet>%s</CharacterSet>',iif(cfg.flags.Unicode,\"Unicode\",\"MultiByte\"))\nlocal toolsets = { vs2012 = \"v110\", vs2013 = \"v120\" }\nlocal to"
	"olset = toolsets[_ACTION]\nif toolset then\n_p(2,'<PlatformToolset>%s</PlatformToolset>', toolset)\nend\nif cfg.flags.MFC then\n_p(2,'<UseOfMfc>%s</UseOfMfc>', iif(cfg.flags.StaticRuntime, \"Static\", \"Dynamic\"))\nend\nif cfg.flags.ATL or cfg.flags.StaticATL then\n_p(2,'<UseOfAtl>%s</UseOfAtl>', iif(cfg.flags.StaticATL, \"Static\", \"Dynamic\"))\nend\nif cfg.flags.Managed then\n_p(2,'<CLRSupport>true</CLRSupport>')\nend\n_p(1,'</PropertyGroup>')\nend\nlocal function import_props(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<ImportGroup '..if_config_and_platform() ..' Label=\"PropertySheets\">'\n,premake.esc(cfginfo.name))\n_p(2,'<Import Project=\"$(UserRootDir)\\\\Microsoft.Cpp.$(Platform).user.props\" Condition=\"exists(\\'$(UserRootDir)\\\\Microsoft.Cpp.$(Platform).user.props\\')\" Label=\"LocalAppDataPlatform\" />')\n_p(1,'</ImportGroup>')\nend\nend\nfunction vc2010.outputProperties(prj)\nfor _, cfgin"
	"fo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nlocal target = cfg.buildtarget\n_p(1,'<PropertyGroup '..if_config_and_platform() ..'>', premake.esc(cfginfo.name))\n_p(2,'<OutDir>%s\\\\</OutDir>', premake.esc(target.directory))\nif cfg.platform == \"Xbox360\" then\n_p(2,'<OutputFile>$(OutDir)%s</OutputFile>', premake.esc(target.name))\nend\n_p(2,'<IntDir>%s\\\\</IntDir>', premake.esc(cfg.objectsdir))\n_p(2,'<TargetName>%s</TargetName>', premake.esc(path.getbasename(target.name)))\n_p(2,'<TargetExt>%s</TargetExt>', premake.esc(path.getextension(target.name)))\nif cfg.kind == \"SharedLib\" then\nlocal ignore = (cfg.flags.NoImportLib ~= nil)\n _p(2,'<IgnoreImportLibrary>%s</IgnoreImportLibrary>', tostring(ignore))\nend\nif cfg.kind ~= \"StaticLib\" then\n_p(2,'<LinkIncremental>%s</LinkIncremental>', tostring(premake.config.isincrementallink(cfg)))\nend\nif cfg.flags.NoManifest then\n_p(2,'<GenerateManifest>false</GenerateManifest>')\nen"
	"d\n_p(1,'</PropertyGroup>')\nend\nend\nlocal function runtime(cfg)\nlocal runtime\nlocal flags = cfg.flags\nif premake.config.isdebugbuild(cfg) then\nruntime = iif(flags.StaticRuntime and not flags.Managed, \"MultiThreadedDebug\", \"MultiThreadedDebugDLL\")\nelse\nruntime = iif(flags.StaticRuntime and not flags.Managed, \"MultiThreaded\", \"MultiThreadedDLL\")\nend\nreturn runtime\nend\nlocal function precompiled_header(cfg)\n      if not cfg.flags.NoPCH and cfg.pchheader then\n_p(3,'<PrecompiledHeader>Use</PrecompiledHeader>')\n_p(3,'<PrecompiledHeaderFile>%s</PrecompiledHeaderFile>', cfg.pchheader)\nelse\n_p(3,'<PrecompiledHeader></PrecompiledHeader>')\nend\nend\nlocal function preprocessor(indent,cfg)\nif #cfg.defines > 0 then\n_p(indent,'<PreprocessorDefinitions>%s;%%(PreprocessorDefinitions)</PreprocessorDefinitions>'\n,premake.esc(table.concat(cfg.defines, \";\")))\nelse\n_p(indent,'<PreprocessorDefinitions></PreprocessorDefinitions>')\nend\nend\nlocal function include_dirs(indent,cfg)\nif #cfg.includedi"
	"rs > 0 then\n_p(indent,'<AdditionalIncludeDirectories>%s;%%(AdditionalIncludeDirectories)</AdditionalIncludeDirectories>'\n,premake.esc(path.translate(table.concat(cfg.includedirs, \";\"), '\\\\')))\nend\nend\nlocal function resource_compile(cfg)\n_p(2,'<ResourceCompile>')\npreprocessor(3,cfg)\ninclude_dirs(3,cfg)\n_p(2,'</ResourceCompile>')\nend\nlocal function exceptions(cfg)\nif cfg.flags.NoExceptions then\n_p(2,'<ExceptionHandling>false</ExceptionHandling>')\nelseif cfg.flags.SEH then\n_p(2,'<ExceptionHandling>Async</ExceptionHandling>')\nend\nend\nlocal function rtti(cfg)\nif cfg.flags.NoRTTI and not cfg.flags.Managed then\n_p(3,'<RuntimeTypeInfo>false</RuntimeTypeInfo>')\nend\nend\nlocal function wchar_t_buildin(cfg)\nif cfg.flags.NativeWChar then\n_p(3,'<TreatWChar_tAsBuiltInType>true</TreatWChar_tAsBuiltInType>')\nelseif cfg.flags.NoNativeWChar then\n_p(3,'<TreatWChar_tAsBuiltInType>false</TreatWChar_tAsBuiltInType>')\nend\nend\nlocal function sse(cfg)\nif cfg.flags.EnableSSE then\n_p(3,'<EnableEnhance"
	"dInstructionSet>StreamingSIMDExtensions</EnableEnhancedInstructionSet>')\nelseif cfg.flags.EnableSSE2 then\n_p(3,'<EnableEnhancedInstructionSet>StreamingSIMDExtensions2</EnableEnhancedInstructionSet>')\nend\nend\nlocal function floating_point(cfg)\n     if cfg.flags.FloatFast then\n_p(3,'<FloatingPointModel>Fast</FloatingPointModel>')\nelseif cfg.flags.FloatStrict and not cfg.flags.Managed then\n_p(3,'<FloatingPointModel>Strict</FloatingPointModel>')\nend\nend\nlocal function debug_info(cfg)\nlocal debug_info = ''\nif cfg.flags.Symbols then\nif cfg.platform == \"x64\"\nor cfg.flags.Managed\nor premake.config.isoptimizedbuild(cfg.flags)\nor cfg.flags.NoEditAndContinue\nthen\ndebug_info = \"ProgramDatabase\"\nelse\ndebug_info = \"EditAndContinue\"\nend\nend\n_p(3,'<DebugInformationFormat>%s</DebugInformationFormat>',debug_info)\nend\nlocal function minimal_build(cfg)\nif premake.config.isdebugbuild(cfg) and not cfg.flags.NoMinimalRebuild then\n_p(3,'<MinimalRebuild>true</MinimalRebuild>')\nelse\n_p(3,'<MinimalRe"
	"build>false</MinimalRebuild>')\nend\nend\nlocal function compile_language(cfg)\nif cfg.language == \"C\" then\n_p(3,'<CompileAs>CompileAsC</CompileAs>')\nend\nend\nlocal function vs10_clcompile(cfg)\n_p(2,'<ClCompile>')\nif #cfg.buildoptions > 0 then\n_p(3,'<AdditionalOptions>%s %%(AdditionalOptions)</AdditionalOptions>',\ntable.concat(premake.esc(cfg.buildoptions), \" \"))\nend\n_p(3,'<Optimization>%s</Optimization>',optimisation(cfg))\ninclude_dirs(3,cfg)\npreprocessor(3,cfg)\nminimal_build(cfg)\nif  not premake.config.isoptimizedbuild(cfg.flags) then\nif not cfg.flags.Managed then\n_p(3,'<BasicRuntimeChecks>EnableFastChecks</BasicRuntimeChecks>')\nend\nif cfg.flags.ExtraWarnings then\n_p(3,'<SmallerTypeCheck>true</SmallerTypeCheck>')\nend\nelse\n_p(3,'<StringPooling>true</StringPooling>')\nend\n_p(3,'<RuntimeLibrary>%s</RuntimeLibrary>', runtime(cfg))\n_p(3,'<FunctionLevelLinking>true</FunctionLevelLinking>')\nprecompiled_header(cfg)\nif cfg.flags.ExtraWarnings then\n_p(3,'<WarningLevel>Level4</WarningLevel"
	">')\nelse\n_p(3,'<WarningLevel>Level3</WarningLevel>')\nend\nif cfg.flags.FatalWarnings then\n_p(3,'<TreatWarningAsError>true</TreatWarningAsError>')\nend\nexceptions(cfg)\nrtti(cfg)\nwchar_t_buildin(cfg)\nsse(cfg)\nfloating_point(cfg)\ndebug_info(cfg)\nif cfg.flags.Symbols then\n_p(3,'<ProgramDataBaseFileName>$(OutDir)%s.pdb</ProgramDataBaseFileName>'\n, path.getbasename(cfg.buildtarget.name))\nend\nif cfg.flags.NoFramePointer then\n_p(3,'<OmitFramePointers>true</OmitFramePointers>')\nend\ncompile_language(cfg)\n_p(2,'</ClCompile>')\nend\nlocal function event_hooks(cfg)\nif #cfg.postbuildcommands> 0 then\n    _p(2,'<PostBuildEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.postbuildcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PostBuildEvent>')\nend\nif #cfg.prebuildcommands> 0 then\n    _p(2,'<PreBuildEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.prebuildcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PreBuildEvent>')\nend\nif #cfg.prelinkcommands> 0 then\n    _p(2,'<Pr"
	"eLinkEvent>')\n_p(3,'<Command>%s</Command>',premake.esc(table.implode(cfg.prelinkcommands, \"\", \"\", \"\\r\\n\")))\n_p(2,'</PreLinkEvent>')\nend\nend\nlocal function additional_options(indent,cfg)\nif #cfg.linkoptions > 0 then\n_p(indent,'<AdditionalOptions>%s %%(AdditionalOptions)</AdditionalOptions>',\ntable.concat(premake.esc(cfg.linkoptions), \" \"))\nend\nend\nlocal function link_target_machine(index,cfg)\nlocal platforms = {x32 = 'MachineX86', x64 = 'MachineX64'}\nif platforms[cfg.platform] then\n_p(index,'<TargetMachine>%s</TargetMachine>', platforms[cfg.platform])\nend\nend\nlocal function item_def_lib(cfg)\n       -- The Xbox360 project files are stored in another place in the project file.\nif cfg.kind == 'StaticLib' and cfg.platform ~= \"Xbox360\" then\n_p(1,'<Lib>')\n_p(2,'<OutputFile>$(OutDir)%s</OutputFile>',cfg.buildtarget.name)\nadditional_options(2,cfg)\nlink_target_machine(2,cfg)\n_p(1,'</Lib>')\nend\nend\nlocal function import_lib(cfg)\nif cfg.kind == \"SharedLib\" then\nlocal implibname ="
	" cfg.linktarget.fullpath\n_p(3,'<ImportLibrary>%s</ImportLibrary>',iif(cfg.flags.NoImportLib, cfg.objectsdir .. \"\\\\\" .. path.getname(implibname), implibname))\nend\nend\nfunction vc2010.link(cfg)\n_p(2,'<Link>')\n_p(3,'<SubSystem>%s</SubSystem>', iif(cfg.kind == \"ConsoleApp\", \"Console\", \"Windows\"))\n_p(3,'<GenerateDebugInformation>%s</GenerateDebugInformation>', tostring(cfg.flags.Symbols ~= nil))\nif premake.config.isoptimizedbuild(cfg.flags) then\n_p(3,'<EnableCOMDATFolding>true</EnableCOMDATFolding>')\n_p(3,'<OptimizeReferences>true</OptimizeReferences>')\nend\nif cfg.kind ~= 'StaticLib' then\nvc2010.additionalDependencies(cfg)\n_p(3,'<OutputFile>$(OutDir)%s</OutputFile>', cfg.buildtarget.name)\nif #cfg.libdirs > 0 then\n_p(3,'<AdditionalLibraryDirectories>%s;%%(AdditionalLibraryDirectories)</AdditionalLibraryDirectories>',\npremake.esc(path.translate(table.concat(cfg.libdirs, ';'), '\\\\')))\nend\nif vc2010.config_type(cfg) == 'Application' and not cfg.flags.WinMain and not cfg.flags.Managed then"
	"\n_p(3,'<EntryPointSymbol>mainCRTStartup</EntryPointSymbol>')\nend\nimport_lib(cfg)\nlocal deffile = premake.findfile(cfg, \".def\")\nif deffile then\n_p(3,'<ModuleDefinitionFile>%s</ModuleDefinitionFile>', deffile)\nend\nlink_target_machine(3,cfg)\nadditional_options(3,cfg)\nend\n_p(2,'</Link>')\nend\nfunction vc2010.additionalDependencies(cfg)\nlocal links = premake.getlinks(cfg, \"system\", \"fullpath\")\nif #links > 0 then\n_p(3,'<AdditionalDependencies>%s;%%(AdditionalDependencies)</AdditionalDependencies>',\ntable.concat(links, \";\"))\nend\nend\nlocal function item_definitions(prj)\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p(1,'<ItemDefinitionGroup ' ..if_config_and_platform() ..'>'\n,premake.esc(cfginfo.name))\nvs10_clcompile(cfg)\nresource_compile(cfg)\nitem_def_lib(cfg)\nvc2010.link(cfg)\nevent_hooks(cfg)\n_p(1,'</ItemDefinitionGroup>')\nend\nend\nfunction vc2010.getfilegroup(prj, group)\nlocal sortedfi"
	"les = prj.vc2010sortedfiles\nif not sortedfiles then\nsortedfiles = {\nClCompile = {},\nClInclude = {},\nNone = {},\nResourceCompile = {},\n}\nfor file in premake.project.eachfile(prj) do\nif path.iscppfile(file.name) then\ntable.insert(sortedfiles.ClCompile, file)\nelseif path.iscppheader(file.name) then\ntable.insert(sortedfiles.ClInclude, file)\nelseif path.isresourcefile(file.name) then\ntable.insert(sortedfiles.ResourceCompile, file)\nelse\ntable.insert(sortedfiles.None, file)\nend\nend\nprj.vc2010sortedfiles = sortedfiles\nend\nreturn sortedfiles[group]\nend\nfunction vc2010.files(prj)\nvc2010.simplefilesgroup(prj, \"ClInclude\")\nvc2010.compilerfilesgroup(prj)\nvc2010.simplefilesgroup(prj, \"None\")\nvc2010.simplefilesgroup(prj, \"ResourceCompile\")\nend\nfunction vc2010.simplefilesgroup(prj, section)\nlocal files = vc2010.getfilegroup(prj, section)\nif #files > 0  then\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\n_p(2,'<%s Include=\\\"%s\\\" />', section, path.translate(file.name, \"\\\\\"))"
	"\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.compilerfilesgroup(prj)\nlocal configs = prj.solution.vstudio_configs\nlocal files = vc2010.getfilegroup(prj, \"ClCompile\")\nif #files > 0  then\nlocal config_mappings = {}\nfor _, cfginfo in ipairs(configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nif cfg.pchheader and cfg.pchsource and not cfg.flags.NoPCH then\nconfig_mappings[cfginfo] = path.translate(cfg.pchsource, \"\\\\\")\nend\nend\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\nlocal translatedpath = path.translate(file.name, \"\\\\\")\n_p(2,'<ClCompile Include=\\\"%s\\\">', translatedpath)\nfor _, cfginfo in ipairs(configs) do\nif config_mappings[cfginfo] and translatedpath == config_mappings[cfginfo] then\n_p(3,'<PrecompiledHeader '.. if_config_and_platform() .. '>Create</PrecompiledHeader>', premake.esc(cfginfo.name))\nconfig_mappings[cfginfo] = nil  --only one source file per pch\nend\nend\n_p(2,'</ClCompile>')\nend\n_p(1,'</ItemGroup>')\nend\ne"
	"nd\nfunction vc2010.header(targets)\nio.eol = \"\\r\\n\"\n_p('<?xml version=\"1.0\" encoding=\"utf-8\"?>')\nlocal t = \"\"\nif targets then\nt = ' DefaultTargets=\"' .. targets .. '\"'\nend\n_p('<Project%s ToolsVersion=\"4.0\" xmlns=\"http://schemas.microsoft.com/developer/msbuild/2003\">', t)\nend\nfunction premake.vs2010_vcxproj(prj)\nio.indent = \"  \"\nvc2010.header(\"Build\")\nvs2010_config(prj)\nvs2010_globals(prj)\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.Default.props\" />')\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\nvc2010.configurationPropertyGroup(cfg, cfginfo)\nend\n_p(1,'<Import Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.props\" />')\n_p(1,'<ImportGroup Label=\"ExtensionSettings\">')\n_p(1,'</ImportGroup>')\nimport_props(prj)\n_p(1,'<PropertyGroup Label=\"UserMacros\" />')\nvc2010.outputProperties(prj)\nitem_definitions(prj)\nvc2010.files(prj)\nvc2010.projectReferences(prj)\n_p(1,'<Im"
	"port Project=\"$(VCTargetsPath)\\\\Microsoft.Cpp.targets\" />')\n_p(1,'<ImportGroup Label=\"ExtensionTargets\">')\n_p(1,'</ImportGroup>')\n_p('</Project>')\nend\nfunction vc2010.projectReferences(prj)\nlocal deps = premake.getdependencies(prj)\nif #deps > 0 then\n_p(1,'<ItemGroup>')\nfor _, dep in ipairs(deps) do\nlocal deppath = path.getrelative(prj.location, vstudio.projectfile(dep))\n_p(2,'<ProjectReference Include=\\\"%s\\\">', path.translate(deppath, \"\\\\\"))\n_p(3,'<Project>{%s}</Project>', dep.uuid)\n_p(2,'</ProjectReference>')\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.debugdir(cfg)\nif cfg.debugdir then\n_p('    <LocalDebuggerWorkingDirectory>%s</LocalDebuggerWorkingDirectory>', path.translate(cfg.debugdir, '\\\\'))\n_p('    <DebuggerFlavor>WindowsLocalDebugger</DebuggerFlavor>')\nend\nif cfg.debugargs then\n_p('    <LocalDebuggerCommandArguments>%s</LocalDebuggerCommandArguments>', table.concat(cfg.debugargs, \" \"))\nend\nend\nfunction vc2010.debugenvs(cfg)\nif cfg.debugenvs and #cfg.de"
	"bugenvs > 0 then\n_p(2,'<LocalDebuggerEnvironment>%s%s</LocalDebuggerEnvironment>',table.concat(cfg.debugenvs, \"\\n\")\n,iif(cfg.flags.DebugEnvsInherit,'\\n$(LocalDebuggerEnvironment)','')\n)\nif cfg.flags.DebugEnvsDontMerge then\n_p(2,'<LocalDebuggerMergeEnvironment>false</LocalDebuggerMergeEnvironment>')\nend\nend\nend\nfunction premake.vs2010_vcxproj_user(prj)\nio.indent = \"  \"\nvc2010.header()\nfor _, cfginfo in ipairs(prj.solution.vstudio_configs) do\nlocal cfg = premake.getconfig(prj, cfginfo.src_buildcfg, cfginfo.src_platform)\n_p('  <PropertyGroup '.. if_config_and_platform() ..'>', premake.esc(cfginfo.name))\nvc2010.debugdir(cfg)\nvc2010.debugenvs(cfg)\n_p('  </PropertyGroup>')\nend\n_p('</Project>')\nend\n",

	/* actions/vstudio/vs2010_vcxproj_filters.lua */
	"local vc2010 = premake.vstudio.vc2010\nlocal project = premake.project\nfunction vc2010.filteridgroup(prj)\nlocal filters = { }\nlocal filterfound = false\nfor file in project.eachfile(prj) do\nlocal folders = string.explode(file.vpath, \"/\", true)\nlocal path = \"\"\nfor i = 1, #folders - 1 do\nif not filterfound then\nfilterfound = true\n_p(1,'<ItemGroup>')\nend\npath = path .. folders[i]\nif not filters[path] then\nfilters[path] = true\n_p(2, '<Filter Include=\"%s\">', path)\n_p(3, '<UniqueIdentifier>{%s}</UniqueIdentifier>', os.uuid())\n_p(2, '</Filter>')\nend\npath = path .. \"\\\\\"\nend\nend\nif filterfound then\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.filefiltergroup(prj, section)\nlocal files = vc2010.getfilegroup(prj, section)\nif #files > 0 then\n_p(1,'<ItemGroup>')\nfor _, file in ipairs(files) do\nlocal filter\nif file.name ~= file.vpath then\nfilter = path.getdirectory(file.vpath)\nelse\nfilter = path.getdirectory(file.name)\nend\nif filter ~= \".\" then\n_p(2,'<%s Include=\\\"%s\\\">', "
	"section, path.translate(file.name, \"\\\\\"))\n_p(3,'<Filter>%s</Filter>', path.translate(filter, \"\\\\\"))\n_p(2,'</%s>', section)\nelse\n_p(2,'<%s Include=\\\"%s\\\" />', section, path.translate(file.name, \"\\\\\"))\nend\nend\n_p(1,'</ItemGroup>')\nend\nend\nfunction vc2010.generate_filters(prj)\nio.indent = \"  \"\nvc2010.header()\nvc2010.filteridgroup(prj)\nvc2010.filefiltergroup(prj, \"None\")\nvc2010.filefiltergroup(prj, \"ClInclude\")\nvc2010.filefiltergroup(prj, \"ClCompile\")\nvc2010.filefiltergroup(prj, \"ResourceCompile\")\n_p('</Project>')\nend\n",

	/* actions/vstudio/vs2012.lua */
	"premake.vstudio.vc2012 = {}\nlocal vc2012 = premake.vstudio.vc2012\nlocal vstudio = premake.vstudio\nnewaction\n{\ntrigger         = \"vs2012\",\nshortname       = \"Visual Studio 2012\",\ndescription     = \"Generate Microsoft Visual Studio 2012 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vcxproj.filters\", vstudio.vc2010.generate_filters)\nend"
	"\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproject,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5\",\ntoolsVersion    = \"4.0\",\n}\n}\n",

	/* actions/vstudio/vs2013.lua */
	"newaction\n{\ntrigger         = \"vs2013\",\nshortname       = \"Visual Studio 2013\",\ndescription     = \"Generate Microsoft Visual Studio 2013 project files\",\nos              = \"windows\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"StaticLib\", \"SharedLib\" },\nvalid_languages = { \"C\", \"C++\", \"C#\"},\nvalid_tools     = {\ncc     = { \"msc\"   },\ndotnet = { \"msnet\" },\n},\nonsolution = function(sln)\npremake.generate(sln, \"%%.sln\", vstudio.sln2005.generate)\nend,\nonproject = function(prj)\nif premake.isdotnetproject(prj) then\npremake.generate(prj, \"%%.csproj\", vstudio.cs2005.generate)\npremake.generate(prj, \"%%.csproj.user\", vstudio.cs2005.generate_user)\nelse\npremake.generate(prj, \"%%.vcxproj\", premake.vs2010_vcxproj)\npremake.generate(prj, \"%%.vcxproj.user\", premake.vs2010_vcxproj_user)\npremake.generate(prj, \"%%.vcxproj.filters\", vstudio.vc2010.generate_filters)\nend\nend,\noncleansolution = premake.vstudio.cleansolution,\noncleanproject  = premake.vstudio.cleanproj"
	"ect,\noncleantarget   = premake.vstudio.cleantarget,\nvstudio = {\nsolutionVersion = \"12\",\ntargetFramework = \"4.5\",\ntoolsVersion    = \"12.0\",\n}\n}\n",

	/* actions/xcode/_xcode.lua */
	"premake.xcode = { }\nnewaction \n{\ntrigger         = \"xcode3\",\nshortname       = \"Xcode 3\",\ndescription     = \"Generate Apple Xcode 3 project files (experimental)\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"SharedLib\", \"StaticLib\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = { \nNative = \"Native\", \nx32 = \"Native 32-bit\", \nx64 = \"Native 64-bit\", \nUniversal32 = \"32-bit Universal\", \nUniversal64 = \"64-bit Universal\", \nUniversal = \"Universal\",\n},\ndefault_platform = \"Universal\",\nonsolution = function(sln)\npremake.xcode.preparesolution(sln)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", premake.xcode.project)\nend,\noncleanproject = function(prj)\npremake.clean.directory(prj, \"%%.xcodeproj\")\nend,\noncheckproject = function(prj)\nlocal last\nfor cfg in premake.eachconfig(prj) do\nif last and last ~= cfg.kind then\nerror(\"Project '"
	"\" .. prj.name .. \"' uses more than one target kind; not supported by Xcode\", 0)\nend\nlast = cfg.kind\nend\nend,\n}\nnewaction \n{\ntrigger         = \"xcode4\",\nshortname       = \"Xcode 4\",\ndescription     = \"Generate Apple Xcode 4 project files (experimental)\",\nos              = \"macosx\",\nvalid_kinds     = { \"ConsoleApp\", \"WindowedApp\", \"SharedLib\", \"StaticLib\" },\nvalid_languages = { \"C\", \"C++\" },\nvalid_tools     = {\ncc     = { \"gcc\" },\n},\nvalid_platforms = { \nNative = \"Native\", \nx32 = \"Native 32-bit\", \nx64 = \"Native 64-bit\", \nUniversal32 = \"32-bit Universal\", \nUniversal64 = \"64-bit Universal\", \nUniversal = \"Universal\",\n},\ndefault_platform = \"Universal\",\nonsolution = function(sln)\npremake.generate(sln, \"%%.xcworkspace/contents.xcworkspacedata\", premake.xcode4.workspace_generate)\nend,\nonproject = function(prj)\npremake.generate(prj, \"%%.xcodeproj/project.pbxproj\", premake.xcode.project)\nend,\noncleanproject = function(prj)\npremake.clean.directory"
	"(prj, \"%%.xcodeproj\")\npremake.clean.directory(prj, \"%%.xcworkspace\")\nend,\noncheckproject = function(prj)\nlocal last\nfor cfg in premake.eachconfig(prj) do\nif last and last ~= cfg.kind then\nerror(\"Project '\" .. prj.name .. \"' uses more than one target kind; not supported by Xcode\", 0)\nend\nlast = cfg.kind\nend\nend,\n}\n",

	/* actions/xcode/xcode_common.lua */
	"local xcode = premake.xcode\nlocal tree  = premake.tree\nfunction xcode.getbuildcategory(node)\nlocal categories = {\n[\".a\"] = \"Frameworks\",\n[\".c\"] = \"Sources\",\n[\".cc\"] = \"Sources\",\n[\".cpp\"] = \"Sources\",\n[\".cxx\"] = \"Sources\",\n[\".dylib\"] = \"Frameworks\",\n[\".framework\"] = \"Frameworks\",\n[\".m\"] = \"Sources\",\n[\".mm\"] = \"Sources\",\n[\".strings\"] = \"Resources\",\n[\".nib\"] = \"Resources\",\n[\".xib\"] = \"Resources\",\n[\".icns\"] = \"Resources\",\n[\".bmp\"] = \"Resources\",\n[\".wav\"] = \"Resources\",\n}\nreturn categories[path.getextension(node.name)]\nend\nfunction xcode.getconfigname(cfg)\nlocal name = cfg.name\nif #cfg.project.solution.xcode.platforms > 1 then\nname = name .. \" \" .. premake.action.current().valid_platforms[cfg.platform]\nend\nreturn name\nend\nfunction xcode.getfiletype(node)\nlocal types = {\n[\".c\"]         = \"sourcecode.c.c\",\n[\".cc\"]        = \"sourcecode.cpp.cpp\",\n[\".cpp\"]       = \"sourcecode.cpp.cpp\",\n[\".css\"]       = \"text.cs"
	"s\",\n[\".cxx\"]       = \"sourcecode.cpp.cpp\",\n[\".framework\"] = \"wrapper.framework\",\n[\".gif\"]       = \"image.gif\",\n[\".h\"]         = \"sourcecode.c.h\",\n[\".html\"]      = \"text.html\",\n[\".lua\"]       = \"sourcecode.lua\",\n[\".m\"]         = \"sourcecode.c.objc\",\n[\".mm\"]        = \"sourcecode.cpp.objc\",\n[\".nib\"]       = \"wrapper.nib\",\n[\".pch\"]       = \"sourcecode.c.h\",\n[\".plist\"]     = \"text.plist.xml\",\n[\".strings\"]   = \"text.plist.strings\",\n[\".xib\"]       = \"file.xib\",\n[\".icns\"]      = \"image.icns\",\n[\".bmp\"]       = \"image.bmp\",\n[\".wav\"]       = \"audio.wav\",\n}\nreturn types[path.getextension(node.path)] or \"text\"\nend\nfunction xcode.getproducttype(node)\nlocal types = {\nConsoleApp  = \"com.apple.product-type.tool\",\nWindowedApp = \"com.apple.product-type.application\",\nStaticLib   = \"com.apple.product-type.library.static\",\nSharedLib   = \"com.apple.product-type.library.dynamic\",\n}\nreturn types[node.cfg.kind]\nend\nfunction xcode.get"
	"targettype(node)\nlocal types = {\nConsoleApp  = \"\\\"compiled.mach-o.executable\\\"\",\nWindowedApp = \"wrapper.application\",\nStaticLib   = \"archive.ar\",\nSharedLib   = \"\\\"compiled.mach-o.dylib\\\"\",\n}\nreturn types[node.cfg.kind]\nend\nfunction xcode.getxcodeprojname(prj)\nlocal fname = premake.project.getfilename(prj, \"%%.xcodeproj\")\nreturn fname\nend\nfunction xcode.isframework(fname)\nreturn (path.getextension(fname) == \".framework\")\nend\nfunction xcode.newid()\nreturn string.format(\"%04X%04X%04X%04X%04X%04X\",\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767),\nmath.random(0, 32767))\nend\nfunction xcode.preparesolution(sln)\nsln.xcode = { }\nsln.xcode.platforms = premake.filterplatforms(sln, premake.action.current().valid_platforms, \"Universal\")\nfor prj in premake.solution.eachproject(sln) do\nlocal cfg = premake.getconfig(prj, prj.configurations[1], sln.xcode.platforms[1])\nlocal node = premake.tree.new(path.getnam"
	"e(cfg.buildtarget.bundlepath))\nnode.cfg = cfg\nnode.id = premake.xcode.newid(node, \"product\")\nnode.targetid = premake.xcode.newid(node, \"target\")\nprj.xcode = {}\nprj.xcode.projectnode = node\nend\nend\nfunction xcode.printlist(list, tag)\nif #list > 0 then\n_p(4,'%s = (', tag)\nfor _, item in ipairs(list) do\nlocal escaped_item = item:gsub(\"\\\"\", \"\\\\\\\"\")\n_p(5, '\"%s\",', escaped_item)\nend\n_p(4,');')\nend\nend\nfunction xcode.Header()\n_p('// !$*UTF8*$!')\n_p('{')\n_p(1,'archiveVersion = 1;')\n_p(1,'classes = {')\n_p(1,'};')\n_p(1,'objectVersion = 45;')\n_p(1,'objects = {')\n_p('')\nend\nfunction xcode.PBXBuildFile(tr)\n_p('/* Begin PBXBuildFile section */')\ntree.traverse(tr, {\nonnode = function(node)\nif node.buildid then\n_p(2,'%s /* %s in %s */ = {isa = PBXBuildFile; fileRef = %s /* %s */; };', \nnode.buildid, node.name, xcode.getbuildcategory(node), node.id, node.name)\nend\nend\n})\n_p('/* End PBXBuildFile section */')\n_p('')\nend\nfunction xcode.PBXContainerItemProxy(tr)\nif #tr.proj"
	"ects.children > 0 then\n_p('/* Begin PBXContainerItemProxy section */')\nfor _, node in ipairs(tr.projects.children) do\n_p(2,'%s /* PBXContainerItemProxy */ = {', node.productproxyid)\n_p(3,'isa = PBXContainerItemProxy;')\n_p(3,'containerPortal = %s /* %s */;', node.id, path.getname(node.path))\n_p(3,'proxyType = 2;')\n_p(3,'remoteGlobalIDString = %s;', node.project.xcode.projectnode.id)\n_p(3,'remoteInfo = \"%s\";', node.project.xcode.projectnode.name)\n_p(2,'};')\n_p(2,'%s /* PBXContainerItemProxy */ = {', node.targetproxyid)\n_p(3,'isa = PBXContainerItemProxy;')\n_p(3,'containerPortal = %s /* %s */;', node.id, path.getname(node.path))\n_p(3,'proxyType = 1;')\n_p(3,'remoteGlobalIDString = %s;', node.project.xcode.projectnode.targetid)\n_p(3,'remoteInfo = \"%s\";', node.project.xcode.projectnode.name)\n_p(2,'};')\nend\n_p('/* End PBXContainerItemProxy section */')\n_p('')\nend\nend\nfunction xcode.PBXFileReference(tr)\n_p('/* Begin PBXFileReference section */')\ntree.traverse(tr, {\nonleaf = function(node)\n"
	"if not node.path then\nreturn\nend\nif node.kind == \"product\" then\n_p(2,'%s /* %s */ = {isa = PBXFileReference; explicitFileType = %s; includeInIndex = 0; name = \"%s\"; path = \"%s\"; sourceTree = BUILT_PRODUCTS_DIR; };',\nnode.id, node.name, xcode.gettargettype(node), node.name, path.getname(node.cfg.buildtarget.bundlepath))\nelseif node.parent.parent == tr.projects then\nlocal relpath = path.getrelative(tr.project.location, node.parent.project.location)\n_p(2,'%s /* %s */ = {isa = PBXFileReference; lastKnownFileType = \"wrapper.pb-project\"; name = \"%s\"; path = \"%s\"; sourceTree = SOURCE_ROOT; };',\nnode.parent.id, node.parent.name, node.parent.name, path.join(relpath, node.parent.name))\nelse\nlocal pth, src\nif xcode.isframework(node.path) then\nlocal nodePath = node.path\nlocal _, matchEnd, variable = string.find(nodePath, \"^%$%((.+)%)/\")\nif variable then\nnodePath = string.sub(nodePath, matchEnd + 1)\nend\nif string.find(nodePath,'/')  then\nif string.find(nodePath,'^%.')then\nerror('relative p"
	"aths are not currently supported for frameworks')\nend\npth = nodePath\nelse\npth = \"/System/Library/Frameworks/\" .. nodePath\nend\nif variable then\nsrc = variable\nif string.find(pth, '^/') then\npth = string.sub(pth, 2)\nend\nelse\nsrc = \"<absolute>\"\nend\nelse\nsrc = \"<group>\"\nif node.parent.isvpath then\npth = node.cfg.name\nelse\npth = tree.getlocalpath(node)\nend\nend\n_p(2,'%s /* %s */ = {isa = PBXFileReference; lastKnownFileType = %s; name = \"%s\"; path = \"%s\"; sourceTree = \"%s\"; };',\nnode.id, node.name, xcode.getfiletype(node), node.name, pth, src)\nend\nend\n})\n_p('/* End PBXFileReference section */')\n_p('')\nend\nfunction xcode.PBXFrameworksBuildPhase(tr)\n_p('/* Begin PBXFrameworksBuildPhase section */')\n_p(2,'%s /* Frameworks */ = {', tr.products.children[1].fxstageid)\n_p(3,'isa = PBXFrameworksBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr.frameworks, {\nonleaf = function(node)\n_p(4,'%s /* %s in Frameworks */,', node.buildid, node.name)"
	"\nend\n})\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(4,'%s /* %s in Frameworks */,', node.buildid, node.name)\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\n_p('/* End PBXFrameworksBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXGroup(tr)\n_p('/* Begin PBXGroup section */')\ntree.traverse(tr, {\nonnode = function(node)\nif (node.path and #node.children == 0) or node.kind == \"vgroup\" then\nreturn\nend\nif node.parent == tr.projects then\n_p(2,'%s /* Products */ = {', node.productgroupid)\nelse\n_p(2,'%s /* %s */ = {', node.id, node.name)\nend\n_p(3,'isa = PBXGroup;')\n_p(3,'children = (')\nfor _, childnode in ipairs(node.children) do\n_p(4,'%s /* %s */,', childnode.id, childnode.name)\nend\n_p(3,');')\nif node.parent == tr.projects then\n_p(3,'name = Products;')\nelse\n_p(3,'name = \"%s\";', node.name)\nif node.path and not node.isvpath then\nlocal p = node.path\nif node.parent.path then\np = path.getrelative(node.parent.path, node.path)\nend\n_p(3,'"
	"path = \"%s\";', p)\nend\nend\n_p(3,'sourceTree = \"<group>\";')\n_p(2,'};')\nend\n}, true)\n_p('/* End PBXGroup section */')\n_p('')\nend\nfunction xcode.PBXNativeTarget(tr)\n_p('/* Begin PBXNativeTarget section */')\nfor _, node in ipairs(tr.products.children) do\nlocal name = tr.project.name\nlocal function hasBuildCommands(which)\nif #tr.project[which] > 0 then\nreturn true\nend\nfor _, cfg in ipairs(tr.configs) do\nif #cfg[which] > 0 then\nreturn true\nend\nend\nend\n_p(2,'%s /* %s */ = {', node.targetid, name)\n_p(3,'isa = PBXNativeTarget;')\n_p(3,'buildConfigurationList = %s /* Build configuration list for PBXNativeTarget \"%s\" */;', node.cfgsection, name)\n_p(3,'buildPhases = (')\nif hasBuildCommands('prebuildcommands') then\n_p(4,'9607AE1010C857E500CD1376 /* Prebuild */,')\nend\n_p(4,'%s /* Resources */,', node.resstageid)\n_p(4,'%s /* Sources */,', node.sourcesid)\nif hasBuildCommands('prelinkcommands') then\n_p(4,'9607AE3510C85E7E00CD1376 /* Prelink */,')\nend\n_p(4,'%s /* Frameworks */,', node.fxs"
	"tageid)\nif hasBuildCommands('postbuildcommands') then\n_p(4,'9607AE3710C85E8F00CD1376 /* Postbuild */,')\nend\n_p(3,');')\n_p(3,'buildRules = (')\n_p(3,');')\n_p(3,'dependencies = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'%s /* PBXTargetDependency */,', node.targetdependid)\nend\n_p(3,');')\n_p(3,'name = \"%s\";', name)\nlocal p\nif node.cfg.kind == \"ConsoleApp\" then\np = \"$(HOME)/bin\"\nelseif node.cfg.kind == \"WindowedApp\" then\np = \"$(HOME)/Applications\"\nend\nif p then\n_p(3,'productInstallPath = \"%s\";', p)\nend\n_p(3,'productName = \"%s\";', name)\n_p(3,'productReference = %s /* %s */;', node.id, node.name)\n_p(3,'productType = \"%s\";', xcode.getproducttype(node))\n_p(2,'};')\nend\n_p('/* End PBXNativeTarget section */')\n_p('')\nend\nfunction xcode.PBXProject(tr)\n_p('/* Begin PBXProject section */')\n_p(2,'08FB7793FE84155DC02AAC07 /* Project object */ = {')\n_p(3,'isa = PBXProject;')\n_p(3,'buildConfigurationList = 1DEB928908733DD80010E9CD /* Build configuration list for PBXP"
	"roject \"%s\" */;', tr.name)\n_p(3,'compatibilityVersion = \"Xcode 3.2\";')\n_p(3,'hasScannedForEncodings = 1;')\n_p(3,'mainGroup = %s /* %s */;', tr.id, tr.name)\n_p(3,'projectDirPath = \"\";')\nif #tr.projects.children > 0 then\n_p(3,'projectReferences = (')\nfor _, node in ipairs(tr.projects.children) do\n_p(4,'{')\n_p(5,'ProductGroup = %s /* Products */;', node.productgroupid)\n_p(5,'ProjectRef = %s /* %s */;', node.id, path.getname(node.path))\n_p(4,'},')\nend\n_p(3,');')\nend\n_p(3,'projectRoot = \"\";')\n_p(3,'targets = (')\nfor _, node in ipairs(tr.products.children) do\n_p(4,'%s /* %s */,', node.targetid, node.name)\nend\n_p(3,');')\n_p(2,'};')\n_p('/* End PBXProject section */')\n_p('')\nend\nfunction xcode.PBXReferenceProxy(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXReferenceProxy section */')\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(2,'%s /* %s */ = {', node.id, node.name)\n_p(3,'isa = PBXReferenceProxy;')\n_p(3,'fileType = %s;', xcode.gettargettype(node))\n_p(3,'path"
	" = \"%s\";', node.path)\n_p(3,'remoteRef = %s /* PBXContainerItemProxy */;', node.parent.productproxyid)\n_p(3,'sourceTree = BUILT_PRODUCTS_DIR;')\n_p(2,'};')\nend\n})\n_p('/* End PBXReferenceProxy section */')\n_p('')\nend\nend\nfunction xcode.PBXResourcesBuildPhase(tr)\n_p('/* Begin PBXResourcesBuildPhase section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Resources */ = {', target.resstageid)\n_p(3,'isa = PBXResourcesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr, {\nonnode = function(node)\nif xcode.getbuildcategory(node) == \"Resources\" then\n_p(4,'%s /* %s in Resources */,', node.buildid, node.name)\nend\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\nend\n_p('/* End PBXResourcesBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXShellScriptBuildPhase(tr)\nlocal wrapperWritten = false\nlocal function doblock(id, name, which)\nlocal prjcmds = tr.project[which]\nlocal commands = table.join(prjcmds, {}"
	")\nfor _, cfg in ipairs(tr.configs) do\nlocal cfgcmds = cfg[which]\nif #cfgcmds > #prjcmds then\ntable.insert(commands, 'if [ \"${CONFIGURATION}\" = \"' .. xcode.getconfigname(cfg) .. '\" ]; then')\nfor i = #prjcmds + 1, #cfgcmds do\ntable.insert(commands, cfgcmds[i])\nend\ntable.insert(commands, 'fi')\nend\nend\nif #commands > 0 then\nif not wrapperWritten then\n_p('/* Begin PBXShellScriptBuildPhase section */')\nwrapperWritten = true\nend\n_p(2,'%s /* %s */ = {', id, name)\n_p(3,'isa = PBXShellScriptBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\n_p(3,');')\n_p(3,'inputPaths = (');\n_p(3,');');\n_p(3,'name = %s;', name);\n_p(3,'outputPaths = (');\n_p(3,');');\n_p(3,'runOnlyForDeploymentPostprocessing = 0;');\n_p(3,'shellPath = /bin/sh;');\n_p(3,'shellScript = \"%s\";', table.concat(commands, \"\\\\n\"):gsub('\"', '\\\\\"'))\n_p(2,'};')\nend\nend\ndoblock(\"9607AE1010C857E500CD1376\", \"Prebuild\", \"prebuildcommands\")\ndoblock(\"9607AE3510C85E7E00CD1376\", \"Prelink\", \"prelinkcomm"
	"ands\")\ndoblock(\"9607AE3710C85E8F00CD1376\", \"Postbuild\", \"postbuildcommands\")\nif wrapperWritten then\n_p('/* End PBXShellScriptBuildPhase section */')\nend\nend\nfunction xcode.PBXSourcesBuildPhase(tr)\n_p('/* Begin PBXSourcesBuildPhase section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Sources */ = {', target.sourcesid)\n_p(3,'isa = PBXSourcesBuildPhase;')\n_p(3,'buildActionMask = 2147483647;')\n_p(3,'files = (')\ntree.traverse(tr, {\nonleaf = function(node)\nif xcode.getbuildcategory(node) == \"Sources\" then\n_p(4,'%s /* %s in Sources */,', node.buildid, node.name)\nend\nend\n})\n_p(3,');')\n_p(3,'runOnlyForDeploymentPostprocessing = 0;')\n_p(2,'};')\nend\n_p('/* End PBXSourcesBuildPhase section */')\n_p('')\nend\nfunction xcode.PBXVariantGroup(tr)\n_p('/* Begin PBXVariantGroup section */')\ntree.traverse(tr, {\nonbranch = function(node)\nif node.kind == \"vgroup\" then\n_p(2,'%s /* %s */ = {', node.id, node.name)\n_p(3,'isa = PBXVariantGroup;')\n_p(3,'children = (')\nfor _,"
	" lang in ipairs(node.children) do\n_p(4,'%s /* %s */,', lang.id, lang.name)\nend\n_p(3,');')\n_p(3,'name = %s;', node.name)\n_p(3,'sourceTree = \"<group>\";')\n_p(2,'};')\nend\nend\n})\n_p('/* End PBXVariantGroup section */')\n_p('')\nend\nfunction xcode.PBXTargetDependency(tr)\nif #tr.projects.children > 0 then\n_p('/* Begin PBXTargetDependency section */')\ntree.traverse(tr.projects, {\nonleaf = function(node)\n_p(2,'%s /* PBXTargetDependency */ = {', node.parent.targetdependid)\n_p(3,'isa = PBXTargetDependency;')\n_p(3,'name = \"%s\";', node.name)\n_p(3,'targetProxy = %s /* PBXContainerItemProxy */;', node.parent.targetproxyid)\n_p(2,'};')\nend\n})\n_p('/* End PBXTargetDependency section */')\n_p('')\nend\nend\nfunction xcode.XCBuildConfiguration_Target(tr, target, cfg)\nlocal cfgname = xcode.getconfigname(cfg)\n_p(2,'%s /* %s */ = {', cfg.xcode.targetid, cfgname)\n_p(3,'isa = XCBuildConfiguration;')\n_p(3,'buildSettings = {')\n_p(4,'ALWAYS_SEARCH_USER_PATHS = NO;')\nif not cfg.flags.Symbols then\n_p(4,'DEB"
	"UG_INFORMATION_FORMAT = \"dwarf-with-dsym\";')\nend\nif cfg.kind ~= \"StaticLib\" and cfg.buildtarget.prefix ~= \"\" then\n_p(4,'EXECUTABLE_PREFIX = %s;', cfg.buildtarget.prefix)\nend\nif cfg.targetextension then\nlocal ext = cfg.targetextension\next = iif(ext:startswith(\".\"), ext:sub(2), ext)\n_p(4,'EXECUTABLE_EXTENSION = %s;', ext)\nend\nlocal outdir = path.getdirectory(cfg.buildtarget.bundlepath)\nif outdir ~= \".\" then\n_p(4,'CONFIGURATION_BUILD_DIR = %s;', outdir)\nend\n_p(4,'GCC_DYNAMIC_NO_PIC = NO;')\n_p(4,'GCC_MODEL_TUNING = G5;')\nif tr.infoplist then\n_p(4,'INFOPLIST_FILE = \"%s\";', tr.infoplist.cfg.name)\nend\ninstallpaths = {\nConsoleApp = '/usr/local/bin',\nWindowedApp = '\"$(HOME)/Applications\"',\nSharedLib = '/usr/local/lib',\nStaticLib = '/usr/local/lib',\n}\n_p(4,'INSTALL_PATH = %s;', installpaths[cfg.kind])\n_p(4,'PRODUCT_NAME = \"%s\";', cfg.buildtarget.basename)\n_p(3,'};')\n_p(3,'name = \"%s\";', cfgname)\n_p(2,'};')\nend\nfunction xcode.XCBuildConfiguration_Project(tr, cfg)\nlocal cf"
	"gname = xcode.getconfigname(cfg)\n_p(2,'%s /* %s */ = {', cfg.xcode.projectid, cfgname)\n_p(3,'isa = XCBuildConfiguration;')\n_p(3,'buildSettings = {')\nlocal archs = {\nNative = \"$(NATIVE_ARCH_ACTUAL)\",\nx32    = \"i386\",\nx64    = \"x86_64\",\nUniversal32 = \"$(ARCHS_STANDARD_32_BIT)\",\nUniversal64 = \"$(ARCHS_STANDARD_64_BIT)\",\nUniversal = \"$(ARCHS_STANDARD_32_64_BIT)\",\n}\n_p(4,'ARCHS = \"%s\";', archs[cfg.platform])\nlocal targetdir = path.getdirectory(cfg.buildtarget.bundlepath)\nif targetdir ~= \".\" then\n_p(4,'CONFIGURATION_BUILD_DIR = \"$(SYMROOT)\";');\nend\n_p(4,'CONFIGURATION_TEMP_DIR = \"$(OBJROOT)\";')\nif cfg.flags.Symbols then\n_p(4,'COPY_PHASE_STRIP = NO;')\nend\n_p(4,'GCC_C_LANGUAGE_STANDARD = gnu99;')\nif cfg.flags.NoExceptions then\n_p(4,'GCC_ENABLE_CPP_EXCEPTIONS = NO;')\nend\nif cfg.flags.NoRTTI then\n_p(4,'GCC_ENABLE_CPP_RTTI = NO;')\nend\nif _ACTION ~= \"xcode4\" and cfg.flags.Symbols and not cfg.flags.NoEditAndContinue then\n_p(4,'GCC_ENABLE_FIX_AND_CONTINUE = YES;')\nend\nif "
	"cfg.flags.NoExceptions then\n_p(4,'GCC_ENABLE_OBJC_EXCEPTIONS = NO;')\nend\nif cfg.flags.Optimize or cfg.flags.OptimizeSize then\n_p(4,'GCC_OPTIMIZATION_LEVEL = s;')\nelseif cfg.flags.OptimizeSpeed then\n_p(4,'GCC_OPTIMIZATION_LEVEL = 3;')\nelse\n_p(4,'GCC_OPTIMIZATION_LEVEL = 0;')\nend\nif cfg.pchheader and not cfg.flags.NoPCH then\n_p(4,'GCC_PRECOMPILE_PREFIX_HEADER = YES;')\n_p(4,'GCC_PREFIX_HEADER = \"%s\";', cfg.pchheader)\nend\nxcode.printlist(cfg.defines, 'GCC_PREPROCESSOR_DEFINITIONS')\n_p(4,'GCC_SYMBOLS_PRIVATE_EXTERN = NO;')\nif cfg.flags.FatalWarnings then\n_p(4,'GCC_TREAT_WARNINGS_AS_ERRORS = YES;')\nend\n_p(4,'GCC_WARN_ABOUT_RETURN_TYPE = YES;')\n_p(4,'GCC_WARN_UNUSED_VARIABLE = YES;')\nxcode.printlist(cfg.includedirs, 'HEADER_SEARCH_PATHS')\nxcode.printlist(cfg.libdirs, 'LIBRARY_SEARCH_PATHS')\n_p(4,'OBJROOT = \"%s\";', cfg.objectsdir)\n_p(4,'ONLY_ACTIVE_ARCH = %s;',iif(premake.config.isdebugbuild(cfg),'YES','NO'))\nlocal checks = {\n[\"-ffast-math\"]          = cfg.flags.FloatFast,\n[\"-ffloat-s"
	"tore\"]        = cfg.flags.FloatStrict,\n[\"-fomit-frame-pointer\"] = cfg.flags.NoFramePointer,\n}\nlocal flags = { }\nfor flag, check in pairs(checks) do\nif check then\ntable.insert(flags, flag)\nend\nend\nxcode.printlist(table.join(flags, cfg.buildoptions), 'OTHER_CFLAGS')\nflags = { }\nfor _, lib in ipairs(premake.getlinks(cfg, \"system\")) do\nif not xcode.isframework(lib) then\ntable.insert(flags, \"-l\" .. lib)\nend\nend\nflags = table.join(flags, cfg.linkoptions)\nxcode.printlist(flags, 'OTHER_LDFLAGS')\nif cfg.flags.StaticRuntime then\n_p(4,'STANDARD_C_PLUS_PLUS_LIBRARY_TYPE = static;')\nend\nif targetdir ~= \".\" then\n_p(4,'SYMROOT = \"%s\";', targetdir)\nend\nif cfg.flags.ExtraWarnings then\n_p(4,'WARNING_CFLAGS = \"-Wall\";')\nend\n_p(3,'};')\n_p(3,'name = \"%s\";', cfgname)\n_p(2,'};')\nend\nfunction xcode.XCBuildConfiguration(tr)\n_p('/* Begin XCBuildConfiguration section */')\nfor _, target in ipairs(tr.products.children) do\nfor _, cfg in ipairs(tr.configs) do\nxcode.XCBuildConfiguration_Targe"
	"t(tr, target, cfg)\nend\nend\nfor _, cfg in ipairs(tr.configs) do\nxcode.XCBuildConfiguration_Project(tr, cfg)\nend\n_p('/* End XCBuildConfiguration section */')\n_p('')\nend\nfunction xcode.XCBuildConfigurationList(tr)\nlocal sln = tr.project.solution\n_p('/* Begin XCConfigurationList section */')\nfor _, target in ipairs(tr.products.children) do\n_p(2,'%s /* Build configuration list for PBXNativeTarget \"%s\" */ = {', target.cfgsection, target.name)\n_p(3,'isa = XCConfigurationList;')\n_p(3,'buildConfigurations = (')\nfor _, cfg in ipairs(tr.configs) do\n_p(4,'%s /* %s */,', cfg.xcode.targetid, xcode.getconfigname(cfg))\nend\n_p(3,');')\n_p(3,'defaultConfigurationIsVisible = 0;')\n_p(3,'defaultConfigurationName = \"%s\";', xcode.getconfigname(tr.configs[1]))\n_p(2,'};')\nend\n_p(2,'1DEB928908733DD80010E9CD /* Build configuration list for PBXProject \"%s\" */ = {', tr.name)\n_p(3,'isa = XCConfigurationList;')\n_p(3,'buildConfigurations = (')\nfor _, cfg in ipairs(tr.configs) do\n_p(4,'%s /* %s */,', cfg.xcode"
	".projectid, xcode.getconfigname(cfg))\nend\n_p(3,');')\n_p(3,'defaultConfigurationIsVisible = 0;')\n_p(3,'defaultConfigurationName = \"%s\";', xcode.getconfigname(tr.configs[1]))\n_p(2,'};')\n_p('/* End XCConfigurationList section */')\n_p('')\nend\nfunction xcode.Footer()\n_p(1,'};')\n_p('\\trootObject = 08FB7793FE84155DC02AAC07 /* Project object */;')\n_p('}')\nend\n",

	/* actions/xcode/xcode_project.lua */
	"local xcode = premake.xcode\nlocal tree = premake.tree\nfunction xcode.buildprjtree(prj)\nlocal tr = premake.project.buildsourcetree(prj)\ntr.configs = {}\nfor _, cfgname in ipairs(prj.solution.configurations) do\nfor _, platform in ipairs(prj.solution.xcode.platforms) do\nlocal cfg = premake.getconfig(prj, cfgname, platform)\ncfg.xcode = {}\ncfg.xcode.targetid = xcode.newid(prj.xcode.projectnode, cfgname)\ncfg.xcode.projectid = xcode.newid(tr, cfgname)\ntable.insert(tr.configs, cfg)\nend\nend\ntree.traverse(tr, {\nonbranch = function(node)\nif path.getextension(node.name) == \".lproj\" then\nlocal lang = path.getbasename(node.name)  -- \"English\", \"French\", etc.\nfor _, filenode in ipairs(node.children) do\nlocal grpnode = node.parent.children[filenode.name]\nif not grpnode then\ngrpnode = tree.insert(node.parent, tree.new(filenode.name))\ngrpnode.kind = \"vgroup\"\nend\nfilenode.name = path.getbasename(lang)\ntree.insert(grpnode, filenode)\nend\ntree.remove(node)\nend\nend\n})\ntr.frameworks = tree.new(\""
	"Frameworks\")\nfor cfg in premake.eachconfig(prj) do\nfor _, link in ipairs(premake.getlinks(cfg, \"system\", \"fullpath\")) do\nlocal name = path.getname(link)\nif xcode.isframework(name) and not tr.frameworks.children[name] then\nnode = tree.insert(tr.frameworks, tree.new(name))\nnode.path = link\nend\nend\nend\nif #tr.frameworks.children > 0 then \ntree.insert(tr, tr.frameworks)\nend\ntr.products = tree.insert(tr, tree.new(\"Products\"))\ntr.projects = tree.new(\"Projects\")\nfor _, dep in ipairs(premake.getdependencies(prj, \"sibling\", \"object\")) do\nlocal xcpath = xcode.getxcodeprojname(dep)\nlocal xcnode = tree.insert(tr.projects, tree.new(path.getname(xcpath)))\nxcnode.path = xcpath\nxcnode.project = dep\nxcnode.productgroupid = xcode.newid(xcnode, \"prodgrp\")\nxcnode.productproxyid = xcode.newid(xcnode, \"prodprox\")\nxcnode.targetproxyid  = xcode.newid(xcnode, \"targprox\")\nxcnode.targetdependid = xcode.newid(xcnode, \"targdep\")\nlocal cfg = premake.getconfig(dep, prj.configurations[1])\nnode = "
	"tree.insert(xcnode, tree.new(cfg.linktarget.name))\nnode.path = cfg.linktarget.fullpath\nnode.cfg = cfg\nend\nif #tr.projects.children > 0 then\ntree.insert(tr, tr.projects)\nend\ntree.traverse(tr, {\nonnode = function(node)\nnode.id = xcode.newid(node)\nif xcode.getbuildcategory(node) then\nnode.buildid = xcode.newid(node, \"build\")\nend\nif string.endswith(node.name, \"Info.plist\") then\ntr.infoplist = node\nend\nend\n}, true)\nnode = tree.insert(tr.products, prj.xcode.projectnode)\nnode.kind = \"product\"\nnode.path = node.cfg.buildtarget.fullpath\nnode.cfgsection = xcode.newid(node, \"cfg\")\nnode.resstageid = xcode.newid(node, \"rez\")\nnode.sourcesid  = xcode.newid(node, \"src\")\nnode.fxstageid  = xcode.newid(node, \"fxs\")\nreturn tr\nend\nfunction premake.xcode.project(prj)\nlocal tr = xcode.buildprjtree(prj)\nxcode.Header(tr)\nxcode.PBXBuildFile(tr)\nxcode.PBXContainerItemProxy(tr)\nxcode.PBXFileReference(tr)\nxcode.PBXFrameworksBuildPhase(tr)\nxcode.PBXGroup(tr)\nxcode.PBXNativeTarget(tr)\nxcode.P"
	"BXProject(tr)\nxcode.PBXReferenceProxy(tr)\nxcode.PBXResourcesBuildPhase(tr)\nxcode.PBXShellScriptBuildPhase(tr)\nxcode.PBXSourcesBuildPhase(tr)\nxcode.PBXVariantGroup(tr)\nxcode.PBXTargetDependency(tr)\nxcode.XCBuildConfiguration(tr)\nxcode.XCBuildConfigurationList(tr)\nxcode.Footer(tr)\nend\n",

	/* actions/xcode/xcode4_workspace.lua */
	"premake.xcode4 = {}\nlocal xcode4 = premake.xcode4\nfunction xcode4.workspace_head()\n_p('<?xml version=\"1.0\" encoding=\"UTF-8\"?>')\n_p('<Workspace')\n_p(1,'version = \"1.0\">')\nend\nfunction xcode4.workspace_tail()\n_p('</Workspace>')\nend\nfunction xcode4.workspace_file_ref(prj)\nlocal projpath = path.getrelative(prj.solution.location, prj.location)\nif projpath == '.' then projpath = '' \nelse projpath = projpath ..'/' \nend\n_p(1,'<FileRef')\n_p(2,'location = \"group:%s\">',projpath .. prj.name .. '.xcodeproj')\n_p(1,'</FileRef>')\nend\nfunction xcode4.workspace_generate(sln)\npremake.xcode.preparesolution(sln)\nxcode4.workspace_head()\nfor prj in premake.solution.eachproject(sln) do\nxcode4.workspace_file_ref(prj)\nend\nxcode4.workspace_tail()\nend\n",

	/* actions/clean/_clean.lua */
	"premake.clean = { }\nfunction premake.clean.directory(obj, pattern)\nlocal fname = premake.project.getfilename(obj, pattern)\nos.rmdir(fname)\nend\nfunction premake.clean.file(obj, pattern)\nlocal fname = premake.project.getfilename(obj, pattern)\nos.remove(fname)\nend\nnewaction {\ntrigger     = \"clean\",\ndescription = \"Remove all binaries and generated files\",\nonsolution = function(sln)\nfor action in premake.action.each() do\nif action.oncleansolution then\naction.oncleansolution(sln)\nend\nend\nend,\nonproject = function(prj)\nfor action in premake.action.each() do\nif action.oncleanproject then\naction.oncleanproject(prj)\nend\nend\nif (prj.objectsdir) then\npremake.clean.directory(prj, prj.objectsdir)\nend\nlocal platforms = prj.solution.platforms or { }\nif not table.contains(platforms, \"Native\") then\nplatforms = table.join(platforms, { \"Native\" })\nend\nfor _, platform in ipairs(platforms) do\nfor cfg in premake.eachconfig(prj, platform) do\npremake.clean.directory(prj, cfg.objectsdir)\nprema"
	"ke.clean.file(prj, premake.gettarget(cfg, \"build\", \"posix\", \"windows\", \"windows\").fullpath)\npremake.clean.file(prj, premake.gettarget(cfg, \"build\", \"posix\", \"posix\", \"linux\").fullpath)\npremake.clean.file(prj, premake.gettarget(cfg, \"build\", \"posix\", \"posix\", \"macosx\").fullpath)\npremake.clean.file(prj, premake.gettarget(cfg, \"build\", \"posix\", \"PS3\", \"windows\").fullpath)\nif cfg.kind == \"WindowedApp\" then\npremake.clean.directory(prj, premake.gettarget(cfg, \"build\", \"posix\", \"posix\", \"linux\").fullpath .. \".app\")\nend\npremake.clean.file(prj, premake.gettarget(cfg, \"link\", \"windows\", \"windows\", \"windows\").fullpath)\npremake.clean.file(prj, premake.gettarget(cfg, \"link\", \"posix\", \"posix\", \"linux\").fullpath)\nlocal target = path.join(premake.project.getfilename(prj, cfg.buildtarget.directory), cfg.buildtarget.basename)\nfor action in premake.action.each() do\nif action.oncleantarget then\naction.oncleantarget(target)\nend\nend\nend\nend\nend\n}\n",

	/* _premake_main.lua */
	"local scriptfile    = \"premake4.lua\"\nlocal shorthelp     = \"Type 'premake4 --help' for help\"\nlocal versionhelp   = \"premake4 (Premake Build Script Generator) %s\"\n_WORKING_DIR        = os.getcwd()\nlocal function injectplatform(platform)\nif not platform then return true end\nplatform = premake.checkvalue(platform, premake.fields.platforms.allowed)\nfor sln in premake.solution.each() do\nlocal platforms = sln.platforms or { }\nif #platforms == 0 then\ntable.insert(platforms, \"Native\")\nend\nif not table.contains(platforms, \"Native\") then\nreturn false, sln.name .. \" does not target native platform\\nNative platform settings are required for the --platform feature.\"\nend\nif not table.contains(platforms, platform) then\ntable.insert(platforms, platform)\nend\nsln.platforms = platforms\nend\nreturn true\nend\nfunction _premake_main(scriptpath)\nif (scriptpath) then\nlocal scripts  = dofile(scriptpath .. \"/_manifest.lua\")\nfor _,v in ipairs(scripts) do\ndofile(scriptpath .. \"/\" .. v)\nend\nend\n"
	"_PREMAKE_COMMAND = path.getabsolute(_PREMAKE_COMMAND)\npremake.action.set(_ACTION)\nmath.randomseed(os.time())\nlocal fname = _OPTIONS[\"file\"] or scriptfile\nif (os.isfile(fname)) then\ndofile(fname)\nend\nif (_OPTIONS[\"version\"]) then\nprintf(versionhelp, _PREMAKE_VERSION)\nreturn 1\nend\nif (_OPTIONS[\"help\"]) then\npremake.showhelp()\nreturn 1\nend\nif (not _ACTION) then\nprint(shorthelp)\nreturn 1\nend\nif (not os.isfile(fname)) then\nerror(\"No Premake script (\"..scriptfile..\") found!\", 2)\nend\naction = premake.action.current()\nif (not action) then\nerror(\"Error: no such action '\" .. _ACTION .. \"'\", 0)\nend\nok, err = premake.option.validate(_OPTIONS)\nif (not ok) then error(\"Error: \" .. err, 0) end\nok, err = premake.checktools()\nif (not ok) then error(\"Error: \" .. err, 0) end\nok, err = injectplatform(_OPTIONS[\"platform\"])\nif (not ok) then error(\"Error: \" .. err, 0) end\nprint(\"Building configurations...\")\npremake.bake.buildconfigs()\nok, err = premake.checkprojects()\nif (not"
	" ok) then error(\"Error: \" .. err, 0) end\nprintf(\"Running action '%s'...\", action.trigger)\npremake.action.call(action.trigger)\nprint(\"Done.\")\nreturn 0\nend\n",

	0
};
