/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Serializer<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

    protected abstract byte[] serializeBytes();

    protected final void appendInt(int i, int length) {
        byte[] bytes = ArrayConverter.intToBytes((int)i, (int)length);
        int reconvertedInt = ArrayConverter.bytesToInt((byte[])bytes);
        if (reconvertedInt != i) {
            LOGGER.warn("Int \"" + i + "\" is too long to write in field of size " + length + ". Only using last " + length + " bytes.");
        }
        this.appendBytes(ArrayConverter.intToBytes((int)i, (int)length));
    }

    protected final void appendBigInteger(BigInteger i, int length) {
        byte[] bytes = i.equals(new BigInteger("0")) ? ArrayConverter.intToBytes((int)0, (int)length) : ArrayConverter.bigIntegerToByteArray((BigInteger)i, (int)length, (boolean)true);
        this.appendBytes(bytes);
    }

    protected final void appendByte(byte b) {
        this.outputStream.write(b);
    }

    protected final void appendBytes(byte[] bytes) {
        try {
            this.outputStream.write(bytes);
        }
        catch (IOException ex) {
            LOGGER.warn("Encountered exception while writing to ByteArrayOutputStream.");
            LOGGER.debug((Object)ex);
        }
    }

    protected final byte[] getAlreadySerialized() {
        return this.outputStream.toByteArray();
    }

    public final byte[] serialize() {
        this.outputStream = new ByteArrayOutputStream();
        this.serializeBytes();
        return this.getAlreadySerialized();
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.outputStream;
    }
}

