/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.metadata.ICodeAnnotation;
import jadx.gui.JadxWrapper;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.CodeLinkGenerator;
import jadx.gui.ui.codearea.CommentAction;
import jadx.gui.ui.codearea.CommentSearchAction;
import jadx.gui.ui.codearea.FindUsageAction;
import jadx.gui.ui.codearea.FridaAction;
import jadx.gui.ui.codearea.GoToDeclarationAction;
import jadx.gui.ui.codearea.JNodePopupBuilder;
import jadx.gui.ui.codearea.JadxTokenMaker;
import jadx.gui.ui.codearea.MouseHoverHighlighter;
import jadx.gui.ui.codearea.RenameAction;
import jadx.gui.ui.codearea.XposedAction;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.CaretPositionFix;
import jadx.gui.utils.DefaultPopupMenuListener;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.UiUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.event.PopupMenuEvent;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodeArea
extends AbstractCodeArea {
    private static final Logger LOG = LoggerFactory.getLogger(CodeArea.class);
    private static final long serialVersionUID = 6312736869579635796L;
    @Nullable
    private ICodeInfo cachedCodeInfo;

    CodeArea(ContentPanel contentPanel, JNode node) {
        super(contentPanel, node);
        this.setSyntaxEditingStyle(node.getSyntaxName());
        boolean isJavaCode = node instanceof JClass;
        if (isJavaCode) {
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle((TokenMaker)new JadxTokenMaker(this));
            this.addMenuItems();
        }
        this.setHyperlinksEnabled(true);
        this.setLinkScanningMask(128);
        final CodeLinkGenerator codeLinkGenerator = new CodeLinkGenerator(this);
        this.setLinkGenerator(codeLinkGenerator);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isControlDown() || CodeArea.this.jumpOnDoubleClick(e)) {
                    CodeArea.this.navToDecl(e.getPoint(), codeLinkGenerator);
                }
            }
        });
        if (isJavaCode) {
            this.addMouseMotionListener(new MouseHoverHighlighter(this, codeLinkGenerator));
        }
    }

    private boolean jumpOnDoubleClick(MouseEvent e) {
        return e.getClickCount() == 2 && this.getMainWindow().getSettings().isJumpOnDoubleClick();
    }

    private void navToDecl(Point point, CodeLinkGenerator codeLinkGenerator) {
        int offs = this.viewToModel(point);
        JNode node = this.getJNodeAtOffset(codeLinkGenerator.getLinkSourceOffset(offs));
        if (node != null) {
            this.contentPanel.getTabbedPane().codeJump(node);
        }
    }

    @Override
    public ICodeInfo getCodeInfo() {
        if (this.cachedCodeInfo == null) {
            if (this.isDisposed()) {
                LOG.debug("CodeArea used after dispose!");
                return ICodeInfo.EMPTY;
            }
            this.cachedCodeInfo = Objects.requireNonNull(this.node.getCodeInfo());
        }
        return this.cachedCodeInfo;
    }

    @Override
    public void load() {
        if (this.getText().isEmpty()) {
            this.setText(this.getCodeInfo().getCodeStr());
            this.setCaretPosition(0);
        }
    }

    @Override
    public void refresh() {
        this.cachedCodeInfo = null;
        this.setText(this.getCodeInfo().getCodeStr());
    }

    private void addMenuItems() {
        JNodePopupBuilder popup = new JNodePopupBuilder(this, this.getPopupMenu());
        popup.addSeparator();
        popup.add(new FindUsageAction(this));
        popup.add(new GoToDeclarationAction(this));
        popup.add(new CommentAction(this));
        popup.add(new CommentSearchAction(this));
        popup.add(new RenameAction(this));
        popup.addSeparator();
        popup.add(new FridaAction(this));
        popup.add(new XposedAction(this));
        popup.getMenu().addPopupMenuListener(new DefaultPopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                int offset;
                CodeArea codeArea = CodeArea.this;
                if (codeArea.getSelectedText() == null && (offset = UiUtils.getOffsetAtMousePosition(codeArea)) >= 0) {
                    codeArea.setCaretPosition(offset);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int adjustOffsetForToken(@Nullable Token token) {
        char ch;
        int sourceOffset;
        if (token == null) {
            return -1;
        }
        int type = token.getType();
        if (this.node instanceof JClass) {
            if (type == 20) {
                sourceOffset = token.getOffset();
            } else {
                if (type != 19 || token.length() <= 1) return -1;
                sourceOffset = token.getOffset() + 1;
            }
        } else {
            if (type != 28) return -1;
            sourceOffset = token.getOffset() + 1;
        }
        if (token.length() != 1 || (ch = token.getTextArray()[token.getTextOffset()]) != '.' && ch != ',' && ch != ';') return sourceOffset;
        return -1;
    }

    @Nullable
    public JumpPosition getDefPosForNodeAtOffset(int offset) {
        if (offset == -1) {
            return null;
        }
        JavaNode foundNode = this.getJavaNodeAtOffset(offset);
        if (foundNode == null) {
            return null;
        }
        if (foundNode == this.node.getJavaNode()) {
            return new JumpPosition(this.node);
        }
        JNode jNode = this.convertJavaNode(foundNode);
        return new JumpPosition(jNode);
    }

    private JNode convertJavaNode(JavaNode javaNode) {
        JNodeCache nodeCache = this.getMainWindow().getCacheObject().getNodeCache();
        return nodeCache.makeFrom(javaNode);
    }

    @Nullable
    public JNode getNodeUnderCaret() {
        int caretPos = this.getCaretPosition();
        Token token = this.modelToToken(caretPos);
        if (token == null) {
            return null;
        }
        int start = this.adjustOffsetForToken(token);
        if (start == -1) {
            start = caretPos;
        }
        return this.getJNodeAtOffset(start);
    }

    @Nullable
    public JNode getNodeUnderMouse() {
        Point pos = UiUtils.getMousePosition((Component)((Object)this));
        int offset = this.adjustOffsetForToken(this.viewToToken(pos));
        return this.getJNodeAtOffset(offset);
    }

    @Nullable
    public JNode getJNodeAtOffset(int offset) {
        JavaNode javaNode = this.getJavaNodeAtOffset(offset);
        if (javaNode != null) {
            return this.convertJavaNode(javaNode);
        }
        return null;
    }

    public JavaNode getJavaNodeAtOffset(int offset) {
        if (offset == -1) {
            return null;
        }
        try {
            return this.getJadxWrapper().getDecompiler().getJavaNodeAtPosition(this.getCodeInfo(), offset);
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)offset, (Object)e);
            return null;
        }
    }

    public JavaNode getClosestJavaNode(int offset) {
        try {
            return this.getJadxWrapper().getDecompiler().getClosestJavaNode(this.getCodeInfo(), offset);
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)offset, (Object)e);
            return null;
        }
    }

    public JavaClass getJavaClassIfAtPos(int pos) {
        try {
            ICodeAnnotation ann;
            ICodeInfo codeInfo = this.getCodeInfo();
            if (codeInfo.hasMetadata() && (ann = codeInfo.getCodeMetadata().getAt(pos)) != null && ann.getAnnType() == ICodeAnnotation.AnnType.CLASS) {
                return (JavaClass)this.getJadxWrapper().getDecompiler().getJavaNodeByCodeAnnotation(codeInfo, ann);
            }
        }
        catch (Exception e) {
            LOG.error("Can't get java node by offset: {}", (Object)pos, (Object)e);
        }
        return null;
    }

    public void refreshClass() {
        if (this.node instanceof JClass) {
            JClass cls = this.node.getRootClass();
            try {
                CaretPositionFix caretFix = new CaretPositionFix(this);
                caretFix.save();
                this.cachedCodeInfo = cls.reload(this.getMainWindow().getCacheObject());
                ClassCodeContentPanel codeContentPanel = (ClassCodeContentPanel)this.contentPanel;
                codeContentPanel.getTabbedPane().refresh(cls);
                codeContentPanel.getJavaCodePanel().refresh(caretFix);
            }
            catch (Exception e) {
                LOG.error("Failed to reload class: {}", (Object)cls.getFullName(), (Object)e);
            }
        }
    }

    public MainWindow getMainWindow() {
        return this.contentPanel.getTabbedPane().getMainWindow();
    }

    public JadxWrapper getJadxWrapper() {
        return this.getMainWindow().getWrapper();
    }

    public JadxProject getProject() {
        return this.getMainWindow().getProject();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cachedCodeInfo = null;
    }
}

