/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.NodeListIterator;

public final class DocumentOrderIterator
implements SequenceIterator {
    private final SequenceIterator iterator;
    private final ArrayList<NodeInfo> sequence;
    private NodeInfo current = null;

    public DocumentOrderIterator(SequenceIterator base, Comparator<? super NodeInfo> comparer) {
        int len = SequenceTool.supportsGetLength(base) ? SequenceTool.getLength(base) : 50;
        this.sequence = new ArrayList(len);
        SequenceTool.supply(base, item -> {
            if (!(item instanceof NodeInfo)) {
                throw new XPathException("Item in input for sorting is not a node: " + Err.depict(item), "XPTY0004");
            }
            this.sequence.add((NodeInfo)item);
        });
        if (this.sequence.size() > 1) {
            this.sequence.sort(comparer);
        }
        this.iterator = new NodeListIterator((List<NodeInfo>)this.sequence);
    }

    @Override
    public NodeInfo next() {
        NodeInfo next;
        do {
            if ((next = (NodeInfo)this.iterator.next()) != null) continue;
            this.current = null;
            return null;
        } while (next.equals(this.current));
        this.current = next;
        return this.current;
    }
}

