/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jde.debugger.CommandEvent;
import jde.debugger.CommandListener;
import jde.debugger.JDE;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.command.DebugCommand;
import jde.debugger.command.DebugCommandFactory;

public abstract class CommandHandler
extends Thread
implements Protocol {
    private static final int TIMEOUT = 10000;
    private LinkedList m_commandQueue = new LinkedList();
    private boolean m_stopRequested = false;
    private final Collection m_commandListeners = new LinkedList();

    public CommandHandler() {
        this.addCommandListener(new CmdListener());
    }

    public void fireCommandEvent(Integer procID, Integer cmdID, String cmdName, List arguments) throws JDEException {
        LinkedList linkedList = this.m_commandQueue;
        synchronized (linkedList) {
            CommandEvent event = new CommandEvent(procID, cmdID, cmdName, arguments);
            if (this.m_commandQueue.contains(event)) {
                throw new JDEException("Command " + cmdID + " already exists in queue for process " + this.getProcID() + ": " + this.m_commandQueue);
            }
            this.m_commandQueue.addLast(event);
            this.m_commandQueue.notifyAll();
        }
    }

    public void addCommandListener(CommandListener listener) {
        if (this.m_commandListeners.contains(listener)) {
            return;
        }
        this.m_commandListeners.add(listener);
    }

    public void removeCommandListener(CommandListener listener) {
        this.m_commandListeners.remove(listener);
    }

    protected final void queue(DebugCommand cmd) throws JDEException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final CommandEvent remove() {
        LinkedList linkedList = this.m_commandQueue;
        synchronized (linkedList) {
            while (this.m_commandQueue.size() == 0 && !this.m_stopRequested) {
                JDE.debug(4, "proc: " + this.getProcID() + " waiting for new commands");
                try {
                    this.m_commandQueue.wait(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.m_stopRequested) {
                return null;
            }
            CommandEvent cmd = (CommandEvent)this.m_commandQueue.removeFirst();
            JDE.debug(4, "proc: " + this.getProcID() + " got command: " + cmd);
            return cmd;
        }
    }

    public abstract void handle(DebugCommand var1) throws JDEException;

    public void requestStop() {
        this.m_stopRequested = true;
        LinkedList linkedList = this.m_commandQueue;
        synchronized (linkedList) {
            this.m_commandQueue.notifyAll();
        }
    }

    public abstract Integer getProcID();

    public void run() {
        JDE.debug(4, "command handler: " + this.getProcID() + " starting up");
        while (!this.m_stopRequested) {
            CommandEvent event = this.remove();
            try {
                if (null == event) continue;
                Iterator iter = this.m_commandListeners.iterator();
                while (iter.hasNext()) {
                    CommandListener listener = (CommandListener)iter.next();
                    listener.commandReceived(event);
                }
            }
            catch (JDEException e) {
                JDE.commandResult(event.getCmdId(), "Exception during command execution: " + e, false, true);
            }
            catch (RuntimeException exc) {
                JDE.signalException(exc);
            }
        }
        JDE.debug(4, "command handler: " + this.getProcID() + " terminated");
    }

    private class CmdListener
    implements CommandListener {
        private CmdListener() {
        }

        public void commandReceived(CommandEvent event) throws JDEException {
            List arguments;
            String cmdName;
            Integer cmdId = event.getCmdId();
            DebugCommand cmd = DebugCommandFactory.theFactory.createCommand(cmdId, cmdName = event.getCmdName(), arguments = event.getArgs());
            if (cmd == null) {
                throw new JDEException("command not implemented: " + cmdName);
            }
            JDE.debug(16, "JDEbug command is " + cmd.getClass().getName());
            CommandHandler.this.handle(cmd);
            cmd.doCommand();
            JDE.debug(4, "CommandHandler " + CommandHandler.this.getProcID() + " did cmd");
        }
    }
}

