/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.IRichSequence;
import com.vladsch.flexmark.util.sequence.RepeatedSequence;
import com.vladsch.flexmark.util.sequence.RichSequenceImpl;
import org.jetbrains.annotations.NotNull;

public interface RichSequence
extends IRichSequence<RichSequence> {
    public static final RichSequence NULL = RichSequenceImpl.create("", 0, 0);
    public static final RichSequence[] EMPTY_ARRAY = new RichSequence[0];

    public static RichSequence of(CharSequence charSequence) {
        return RichSequenceImpl.create(charSequence, 0, charSequence.length());
    }

    public static RichSequence of(CharSequence charSequence, int startIndex) {
        return RichSequenceImpl.create(charSequence, startIndex, charSequence.length());
    }

    public static RichSequence of(CharSequence charSequence, int startIndex, int endIndex) {
        return RichSequenceImpl.create(charSequence, startIndex, endIndex);
    }

    @NotNull
    public static RichSequence ofSpaces(int count) {
        return RichSequence.of(RepeatedSequence.ofSpaces(count));
    }

    @NotNull
    public static RichSequence repeatOf(char c, int count) {
        return RichSequence.of(RepeatedSequence.repeatOf(String.valueOf(c), 0, count));
    }

    @NotNull
    public static RichSequence repeatOf(@NotNull CharSequence chars, int count) {
        return RichSequence.of(RepeatedSequence.repeatOf(chars, 0, chars.length() * count));
    }

    @NotNull
    public static RichSequence repeatOf(@NotNull CharSequence chars, int startIndex, int endIndex) {
        return RichSequence.of(RepeatedSequence.repeatOf(chars, startIndex, endIndex));
    }
}

