/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import java.time.Duration;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KTypes;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metaconfig.ConfigException;
import org.jitsi.metaconfig.ConfigSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J2\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f\"\u000e\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0014H\u0002J(\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/config/TypesafeConfigSource;", "Lorg/jitsi/metaconfig/ConfigSource;", "name", "", "config", "Lcom/typesafe/config/Config;", "(Ljava/lang/String;Lcom/typesafe/config/Config;)V", "description", "getDescription", "()Ljava/lang/String;", "getName", "getterFor", "Lkotlin/Function1;", "", "type", "Lkotlin/reflect/KType;", "getterForEnum", "T", "", "clazz", "Lkotlin/reflect/KClass;", "wrap", "block", "jicoco-config"})
public final class TypesafeConfigSource
implements ConfigSource {
    @NotNull
    private final String name;
    @NotNull
    private final Config config;
    @NotNull
    private final String description;

    public TypesafeConfigSource(@NotNull String name, @NotNull Config config) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(config, "config");
        this.name = name;
        this.config = config;
        String string = this.config.origin().description();
        Intrinsics.checkNotNullExpressionValue(string, "description(...)");
        this.description = string;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Function1<String, Object> getterFor(@NotNull KType type2) {
        Function1<String, Object> function1;
        Intrinsics.checkNotNullParameter(type2, "type");
        if (KTypes.isSubtypeOf(type2, Reflection.typeOf(Enum.class, KTypeProjection.Companion.getSTAR()))) {
            KClassifier kClassifier = type2.getClassifier();
            Intrinsics.checkNotNull(kClassifier, "null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Nothing>");
            return this.getterForEnum((KClass)kClassifier);
        }
        KType kType = type2;
        if (Intrinsics.areEqual(kType, Reflection.typeOf(Boolean.TYPE))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    String string = TypesafeConfigSource.access$getConfig$p(this.this$0).getString(key);
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    String string2 = string.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    String string3 = string2;
                    return Intrinsics.areEqual(string3, "true") ? true : (Intrinsics.areEqual(string3, "false") ? false : TypesafeConfigSource.access$getConfig$p(this.this$0).getBoolean(key));
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Integer.TYPE))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return TypesafeConfigSource.access$getConfig$p(this.this$0).getInt(key);
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Long.TYPE))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    return TypesafeConfigSource.access$getConfig$p(this.this$0).getLong(key);
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Double.TYPE))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    double d;
                    Intrinsics.checkNotNullParameter(key, "key");
                    try {
                        d = TypesafeConfigSource.access$getConfig$p(this.this$0).getDouble(key);
                    }
                    catch (ConfigException.WrongType wrongTypeException) {
                        double d2;
                        String string = TypesafeConfigSource.access$getConfig$p(this.this$0).getString(key);
                        Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                        String stringValue = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        if (StringsKt.endsWith$default(stringValue, "%", false, 2, null)) {
                            try {
                                d2 = 0.01 * Double.parseDouble(StringsKt.dropLast(stringValue, 1));
                            }
                            catch (Throwable e) {
                                throw wrongTypeException;
                            }
                        } else {
                            throw wrongTypeException;
                        }
                        d = d2;
                    }
                    return d;
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(String.class))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    String string = TypesafeConfigSource.access$getConfig$p(this.this$0).getString(key);
                    Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
                    return string;
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(String.class))))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    List<String> list = TypesafeConfigSource.access$getConfig$p(this.this$0).getStringList(key);
                    Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
                    return list;
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Integer.TYPE))))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    List<Integer> list = TypesafeConfigSource.access$getConfig$p(this.this$0).getIntList(key);
                    Intrinsics.checkNotNullExpressionValue(list, "getIntList(...)");
                    return list;
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Duration.class))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Duration duration = TypesafeConfigSource.access$getConfig$p(this.this$0).getDuration(key);
                    Intrinsics.checkNotNullExpressionValue(duration, "getDuration(...)");
                    return duration;
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(ConfigObject.class))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    ConfigObject configObject = TypesafeConfigSource.access$getConfig$p(this.this$0).getObject(key);
                    Intrinsics.checkNotNullExpressionValue(configObject, "getObject(...)");
                    return configObject;
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Config.class))))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    List<? extends Config> list = TypesafeConfigSource.access$getConfig$p(this.this$0).getConfigList(key);
                    Intrinsics.checkNotNullExpressionValue(list, "getConfigList(...)");
                    return list;
                }
            });
        } else if (Intrinsics.areEqual(kType, Reflection.typeOf(Pattern.class))) {
            function1 = this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this){
                final /* synthetic */ TypesafeConfigSource this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Object invoke(@NotNull String key) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Pattern pattern = Pattern.compile(TypesafeConfigSource.access$getConfig$p(this.this$0).getString(key));
                    Intrinsics.checkNotNullExpressionValue(pattern, "compile(...)");
                    return pattern;
                }
            });
        } else {
            throw new ConfigException.UnsupportedType("Type " + type2 + " unsupported");
        }
        return function1;
    }

    private final <T extends Enum<T>> Function1<String, Object> getterForEnum(KClass<T> clazz) {
        return this.wrap((Function1<? super String, ? extends Object>)new Function1<String, Object>(this, clazz){
            final /* synthetic */ TypesafeConfigSource this$0;
            final /* synthetic */ KClass<T> $clazz;
            {
                this.this$0 = $receiver;
                this.$clazz = $clazz;
                super(1);
            }

            @NotNull
            public final Object invoke(@NotNull String key) {
                Intrinsics.checkNotNullParameter(key, "key");
                KClass<T> kClass = TypesafeConfigSource.access$getConfig$p(this.this$0).getEnum(JvmClassMappingKt.getJavaClass(this.$clazz), key);
                Intrinsics.checkNotNullExpressionValue(kClass, "getEnum(...)");
                return kClass;
            }
        });
    }

    private final Function1<String, Object> wrap(Function1<? super String, ? extends Object> block) {
        return new Function1<String, Object>(block, this){
            final /* synthetic */ Function1<String, Object> $block;
            final /* synthetic */ TypesafeConfigSource this$0;
            {
                this.$block = $block;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Object invoke(@NotNull String key) {
                Object object;
                Intrinsics.checkNotNullParameter(key, "key");
                try {
                    object = this.$block.invoke(key);
                }
                catch (ConfigException.Missing e) {
                    throw new ConfigException.UnableToRetrieve.NotFound("Key '" + key + "' not found in source '" + this.this$0.getName() + "'");
                }
                catch (ConfigException.WrongType e) {
                    throw new ConfigException.UnableToRetrieve.WrongType("Key '" + key + "' in source '" + this.this$0.getName() + "': " + e.getMessage());
                }
                catch (ConfigException e) {
                    Object object2 = e.getMessage();
                    if (object2 == null) {
                        object2 = "typesafe exception: " + Reflection.getOrCreateKotlinClass(e.getClass());
                    }
                    throw new ConfigException.UnableToRetrieve.NotFound((String)object2);
                }
                catch (Throwable t) {
                    throw new ConfigException.UnableToRetrieve.Error(t);
                }
                return object;
            }
        };
    }

    public static final /* synthetic */ Config access$getConfig$p(TypesafeConfigSource $this) {
        return $this.config;
    }
}

