/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.math.ed25519;

import net.i2p.crypto.eddsa.math.Encoding;
import net.i2p.crypto.eddsa.math.FieldElement;
import net.i2p.crypto.eddsa.math.ed25519.Ed25519FieldElement;

public class Ed25519LittleEndianEncoding
extends Encoding {
    @Override
    public byte[] encode(FieldElement fieldElement) {
        int[] nArray = ((Ed25519FieldElement)fieldElement).t;
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        int n7 = nArray[6];
        int n8 = nArray[7];
        int n9 = nArray[8];
        int n10 = nArray[9];
        int n11 = 19 * n10 + 0x1000000 >> 25;
        n11 = n + n11 >> 26;
        n11 = n2 + n11 >> 25;
        n11 = n3 + n11 >> 26;
        n11 = n4 + n11 >> 25;
        n11 = n5 + n11 >> 26;
        n11 = n6 + n11 >> 25;
        n11 = n7 + n11 >> 26;
        n11 = n8 + n11 >> 25;
        n11 = n9 + n11 >> 26;
        n11 = n10 + n11 >> 25;
        int n12 = (n += 19 * n11) >> 26;
        n -= n12 << 26;
        int n13 = (n2 += n12) >> 25;
        n2 -= n13 << 25;
        int n14 = (n3 += n13) >> 26;
        n3 -= n14 << 26;
        int n15 = (n4 += n14) >> 25;
        n4 -= n15 << 25;
        int n16 = (n5 += n15) >> 26;
        n5 -= n16 << 26;
        int n17 = (n6 += n16) >> 25;
        n6 -= n17 << 25;
        int n18 = (n7 += n17) >> 26;
        int n19 = (n8 += n18) >> 25;
        int n20 = (n9 += n19) >> 26;
        int n21 = (n10 += n20) >> 25;
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24 | n2 << 2), (byte)(n2 >> 6), (byte)(n2 >> 14), (byte)(n2 >> 22 | n3 << 3), (byte)(n3 >> 5), (byte)(n3 >> 13), (byte)(n3 >> 21 | n4 << 5), (byte)(n4 >> 3), (byte)(n4 >> 11), (byte)(n4 >> 19 | n5 << 6), (byte)(n5 >> 2), (byte)(n5 >> 10), (byte)(n5 >> 18), (byte)n6, (byte)(n6 >> 8), (byte)(n6 >> 16), (byte)(n6 >> 24 | (n7 -= n18 << 26) << 1), (byte)(n7 >> 7), (byte)(n7 >> 15), (byte)(n7 >> 23 | (n8 -= n19 << 25) << 3), (byte)(n8 >> 5), (byte)(n8 >> 13), (byte)(n8 >> 21 | (n9 -= n20 << 26) << 4), (byte)(n9 >> 4), (byte)(n9 >> 12), (byte)(n9 >> 20 | (n10 -= n21 << 25) << 6), (byte)(n10 >> 2), (byte)(n10 >> 10), (byte)(n10 >> 18)};
        return byArray;
    }

    static int load_3(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        n2 |= (byArray[n++] & 0xFF) << 8;
        return n2 |= (byArray[n] & 0xFF) << 16;
    }

    static long load_4(byte[] byArray, int n) {
        int n2 = byArray[n++] & 0xFF;
        n2 |= (byArray[n++] & 0xFF) << 8;
        n2 |= (byArray[n++] & 0xFF) << 16;
        return (long)(n2 |= byArray[n] << 24) & 0xFFFFFFFFL;
    }

    @Override
    public FieldElement decode(byte[] byArray) {
        long l = Ed25519LittleEndianEncoding.load_4(byArray, 0);
        long l2 = Ed25519LittleEndianEncoding.load_3(byArray, 4) << 6;
        long l3 = Ed25519LittleEndianEncoding.load_3(byArray, 7) << 5;
        long l4 = Ed25519LittleEndianEncoding.load_3(byArray, 10) << 3;
        long l5 = Ed25519LittleEndianEncoding.load_3(byArray, 13) << 2;
        long l6 = Ed25519LittleEndianEncoding.load_4(byArray, 16);
        long l7 = Ed25519LittleEndianEncoding.load_3(byArray, 20) << 7;
        long l8 = Ed25519LittleEndianEncoding.load_3(byArray, 23) << 5;
        long l9 = Ed25519LittleEndianEncoding.load_3(byArray, 26) << 4;
        long l10 = (Ed25519LittleEndianEncoding.load_3(byArray, 29) & 0x7FFFFF) << 2;
        long l11 = l10 + 0x1000000L >> 25;
        l += l11 * 19L;
        l10 -= l11 << 25;
        long l12 = l2 + 0x1000000L >> 25;
        l3 += l12;
        l2 -= l12 << 25;
        long l13 = l4 + 0x1000000L >> 25;
        l5 += l13;
        l4 -= l13 << 25;
        long l14 = l6 + 0x1000000L >> 25;
        l7 += l14;
        l6 -= l14 << 25;
        long l15 = l8 + 0x1000000L >> 25;
        l9 += l15;
        l8 -= l15 << 25;
        long l16 = l + 0x2000000L >> 26;
        l2 += l16;
        l -= l16 << 26;
        long l17 = l3 + 0x2000000L >> 26;
        l4 += l17;
        l3 -= l17 << 26;
        long l18 = l5 + 0x2000000L >> 26;
        long l19 = l7 + 0x2000000L >> 26;
        long l20 = l9 + 0x2000000L >> 26;
        int[] nArray = new int[]{(int)l, (int)l2, (int)l3, (int)l4, (int)(l5 -= l18 << 26), (int)(l6 += l18), (int)(l7 -= l19 << 26), (int)(l8 += l19), (int)(l9 -= l20 << 26), (int)(l10 += l20)};
        return new Ed25519FieldElement(this.f, nArray);
    }

    @Override
    public boolean isNegative(FieldElement fieldElement) {
        byte[] byArray = this.encode(fieldElement);
        return (byArray[0] & 1) != 0;
    }
}

