<?php

declare(strict_types=1);

namespace PhpMyAdmin\SqlParser\Contexts;

use PhpMyAdmin\SqlParser\Context;
use PhpMyAdmin\SqlParser\Token;

/**
 * Context for MySQL 5.0.
 *
 * This class was auto-generated from tools/contexts/*.txt.
 * Use tools/run_generators.sh for update.
 *
 * @see https://dev.mysql.com/doc/refman/5.0/en/keywords.html
 */
class ContextMySql50000 extends Context
{
    /**
     * List of keywords.
     *
     * The value associated to each keyword represents its flags.
     *
     * @see Token
     *
     * @var array<string,int>
     * @phpstan-var non-empty-array<non-empty-string,Token::FLAG_KEYWORD_*|int>
     */
    public static $KEYWORDS = [
        'ACTION' => Token::FLAG_KEYWORD,
        'AFTER' => Token::FLAG_KEYWORD,
        'AGGREGATE' => Token::FLAG_KEYWORD,
        'ALGORITHM' => Token::FLAG_KEYWORD,
        'ANY' => Token::FLAG_KEYWORD,
        'AUTO_INCREMENT' => Token::FLAG_KEYWORD,
        'AVG_ROW_LENGTH' => Token::FLAG_KEYWORD,
        'BACKUP' => Token::FLAG_KEYWORD,
        'BDB' => Token::FLAG_KEYWORD,
        'BEGIN' => Token::FLAG_KEYWORD,
        'BERKELEYDB' => Token::FLAG_KEYWORD,
        'BINLOG' => Token::FLAG_KEYWORD,
        'BLOCK' => Token::FLAG_KEYWORD,
        'BTREE' => Token::FLAG_KEYWORD,
        'BYTE' => Token::FLAG_KEYWORD,
        'CACHE' => Token::FLAG_KEYWORD,
        'CASCADED' => Token::FLAG_KEYWORD,
        'CHAIN' => Token::FLAG_KEYWORD,
        'CHANGED' => Token::FLAG_KEYWORD,
        'CHECKSUM' => Token::FLAG_KEYWORD,
        'CIPHER' => Token::FLAG_KEYWORD,
        'CLIENT' => Token::FLAG_KEYWORD,
        'CLOSE' => Token::FLAG_KEYWORD,
        'CODE' => Token::FLAG_KEYWORD,
        'COLUMNS' => Token::FLAG_KEYWORD,
        'COMMENT' => Token::FLAG_KEYWORD,
        'COMMIT' => Token::FLAG_KEYWORD,
        'COMMITTED' => Token::FLAG_KEYWORD,
        'COMPACT' => Token::FLAG_KEYWORD,
        'COMPRESSED' => Token::FLAG_KEYWORD,
        'CONCURRENT' => Token::FLAG_KEYWORD,
        'CONNECTION' => Token::FLAG_KEYWORD,
        'CONSISTENT' => Token::FLAG_KEYWORD,
        'CONTEXT' => Token::FLAG_KEYWORD,
        'CPU' => Token::FLAG_KEYWORD,
        'CUBE' => Token::FLAG_KEYWORD,
        'DATA' => Token::FLAG_KEYWORD,
        'DEALLOCATE' => Token::FLAG_KEYWORD,
        'DEFINER' => Token::FLAG_KEYWORD,
        'DELAY_KEY_WRITE' => Token::FLAG_KEYWORD,
        'DES_KEY_FILE' => Token::FLAG_KEYWORD,
        'DIRECTORY' => Token::FLAG_KEYWORD,
        'DISABLE' => Token::FLAG_KEYWORD,
        'DISCARD' => Token::FLAG_KEYWORD,
        'DO' => Token::FLAG_KEYWORD,
        'DUMPFILE' => Token::FLAG_KEYWORD,
        'DUPLICATE' => Token::FLAG_KEYWORD,
        'DYNAMIC' => Token::FLAG_KEYWORD,
        'ENABLE' => Token::FLAG_KEYWORD,
        'END' => Token::FLAG_KEYWORD,
        'ENGINE' => Token::FLAG_KEYWORD,
        'ENGINES' => Token::FLAG_KEYWORD,
        'ERRORS' => Token::FLAG_KEYWORD,
        'ESCAPE' => Token::FLAG_KEYWORD,
        'EVENTS' => Token::FLAG_KEYWORD,
        'EXECUTE' => Token::FLAG_KEYWORD,
        'EXPANSION' => Token::FLAG_KEYWORD,
        'EXTENDED' => Token::FLAG_KEYWORD,
        'FAST' => Token::FLAG_KEYWORD,
        'FAULTS' => Token::FLAG_KEYWORD,
        'FIELDS' => Token::FLAG_KEYWORD,
        'FILE' => Token::FLAG_KEYWORD,
        'FIRST' => Token::FLAG_KEYWORD,
        'FLUSH' => Token::FLAG_KEYWORD,
        'FOUND' => Token::FLAG_KEYWORD,
        'FRAC_SECOND' => Token::FLAG_KEYWORD,
        'FULL' => Token::FLAG_KEYWORD,
        'FUNCTION' => Token::FLAG_KEYWORD,
        'GLOBAL' => Token::FLAG_KEYWORD,
        'GRANTS' => Token::FLAG_KEYWORD,
        'HANDLER' => Token::FLAG_KEYWORD,
        'HASH' => Token::FLAG_KEYWORD,
        'HELP' => Token::FLAG_KEYWORD,
        'HOSTS' => Token::FLAG_KEYWORD,
        'IDENTIFIED' => Token::FLAG_KEYWORD,
        'IMPORT' => Token::FLAG_KEYWORD,
        'INDEXES' => Token::FLAG_KEYWORD,
        'INNOBASE' => Token::FLAG_KEYWORD,
        'INNODB' => Token::FLAG_KEYWORD,
        'INSERT_METHOD' => Token::FLAG_KEYWORD,
        'INVOKER' => Token::FLAG_KEYWORD,
        'IO' => Token::FLAG_KEYWORD,
        'IO_THREAD' => Token::FLAG_KEYWORD,
        'IPC' => Token::FLAG_KEYWORD,
        'ISOLATION' => Token::FLAG_KEYWORD,
        'ISSUER' => Token::FLAG_KEYWORD,
        'LANGUAGE' => Token::FLAG_KEYWORD,
        'LAST' => Token::FLAG_KEYWORD,
        'LEAVES' => Token::FLAG_KEYWORD,
        'LEVEL' => Token::FLAG_KEYWORD,
        'LOCAL' => Token::FLAG_KEYWORD,
        'LOCKS' => Token::FLAG_KEYWORD,
        'LOGS' => Token::FLAG_KEYWORD,
        'MASTER' => Token::FLAG_KEYWORD,
        'MASTER_CONNECT_RETRY' => Token::FLAG_KEYWORD,
        'MASTER_HOST' => Token::FLAG_KEYWORD,
        'MASTER_LOG_FILE' => Token::FLAG_KEYWORD,
        'MASTER_LOG_POS' => Token::FLAG_KEYWORD,
        'MASTER_PASSWORD' => Token::FLAG_KEYWORD,
        'MASTER_PORT' => Token::FLAG_KEYWORD,
        'MASTER_SERVER_ID' => Token::FLAG_KEYWORD,
        'MASTER_SSL' => Token::FLAG_KEYWORD,
        'MASTER_SSL_CA' => Token::FLAG_KEYWORD,
        'MASTER_SSL_CAPATH' => Token::FLAG_KEYWORD,
        'MASTER_SSL_CERT' => Token::FLAG_KEYWORD,
        'MASTER_SSL_CIPHER' => Token::FLAG_KEYWORD,
        'MASTER_SSL_KEY' => Token::FLAG_KEYWORD,
        'MASTER_USER' => Token::FLAG_KEYWORD,
        'MAX_CONNECTIONS_PER_HOUR' => Token::FLAG_KEYWORD,
        'MAX_QUERIES_PER_HOUR' => Token::FLAG_KEYWORD,
        'MAX_ROWS' => Token::FLAG_KEYWORD,
        'MAX_UPDATES_PER_HOUR' => Token::FLAG_KEYWORD,
        'MAX_USER_CONNECTIONS' => Token::FLAG_KEYWORD,
        'MEDIUM' => Token::FLAG_KEYWORD,
        'MEMORY' => Token::FLAG_KEYWORD,
        'MERGE' => Token::FLAG_KEYWORD,
        'MIGRATE' => Token::FLAG_KEYWORD,
        'MIN_ROWS' => Token::FLAG_KEYWORD,
        'MODE' => Token::FLAG_KEYWORD,
        'MODIFY' => Token::FLAG_KEYWORD,
        'MUTEX' => Token::FLAG_KEYWORD,
        'NAME' => Token::FLAG_KEYWORD,
        'NAMES' => Token::FLAG_KEYWORD,
        'NATIONAL' => Token::FLAG_KEYWORD,
        'NCHAR' => Token::FLAG_KEYWORD,
        'NDB' => Token::FLAG_KEYWORD,
        'NDBCLUSTER' => Token::FLAG_KEYWORD,
        'NEW' => Token::FLAG_KEYWORD,
        'NEXT' => Token::FLAG_KEYWORD,
        'NO' => Token::FLAG_KEYWORD,
        'NONE' => Token::FLAG_KEYWORD,
        'NVARCHAR' => Token::FLAG_KEYWORD,
        'OFFSET' => Token::FLAG_KEYWORD,
        'ONE' => Token::FLAG_KEYWORD,
        'ONE_SHOT' => Token::FLAG_KEYWORD,
        'OPEN' => Token::FLAG_KEYWORD,
        'PACK_KEYS' => Token::FLAG_KEYWORD,
        'PAGE' => Token::FLAG_KEYWORD,
        'PARTIAL' => Token::FLAG_KEYWORD,
        'PARTITIONS' => Token::FLAG_KEYWORD,
        'PERSISTENT' => Token::FLAG_KEYWORD,
        'PHASE' => Token::FLAG_KEYWORD,
        'PREPARE' => Token::FLAG_KEYWORD,
        'PREV' => Token::FLAG_KEYWORD,
        'PRIVILEGES' => Token::FLAG_KEYWORD,
        'PROCESSLIST' => Token::FLAG_KEYWORD,
        'PROFILE' => Token::FLAG_KEYWORD,
        'PROFILES' => Token::FLAG_KEYWORD,
        'QUERY' => Token::FLAG_KEYWORD,
        'QUICK' => Token::FLAG_KEYWORD,
        'RAID0' => Token::FLAG_KEYWORD,
        'RAID_CHUNKS' => Token::FLAG_KEYWORD,
        'RAID_CHUNKSIZE' => Token::FLAG_KEYWORD,
        'RAID_TYPE' => Token::FLAG_KEYWORD,
        'RECOVER' => Token::FLAG_KEYWORD,
        'REDUNDANT' => Token::FLAG_KEYWORD,
        'RELAY_LOG_FILE' => Token::FLAG_KEYWORD,
        'RELAY_LOG_POS' => Token::FLAG_KEYWORD,
        'RELAY_THREAD' => Token::FLAG_KEYWORD,
        'RELOAD' => Token::FLAG_KEYWORD,
        'REPAIR' => Token::FLAG_KEYWORD,
        'REPEATABLE' => Token::FLAG_KEYWORD,
        'REPLICATION' => Token::FLAG_KEYWORD,
        'RESET' => Token::FLAG_KEYWORD,
        'RESTORE' => Token::FLAG_KEYWORD,
        'RESUME' => Token::FLAG_KEYWORD,
        'RETURNS' => Token::FLAG_KEYWORD,
        'ROLLBACK' => Token::FLAG_KEYWORD,
        'ROLLUP' => Token::FLAG_KEYWORD,
        'ROUTINE' => Token::FLAG_KEYWORD,
        'ROW' => Token::FLAG_KEYWORD,
        'ROWS' => Token::FLAG_KEYWORD,
        'ROW_FORMAT' => Token::FLAG_KEYWORD,
        'RTREE' => Token::FLAG_KEYWORD,
        'SAVEPOINT' => Token::FLAG_KEYWORD,
        'SECURITY' => Token::FLAG_KEYWORD,
        'SERIALIZABLE' => Token::FLAG_KEYWORD,
        'SESSION' => Token::FLAG_KEYWORD,
        'SHARE' => Token::FLAG_KEYWORD,
        'SHUTDOWN' => Token::FLAG_KEYWORD,
        'SIGNED' => Token::FLAG_KEYWORD,
        'SIMPLE' => Token::FLAG_KEYWORD,
        'SLAVE' => Token::FLAG_KEYWORD,
        'SNAPSHOT' => Token::FLAG_KEYWORD,
        'SOME' => Token::FLAG_KEYWORD,
        'SOUNDS' => Token::FLAG_KEYWORD,
        'SOURCE' => Token::FLAG_KEYWORD,
        'SQL_BUFFER_RESULT' => Token::FLAG_KEYWORD,
        'SQL_CACHE' => Token::FLAG_KEYWORD,
        'SQL_NO_CACHE' => Token::FLAG_KEYWORD,
        'SQL_THREAD' => Token::FLAG_KEYWORD,
        'SQL_TSI_DAY' => Token::FLAG_KEYWORD,
        'SQL_TSI_FRAC_SECOND' => Token::FLAG_KEYWORD,
        'SQL_TSI_HOUR' => Token::FLAG_KEYWORD,
        'SQL_TSI_MINUTE' => Token::FLAG_KEYWORD,
        'SQL_TSI_MONTH' => Token::FLAG_KEYWORD,
        'SQL_TSI_QUARTER' => Token::FLAG_KEYWORD,
        'SQL_TSI_SECOND' => Token::FLAG_KEYWORD,
        'SQL_TSI_WEEK' => Token::FLAG_KEYWORD,
        'SQL_TSI_YEAR' => Token::FLAG_KEYWORD,
        'START' => Token::FLAG_KEYWORD,
        'STATUS' => Token::FLAG_KEYWORD,
        'STOP' => Token::FLAG_KEYWORD,
        'STORAGE' => Token::FLAG_KEYWORD,
        'STRING' => Token::FLAG_KEYWORD,
        'STRIPED' => Token::FLAG_KEYWORD,
        'SUBJECT' => Token::FLAG_KEYWORD,
        'SUBPARTITIONS' => Token::FLAG_KEYWORD,
        'SUPER' => Token::FLAG_KEYWORD,
        'SUSPEND' => Token::FLAG_KEYWORD,
        'SWAPS' => Token::FLAG_KEYWORD,
        'SWITCHES' => Token::FLAG_KEYWORD,
        'TABLES' => Token::FLAG_KEYWORD,
        'TABLESPACE' => Token::FLAG_KEYWORD,
        'TEMPORARY' => Token::FLAG_KEYWORD,
        'TEMPTABLE' => Token::FLAG_KEYWORD,
        'TRANSACTION' => Token::FLAG_KEYWORD,
        'TRIGGERS' => Token::FLAG_KEYWORD,
        'TYPE' => Token::FLAG_KEYWORD,
        'TYPES' => Token::FLAG_KEYWORD,
        'UNCOMMITTED' => Token::FLAG_KEYWORD,
        'UNDEFINED' => Token::FLAG_KEYWORD,
        'UNICODE' => Token::FLAG_KEYWORD,
        'UNKNOWN' => Token::FLAG_KEYWORD,
        'UNTIL' => Token::FLAG_KEYWORD,
        'UPGRADE' => Token::FLAG_KEYWORD,
        'USER_RESOURCES' => Token::FLAG_KEYWORD,
        'USE_FRM' => Token::FLAG_KEYWORD,
        'VALUE' => Token::FLAG_KEYWORD,
        'VARIABLES' => Token::FLAG_KEYWORD,
        'VIEW' => Token::FLAG_KEYWORD,
        'VIRTUAL' => Token::FLAG_KEYWORD,
        'WARNINGS' => Token::FLAG_KEYWORD,
        'WORK' => Token::FLAG_KEYWORD,
        'X509' => Token::FLAG_KEYWORD,
        'XA' => Token::FLAG_KEYWORD,
        'ADD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ALL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ALTER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ANALYZE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'AND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'AS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ASC' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ASENSITIVE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'BEFORE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'BETWEEN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'BOTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CALL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CASCADE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CASE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CHANGE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CHECK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'COLLATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'COLUMN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CONDITION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CONSTRAINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CONTINUE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CREATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CROSS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'CURSOR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DATABASES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DAY_HOUR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DAY_MICROSECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DAY_MINUTE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DAY_SECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DEC' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DECLARE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DELAYED' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DELETE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DESC' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DESCRIBE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DETERMINISTIC' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DISTINCT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DISTINCTROW' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DIV' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DROP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'DUAL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'EACH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ELSE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ELSEIF' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ENCLOSED' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ESCAPED' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'EXIT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'EXPLAIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'FALSE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'FETCH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'FOR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'FORCE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'FOREIGN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'FROM' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'GRANT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'GROUP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'HAVING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'HIGH_PRIORITY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'HOUR_MICROSECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'HOUR_MINUTE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'HOUR_SECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'IGNORE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'INFILE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'INNER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'INOUT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'INSENSITIVE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'INTO' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'IS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ITERATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'KEYS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'KILL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LEADING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LEAVE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LIKE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LIMIT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LINES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LOAD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LOCK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LOOP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'LOW_PRIORITY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'MINUTE_MICROSECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'MINUTE_SECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'MODIFIES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'NATURAL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'NOT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'NO_WRITE_TO_BINLOG' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'NULL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ON' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'OPTIMIZE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'OPTION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'OPTIONALLY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'OR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ORDER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'OUT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'OUTER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'OUTFILE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'PRECISION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'PRIMARY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'PROCEDURE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'PURGE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'READ' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'READS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'REFERENCES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'REGEXP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'RELEASE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'RENAME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'REQUIRE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'RESTRICT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'RETURN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'REVOKE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'RLIKE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SCHEMAS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SECOND_MICROSECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SELECT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SENSITIVE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SEPARATOR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SHOW' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SONAME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SPECIFIC' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SQL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SQLEXCEPTION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SQLSTATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SQLWARNING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SQL_BIG_RESULT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SQL_CALC_FOUND_ROWS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SQL_SMALL_RESULT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'SSL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'STARTING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'STRAIGHT_JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'TABLE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'TERMINATED' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'THEN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'TO' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'TRAILING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'TRIGGER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'TRUE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'UNDO' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'UNION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'UNLOCK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'UNSIGNED' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'UPDATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'USAGE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'USE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'USING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'VARCHARACTER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'VARYING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'WHEN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'WHERE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'WHILE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'WITH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'WRITE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'XOR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'YEAR_MONTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'ZEROFILL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED,
        'AND CHAIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'AND NO CHAIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'CHARACTER SET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'COALESCE PARTITION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'CONTAINS SQL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'CROSS JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'DATA DIRECTORY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'DEFAULT CHARACTER SET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'DEFAULT CHARSET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'DEFAULT COLLATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'ENCLOSED BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'ESCAPED BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'FOR EACH ROW' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'FOR UPDATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'FULL JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'FULL OUTER JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'GENERATED ALWAYS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'GROUP BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'IF EXISTS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'IF NOT EXISTS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'INDEX DIRECTORY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'INNER JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'LANGUAGE SQL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'LEFT JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'LEFT OUTER JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'LESS THAN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'LINEAR HASH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'LINEAR KEY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'LOAD DATA' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'LOCK IN SHARE MODE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'MODIFIES SQL DATA' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NATURAL JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NATURAL LEFT JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NATURAL LEFT OUTER JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NATURAL RIGHT JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NATURAL RIGHT OUTER JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NO ACTION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NO RELEASE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NO SQL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'NOT NULL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'ON DELETE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'ON UPDATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'OR REPLACE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'ORDER BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'PARTITION BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'READS SQL DATA' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'RIGHT JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'RIGHT OUTER JOIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'SELECT TRANSACTION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'SET NULL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'SET PASSWORD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'SQL SECURITY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'START TRANSACTION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'STARTING BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'SUBPARTITION BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'TERMINATED BY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'UNION ALL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'UNION DISTINCT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'WITH CONSISTENT SNAPSHOT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'WITH ROLLUP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED,
        'ARRAY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'BIT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'BOOL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'BOOLEAN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'DATETIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'ENUM' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'FIXED' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'GEOMETRY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'JSON' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'MULTILINEPOINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'MULTILINEPOLYGON' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'MULTISET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'SERIAL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'TEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'XML' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE,
        'BIGINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'BLOB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'CHARACTER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'DECIMAL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'DOUBLE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'FLOAT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'FLOAT4' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'FLOAT8' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'INT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'INT1' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'INT2' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'INT3' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'INT4' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'INT8' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'INTEGER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'LONG' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'LONGBLOB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'LONGTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'MEDIUMBLOB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'MEDIUMINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'MEDIUMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'MIDDLEINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'NUMERIC' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'REAL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'SET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'SMALLINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'TINYBLOB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'TINYINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'TINYTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'VARBINARY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'VARCHAR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE,
        'BINARY VARYING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_DATA_TYPE,
        'CHARACTER VARYING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_DATA_TYPE,
        'LONG VARBINARY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_DATA_TYPE,
        'LONG VARCHAR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_DATA_TYPE,
        'FULLTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_KEY,
        'INDEX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_KEY,
        'KEY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_KEY,
        'SPATIAL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_KEY,
        'UNIQUE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_KEY,
        'FOREIGN KEY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'FULLTEXT INDEX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'FULLTEXT KEY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'INDEX KEY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'PRIMARY KEY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'SPATIAL INDEX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'SPATIAL KEY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'UNIQUE INDEX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'UNIQUE KEY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_KEY,
        'ABS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ACOS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ADDDATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ADDTIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'AES_DECRYPT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'AES_ENCRYPT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'AGAINST' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'AREA' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ASBINARY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ASCII' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ASIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ASTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ASWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ASWKT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ATAN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ATAN2' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'AVG' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'BENCHMARK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'BIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'BIT_AND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'BIT_COUNT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'BIT_LENGTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'BIT_OR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'BIT_XOR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CAST' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CEIL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CEILING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CENTROID' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CHARACTER_LENGTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CHARSET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CHAR_LENGTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'COALESCE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'COERCIBILITY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'COLLATION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'COMPRESS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CONCAT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CONCAT_WS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CONNECTION_ID' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CONTAINS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CONV' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CONVERT_TZ' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'COS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'COT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'COUNT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CRC32' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CROSSES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CURDATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CURTIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DATEDIFF' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DATE_ADD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DATE_FORMAT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DATE_SUB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DAY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DAYNAME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DAYOFMONTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DAYOFWEEK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DAYOFYEAR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DECODE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DEGREES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DES_DECRYPT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DES_ENCRYPT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DIMENSION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'DISJOINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ELT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ENCODE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ENCRYPT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ENDPOINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ENVELOPE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'EQUALS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'EXP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'EXPORT_SET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'EXTERIORRING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'EXTRACT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'FIELD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'FIND_IN_SET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'FLOOR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'FORMAT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'FOUND_ROWS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'FROM_DAYS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'FROM_UNIXTIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMCOLLFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMCOLLFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMETRYCOLLECTIONFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMETRYCOLLECTIONFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMETRYFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMETRYFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMETRYN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMETRYTYPE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GET_FORMAT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GET_LOCK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GLENGTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GREATEST' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'GROUP_CONCAT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'HEX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'HOUR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'IFNULL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'INET_ATON' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'INET_NTOA' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'INSTR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'INTERIORRINGN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'INTERSECTS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ISCLOSED' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ISEMPTY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ISNULL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ISSIMPLE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'IS_FREE_LOCK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'IS_USED_LOCK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LAST_DAY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LAST_INSERT_ID' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LCASE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LEAST' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LENGTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LINEFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LINEFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LOAD_FILE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LOCATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LOG' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LOG10' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LOG2' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LOWER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LPAD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'LTRIM' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MAKEDATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MAKETIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MAKE_SET' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MASTER_POS_WAIT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MAX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MBRCONTAINS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MBRDISJOINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MBREQUAL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MBRINTERSECTS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MBROVERLAPS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MBRTOUCHES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MBRWITHIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MD5' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MICROSECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MID' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MINUTE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MLINEFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MLINEFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MONTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MONTHNAME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MPOINTFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MPOINTFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MPOLYFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'MPOLYFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'NAME_CONST' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'NOW' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'NULLIF' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'NUMGEOMETRIES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'NUMINTERIORRINGS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'NUMPOINTS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'OCT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'OCTET_LENGTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'OLD_PASSWORD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ORD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'OVERLAPS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'PASSWORD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'PERIOD_ADD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'PERIOD_DIFF' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'PI' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'POINTFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'POINTFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'POINTN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'POLYFROMTEXT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'POLYFROMWKB' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'POSITION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'POW' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'POWER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'QUARTER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'QUOTE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'RADIANS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'RAND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'RELEASE_LOCK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'REVERSE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ROUND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'ROW_COUNT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'RPAD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'RTRIM' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SECOND' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SEC_TO_TIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SESSION_USER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SHA' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SHA1' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SIGN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SLEEP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SOUNDEX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SPACE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SQRT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SRID' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'STARTPOINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'STD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'STDDEV' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'STDDEV_POP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'STDDEV_SAMP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'STRCMP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'STR_TO_DATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SUBDATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SUBSTR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SUBSTRING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SUBSTRING_INDEX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SUBTIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SUM' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SYSDATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'SYSTEM_USER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TAN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TIMEDIFF' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TIMESTAMPADD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TIMESTAMPDIFF' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TIME_FORMAT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TIME_TO_SEC' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TOUCHES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TO_DAYS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TRIM' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'TRUNCATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'UCASE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'UNCOMPRESS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'UNCOMPRESSED_LENGTH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'UNHEX' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'UNIX_TIMESTAMP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'UPPER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'USER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'UUID' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'VARIANCE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'VAR_POP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'VAR_SAMP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'VERSION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'WEEK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'WEEKDAY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'WEEKOFYEAR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'WITHIN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'X' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'Y' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'YEARWEEK' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_FUNCTION,
        'CONVERT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'CURRENT_DATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'CURRENT_TIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'CURRENT_TIMESTAMP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'CURRENT_USER' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'DATABASE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'DEFAULT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'EXISTS' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'IF' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'IN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'INSERT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'LEFT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'LOCALTIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'LOCALTIMESTAMP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'MATCH' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'MOD' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'REPEAT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'REPLACE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'RIGHT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'SCHEMA' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'UTC_DATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'UTC_TIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'UTC_TIMESTAMP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'VALUES' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_FUNCTION,
        'NOT IN' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_COMPOSED | Token::FLAG_KEYWORD_FUNCTION,
        'DATE' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'GEOMETRYCOLLECTION' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'LINESTRING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'MULTILINESTRING' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'MULTIPOINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'MULTIPOLYGON' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'POINT' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'POLYGON' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'TIME' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'TIMESTAMP' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'YEAR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'BINARY' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'CHAR' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
        'INTERVAL' => Token::FLAG_KEYWORD | Token::FLAG_KEYWORD_RESERVED | Token::FLAG_KEYWORD_DATA_TYPE | Token::FLAG_KEYWORD_FUNCTION,
    ];
}
