# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("ws2_32.dll")
prototypes = \
    {
        #
        'WSCEnumProtocols32': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpiProtocols", "lpProtocolBuffer", "lpdwBufferLength", "lpErrno"]),
        #
        'WSCDeinstallProvider32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpErrno"]),
        #
        'WSCInstallProvider64_32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpszProviderDllPath", "lpProtocolInfoList", "dwNumberOfEntries", "lpErrno"]),
        #
        'WSCGetProviderPath32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpszProviderDllPath", "lpProviderDllPathLen", "lpErrno"]),
        #
        'WSCUpdateProvider32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpszProviderDllPath", "lpProtocolInfoList", "dwNumberOfEntries", "lpErrno"]),
        #
        'WSCSetProviderInfo32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WSC_PROVIDER_INFO_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "InfoType", "Info", "InfoSize", "Flags", "lpErrno"]),
        #
        'WSCGetProviderInfo32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WSC_PROVIDER_INFO_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "InfoType", "Info", "InfoSize", "Flags", "lpErrno"]),
        #
        'WSCEnumNameSpaceProviders32': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"NSProviderId": SimTypeBottom(label="Guid"), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "fActive": SimTypeInt(signed=True, label="Int32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "lpszIdentifier": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSANAMESPACE_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwBufferLength", "lpnspBuffer"]),
        #
        'WSCEnumNameSpaceProvidersEx32': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"NSProviderId": SimTypeBottom(label="Guid"), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "fActive": SimTypeInt(signed=True, label="Int32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "lpszIdentifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ProviderSpecific": SimTypeBottom(label="BLOB")}, name="WSANAMESPACE_INFOEXW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwBufferLength", "lpnspBuffer"]),
        #
        'WSCInstallNameSpace32': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszIdentifier", "lpszPathName", "dwNameSpace", "dwVersion", "lpProviderId"]),
        #
        'WSCInstallNameSpaceEx32': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBlobData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszIdentifier", "lpszPathName", "dwNameSpace", "dwVersion", "lpProviderId", "lpProviderSpecific"]),
        #
        'WSCUnInstallNameSpace32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId"]),
        #
        'WSCEnableNSProvider32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "fEnable"]),
        #
        'WSCInstallProviderAndChains64_32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpszProviderDllPath", "lpszProviderDllPath32", "lpszLspName", "dwServiceFlags", "lpProtocolInfoList", "dwNumberOfEntries", "lpdwCatalogEntryId", "lpErrno"]),
        #
        'WSCWriteProviderOrder32': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpwdCatalogEntryId", "dwNumberOfEntries"]),
        #
        'WSCWriteNameSpaceOrder32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "dwNumberOfEntries"]),
        #
        '__WSAFDIsSet': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"fd_count": SimTypeInt(signed=False, label="UInt32"), "fd_array": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 64)}, name="fd_set", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["fd", "param1"]),
        #
        'accept': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["s", "addr", "addrlen"]),
        #
        'bind': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "name", "namelen"]),
        #
        'closesocket': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s"]),
        #
        'connect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "name", "namelen"]),
        #
        'ioctlsocket': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "cmd", "argp"]),
        #
        'getpeername': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "name", "namelen"]),
        #
        'getsockname': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "name", "namelen"]),
        #
        'getsockopt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "level", "optname", "optval", "optlen"]),
        #
        'htonl': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hostlong"]),
        #
        'htons': SimTypeFunction([SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=False, label="UInt16"), arg_names=["hostshort"]),
        #
        'inet_addr': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["cp"]),
        #
        'inet_ntoa': SimTypeFunction([SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["in"]),
        #
        'listen': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "backlog"]),
        #
        'ntohl': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["netlong"]),
        #
        'ntohs': SimTypeFunction([SimTypeShort(signed=False, label="UInt16")], SimTypeShort(signed=False, label="UInt16"), arg_names=["netshort"]),
        #
        'recv': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "buf", "len", "flags"]),
        #
        'recvfrom': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "buf", "len", "flags", "from", "fromlen"]),
        #
        'select': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"fd_count": SimTypeInt(signed=False, label="UInt32"), "fd_array": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 64)}, name="fd_set", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fd_count": SimTypeInt(signed=False, label="UInt32"), "fd_array": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 64)}, name="fd_set", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"fd_count": SimTypeInt(signed=False, label="UInt32"), "fd_array": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 64)}, name="fd_set", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tv_sec": SimTypeInt(signed=True, label="Int32"), "tv_usec": SimTypeInt(signed=True, label="Int32")}, name="timeval", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["nfds", "readfds", "writefds", "exceptfds", "timeout"]),
        #
        'send': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="SEND_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "buf", "len", "flags"]),
        #
        'sendto': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "buf", "len", "flags", "to", "tolen"]),
        #
        'setsockopt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "level", "optname", "optval", "optlen"]),
        #
        'shutdown': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "how"]),
        #
        'socket': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["af", "type", "protocol"]),
        #
        'gethostbyaddr': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({"h_name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "h_aliases": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "h_addrtype": SimTypeShort(signed=True, label="Int16"), "h_length": SimTypeShort(signed=True, label="Int16"), "h_addr_list": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0)}, name="hostent", pack=False, align=None), offset=0), arg_names=["addr", "len", "type"]),
        #
        'gethostbyname': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"h_name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "h_aliases": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "h_addrtype": SimTypeShort(signed=True, label="Int16"), "h_length": SimTypeShort(signed=True, label="Int16"), "h_addr_list": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0)}, name="hostent", pack=False, align=None), offset=0), arg_names=["name"]),
        #
        'gethostname': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["name", "namelen"]),
        #
        'GetHostNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["name", "namelen"]),
        #
        'getservbyport': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"s_name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "s_aliases": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "s_port": SimTypeShort(signed=True, label="Int16"), "s_proto": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="servent", pack=False, align=None), offset=0), arg_names=["port", "proto"]),
        #
        'getservbyname': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"s_name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "s_aliases": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "s_port": SimTypeShort(signed=True, label="Int16"), "s_proto": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="servent", pack=False, align=None), offset=0), arg_names=["name", "proto"]),
        #
        'getprotobynumber': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimStruct({"p_name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "p_aliases": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "p_proto": SimTypeShort(signed=True, label="Int16")}, name="protoent", pack=False, align=None), offset=0), arg_names=["number"]),
        #
        'getprotobyname': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypePointer(SimStruct({"p_name": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "p_aliases": SimTypePointer(SimTypePointer(SimTypeChar(label="SByte"), offset=0), offset=0), "p_proto": SimTypeShort(signed=True, label="Int16")}, name="protoent", pack=False, align=None), offset=0), arg_names=["name"]),
        #
        'WSAStartup': SimTypeFunction([SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"wVersion": SimTypeShort(signed=False, label="UInt16"), "wHighVersion": SimTypeShort(signed=False, label="UInt16"), "szDescription": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 257), "szSystemStatus": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "iMaxSockets": SimTypeShort(signed=False, label="UInt16"), "iMaxUdpDg": SimTypeShort(signed=False, label="UInt16"), "lpVendorInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSAData", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["wVersionRequested", "lpWSAData"]),
        #
        'WSACleanup': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'WSASetLastError': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeBottom(label="Void"), arg_names=["iError"]),
        #
        'WSAGetLastError': SimTypeFunction([], SimTypeInt(signed=False, label="WSA_ERROR")),
        #
        'WSAIsBlocking': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'WSAUnhookBlockingHook': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'WSASetBlockingHook': SimTypeFunction([SimTypePointer(SimTypeFunction([], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), offset=0)], SimTypePointer(SimTypeFunction([], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)), offset=0), arg_names=["lpBlockFunc"]),
        #
        'WSACancelBlockingCall': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        #
        'WSAAsyncGetServByName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "wMsg", "name", "proto", "buf", "buflen"]),
        #
        'WSAAsyncGetServByPort': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "wMsg", "port", "proto", "buf", "buflen"]),
        #
        'WSAAsyncGetProtoByName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "wMsg", "name", "buf", "buflen"]),
        #
        'WSAAsyncGetProtoByNumber': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "wMsg", "number", "buf", "buflen"]),
        #
        'WSAAsyncGetHostByName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "wMsg", "name", "buf", "buflen"]),
        #
        'WSAAsyncGetHostByAddr': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["hWnd", "wMsg", "addr", "len", "type", "buf", "buflen"]),
        #
        'WSACancelAsyncRequest': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hAsyncTaskHandle"]),
        #
        'WSAAsyncSelect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "hWnd", "wMsg", "lEvent"]),
        #
        'WSAAccept': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="QOS"), offset=0), SimTypePointer(SimTypeBottom(label="QOS"), offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpCallerId", "lpCallerData", "lpSQOS", "lpGQOS", "lpCalleeId", "lpCalleeData", "g", "dwCallbackData"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["s", "addr", "addrlen", "lpfnCondition", "dwCallbackData"]),
        #
        'WSACloseEvent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEvent"]),
        #
        'WSAConnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SendingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ReceivingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ProviderSpecific": SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None)}, name="QOS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SendingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ReceivingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ProviderSpecific": SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None)}, name="QOS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "name", "namelen", "lpCallerData", "lpCalleeData", "lpSQOS", "lpGQOS"]),
        #
        'WSAConnectByNameW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tv_sec": SimTypeInt(signed=True, label="Int32"), "tv_usec": SimTypeInt(signed=True, label="Int32")}, name="timeval", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "nodename", "servicename", "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "timeout", "Reserved"]),
        #
        'WSAConnectByNameA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tv_sec": SimTypeInt(signed=True, label="Int32"), "tv_usec": SimTypeInt(signed=True, label="Int32")}, name="timeval", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "nodename", "servicename", "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "timeout", "Reserved"]),
        #
        'WSAConnectByList': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"iAddressCount": SimTypeInt(signed=True, label="Int32"), "Address": SimTypePointer(SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), offset=0)}, name="SOCKET_ADDRESS_LIST", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"tv_sec": SimTypeInt(signed=True, label="Int32"), "tv_usec": SimTypeInt(signed=True, label="Int32")}, name="timeval", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "SocketAddress", "LocalAddressLength", "LocalAddress", "RemoteAddressLength", "RemoteAddress", "timeout", "Reserved"]),
        #
        'WSACreateEvent': SimTypeFunction([], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)),
        #
        'WSADuplicateSocketA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="WSAPROTOCOL_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "dwProcessId", "lpProtocolInfo"]),
        #
        'WSADuplicateSocketW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "dwProcessId", "lpProtocolInfo"]),
        #
        'WSAEnumNetworkEvents': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"lNetworkEvents": SimTypeInt(signed=True, label="Int32"), "iErrorCode": SimTypeFixedSizeArray(SimTypeInt(signed=True, label="Int32"), 10)}, name="WSANETWORKEVENTS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "hEventObject", "lpNetworkEvents"]),
        #
        'WSAEnumProtocolsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="WSAPROTOCOL_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpiProtocols", "lpProtocolBuffer", "lpdwBufferLength"]),
        #
        'WSAEnumProtocolsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpiProtocols", "lpProtocolBuffer", "lpdwBufferLength"]),
        #
        'WSAEventSelect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "hEventObject", "lNetworkEvents"]),
        #
        'WSAGetOverlappedResult': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpOverlapped", "lpcbTransfer", "fWait", "lpdwFlags"]),
        #
        'WSAGetQOSByName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SendingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ReceivingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ProviderSpecific": SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None)}, name="QOS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpQOSName", "lpQOS"]),
        #
        'WSAHtonl': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "hostlong", "lpnetlong"]),
        #
        'WSAHtons': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "hostshort", "lpnetshort"]),
        #
        'WSAIoctl': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "dwIoControlCode", "lpvInBuffer", "cbInBuffer", "lpvOutBuffer", "cbOutBuffer", "lpcbBytesReturned", "lpOverlapped", "lpCompletionRoutine"]),
        #
        'WSAJoinLeaf': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SendingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ReceivingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ProviderSpecific": SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None)}, name="QOS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"SendingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ReceivingFlowspec": SimStruct({"TokenRate": SimTypeInt(signed=False, label="UInt32"), "TokenBucketSize": SimTypeInt(signed=False, label="UInt32"), "PeakBandwidth": SimTypeInt(signed=False, label="UInt32"), "Latency": SimTypeInt(signed=False, label="UInt32"), "DelayVariation": SimTypeInt(signed=False, label="UInt32"), "ServiceType": SimTypeInt(signed=False, label="UInt32"), "MaxSduSize": SimTypeInt(signed=False, label="UInt32"), "MinimumPolicedSize": SimTypeInt(signed=False, label="UInt32")}, name="FLOWSPEC", pack=False, align=None), "ProviderSpecific": SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None)}, name="QOS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["s", "name", "namelen", "lpCallerData", "lpCalleeData", "lpSQOS", "lpGQOS", "dwFlags"]),
        #
        'WSANtohl': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "netlong", "lphostlong"]),
        #
        'WSANtohs': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "netshort", "lphostshort"]),
        #
        'WSARecv': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpBuffers", "dwBufferCount", "lpNumberOfBytesRecvd", "lpFlags", "lpOverlapped", "lpCompletionRoutine"]),
        #
        'WSARecvDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpInboundDisconnectData"]),
        #
        'WSARecvFrom': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpBuffers", "dwBufferCount", "lpNumberOfBytesRecvd", "lpFlags", "lpFrom", "lpFromlen", "lpOverlapped", "lpCompletionRoutine"]),
        #
        'WSAResetEvent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEvent"]),
        #
        'WSASend': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpBuffers", "dwBufferCount", "lpNumberOfBytesSent", "dwFlags", "lpOverlapped", "lpCompletionRoutine"]),
        #
        'WSASendMsg': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"name": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "namelen": SimTypeInt(signed=True, label="Int32"), "lpBuffers": SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0), "dwBufferCount": SimTypeInt(signed=False, label="UInt32"), "Control": SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="WSAMSG", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Handle", "lpMsg", "dwFlags", "lpNumberOfBytesSent", "lpOverlapped", "lpCompletionRoutine"]),
        #
        'WSASendDisconnect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpOutboundDisconnectData"]),
        #
        'WSASendTo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"len": SimTypeInt(signed=False, label="UInt32"), "buf": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSABUF", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpBuffers", "dwBufferCount", "lpNumberOfBytesSent", "dwFlags", "lpTo", "iTolen", "lpOverlapped", "lpCompletionRoutine"]),
        #
        'WSASetEvent': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEvent"]),
        #
        'WSASocketA': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="WSAPROTOCOL_INFOA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["af", "type", "protocol", "lpProtocolInfo", "g", "dwFlags"]),
        #
        'WSASocketW': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), arg_names=["af", "type", "protocol", "lpProtocolInfo", "g", "dwFlags"]),
        #
        'WSAWaitForMultipleEvents': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), label="LPArray", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["cEvents", "lphEvents", "fWaitAll", "dwTimeout", "fAlertable"]),
        #
        'WSAAddressToStringA': SimTypeFunction([SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="WSAPROTOCOL_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpsaAddress", "dwAddressLength", "lpProtocolInfo", "lpszAddressString", "lpdwAddressStringLength"]),
        #
        'WSAAddressToStringW': SimTypeFunction([SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpsaAddress", "dwAddressLength", "lpProtocolInfo", "lpszAddressString", "lpdwAddressStringLength"]),
        #
        'WSAStringToAddressA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 256)}, name="WSAPROTOCOL_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AddressString", "AddressFamily", "lpProtocolInfo", "lpAddress", "lpAddressLength"]),
        #
        'WSAStringToAddressW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AddressString", "AddressFamily", "lpProtocolInfo", "lpAddress", "lpAddressLength"]),
        #
        'WSALookupServiceBeginA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSETA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpqsRestrictions", "dwControlFlags", "lphLookup"]),
        #
        'WSALookupServiceBeginW': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSETW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpqsRestrictions", "dwControlFlags", "lphLookup"]),
        #
        'WSALookupServiceNextA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSETA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLookup", "dwControlFlags", "lpdwBufferLength", "lpqsResults"]),
        #
        'WSALookupServiceNextW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSETW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLookup", "dwControlFlags", "lpdwBufferLength", "lpqsResults"]),
        #
        'WSANSPIoctl': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Type": SimTypeInt(signed=False, label="WSACOMPLETIONTYPE"), "Parameters": SimUnion({"WindowMessage": SimStruct({"hWnd": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "uMsg": SimTypeInt(signed=False, label="UInt32"), "context": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="_WindowMessage_e__Struct", pack=False, align=None), "Event": SimStruct({"lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)}, name="_Event_e__Struct", pack=False, align=None), "Apc": SimStruct({"lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), "lpfnCompletionProc": SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)}, name="_Apc_e__Struct", pack=False, align=None), "Port": SimStruct({"lpOverlapped": SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), "hPort": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Key": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="_Port_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="WSACOMPLETION", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLookup", "dwControlCode", "lpvInBuffer", "cbInBuffer", "lpvOutBuffer", "cbOutBuffer", "lpcbBytesReturned", "lpCompletion"]),
        #
        'WSALookupServiceEnd': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLookup"]),
        #
        'WSAInstallServiceClassA': SimTypeFunction([SimTypePointer(SimStruct({"lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszServiceClassName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCount": SimTypeInt(signed=False, label="UInt32"), "lpClassInfos": SimTypePointer(SimStruct({"lpszName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "dwValueType": SimTypeInt(signed=False, label="UInt32"), "dwValueSize": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WSANSCLASSINFOA", pack=False, align=None), offset=0)}, name="WSASERVICECLASSINFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceClassInfo"]),
        #
        'WSAInstallServiceClassW': SimTypeFunction([SimTypePointer(SimStruct({"lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszServiceClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwCount": SimTypeInt(signed=False, label="UInt32"), "lpClassInfos": SimTypePointer(SimStruct({"lpszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "dwValueType": SimTypeInt(signed=False, label="UInt32"), "dwValueSize": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WSANSCLASSINFOW", pack=False, align=None), offset=0)}, name="WSASERVICECLASSINFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceClassInfo"]),
        #
        'WSARemoveServiceClass': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceClassId"]),
        #
        'WSAGetServiceClassInfoA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszServiceClassName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwCount": SimTypeInt(signed=False, label="UInt32"), "lpClassInfos": SimTypePointer(SimStruct({"lpszName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "dwValueType": SimTypeInt(signed=False, label="UInt32"), "dwValueSize": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WSANSCLASSINFOA", pack=False, align=None), offset=0)}, name="WSASERVICECLASSINFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpServiceClassId", "lpdwBufSize", "lpServiceClassInfo"]),
        #
        'WSAGetServiceClassInfoW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszServiceClassName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwCount": SimTypeInt(signed=False, label="UInt32"), "lpClassInfos": SimTypePointer(SimStruct({"lpszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "dwValueType": SimTypeInt(signed=False, label="UInt32"), "dwValueSize": SimTypeInt(signed=False, label="UInt32"), "lpValue": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WSANSCLASSINFOW", pack=False, align=None), offset=0)}, name="WSASERVICECLASSINFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpServiceClassId", "lpdwBufSize", "lpServiceClassInfo"]),
        #
        'WSAEnumNameSpaceProvidersA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"NSProviderId": SimTypeBottom(label="Guid"), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "fActive": SimTypeInt(signed=True, label="Int32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "lpszIdentifier": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSANAMESPACE_INFOA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwBufferLength", "lpnspBuffer"]),
        #
        'WSAEnumNameSpaceProvidersW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"NSProviderId": SimTypeBottom(label="Guid"), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "fActive": SimTypeInt(signed=True, label="Int32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "lpszIdentifier": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSANAMESPACE_INFOW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwBufferLength", "lpnspBuffer"]),
        #
        'WSAEnumNameSpaceProvidersExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"NSProviderId": SimTypeBottom(label="Guid"), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "fActive": SimTypeInt(signed=True, label="Int32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "lpszIdentifier": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ProviderSpecific": SimTypeBottom(label="BLOB")}, name="WSANAMESPACE_INFOEXA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwBufferLength", "lpnspBuffer"]),
        #
        'WSAEnumNameSpaceProvidersExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"NSProviderId": SimTypeBottom(label="Guid"), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "fActive": SimTypeInt(signed=True, label="Int32"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "lpszIdentifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ProviderSpecific": SimTypeBottom(label="BLOB")}, name="WSANAMESPACE_INFOEXW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwBufferLength", "lpnspBuffer"]),
        #
        'WSAGetServiceClassNameByClassIdA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceClassId", "lpszServiceClassName", "lpdwBufferLength"]),
        #
        'WSAGetServiceClassNameByClassIdW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceClassId", "lpszServiceClassName", "lpdwBufferLength"]),
        #
        'WSASetServiceA': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSETA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WSAESETSERVICEOP"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpqsRegInfo", "essoperation", "dwControlFlags"]),
        #
        'WSASetServiceW': SimTypeFunction([SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpServiceClassId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSETW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WSAESETSERVICEOP"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpqsRegInfo", "essoperation", "dwControlFlags"]),
        #
        'WSAProviderConfigChange': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["dwError", "cbTransferred", "lpOverlapped", "dwFlags"]), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpNotificationHandle", "lpOverlapped", "lpCompletionRoutine"]),
        #
        'WSAPoll': SimTypeFunction([SimTypePointer(SimStruct({"fd": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "events": SimTypeShort(signed=True, label="Int16"), "revents": SimTypeShort(signed=True, label="Int16")}, name="WSAPOLLFD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["fdArray", "fds", "timeout"]),
        #
        'WSCEnumProtocols': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpiProtocols", "lpProtocolBuffer", "lpdwBufferLength", "lpErrno"]),
        #
        'WSCDeinstallProvider': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpErrno"]),
        #
        'WSCInstallProvider': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpszProviderDllPath", "lpProtocolInfoList", "dwNumberOfEntries", "lpErrno"]),
        #
        'WSCGetProviderPath': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpszProviderDllPath", "lpProviderDllPathLen", "lpErrno"]),
        #
        'WSCUpdateProvider': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwServiceFlags1": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags2": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags3": SimTypeInt(signed=False, label="UInt32"), "dwServiceFlags4": SimTypeInt(signed=False, label="UInt32"), "dwProviderFlags": SimTypeInt(signed=False, label="UInt32"), "ProviderId": SimTypeBottom(label="Guid"), "dwCatalogEntryId": SimTypeInt(signed=False, label="UInt32"), "ProtocolChain": SimStruct({"ChainLen": SimTypeInt(signed=True, label="Int32"), "ChainEntries": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 7)}, name="WSAPROTOCOLCHAIN", pack=False, align=None), "iVersion": SimTypeInt(signed=True, label="Int32"), "iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iMaxSockAddr": SimTypeInt(signed=True, label="Int32"), "iMinSockAddr": SimTypeInt(signed=True, label="Int32"), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32"), "iProtocolMaxOffset": SimTypeInt(signed=True, label="Int32"), "iNetworkByteOrder": SimTypeInt(signed=True, label="Int32"), "iSecurityScheme": SimTypeInt(signed=True, label="Int32"), "dwMessageSize": SimTypeInt(signed=False, label="UInt32"), "dwProviderReserved": SimTypeInt(signed=False, label="UInt32"), "szProtocol": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WSAPROTOCOL_INFOW", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpszProviderDllPath", "lpProtocolInfoList", "dwNumberOfEntries", "lpErrno"]),
        #
        'WSCSetProviderInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WSC_PROVIDER_INFO_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "InfoType", "Info", "InfoSize", "Flags", "lpErrno"]),
        #
        'WSCGetProviderInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="WSC_PROVIDER_INFO_TYPE"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "InfoType", "Info", "InfoSize", "Flags", "lpErrno"]),
        #
        'WSCSetApplicationCategory': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Path", "PathLength", "Extra", "ExtraLength", "PermittedLspCategories", "pPrevPermLspCat", "lpErrno"]),
        #
        'WSCGetApplicationCategory': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Path", "PathLength", "Extra", "ExtraLength", "pPermittedLspCategories", "lpErrno"]),
        #
        'WPUCompleteOverlappedRequest': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "lpOverlapped", "dwError", "cbTransferred", "lpErrno"]),
        #
        'WSCInstallNameSpace': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszIdentifier", "lpszPathName", "dwNameSpace", "dwVersion", "lpProviderId"]),
        #
        'WSCUnInstallNameSpace': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId"]),
        #
        'WSCInstallNameSpaceEx': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBlobData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="BLOB", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszIdentifier", "lpszPathName", "dwNameSpace", "dwVersion", "lpProviderId", "lpProviderSpecific"]),
        #
        'WSCEnableNSProvider': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "fEnable"]),
        #
        'WSAAdvertiseProvider': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwMajorVersion": SimTypeInt(signed=False, label="UInt32"), "dwMinorVersion": SimTypeInt(signed=False, label="UInt32"), "NSPv2Startup": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "ppvClientSessionArg"]), offset=0), "NSPv2Cleanup": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "pvClientSessionArg"]), offset=0), "NSPv2LookupServiceBegin": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSET2W", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "lpqsRestrictions", "dwControlFlags", "lpvClientSessionArg", "lphLookup"]), offset=0), "NSPv2LookupServiceNextEx": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSET2W", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["hAsyncCall", "hLookup", "dwControlFlags", "lpdwBufferLength", "lpqsResults"]), offset=0), "NSPv2LookupServiceEnd": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLookup"]), offset=0), "NSPv2SetServiceEx": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "lpszServiceInstanceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpVersion": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "ecHow": SimTypeInt(signed=False, label="WSAECOMPARATOR")}, name="WSAVERSION", pack=False, align=None), offset=0), "lpszComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNameSpace": SimTypeInt(signed=False, label="UInt32"), "lpNSProviderId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpszContext": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfProtocols": SimTypeInt(signed=False, label="UInt32"), "lpafpProtocols": SimTypePointer(SimStruct({"iAddressFamily": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="AFPROTOCOLS", pack=False, align=None), offset=0), "lpszQueryString": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwNumberOfCsAddrs": SimTypeInt(signed=False, label="UInt32"), "lpcsaBuffer": SimTypePointer(SimStruct({"LocalAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "RemoteAddr": SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), "iSocketType": SimTypeInt(signed=True, label="Int32"), "iProtocol": SimTypeInt(signed=True, label="Int32")}, name="CSADDR_INFO", pack=False, align=None), offset=0), "dwOutputFlags": SimTypeInt(signed=False, label="UInt32"), "lpBlob": SimTypePointer(SimTypeBottom(label="BLOB"), offset=0)}, name="WSAQUERYSET2W", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WSAESETSERVICEOP"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hAsyncCall", "lpProviderId", "lpqsRegInfo", "essOperation", "dwControlFlags", "lpvClientSessionArg"]), offset=0), "NSPv2ClientSessionRundown": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["lpProviderId", "pvClientSessionArg"]), offset=0)}, name="NSPV2_ROUTINE", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["puuidProviderId", "pNSPv2Routine"]),
        #
        'WSAUnadvertiseProvider': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["puuidProviderId"]),
        #
        'WSAProviderCompleteAsyncCall': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hAsyncCall", "iRetCode"]),
        #
        'getaddrinfo': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="ADDRINFOA"), offset=0)}, name="ADDRINFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="ADDRINFOA"), offset=0)}, name="ADDRINFOA", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pNodeName", "pServiceName", "pHints", "ppResult"]),
        #
        'GetAddrInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoW"), offset=0)}, name="addrinfoW", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoW"), offset=0)}, name="addrinfoW", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pNodeName", "pServiceName", "pHints", "ppResult"]),
        #
        'GetAddrInfoExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_blob": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ai_bloblen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_provider": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoexA"), offset=0)}, name="addrinfoexA", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_blob": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ai_bloblen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_provider": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoexA"), offset=0)}, name="addrinfoexA", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({"tv_sec": SimTypeInt(signed=True, label="Int32"), "tv_usec": SimTypeInt(signed=True, label="Int32")}, name="timeval", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwError", "dwBytes", "lpOverlapped"]), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pServiceName", "dwNameSpace", "lpNspId", "hints", "ppResult", "timeout", "lpOverlapped", "lpCompletionRoutine", "lpNameHandle"]),
        #
        'GetAddrInfoExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_blob": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ai_bloblen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_provider": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoexW"), offset=0)}, name="addrinfoexW", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_blob": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ai_bloblen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_provider": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoexW"), offset=0)}, name="addrinfoexW", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimStruct({"tv_sec": SimTypeInt(signed=True, label="Int32"), "tv_usec": SimTypeInt(signed=True, label="Int32")}, name="timeval", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwError", "dwBytes", "lpOverlapped"]), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pServiceName", "dwNameSpace", "lpNspId", "hints", "ppResult", "timeout", "lpOverlapped", "lpCompletionRoutine", "lpHandle"]),
        #
        'GetAddrInfoExCancel': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpHandle"]),
        #
        'GetAddrInfoExOverlappedResult': SimTypeFunction([SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpOverlapped"]),
        #
        'SetAddrInfoExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBlobData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"tv_sec": SimTypeInt(signed=True, label="Int32"), "tv_usec": SimTypeInt(signed=True, label="Int32")}, name="timeval", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwError", "dwBytes", "lpOverlapped"]), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pServiceName", "pAddresses", "dwAddressCount", "lpBlob", "dwFlags", "dwNameSpace", "lpNspId", "timeout", "lpOverlapped", "lpCompletionRoutine", "lpNameHandle"]),
        #
        'SetAddrInfoExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"lpSockaddr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "iSockaddrLength": SimTypeInt(signed=True, label="Int32")}, name="SOCKET_ADDRESS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBlobData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="BLOB", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"tv_sec": SimTypeInt(signed=True, label="Int32"), "tv_usec": SimTypeInt(signed=True, label="Int32")}, name="timeval", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="OVERLAPPED"), offset=0)], SimTypeBottom(label="Void"), arg_names=["dwError", "dwBytes", "lpOverlapped"]), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pName", "pServiceName", "pAddresses", "dwAddressCount", "lpBlob", "dwFlags", "dwNameSpace", "lpNspId", "timeout", "lpOverlapped", "lpCompletionRoutine", "lpNameHandle"]),
        #
        'freeaddrinfo': SimTypeFunction([SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="ADDRINFOA"), offset=0)}, name="ADDRINFOA", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pAddrInfo"]),
        #
        'FreeAddrInfoW': SimTypeFunction([SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoW"), offset=0)}, name="addrinfoW", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pAddrInfo"]),
        #
        'FreeAddrInfoEx': SimTypeFunction([SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_blob": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ai_bloblen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_provider": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoexA"), offset=0)}, name="addrinfoexA", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pAddrInfoEx"]),
        #
        'FreeAddrInfoExW': SimTypeFunction([SimTypePointer(SimStruct({"ai_flags": SimTypeInt(signed=True, label="Int32"), "ai_family": SimTypeInt(signed=True, label="Int32"), "ai_socktype": SimTypeInt(signed=True, label="Int32"), "ai_protocol": SimTypeInt(signed=True, label="Int32"), "ai_addrlen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_canonname": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ai_addr": SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), "ai_blob": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "ai_bloblen": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "ai_provider": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "ai_next": SimTypePointer(SimTypeBottom(label="addrinfoexW"), offset=0)}, name="addrinfoexW", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pAddrInfoEx"]),
        #
        'getnameinfo': SimTypeFunction([SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSockaddr", "SockaddrLength", "pNodeBuffer", "NodeBufferSize", "pServiceBuffer", "ServiceBufferSize", "Flags"]),
        #
        'GetNameInfoW': SimTypeFunction([SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pSockaddr", "SockaddrLength", "pNodeBuffer", "NodeBufferSize", "pServiceBuffer", "ServiceBufferSize", "Flags"]),
        #
        'inet_pton': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "pszAddrString", "pAddrBuf"]),
        #
        'InetPtonW': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Family", "pszAddrString", "pAddrBuf"]),
        #
        'inet_ntop': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["Family", "pAddr", "pStringBuf", "StringBufSize"]),
        #
        'InetNtopW': SimTypeFunction([SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["Family", "pAddr", "pStringBuf", "StringBufSize"]),
        #
        'WSCWriteProviderOrder': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpwdCatalogEntryId", "dwNumberOfEntries"]),
        #
        'WSCWriteNameSpaceOrder': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpProviderId", "dwNumberOfEntries"]),
    }

lib.set_prototypes(prototypes)
