
# ZYXEL IES-500x SNMP

## Overview

For Zabbix version: 5.0 and higher  
https://service-provider.zyxel.com/global/en/products/msansdslams/central-msans/chassis-msans/ies-5000-series

This template was tested on:

- ZYXEL IES-500x

## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/5.0/manual/config/templates_out_of_the_box/network_devices) for basic instructions.

Refer to the vendor documentation.

## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$SNMP.TIMEOUT} |<p>The time interval for SNMP agent availability trigger expression.</p> |`5m` |
|{$ZYXEL.ADSL.ATN.MAX} |<p>Type the maximum signal attenuation</p> |`40` |
|{$ZYXEL.ADSL.SNR.MIN} |<p>Type the minimum signal to noise margin (0-31 dB)</p> |`8` |
|{$ZYXEL.LLD.FILTER.IF.CONTROL.MATCHES} |<p>Triggers will be created only for interfaces whose description contains the value of this macro</p> |`CHANGE_IF_NEEDED` |
|{$ZYXEL.LLD.FILTER.IF.DESC.MATCHES} |<p>Filter by discoverable interface names.</p> |`.*` |
|{$ZYXEL.LLD.FILTER.IF.DESC.NOT_MATCHES} |<p>Filter to exclude discovered interfaces by name.</p> |`CHANGE_IF_NEEDED` |
|{$ZYXEL.LLD.FILTER.IF.LINKSTATUS.MATCHES} |<p>Filter of discoverable link types.</p> |`.*` |
|{$ZYXEL.LLD.FILTER.IF.LINKSTATUS.NOT_MATCHES} |<p>Filter to exclude discovered by link types.</p> |`2` |
|{$ZYXEL.LLD.FILTER.SLOT.STATUS.MATCHES} |<p>Filter by discoverable slot status.</p> |`.*` |
|{$ZYXEL.LLD.FILTER.SLOT.STATUS.NOT_MATCHES} |<p>Filter to exclude discovered slots by status.</p> |`1` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|Slot discovery |<p>The table which contains the slot information in a chassis.</p> |SNMP |zyxel.ies500x.slot.discovery<p>**Filter**:</p>AND <p>- A: {#ZYXEL.SLOTSTATUS} MATCHES_REGEX `{$ZYXEL.LLD.FILTER.SLOT.STATUS.MATCHES}`</p><p>- B: {#ZYXEL.SLOTSTATUS} NOT_MATCHES_REGEX `{$ZYXEL.LLD.FILTER.SLOT.STATUS.NOT_MATCHES}`</p> |
|Fan discovery |<p>An entry in fanRpmTable.</p> |SNMP |zyxel.ies500x.fan.discovery |
|Temperature discovery |<p>An entry in tempTable.</p> |SNMP |zyxel.ies500x.temp.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Voltage discovery |<p>An entry in voltageTable.</p> |SNMP |zyxel.ies500x.volt.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|CPU discovery |<p>A table that contains CPU utilization information.</p><p>This table is supported by R1.03 and later versions.</p> |SNMP |zyxel.ies500x.cpu.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Memory discovery |<p>A table that contains memory usage information.</p> |SNMP |zyxel.ies500x.memory.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Packet buffer discovery |<p>A table that contains packet buffer usage information.</p> |SNMP |zyxel.ies500x.buffer.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Ethernet interface discovery |<p>-</p> |SNMP |zyxel.ies500x.net.if.discovery<p>**Filter**:</p>AND <p>- A: {#ZYXEL.IF.DESC} MATCHES_REGEX `{$ZYXEL.LLD.FILTER.IF.DESC.MATCHES}`</p><p>- B: {#ZYXEL.IF.DESC} NOT_MATCHES_REGEX `{$ZYXEL.LLD.FILTER.IF.DESC.NOT_MATCHES}`</p><p>- C: {#ZYXEL.IF.LINKSTATUS} MATCHES_REGEX `{$ZYXEL.LLD.FILTER.IF.LINKSTATUS.MATCHES}`</p><p>- D: {#ZYXEL.IF.LINKSTATUS} NOT_MATCHES_REGEX `{$ZYXEL.LLD.FILTER.IF.LINKSTATUS.NOT_MATCHES}`</p><p>- E: {#ZYXEL.IF.NAME} MATCHES_REGEX `enet`</p> |
|ADSL interface discovery |<p>-</p> |SNMP |zyxel.ies500x.net.adsl.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>**Filter**:</p>AND <p>- A: {#ZYXEL.IF.DESC} MATCHES_REGEX `{$ZYXEL.LLD.FILTER.IF.DESC.MATCHES}`</p><p>- B: {#ZYXEL.IF.DESC} NOT_MATCHES_REGEX `{$ZYXEL.LLD.FILTER.IF.DESC.NOT_MATCHES}`</p><p>- C: {#ZYXEL.IF.LINKSTATUS} MATCHES_REGEX `{$ZYXEL.LLD.FILTER.IF.LINKSTATUS.MATCHES}`</p><p>- D: {#ZYXEL.IF.LINKSTATUS} NOT_MATCHES_REGEX `{$ZYXEL.LLD.FILTER.IF.LINKSTATUS.NOT_MATCHES}`</p><p>- E: {#ZYXEL.IF.NAME} MATCHES_REGEX `adsl`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|CPU |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: CPU utilization |<p>MIB: ZYXEL-IES5000-MIB</p><p>The CPU utilization in the past 60 seconds.</p> |SNMP |zyxel.ies500x.cpu[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Fans |ZYXEL IES-500x: Fan #{#SNMPINDEX} |<p>MIB: ZYXEL-IES5000-MIB</p><p>Current speed in Revolutions Per Minute (RPM) on the fan.</p> |SNMP |zyxel.ies500x.fan[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Inventory |ZYXEL IES-500x: Hardware model name |<p>MIB: RFC1213-MIB</p><p>A textual description of the entity.  This value</p><p>should include the full name and version</p><p>identification of the system's hardware type,</p><p>software operating-system, and networking</p><p>software.  It is mandatory that this only contain</p><p>printable ASCII characters.</p> |SNMP |zyxel.ies500x.model<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |ZYXEL IES-500x: Contact |<p>MIB: RFC1213-MIB</p><p>The textual identification of the contact person</p><p>for this managed node, together with information</p><p>on how to contact this person.</p> |SNMP |zyxel.ies500x.contact<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |ZYXEL IES-500x: Host name |<p>MIB: RFC1213-MIB</p><p>An administratively-assigned name for this</p><p>managed node.  By convention, this is the node's</p><p>fully-qualified domain name.</p> |SNMP |zyxel.ies500x.name<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |ZYXEL IES-500x: Location |<p>MIB: RFC1213-MIB</p><p>The physical location of this node (e.g.,</p><p>`telephone closet, 3rd floor').</p> |SNMP |zyxel.ies500x.location<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Inventory |ZYXEL IES-500x: MAC address |<p>MIB: IF-MIB</p><p>The interface's address at the protocol layer</p><p>immediately `below' the network layer in the</p><p>protocol stack.  For interfaces which do not have</p><p>such an address (e.g., a serial line), this object</p><p>should contain an octet string of zero length.</p> |SNMP |zyxel.ies500x.mac<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Memory |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Memory utilization |<p>MIB: ZYXEL-IES5000-MIB</p><p>The memory usage in the past 60 seconds.</p> |SNMP |zyxel.ies500x.memory[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Memory |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Packet buffer utilization |<p>MIB: ZYXEL-IES5000-MIB</p><p>The packet buffer usage in the past 60 seconds.</p> |SNMP |zyxel.ies500x.buffer[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Type |<p>MIB: ZYXEL-IES5000-MIB</p><p>Card type of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.type[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Description |<p>MIB: ZYXEL-IES5000-MIB</p><p>The descriptions of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.desc[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Firmware version |<p>MIB: ZYXEL-IES5000-MIB</p><p>The firmware version of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.fw.ver[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Driver version |<p>MIB: ZYXEL-IES5000-MIB</p><p>The DSL driver of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.dv.ver[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: DSL modem code version |<p>MIB: ZYXEL-IES5000-MIB</p><p>The DSL modem code version of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.cv.ver[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Status |<p>MIB: ZYXEL-IES5000-MIB</p><p>The module state of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.status[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Alarm status |<p>MIB: ZYXEL-IES5000-MIB</p><p>This variable indicates the alarm status of the module.</p><p>It is a bit map represented a sum, therefore, it can represent</p><p>multiple defects simultaneously. The moduleNoDefect should be set</p><p>if and only if no other flag is set.</p><p>The various bit positions are:</p><p>1   moduleNoDefect</p><p>2   moduleOverHeat</p><p>3   moduleFanRpmLow</p><p>4   moduleVoltageLow</p><p>5   moduleThermalSensorFailure</p><p>6   modulePullOut</p><p>7   powerDC48VAFailure</p><p>8   powerDC48VBFailure</p><p>9   extAlarmInputTrigger</p><p>10   moduleDown</p><p>11   mscSwitchOverOK</p><p>12   networkTopologyChange</p><p>13   macSpoof</p><p>14   cpuHigh</p><p>15   memoryUsageHigh</p><p>16   packetBufferUsageHigh</p><p>17   loopguardOccurence</p> |SNMP |zyxel.ies500x.slot.alarm[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Hardware version |<p>MIB: ZYXEL-IES5000-MIB</p><p>The hardware version of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.hw.ver[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Serial number |<p>MIB: ZYXEL-IES5000-MIB</p><p>The serial number of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.serial[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Uptime |<p>MIB: ZYXEL-IES5000-MIB</p><p>The time (in seconds) since the plug-in card was last re-initialized.</p> |SNMP |zyxel.ies500x.slot.uptime[{#SNMPINDEX}] |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: MAC address 1 |<p>MIB: ZYXEL-IES5000-MIB</p><p>The MAC Address of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.mac1[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: MAC address 2 |<p>MIB: ZYXEL-IES5000-MIB</p><p>The MAC Address of the plug-in card.</p> |SNMP |zyxel.ies500x.slot.mac2[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Interface description |<p>MIB: IF-MIB</p><p>A textual string containing information about the interface</p> |SNMP |zyxel.ies500x.net.if.descr[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Interface name |<p>MIB: IF-MIB</p><p>A textual string containing information about the interface</p> |SNMP |zyxel.ies500x.net.if.name[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Operational status |<p>MIB: IF-MIB</p><p>The current operational state of the interface.</p><p>The testing(3) state indicates that no operational</p><p>packets can be passed.</p> |SNMP |zyxel.ies500x.net.if.operstatus[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Administrative status |<p>MIB: IF-MIB</p><p>The desired state of the interface.  The</p><p>testing(3) state indicates that no operational</p><p>packets can be passed.</p> |SNMP |zyxel.ies500x.net.if.adminstatus[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Incoming traffic |<p>MIB: IF-MIB</p><p>The total number of octets received on the interface,</p><p>including framing characters.</p> |SNMP |zyxel.ies500x.net.if.in.traffic[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `8`</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Incoming unicast packages |<p>MIB: IF-MIB</p><p>The number of packets, delivered by this sub-layer to a</p><p>higher (sub-)layer, which were not addressed to a multicast</p><p>or broadcast address at this sub-layer</p> |SNMP |zyxel.ies500x.net.if.in.ucastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Incoming multicast packages |<p>MIB: IF-MIB</p><p>The number of packets, delivered by this sub-layer to a</p><p>higher (sub-)layer, which were addressed to a multicast</p><p>address at this sub-layer.  For a MAC layer protocol, this</p><p>includes both Group and Functional addresses.</p> |SNMP |zyxel.ies500x.net.if.in.multicastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Incoming broadcast packages |<p>MIB: IF-MIB</p><p>The number of packets, delivered by this sub-layer to a</p><p>higher (sub-)layer, which were addressed to a broadcast</p><p>address at this sub-layer.</p> |SNMP |zyxel.ies500x.net.if.in.broadcastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Outgoing traffic |<p>MIB: IF-MIB</p><p>The total number of octets transmitted out of the</p><p>interface, including framing characters.  This object is a</p><p>64-bit version of ifOutOctets.</p> |SNMP |zyxel.ies500x.net.if.out.traffic[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `8`</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Outgoing unicast packages |<p>MIB: IF-MIB</p><p>The total number of packets that higher-level protocols</p><p>requested be transmitted, and which were not addressed to a</p><p>multicast or broadcast address at this sub-layer, including</p><p>those that were discarded or not sent.</p> |SNMP |zyxel.ies500x.net.if.out.ucastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Outgoing multicast packages |<p>MIB: IF-MIB</p><p>The total number of packets that higher-level protocols</p><p>requested be transmitted, and which were addressed to a</p><p>multicast address at this sub-layer, including those that</p><p>were discarded or not sent.  For a MAC layer protocol, this</p><p>includes both Group and Functional addresses.</p> |SNMP |zyxel.ies500x.net.if.out.multicastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Outgoing broadcast packages |<p>MIB: IF-MIB</p><p>The total number of packets that higher-level protocols</p><p>requested be transmitted, and which were addressed to a</p><p>broadcast address at this sub-layer, including those that</p><p>were discarded or not sent.</p> |SNMP |zyxel.ies500x.net.if.out.broadcastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Link speed |<p>MIB: IF-MIB</p><p>An estimate of the interface's current bandwidth in bits per second</p> |SNMP |zyxel.ies500x.net.if.highspeed[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `1000000`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Incoming utilization |<p>Interface utilization percentage</p> |CALCULATED |zyxel.ies500x.net.if.in.util[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- IN_RANGE: `0 100`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- JAVASCRIPT: `return +parseFloat(value).toFixed(0); `</p><p>**Expression**:</p>`last(zyxel.ies500x.net.if.in.traffic[{#SNMPINDEX}]) * (last(zyxel.ies500x.net.if.highspeed[{#SNMPINDEX}]) <> 0) / ( last(zyxel.ies500x.net.if.highspeed[{#SNMPINDEX}]) + (last(zyxel.ies500x.net.if.highspeed[{#SNMPINDEX}]) = 0) ) * 100 ` |
|Network_interfaces |ZYXEL IES-500x: Port {#SNMPINDEX}: Outgoing utilization |<p>Interface utilization percentage</p> |CALCULATED |zyxel.ies500x.net.if.out.util[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- IN_RANGE: `0 100`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- JAVASCRIPT: `return +parseFloat(value).toFixed(0); `</p><p>**Expression**:</p>`last(zyxel.ies500x.net.if.out.traffic[{#SNMPINDEX}]) * (last(zyxel.ies500x.net.if.highspeed[{#SNMPINDEX}]) <> 0) / ( last(zyxel.ies500x.net.if.highspeed[{#SNMPINDEX}]) + (last(zyxel.ies500x.net.if.highspeed[{#SNMPINDEX}]) = 0) ) * 100 ` |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Interface description |<p>MIB: IF-MIB</p><p>A textual string containing information about the interface</p> |SNMP |zyxel.ies500x.net.adsl.descr[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Interface name |<p>MIB: IF-MIB</p><p>A textual string containing information about the interface</p> |SNMP |zyxel.ies500x.net.adsl.name[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Operational status |<p>MIB: IF-MIB</p><p>The current operational state of the interface.</p><p>The testing(3) state indicates that no operational</p><p>packets can be passed.</p> |SNMP |zyxel.ies500x.net.adsl.operstatus[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Administrative status |<p>MIB: IF-MIB</p><p>The desired state of the interface.  The</p><p>testing(3) state indicates that no operational</p><p>packets can be passed.</p> |SNMP |zyxel.ies500x.net.adsl.adminstatus[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `6h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Incoming traffic |<p>MIB: IF-MIB</p><p>The total number of octets received on the interface,</p><p>including framing characters.</p> |SNMP |zyxel.ies500x.net.adsl.in.traffic[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `8`</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Incoming unicast packages |<p>MIB: IF-MIB</p><p>The number of packets, delivered by this sub-layer to a</p><p>higher (sub-)layer, which were not addressed to a multicast</p><p>or broadcast address at this sub-layer</p> |SNMP |zyxel.ies500x.net.adsl.in.ucastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Incoming multicast packages |<p>MIB: IF-MIB</p><p>The number of packets, delivered by this sub-layer to a</p><p>higher (sub-)layer, which were addressed to a multicast</p><p>address at this sub-layer.  For a MAC layer protocol, this</p><p>includes both Group and Functional addresses.</p> |SNMP |zyxel.ies500x.net.adsl.in.multicastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Incoming broadcast packages |<p>MIB: IF-MIB</p><p>The number of packets, delivered by this sub-layer to a</p><p>higher (sub-)layer, which were addressed to a broadcast</p><p>address at this sub-layer.</p> |SNMP |zyxel.ies500x.net.adsl.in.broadcastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Outgoing traffic |<p>MIB: IF-MIB</p><p>The total number of octets transmitted out of the</p><p>interface, including framing characters.  This object is a</p><p>64-bit version of ifOutOctets.</p> |SNMP |zyxel.ies500x.net.adsl.out.traffic[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `8`</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Outgoing unicast packages |<p>MIB: IF-MIB</p><p>The total number of packets that higher-level protocols</p><p>requested be transmitted, and which were not addressed to a</p><p>multicast or broadcast address at this sub-layer, including</p><p>those that were discarded or not sent.</p> |SNMP |zyxel.ies500x.net.adsl.out.ucastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Outgoing multicast packages |<p>MIB: IF-MIB</p><p>The total number of packets that higher-level protocols</p><p>requested be transmitted, and which were addressed to a</p><p>multicast address at this sub-layer, including those that</p><p>were discarded or not sent.  For a MAC layer protocol, this</p><p>includes both Group and Functional addresses.</p> |SNMP |zyxel.ies500x.net.adsl.out.multicastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Outgoing broadcast packages |<p>MIB: IF-MIB</p><p>The total number of packets that higher-level protocols</p><p>requested be transmitted, and which were addressed to a</p><p>broadcast address at this sub-layer, including those that</p><p>were discarded or not sent.</p> |SNMP |zyxel.ies500x.net.adsl.out.broadcastpkts[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- CHANGE_PER_SECOND |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: ATUC noise margin |<p>MIB: ADSL-LINE-MIB</p><p>Noise Margin as seen by this ATU with respect to its</p><p>received signal in tenth dB. </p><p>The Info Atuc fields show data acquired from the ATUC (ADSL Termination Unit – Central), in this case ZYXEL IES-500x, during negotiation/provisioning message interchanges.</p> |SNMP |zyxel.ies500x.net.adsl.atuc.snrmgn[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.1`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: ATUC attenuation |<p>MIB: ADSL-LINE-MIB</p><p>Measured difference in the total power transmitted by</p><p>the peer ATU and the total power received by this ATU. </p><p>The Info Atuc fields show data acquired from the ATUC (ADSL Termination Unit – Central), in this case ZYXEL IES-500x, during negotiation/provisioning message interchanges.</p> |SNMP |zyxel.ies500x.net.adsl.atuc.atn[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.1`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: ATUC output power |<p>MIB: ADSL-LINE-MIB</p><p>Measured total output power transmitted by this ATU. </p><p>The Info Atuc fields show data acquired from the ATUC (ADSL Termination Unit – Central), in this case ZYXEL IES-500x, during negotiation/provisioning message interchanges.</p> |SNMP |zyxel.ies500x.net.adsl.atuc.outpwr[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.1`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: ATUR noise margin |<p>MIB: ADSL-LINE-MIB</p><p>Noise Margin as seen by this ATU with respect to its</p><p>received signal in tenth dB. </p><p>The Info Atur fields show data acquired from the ATUR (ADSL Termination Unit – Remote), in this case the subscriber’s ADSL modem or router, during negotiation/provisioning message interchanges.</p> |SNMP |zyxel.ies500x.net.adsl.atur.snrmgn[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.1`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: ATUR attenuation |<p>MIB: ADSL-LINE-MIB</p><p>Measured difference in the total power transmitted by</p><p>the peer ATU and the total power received by this ATU. </p><p>The Info Atur fields show data acquired from the ATUR (ADSL Termination Unit – Remote), in this case the subscriber’s ADSL modem or router, during negotiation/provisioning message interchanges.</p> |SNMP |zyxel.ies500x.net.adsl.atur.atn[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.1`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Network_interfaces |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: ATUR output power |<p>MIB: ADSL-LINE-MIB</p><p>Measured total output power transmitted by this ATU. </p><p>The Info Atur fields show data acquired from the ATUR (ADSL Termination Unit – Remote), in this case the subscriber’s ADSL modem or router, during negotiation/provisioning message interchanges.</p> |SNMP |zyxel.ies500x.net.adsl.atur.outpwr[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.1`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Power_supply |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Nominal "{#ZYXEL.VOLT.NOMINAL}" |<p>MIB: ZYXEL-IES5000-MIB</p><p>The current voltage reading.</p> |SNMP |zyxel.ies500x.volt[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Status |ZYXEL IES-500x: SNMP agent availability |<p>-</p> |INTERNAL |zabbix[host,snmp,available]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Status |ZYXEL IES-500x: Uptime |<p>MIB: RFC1213-MIB</p><p>The time (in hundredths of a second) since the</p><p>network management portion of the system was last</p><p>re-initialized.</p> |SNMP |zyxel.ies500x.uptime<p>**Preprocessing**:</p><p>- MULTIPLIER: `0.01`</p> |
|Temperature |ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Temperature "{#ZYXEL.TEMP.ID}" |<p>MIB: ZYXEL-IES5000-MIB</p><p>The current temperature measured at this sensor</p> |SNMP |zyxel.ies500x.temp[{#SNMPINDEX}]<p>**Preprocessing**:</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} high CPU utilization (over {#ZYXEL.CPU.THRESH.HIGH}% for 5m) |<p>CPU utilization is too high. The system might be slow to respond.</p> |`{TEMPLATE_NAME:zyxel.ies500x.cpu[{#SNMPINDEX}].min(5m)}>{#ZYXEL.CPU.THRESH.HIGH}` |WARNING | |
|ZYXEL IES-500x: FAN{#SNMPINDEX} is in critical state |<p>Please check the fan unit</p> |`{TEMPLATE_NAME:zyxel.ies500x.fan[{#SNMPINDEX}].last()}<{#ZYXEL.FANRPM.THRESH.LOW} or {TEMPLATE_NAME:zyxel.ies500x.fan[{#SNMPINDEX}].last()}>{#ZYXEL.FANRPM.THRESH.HIGH}` |AVERAGE | |
|ZYXEL IES-500x: Template does not match hardware |<p>This template is for Zyxel IES-500x, but connected to {ITEM.VALUE}</p> |`not({TEMPLATE_NAME:zyxel.ies500x.model.last()}="IES-5000" or {TEMPLATE_NAME:zyxel.ies500x.model.last()}="IES-5005")` |INFO | |
|ZYXEL IES-500x: High memory utilization in Slot {#ZYXEL.SLOT.ID} pool (>{#ZYXEL.MEMORYHIGHTHRESH}% for 5m) |<p>The system is running out of free memory.</p> |`{TEMPLATE_NAME:zyxel.ies500x.memory[{#SNMPINDEX}].min(5m)}>{#ZYXEL.MEMORYHIGHTHRESH}` |AVERAGE | |
|ZYXEL IES-500x: High Packet buffer utilization in Slot {#ZYXEL.SLOT.ID} (>{#ZYXEL.BUFFERHIGHTHRESH}% for 5m) |<p>The system is running out of free buffer.</p> |`{TEMPLATE_NAME:zyxel.ies500x.buffer[{#SNMPINDEX}].min(5m)}>{#ZYXEL.BUFFERHIGHTHRESH}` |AVERAGE | |
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Firmware has changed |<p>Firmware version has changed. Ack to close</p> |`{TEMPLATE_NAME:zyxel.ies500x.slot.fw.ver[{#SNMPINDEX}].diff()}=1 and {TEMPLATE_NAME:zyxel.ies500x.slot.fw.ver[{#SNMPINDEX}].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Driver has changed |<p>Firmware version has changed. Ack to close</p> |`{TEMPLATE_NAME:zyxel.ies500x.slot.dv.ver[{#SNMPINDEX}].diff()}=1 and {TEMPLATE_NAME:zyxel.ies500x.slot.dv.ver[{#SNMPINDEX}].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: DSL modem code has changed |<p>Firmware version has changed. Ack to close</p> |`{TEMPLATE_NAME:zyxel.ies500x.slot.cv.ver[{#SNMPINDEX}].diff()}=1 and {TEMPLATE_NAME:zyxel.ies500x.slot.cv.ver[{#SNMPINDEX}].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} alarm |<p>The slot reported an error.</p> |`{TEMPLATE_NAME:zyxel.ies500x.slot.alarm[{#SNMPINDEX}].str("moduleNoDefect")}=0` |AVERAGE | |
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID}: Hardware version has changed |<p>Firmware version has changed. Ack to close</p> |`{TEMPLATE_NAME:zyxel.ies500x.slot.hw.ver[{#SNMPINDEX}].diff()}=1 and {TEMPLATE_NAME:zyxel.ies500x.slot.hw.ver[{#SNMPINDEX}].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} has been replaced (new serial number received) |<p>Slot {#ZYXEL.SLOT.ID} serial number has changed. Ack to close</p> |`{TEMPLATE_NAME:zyxel.ies500x.slot.serial[{#SNMPINDEX}].diff()}=1 and {TEMPLATE_NAME:zyxel.ies500x.slot.serial[{#SNMPINDEX}].strlen()}>0` |INFO |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} has been restarted (uptime < 10m) |<p>Uptime is less than 10 minutes</p> |`{TEMPLATE_NAME:zyxel.ies500x.slot.uptime[{#SNMPINDEX}].last()}<10m` |INFO |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Port {#SNMPINDEX}: Link down |<p>This trigger expression works as follows:</p><p>1. Can be triggered if operations status is down.</p><p>2. {TEMPLATE_NAME:METRIC.diff()}=1) - trigger fires only if operational status was up(1) sometime before. (So, do not fire 'ethernal off' interfaces.)</p><p>WARNING: if closed manually - won't fire again on next poll, because of .diff.</p> |`{TEMPLATE_NAME:zyxel.ies500x.net.if.operstatus[{#SNMPINDEX}].last()}=2 and {TEMPLATE_NAME:zyxel.ies500x.net.if.operstatus[{#SNMPINDEX}].diff()}=1`<p>Recovery expression:</p>`{TEMPLATE_NAME:zyxel.ies500x.net.if.operstatus[{#SNMPINDEX}].last()}<>2` |AVERAGE |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID}: Link down |<p>This trigger expression works as follows:</p><p>1. Can be triggered if operations status is down.</p><p>2. {TEMPLATE_NAME:METRIC.diff()}=1) - trigger fires only if operational status was up(1) sometime before. (So, do not fire 'ethernal off' interfaces.)</p><p>WARNING: if closed manually - won't fire again on next poll, because of .diff.</p> |`{TEMPLATE_NAME:zyxel.ies500x.net.adsl.operstatus[{#SNMPINDEX}].last()}=2 and {TEMPLATE_NAME:zyxel.ies500x.net.adsl.operstatus[{#SNMPINDEX}].diff()}=1`<p>Recovery expression:</p>`{TEMPLATE_NAME:zyxel.ies500x.net.adsl.operstatus[{#SNMPINDEX}].last()}<>2` |AVERAGE |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Low the DSL line noise margins in Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID} (<{$ZYXEL.ADSL.SNR.MIN}dB for 5m) |<p>Signal-to-noise margin (SNR Margin) which is the difference between the actual SNR and the SNR required to sync at a specific speed</p> |`{TEMPLATE_NAME:zyxel.ies500x.net.adsl.atuc.snrmgn[{#SNMPINDEX}].min(5m)}<{$ZYXEL.ADSL.SNR.MIN}` |WARNING | |
|ZYXEL IES-500x: High the DSL line attenuation in Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID} (>{$ZYXEL.ADSL.ATN.MAX}dB for 5m) |<p>The reductions in amplitude of the downstream and upstream DSL signals.</p> |`{TEMPLATE_NAME:zyxel.ies500x.net.adsl.atuc.atn[{#SNMPINDEX}].min(5m)}>{$ZYXEL.ADSL.ATN.MAX}` |WARNING | |
|ZYXEL IES-500x: Low the DSL line noise margins in Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID} (<{$ZYXEL.ADSL.SNR.MIN}dB for 5m) |<p>Signal-to-noise margin (SNR Margin) which is the difference between the actual SNR and the SNR required to sync at a specific speed</p> |`{TEMPLATE_NAME:zyxel.ies500x.net.adsl.atur.snrmgn[{#SNMPINDEX}].min(5m)}<{$ZYXEL.ADSL.SNR.MIN}` |WARNING | |
|ZYXEL IES-500x: High the DSL line attenuation in Slot {#ZYXEL.SLOT.ID} Port {#ZYXEL.PORTID} (>{$ZYXEL.ADSL.ATN.MAX}dB for 5m) |<p>The reductions in amplitude of the downstream and upstream DSL signals.</p> |`{TEMPLATE_NAME:zyxel.ies500x.net.adsl.atur.atn[{#SNMPINDEX}].min(5m)}>{$ZYXEL.ADSL.ATN.MAX}` |WARNING | |
|ZYXEL IES-500x: Voltage Slot {#ZYXEL.SLOT.ID} {#ZYXEL.VOLT.NOMINAL} is in critical state |<p>Please check the power supply</p> |`{TEMPLATE_NAME:zyxel.ies500x.volt[{#SNMPINDEX}].last()}<{#ZYXEL.VOLT.THRESH.LOW} or {TEMPLATE_NAME:zyxel.ies500x.volt[{#SNMPINDEX}].last()}>{#ZYXEL.VOLT.THRESH.HIGH}` |AVERAGE | |
|ZYXEL IES-500x: No SNMP data collection |<p>SNMP is not available for polling. Please check device connectivity and SNMP settings.</p> |`{TEMPLATE_NAME:zabbix[host,snmp,available].max({$SNMP.TIMEOUT})}=0` |WARNING | |
|ZYXEL IES-500x: has been restarted (uptime < 10m) |<p>Uptime is less than 10 minutes</p> |`{TEMPLATE_NAME:zyxel.ies500x.uptime.last()}<10m` |INFO |<p>Manual close: YES</p> |
|ZYXEL IES-500x: Temperature Slot {#ZYXEL.SLOT.ID} Sensor: {#ZYXEL.TEMP.ID} is in critical state |<p>Please check the temperature</p> |`{TEMPLATE_NAME:zyxel.ies500x.temp[{#SNMPINDEX}].last()}>{#ZYXEL.TEMP.THRESH.HIGH} or {TEMPLATE_NAME:zyxel.ies500x.temp[{#SNMPINDEX}].last()}<{#ZYXEL.TEMP.THRESH.LOW}` |AVERAGE | |

## Feedback

Please report any issues with the template at https://support.zabbix.com

You can also provide a feedback, discuss the template or ask for help with it at [ZABBIX forums](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback/422668-discussion-thread-for-official-zabbix-templates-for-zyxel).

## Known Issues

- Description: Incorrect handling of SNMP bulk requests. Disable the use of bulk requests in the SNMP interface settings.
  - Version: all versions firmware
  - Device: ZYXEL IES-500x

