/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

using System;
using Gtk;
using Gdk;
using Glade;

public class yTLangSelector {
	// Language selection Widgets
	[Widget] Gtk.Window		langWindow;
	[Widget] Gtk.Window		parentWindow;
	[Widget] Gtk.TreeView	langView;
	[Widget] Gtk.Image		imgFlag;
	[Widget] Gtk.Button		cmdApplyLang;
	private yTService		currentService;
	private yTUserProfile	currentProfile;
	private Gtk.ListStore	langStore;
	private string[] 		languagesAcro;
	private string[] 		languagesDesc;
	private int				fromWhere;
	private string			actualSelectedItem;
	
	public yTLangSelector(Gtk.Window owner,yTUserProfile usp, Gtk.Image img,yTService cs,int from){
		Glade.XML gxml = new Glade.XML (null, "yt.glade", "langWindow", null);
		gxml.Autoconnect (this);
		parentWindow = owner;
		currentProfile = usp;
		currentService = cs;
		fromWhere = from;
		imgFlag = img;
		setupData();
		setupGui();
		actualSelectedItem = "";
	}	
	
	private void setupData(){
		string ll = "ar,nl,en,fr,de,el,it,ja,ko,pt,ru,zh,es,sv";
		string ld = "Arabic,Dutch,English,French,German,Greek Modern,Italian,Japanese,Korean,"+
					"Portuguese,Russian,Simplified Chinese,Spanish,Swedish";
		languagesAcro = ll.Split(',');
		languagesDesc = ld.Split(',');
	}


	private void setupGui(){
		langWindow.Icon = new Gdk.Pixbuf(null,"yTicon.png");
		langWindow.TransientFor = parentWindow;
		langWindow.SetPosition(Gtk.WindowPosition.CenterOnParent);
		langWindow.Modal = true;
		langWindow.ShowAll();
		setupLanguageViewer();
		populateLanguageViewr();
		cmdApplyLang.Clicked+=on_cmdApplyLang_clicked;
	}	
	
	private void setupLanguageViewer(){
		TreeViewColumn col = new TreeViewColumn();
		CellRendererPixbuf pixr = new CellRendererPixbuf();
		col.PackStart(pixr, false);
		col.AddAttribute(pixr, "pixbuf", 0);
		langView.AppendColumn (col);
		col = new TreeViewColumn ();
		CellRenderer colr = new CellRendererText();
		col.PackStart(colr, true);
		col.AddAttribute (colr, "markup", 1);
		langView.AppendColumn (col);
		col = new TreeViewColumn ();
		colr = new CellRendererText();
		col.PackStart(colr, true);
		col.AddAttribute (colr, "markup", 2);
		langView.AppendColumn (col);		langStore = new ListStore (typeof (Gdk.Pixbuf),typeof(string),typeof(string));
		langView.Model = langStore;		
		langView.RowActivated+=onDoubleClicked;
		langView.Selection.Changed+=onSingleSelection;
	}
	
	private void populateLanguageViewr(){
		for(int j=0;j<languagesAcro.Length;j++){
			langStore.AppendValues(new Pixbuf(null, languagesAcro[j]+".png"),
				"<span><b>"+languagesDesc[j]+"</b></span>",languagesAcro[j]);
		}
	}
	
	private void onSingleSelection(object o, EventArgs args){
	  TreeModel model;
	  TreeIter iterSelected;
	  if(((TreeSelection)o).GetSelected (out model, out iterSelected)) {
	    actualSelectedItem = (string) model.GetValue (iterSelected, 2);
	  }
	} 	
	
	private void on_cmdApplyLang_clicked(object sender, EventArgs e) {
		if(actualSelectedItem!="") {
			imgFlag.Pixbuf = new Pixbuf(null, actualSelectedItem+".png");
			if(fromWhere==1) {
				currentProfile.Language1 = actualSelectedItem;
				currentService.Language1 = actualSelectedItem;
			}
			else if(fromWhere==2) {
				currentProfile.Language2 = actualSelectedItem;
				currentService.Language2 = actualSelectedItem;
			}
		}
		langWindow.Destroy();
	}	
	
	private void  onDoubleClicked(object o, EventArgs args){
		string selectedItem="";
		TreeIter iter = new TreeIter();
		langStore.GetIterFirst(out iter);
		if (langView.Selection.IterIsSelected(iter)) {
			selectedItem = (string)langStore.GetValue(iter, 2);
		}
		while(langStore.IterNext(ref iter)) {
			if(langView.Selection.IterIsSelected(iter)) {
				selectedItem = (string)langStore.GetValue(iter, 2);
			}
		}
		imgFlag.Pixbuf = new Pixbuf(null, selectedItem+".png");
		if(fromWhere==1) {
			currentProfile.Language1 = selectedItem;
			currentService.Language1 = selectedItem;
		}
		else if(fromWhere==2) {
			currentProfile.Language2 = selectedItem;
			currentService.Language2 = selectedItem;
		}
		langWindow.Destroy();
	}	
	
	
}