/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name: blocke.c
 * Abstract:	Block extension word set
 */

#include <stdio.h>
#include "yforth.h"
#include "core.h"
#include "coree.h"
#include "block.h"
#include "blocke.h"

/**************************************************************************/
/* VARIABLES ************** ***********************************************/
/**************************************************************************/

UCell _s_c_r;

/**************************************************************************/
/* WORDS ****************** ***********************************************/
/**************************************************************************/

void _empty_buffers() {
	register int i;
	for (i = 0; i < NUM_BLOCKS; i++) block_data[i].block_no = 0;
}

void _list() {
	register Char *buffer;
	register int i;
	_block();
	buffer = (Char *) *sp++;
	for (i = 0; i < BLOCK_SIZE; i += 64) {
		*--sp = i / 64;
		*--sp = 2;
		_dot_r();
		*--sp = ':';
		_emit();
		_b_l();
		_emit();
		*--sp = (Cell) buffer + i;
		*--sp = 64;
		_type();
		_c_r();
	}
}

void _thru() {
	register UCell u2 = (UCell) *sp++;
	register UCell u1 = (UCell) *sp++;
	for (; u1 <= u2; u1++) {
		*--sp = u1;
		_load();
	}
}


