/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Event;
import java.awt.Graphics;
import java.io.InputStream;
import java.net.URL;

public class ThreeD
extends Applet
implements Runnable {
    Model3D md;
    boolean painted = true;
    float xfac;
    int prevx;
    int prevy;
    float xtheta;
    float ytheta;
    float scalefudge = 1.0f;
    Matrix3D amat = new Matrix3D();
    Matrix3D tmat = new Matrix3D();
    String mdname = null;
    String message = null;

    public void init() {
        this.mdname = this.getParameter("model");
        try {
            this.scalefudge = Float.valueOf(this.getParameter("scale")).floatValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.amat.yrot(20.0);
        this.amat.xrot(20.0);
        if (this.mdname == null) {
            this.mdname = "model.obj";
        }
        this.resize(this.size().width <= 20 ? 400 : this.size().width, this.size().height <= 20 ? 400 : this.size().height);
    }

    public void run() {
        InputStream inputStream = null;
        try {
            float f;
            float f2;
            Model3D model3D;
            Thread.currentThread().setPriority(1);
            inputStream = new URL(this.getDocumentBase(), this.mdname).openStream();
            this.md = model3D = new Model3D(inputStream);
            model3D.findBB();
            model3D.compress();
            float f3 = model3D.xmax - model3D.xmin;
            float f4 = model3D.ymax - model3D.ymin;
            float f5 = model3D.zmax - model3D.zmin;
            if (f4 > f3) {
                f3 = f4;
            }
            if (f5 > f3) {
                f3 = f5;
            }
            this.xfac = 0.7f * ((f2 = (float)this.size().width / f3) < (f = (float)this.size().height / f3) ? f2 : f) * this.scalefudge;
        }
        catch (Exception exception) {
            this.md = null;
            this.message = exception.toString();
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    public void start() {
        if (this.md == null && this.message == null) {
            new Thread(this).start();
        }
    }

    public void stop() {
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.tmat.unit();
        float f = (float)(this.prevy - n2) * 360.0f / (float)this.size().width;
        float f2 = (float)(n - this.prevx) * 360.0f / (float)this.size().height;
        this.tmat.xrot(f);
        this.tmat.yrot(f2);
        this.amat.mult(this.tmat);
        if (this.painted) {
            this.painted = false;
            this.repaint();
        }
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / 2.0f, -(this.md.ymin + this.md.ymax) / 2.0f, -(this.md.zmin + this.md.zmax) / 2.0f);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 16.0f * this.xfac / (float)this.size().width);
            this.md.mat.translate(this.size().width / 2, this.size().height / 2, 8.0f);
            this.md.transformed = false;
            this.md.paint(graphics);
            this.setPainted();
        } else if (this.message != null) {
            graphics.drawString("Error in model:", 3, 20);
            graphics.drawString(this.message, 10, 40);
        }
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }
}

