# -*- coding: utf-8 -*-
# Copyright (C) 2008-2009  Warp Networks, S.L.
# Author:  Pablo Martí
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
"""unittests for resolvconf module"""

import os
import tempfile
import sys

from twisted.trial import unittest

sys.path.insert(0, '..')
from core.resolvconf import NamedManager
from wader.common.utils import get_file_data


class ResolvconfTestCase(unittest.TestCase):
    """Test-suite for resolvconf module"""

    def setUp(self):
        self.path = tempfile.mkstemp()[1]
        self.named_manager = NamedManager(self.path)

    def tearDown(self):
        del self.named_manager
        os.unlink(self.path)

    def test_add_dns_info(self):
        expected = """# Generated by Wader
nameserver 10.0.0.1
nameserver 10.0.0.2
"""
        self.named_manager.add_dns_info(["10.0.0.1", "10.0.0.2"])
        self.assertEqual(expected, get_file_data(self.path))

    def test_delete_dns_info(self):
        expected = """# Generated by Wader
nameserver 10.0.0.1
nameserver 10.0.0.2
"""
        self.named_manager.add_dns_info(["10.0.0.1", "10.0.0.2"])
        self.assertEqual(expected, get_file_data(self.path))
        self.named_manager.delete_dns_info(["10.0.0.1", "10.0.0.2"])
        self.assertEqual("", get_file_data(self.path))
