#!/bin/sh

VERSION=$2
TAG=$(echo $VERSION | sed s/\\.//g)
DIR=visualvm-$VERSION
TAR=../visualvm_$VERSION.orig.tar.xz

rm -Rf github.com $DIR

# Download the tarballs
wget --no-verbose --recursive --level 1 -e robots=off \
     --accept 'netbeans-profiler-visualvm_release*' \
     https://github.com/visualvm/visualvm.src/releases/tag/$VERSION

# Extract the source files
mkdir $DIR
mkdir $DIR/netbeans
tar -xf $3 --strip-components 1 -C $DIR
tar -xf github.com/visualvm/visualvm.src/releases/download/$VERSION/netbeans-profiler-visualvm_release*.tar.gz -C $DIR/netbeans
rm $3

# Add a file in the empty directories to preserve them in Git (the build fails otherwise)
for dir in $(find ./$DIR -type d -regex ``./[^.].*'' -empty); do touch $dir"/.gitignore"; done;

# Build the upstream tarball
XZ_OPT=--best tar -cJf $TAR --exclude '*.exe' --exclude 'plugins/*' $DIR

rm -Rf $DIR github.com
