/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef INPUTPWDDIALOG_H
#define INPUTPWDDIALOG_H
#include <QDialog>
#include <QVBoxLayout>
#include <QGSettings>
#include <QLabel>
#include <QLineEdit>
#include <QDBusInterface>
#include "vinoui.h"


namespace Ui {
class InputPwdDialog;
}
class InputPwdDialog : public QDialog
{
    Q_OBJECT

public:
    InputPwdDialog(QWidget *parent = nullptr);
    ~InputPwdDialog();


private:
    QPushButton *mCancelBtn;
    QPushButton *mConfirmBtn;

    QLabel *mHintLabel;
    QLineEdit *mPwdLineEdit;
    QByteArray secPwd;
    bool mFirstload;

    bool mStatus;
    QDBusInterface *mVinoDBus;

private:
    void initUi();
    void initConnect();
    bool eventFilter(QObject *wcg, QEvent *event);

private slots:
    void mPwdLineEditInputSlot(const QString &pwd);


};


#endif // INPUTPWDDIALOG_H
