/*
    		 Crown Copyright (c) 1997
    
    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-
    
        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;
    
        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;
    
        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;
    
        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/


/* AUTOMATICALLY GENERATED BY make_tdf VERSION 2.0 FROM TDF 4.1 */

#include "config.h"
#include "common_types.h"
#include "basicread.h"
#include "ecodes.h"
#include "externs.h"
#include "messages_r.h"
#include "main_reads.h"
#include "check.h"


/* REPORT AN ERROR */

static void decode_error
    PROTO_N ( ( s ) )
    PROTO_T ( char *s )
{
    failer ( s ) ;
    exit ( EXIT_FAILURE ) ;
}


/* DECODE ACCESS */

access d_access
    PROTO_Z ()
{
    int code = get_big_code ( 4 ) ;
    switch ( code ) {
	case e_access_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_access_apply_token ( p0, p1 ) ) ;
	}
	case e_access_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_access_cond ( p0, p1, p2 ) ) ;
	}
	case e_add_accesses : {
	    access p0 ;
	    access p1 ;
	    p0 = d_access () ;
	    p1 = d_access () ;
	    return ( f_add_accesses ( p0, p1 ) ) ;
	}
	case e_constant : {
	    return ( f_constant ) ;
	}
	case e_long_jump_access : {
	    return ( f_long_jump_access ) ;
	}
	case e_no_other_read : {
	    return ( f_no_other_read ) ;
	}
	case e_no_other_write : {
	    return ( f_no_other_write ) ;
	}
	case e_out_par : {
	    return ( f_out_par ) ;
	}
	case e_preserve : {
	    return ( f_preserve ) ;
	}
	case e_register : {
	    return ( f_register ) ;
	}
	case e_standard_access : {
	    return ( f_standard_access ) ;
	}
	case e_used_as_volatile : {
	    return ( f_used_as_volatile ) ;
	}
	case e_visible : {
	    return ( f_visible ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_access ) ;
    return ( f_dummy_access ) ;
}


/* DECODE ACCESS_OPTION */

access_option d_access_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	access e ;
	e = d_access () ;
	return ( yes_access_option ( e ) ) ;
    }
    return ( no_access_option ) ;
}


/* DECODE AL_TAG */

al_tag d_al_tag
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_al_tag_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_al_tag_apply_token ( p0, p1 ) ) ;
	}
	case e_make_al_tag : {
	    tdfint p0 ;
	    p0 = d_tdfint () ;
	    return ( f_make_al_tag ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_al_tag ) ;
    return ( f_dummy_al_tag ) ;
}


/* DECODE AL_TAGDEF */

al_tagdef d_al_tagdef
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_al_tagdef : {
	    tdfint p0 ;
	    alignment p1 ;
	    p0 = d_tdfint () ;
	    p1 = d_alignment () ;
	    return ( f_make_al_tagdef ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_al_tagdef ) ;
    return ( f_dummy_al_tagdef ) ;
}


/* DECODE AL_TAGDEF_LIST */

al_tagdef_list d_al_tagdef_list
    PROTO_Z ()
{
    int i, n ;
    al_tagdef_list temp ;
    n = small_dtdfint () ;
    temp = new_al_tagdef_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	al_tagdef e ;
	e = d_al_tagdef () ;
	temp = add_al_tagdef_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE AL_TAGDEF_PROPS */

al_tagdef_props d_al_tagdef_props
    PROTO_Z ()
{
    tdfint p0 ;
    al_tagdef_list p1 ;
    p0 = d_tdfint () ;
    p1 = d_al_tagdef_list () ;
    return ( f_make_al_tagdefs ( p0, p1 ) ) ;
}


/* DECODE ALIGNMENT */

alignment d_alignment
    PROTO_Z ()
{
    int code = get_big_code ( 4 ) ;
    switch ( code ) {
	case e_alignment_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_alignment_apply_token ( p0, p1 ) ) ;
	}
	case e_alignment_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_alignment_cond ( p0, p1, p2 ) ) ;
	}
	case e_alignment : {
	    shape p0 ;
	    p0 = d_shape () ;
	    return ( f_alignment ( p0 ) ) ;
	}
	case e_alloca_alignment : {
	    return ( f_alloca_alignment ) ;
	}
	case e_callees_alignment : {
	    bool p0 ;
	    p0 = d_bool () ;
	    return ( f_callees_alignment ( p0 ) ) ;
	}
	case e_callers_alignment : {
	    bool p0 ;
	    p0 = d_bool () ;
	    return ( f_callers_alignment ( p0 ) ) ;
	}
	case e_code_alignment : {
	    return ( f_code_alignment ) ;
	}
	case e_locals_alignment : {
	    return ( f_locals_alignment ) ;
	}
	case e_obtain_al_tag : {
	    al_tag p0 ;
	    p0 = d_al_tag () ;
	    return ( f_obtain_al_tag ( p0 ) ) ;
	}
	case e_parameter_alignment : {
	    shape p0 ;
	    p0 = d_shape () ;
	    return ( f_parameter_alignment ( p0 ) ) ;
	}
	case e_unite_alignments : {
	    alignment p0 ;
	    alignment p1 ;
	    p0 = d_alignment () ;
	    p1 = d_alignment () ;
	    return ( f_unite_alignments ( p0, p1 ) ) ;
	}
	case e_var_param_alignment : {
	    return ( f_var_param_alignment ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_alignment ) ;
    return ( f_dummy_alignment ) ;
}


/* DECODE BITFIELD_VARIETY */

bitfield_variety d_bitfield_variety
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_bfvar_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_bfvar_apply_token ( p0, p1 ) ) ;
	}
	case e_bfvar_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_bfvar_cond ( p0, p1, p2 ) ) ;
	}
	case e_bfvar_bits : {
	    bool p0 ;
	    nat p1 ;
	    p0 = d_bool () ;
	    p1 = d_nat () ;
	    return ( f_bfvar_bits ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_bitfield_variety ) ;
    return ( f_dummy_bitfield_variety ) ;
}


/* DECODE BOOL */

bool d_bool
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_bool_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_bool_apply_token ( p0, p1 ) ) ;
	}
	case e_bool_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_bool_cond ( p0, p1, p2 ) ) ;
	}
	case e_false : {
	    return ( f_false ) ;
	}
	case e_true : {
	    return ( f_true ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_bool ) ;
    return ( f_dummy_bool ) ;
}


/* DECODE BOOL_OPTION */

bool_option d_bool_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	bool e ;
	e = d_bool () ;
	return ( yes_bool_option ( e ) ) ;
    }
    return ( no_bool_option ) ;
}


/* DECODE CALLEES */

callees d_callees
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_make_callee_list : {
	    exp_list p0 ;
	    p0 = d_exp_list () ;
	    return ( f_make_callee_list ( p0 ) ) ;
	}
	case e_make_dynamic_callees : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_make_dynamic_callees ( p0, p1 ) ) ;
	}
	case e_same_callees : {
	    return ( f_same_callees ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_callees ) ;
    return ( f_dummy_callees ) ;
}


/* DECODE CAPSULE */

capsule d_capsule
    PROTO_Z ()
{
    tdfident_list p0 ;
    capsule_link_list p1 ;
    extern_link_list p2 ;
    group_list p3 ;
    p0 = d_tdfident_list () ;
    p1 = d_capsule_link_list () ;
    start_make_capsule ( p0, p1 ) ;
    p2 = d_extern_link_list () ;
    p3 = d_group_list () ;
    return ( f_make_capsule ( p0, p1, p2, p3 ) ) ;
}


/* DECODE CAPSULE_LINK */

capsule_link d_capsule_link
    PROTO_Z ()
{
    tdfident p0 ;
    tdfint p1 ;
    p0 = d_tdfident () ;
    p1 = d_tdfint () ;
    return ( f_make_capsule_link ( p0, p1 ) ) ;
}


/* DECODE CAPSULE_LINK_LIST */

capsule_link_list d_capsule_link_list
    PROTO_Z ()
{
    int i, n ;
    capsule_link_list temp ;
    n = small_dtdfint () ;
    temp = new_capsule_link_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	capsule_link e ;
	e = d_capsule_link () ;
	temp = add_capsule_link_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE CASELIM */

caselim d_caselim
    PROTO_Z ()
{
    label p0 ;
    signed_nat p1 ;
    signed_nat p2 ;
    p0 = d_label () ;
    p1 = d_signed_nat () ;
    p2 = d_signed_nat () ;
    return ( f_make_caselim ( p0, p1, p2 ) ) ;
}


/* DECODE CASELIM_LIST */

caselim_list d_caselim_list
    PROTO_Z ()
{
    int i, n ;
    caselim_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_caselim_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	caselim e ;
	e = d_caselim () ;
	temp = add_caselim_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG */

dg d_dg
    PROTO_Z ()
{
    int code = get_big_code ( 6 ) ;
    switch ( code ) {
	case e_dg_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_dg_apply_token ( p0, p1 ) ) ;
	}
	case e_make_tag_dg : {
	    dg_tag p0 ;
	    dg p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg () ;
	    return ( f_make_tag_dg ( p0, p1 ) ) ;
	}
	case e_abortable_part_dg : {
	    dg_sourcepos p0 ;
	    bool p1 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_bool () ;
	    return ( f_abortable_part_dg ( p0, p1 ) ) ;
	}
	case e_accept_dg : {
	    dg_sourcepos p0 ;
	    dg_tag p1 ;
	    dg_name_list p2 ;
	    bool p3 ;
	    dg_tag_option p4 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_tag () ;
	    p2 = d_dg_name_list () ;
	    p3 = d_bool () ;
	    p4 = d_dg_tag_option () ;
	    return ( f_accept_dg ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_barrier_dg : {
	    dg_sourcepos p0 ;
	    dg_tag p1 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_tag () ;
	    return ( f_barrier_dg ( p0, p1 ) ) ;
	}
	case e_branch_dg : {
	    dg_sourcepos p0 ;
	    p0 = d_dg_sourcepos () ;
	    return ( f_branch_dg ( p0 ) ) ;
	}
	case e_call_dg : {
	    dg_idname_option p0 ;
	    dg_sourcepos p1 ;
	    nat_option p2 ;
	    dg_tag_option p3 ;
	    dg_tag_option p4 ;
	    p0 = d_dg_idname_option () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_nat_option () ;
	    p3 = d_dg_tag_option () ;
	    p4 = d_dg_tag_option () ;
	    return ( f_call_dg ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_compilation_dg : {
	    dg_tag p0 ;
	    p0 = d_dg_tag () ;
	    return ( f_compilation_dg ( p0 ) ) ;
	}
	case e_destructor_dg : {
	    dg_sourcepos p0 ;
	    exp_option p1 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_exp_option () ;
	    return ( f_destructor_dg ( p0, p1 ) ) ;
	}
	case e_exception_handler_dg : {
	    dg_name_option p0 ;
	    p0 = d_dg_name_option () ;
	    return ( f_exception_handler_dg ( p0 ) ) ;
	}
	case e_exception_scope_dg : {
	    dg_tag_list p0 ;
	    p0 = d_dg_tag_list () ;
	    return ( f_exception_scope_dg ( p0 ) ) ;
	}
	case e_inline_call_dg : {
	    dg_tag p0 ;
	    dg_name_list p1 ;
	    nat_option p2 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_name_list () ;
	    p2 = d_nat_option () ;
	    return ( f_inline_call_dg ( p0, p1, p2 ) ) ;
	}
	case e_inline_result_dg : {
	    dg_tag p0 ;
	    p0 = d_dg_tag () ;
	    return ( f_inline_result_dg ( p0 ) ) ;
	}
	case e_inlined_dg : {
	    dg p0 ;
	    dg_tag p1 ;
	    p0 = d_dg () ;
	    p1 = d_dg_tag () ;
	    return ( f_inlined_dg ( p0, p1 ) ) ;
	}
	case e_jump_dg : {
	    dg_sourcepos p0 ;
	    p0 = d_dg_sourcepos () ;
	    return ( f_jump_dg ( p0 ) ) ;
	}
	case e_label_dg : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    return ( f_label_dg ( p0, p1 ) ) ;
	}
	case e_lexical_block_dg : {
	    dg_idname_option p0 ;
	    dg_sourcepos p1 ;
	    p0 = d_dg_idname_option () ;
	    p1 = d_dg_sourcepos () ;
	    return ( f_lexical_block_dg ( p0, p1 ) ) ;
	}
	case e_list_dg : {
	    dg_list p0 ;
	    p0 = d_dg_list () ;
	    return ( f_list_dg ( p0 ) ) ;
	}
	case e_long_jump_dg : {
	    dg_sourcepos p0 ;
	    p0 = d_dg_sourcepos () ;
	    return ( f_long_jump_dg ( p0 ) ) ;
	}
	case e_name_decl_dg : {
	    dg_name p0 ;
	    p0 = d_dg_name () ;
	    return ( f_name_decl_dg ( p0 ) ) ;
	}
	case e_params_dg : {
	    dg_name_list p0 ;
	    exp_option p1 ;
	    p0 = d_dg_name_list () ;
	    p1 = d_exp_option () ;
	    return ( f_params_dg ( p0, p1 ) ) ;
	}
	case e_raise_dg : {
	    dg_sourcepos p0 ;
	    dg_type_option p1 ;
	    exp_option p2 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_type_option () ;
	    p2 = d_exp_option () ;
	    return ( f_raise_dg ( p0, p1, p2 ) ) ;
	}
	case e_requeue_dg : {
	    dg_sourcepos p0 ;
	    dg_tag p1 ;
	    bool p2 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_tag () ;
	    p2 = d_bool () ;
	    return ( f_requeue_dg ( p0, p1, p2 ) ) ;
	}
	case e_rts_call_dg : {
	    dg_sourcepos p0 ;
	    nat p1 ;
	    dg_tag_option p2 ;
	    dg_tag_option p3 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_nat () ;
	    p2 = d_dg_tag_option () ;
	    p3 = d_dg_tag_option () ;
	    return ( f_rts_call_dg ( p0, p1, p2, p3 ) ) ;
	}
	case e_select_dg : {
	    dg_sourcepos p0 ;
	    bool p1 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_bool () ;
	    return ( f_select_dg ( p0, p1 ) ) ;
	}
	case e_select_alternative_dg : {
	    dg_sourcepos p0 ;
	    nat p1 ;
	    bool p2 ;
	    exp p3 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_nat () ;
	    p2 = d_bool () ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_select_alternative_dg ( p0, p1, p2, p3 ) ) ;
	}
	case e_select_guard_dg : {
	    dg_sourcepos p0 ;
	    dg_tag p1 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_tag () ;
	    return ( f_select_guard_dg ( p0, p1 ) ) ;
	}
	case e_singlestep_dg : {
	    dg_sourcepos p0 ;
	    p0 = d_dg_sourcepos () ;
	    return ( f_singlestep_dg ( p0 ) ) ;
	}
	case e_source_language_dg : {
	    nat p0 ;
	    p0 = d_nat () ;
	    return ( f_source_language_dg ( p0 ) ) ;
	}
	case e_sourcepos_dg : {
	    dg_sourcepos p0 ;
	    p0 = d_dg_sourcepos () ;
	    return ( f_sourcepos_dg ( p0 ) ) ;
	}
	case e_statement_part_dg : {
	    dg_tag p0 ;
	    p0 = d_dg_tag () ;
	    return ( f_statement_part_dg ( p0 ) ) ;
	}
	case e_test_dg : {
	    dg_sourcepos p0 ;
	    bool p1 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_bool () ;
	    return ( f_test_dg ( p0, p1 ) ) ;
	}
	case e_triggering_alternative_dg : {
	    dg_sourcepos p0 ;
	    nat p1 ;
	    bool p2 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_nat () ;
	    p2 = d_bool () ;
	    return ( f_triggering_alternative_dg ( p0, p1, p2 ) ) ;
	}
	case e_with_dg : {
	    dg_type p0 ;
	    exp p1 ;
	    p0 = d_dg_type () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_with_dg ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg ) ;
    return ( f_dummy_dg ) ;
}


/* DECODE DG_ACCESSIBILITY */

dg_accessibility d_dg_accessibility
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_local_accessibility : {
	    return ( f_dg_local_accessibility ) ;
	}
	case e_dg_private_accessibility : {
	    return ( f_dg_private_accessibility ) ;
	}
	case e_dg_protected_accessibility : {
	    return ( f_dg_protected_accessibility ) ;
	}
	case e_dg_public_accessibility : {
	    return ( f_dg_public_accessibility ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_accessibility ) ;
    return ( f_dummy_dg_accessibility ) ;
}


/* DECODE DG_ACCESSIBILITY_OPTION */

dg_accessibility_option d_dg_accessibility_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_accessibility e ;
	e = d_dg_accessibility () ;
	return ( yes_dg_accessibility_option ( e ) ) ;
    }
    return ( no_dg_accessibility_option ) ;
}


/* DECODE DG_APPEND */

dg_append d_dg_append
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_dg_name_append : {
	    dg_tag p0 ;
	    dg_name p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_name () ;
	    return ( f_dg_name_append ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_append ) ;
    return ( f_dummy_dg_append ) ;
}


/* DECODE DG_APPEND_LIST */

dg_append_list d_dg_append_list
    PROTO_Z ()
{
    int i, n ;
    dg_append_list temp ;
    n = small_dtdfint () ;
    temp = new_dg_append_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_append e ;
	e = d_dg_append () ;
	temp = add_dg_append_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_BOUND */

dg_bound d_dg_bound
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_dynamic_bound : {
	    dg_tag p0 ;
	    shape p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_shape () ;
	    return ( f_dg_dynamic_bound ( p0, p1 ) ) ;
	}
	case e_dg_static_bound : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_dg_static_bound ( p0 ) ) ;
	}
	case e_dg_unknown_bound : {
	    shape p0 ;
	    p0 = d_shape () ;
	    return ( f_dg_unknown_bound ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_bound ) ;
    return ( f_dummy_dg_bound ) ;
}


/* DECODE DG_CLASS_BASE */

dg_class_base d_dg_class_base
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_dg_class_base : {
	    dg_tag p0 ;
	    dg_sourcepos_option p1 ;
	    token_option p2 ;
	    dg_accessibility_option p3 ;
	    dg_virtuality_option p4 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_sourcepos_option () ;
	    p2 = d_token_option () ;
	    p3 = d_dg_accessibility_option () ;
	    p4 = d_dg_virtuality_option () ;
	    return ( f_make_dg_class_base ( p0, p1, p2, p3, p4 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_class_base ) ;
    return ( f_dummy_dg_class_base ) ;
}


/* DECODE DG_CLASS_BASE_LIST */

dg_class_base_list d_dg_class_base_list
    PROTO_Z ()
{
    int i, n ;
    dg_class_base_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_class_base_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_class_base e ;
	e = d_dg_class_base () ;
	temp = add_dg_class_base_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_CLASSMEM */

dg_classmem d_dg_classmem
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_dg_tag_classmem : {
	    dg_tag p0 ;
	    dg_classmem p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_classmem () ;
	    return ( f_dg_tag_classmem ( p0, p1 ) ) ;
	}
	case e_dg_field_classmem : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    exp p2 ;
	    dg_type p3 ;
	    dg_accessibility_option p4 ;
	    bool_option p5 ;
	    dg_default_option p6 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = d_dg_type () ;
	    p4 = d_dg_accessibility_option () ;
	    p5 = d_bool_option () ;
	    p6 = d_dg_default_option () ;
	    return ( f_dg_field_classmem ( p0, p1, p2, p3, p4, p5, p6 ) ) ;
	}
	case e_dg_function_classmem : {
	    dg_name p0 ;
	    exp_option p1 ;
	    p0 = d_dg_name () ;
	    p1 = d_exp_option () ;
	    return ( f_dg_function_classmem ( p0, p1 ) ) ;
	}
	case e_dg_indirect_classmem : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    token p2 ;
	    dg_type p3 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_token () ;
	    p3 = d_dg_type () ;
	    return ( f_dg_indirect_classmem ( p0, p1, p2, p3 ) ) ;
	}
	case e_dg_name_classmem : {
	    dg_name p0 ;
	    p0 = d_dg_name () ;
	    return ( f_dg_name_classmem ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_classmem ) ;
    return ( f_dummy_dg_classmem ) ;
}


/* DECODE DG_CLASSMEM_LIST */

dg_classmem_list d_dg_classmem_list
    PROTO_Z ()
{
    int i, n ;
    dg_classmem_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_classmem_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_classmem e ;
	e = d_dg_classmem () ;
	temp = add_dg_classmem_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_COMP_PROPS */

dg_comp_props d_dg_comp_props
    PROTO_Z ()
{
    tdfint p0 ;
    dg_compilation p1 ;
    dg_append_list p2 ;
    p0 = d_tdfint () ;
    p1 = d_dg_compilation () ;
    p2 = d_dg_append_list () ;
    return ( f_make_dg_compunit ( p0, p1, p2 ) ) ;
}


/* DECODE DG_COMPILATION */

dg_compilation d_dg_compilation
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_tag_compilation : {
	    dg_tag p0 ;
	    dg_compilation p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_compilation () ;
	    return ( f_dg_tag_compilation ( p0, p1 ) ) ;
	}
	case e_make_dg_compilation : {
	    dg_filename p0 ;
	    string_list p1 ;
	    dg_macro_list p2 ;
	    dg_filename p3 ;
	    nat p4 ;
	    nat p5 ;
	    nat p6 ;
	    string p7 ;
	    string_list p8 ;
	    dg_namelist p9 ;
	    p0 = d_dg_filename () ;
	    p1 = d_string_list () ;
	    p2 = d_dg_macro_list () ;
	    p3 = d_dg_filename () ;
	    p4 = d_nat () ;
	    p5 = d_nat () ;
	    p6 = d_nat () ;
	    p7 = d_string () ;
	    p8 = d_string_list () ;
	    p9 = d_dg_namelist () ;
	    return ( f_make_dg_compilation ( p0, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_compilation ) ;
    return ( f_dummy_dg_compilation ) ;
}


/* DECODE DG_CONSTRAINT */

dg_constraint d_dg_constraint
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_type_constraint : {
	    dg_tag_option p0 ;
	    dg_type p1 ;
	    p0 = d_dg_tag_option () ;
	    p1 = d_dg_type () ;
	    return ( f_dg_type_constraint ( p0, p1 ) ) ;
	}
	case e_dg_value_constraint : {
	    dg_tag_option p0 ;
	    exp p1 ;
	    p0 = d_dg_tag_option () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_dg_value_constraint ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_constraint ) ;
    return ( f_dummy_dg_constraint ) ;
}


/* DECODE DG_CONSTRAINT_LIST */

dg_constraint_list d_dg_constraint_list
    PROTO_Z ()
{
    int i, n ;
    dg_constraint_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_constraint_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_constraint e ;
	e = d_dg_constraint () ;
	temp = add_dg_constraint_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_CONSTRAINT_LIST_OPTION */

dg_constraint_list_option d_dg_constraint_list_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_constraint_list e ;
	e = d_dg_constraint_list () ;
	return ( yes_dg_constraint_list_option ( e ) ) ;
    }
    return ( no_dg_constraint_list_option ) ;
}


/* DECODE DG_DEFAULT */

dg_default d_dg_default
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_dg_default : {
	    exp_option p0 ;
	    dg_sourcepos_option p1 ;
	    p0 = d_exp_option () ;
	    p1 = d_dg_sourcepos_option () ;
	    return ( f_make_dg_default ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_default ) ;
    return ( f_dummy_dg_default ) ;
}


/* DECODE DG_DEFAULT_OPTION */

dg_default_option d_dg_default_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_default e ;
	e = d_dg_default () ;
	return ( yes_dg_default_option ( e ) ) ;
    }
    return ( no_dg_default_option ) ;
}


/* DECODE DG_DIM */

dg_dim d_dg_dim
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_dg_dim_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_dg_dim_apply_token ( p0, p1 ) ) ;
	}
	case e_dg_tag_dim : {
	    dg_tag p0 ;
	    dg_dim p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_dim () ;
	    return ( f_dg_tag_dim ( p0, p1 ) ) ;
	}
	case e_dg_bounds_dim : {
	    dg_bound p0 ;
	    dg_bound p1 ;
	    dg_type p2 ;
	    p0 = d_dg_bound () ;
	    p1 = d_dg_bound () ;
	    p2 = d_dg_type () ;
	    return ( f_dg_bounds_dim ( p0, p1, p2 ) ) ;
	}
	case e_dg_count_dim : {
	    dg_bound p0 ;
	    dg_bound p1 ;
	    dg_type p2 ;
	    p0 = d_dg_bound () ;
	    p1 = d_dg_bound () ;
	    p2 = d_dg_type () ;
	    return ( f_dg_count_dim ( p0, p1, p2 ) ) ;
	}
	case e_dg_type_dim : {
	    dg_type p0 ;
	    nat_option p1 ;
	    p0 = d_dg_type () ;
	    p1 = d_nat_option () ;
	    return ( f_dg_type_dim ( p0, p1 ) ) ;
	}
	case e_dg_unspecified_dim : {
	    return ( f_dg_unspecified_dim ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_dim ) ;
    return ( f_dummy_dg_dim ) ;
}


/* DECODE DG_DIM_LIST */

dg_dim_list d_dg_dim_list
    PROTO_Z ()
{
    int i, n ;
    dg_dim_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_dim_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_dim e ;
	e = d_dg_dim () ;
	temp = add_dg_dim_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_DIM_OPTION */

dg_dim_option d_dg_dim_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_dim e ;
	e = d_dg_dim () ;
	return ( yes_dg_dim_option ( e ) ) ;
    }
    return ( no_dg_dim_option ) ;
}


/* DECODE DG_DISCRIM */

dg_discrim d_dg_discrim
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_dg_discrim : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_make_dg_discrim ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_discrim ) ;
    return ( f_dummy_dg_discrim ) ;
}


/* DECODE DG_DISCRIM_LIST */

dg_discrim_list d_dg_discrim_list
    PROTO_Z ()
{
    int i, n ;
    dg_discrim_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_discrim_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_discrim e ;
	e = d_dg_discrim () ;
	temp = add_dg_discrim_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_ENUM */

dg_enum d_dg_enum
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_tag_enum : {
	    dg_tag p0 ;
	    dg_enum p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_enum () ;
	    return ( f_dg_tag_enum ( p0, p1 ) ) ;
	}
	case e_make_dg_enum : {
	    exp p0 ;
	    dg_idname p1 ;
	    dg_sourcepos p2 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = d_dg_idname () ;
	    p2 = d_dg_sourcepos () ;
	    return ( f_make_dg_enum ( p0, p1, p2 ) ) ;
	}
	case e_dg_char_enum : {
	    exp p0 ;
	    nat p1 ;
	    dg_sourcepos p2 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = d_nat () ;
	    p2 = d_dg_sourcepos () ;
	    return ( f_dg_char_enum ( p0, p1, p2 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_enum ) ;
    return ( f_dummy_dg_enum ) ;
}


/* DECODE DG_ENUM_LIST */

dg_enum_list d_dg_enum_list
    PROTO_Z ()
{
    int i, n ;
    dg_enum_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_enum_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_enum e ;
	e = d_dg_enum () ;
	temp = add_dg_enum_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_FILENAME */

dg_filename d_dg_filename
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_filename_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_dg_filename_apply_token ( p0, p1 ) ) ;
	}
	case e_make_dg_filename : {
	    nat p0 ;
	    string p1 ;
	    string p2 ;
	    string p3 ;
	    p0 = d_nat () ;
	    p1 = d_string () ;
	    p2 = d_string () ;
	    p3 = d_string () ;
	    return ( f_make_dg_filename ( p0, p1, p2, p3 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_filename ) ;
    return ( f_dummy_dg_filename ) ;
}


/* DECODE DG_FILENAME_OPTION */

dg_filename_option d_dg_filename_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_filename e ;
	e = d_dg_filename () ;
	return ( yes_dg_filename_option ( e ) ) ;
    }
    return ( no_dg_filename_option ) ;
}


/* DECODE DG_IDNAME */

dg_idname d_dg_idname
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_dg_idname_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_dg_idname_apply_token ( p0, p1 ) ) ;
	}
	case e_dg_anonymous_idname : {
	    string_option p0 ;
	    p0 = d_string_option () ;
	    return ( f_dg_anonymous_idname ( p0 ) ) ;
	}
	case e_dg_artificial_idname : {
	    string_option p0 ;
	    p0 = d_string_option () ;
	    return ( f_dg_artificial_idname ( p0 ) ) ;
	}
	case e_dg_external_idname : {
	    string p0 ;
	    p0 = d_string () ;
	    return ( f_dg_external_idname ( p0 ) ) ;
	}
	case e_dg_instance_idname : {
	    dg_idname_option p0 ;
	    dg_idname p1 ;
	    dg_sourcepos p2 ;
	    dg_name_list p3 ;
	    p0 = d_dg_idname_option () ;
	    p1 = d_dg_idname () ;
	    p2 = d_dg_sourcepos () ;
	    p3 = d_dg_name_list () ;
	    return ( f_dg_instance_idname ( p0, p1, p2, p3 ) ) ;
	}
	case e_dg_sourcestring_idname : {
	    string p0 ;
	    p0 = d_string () ;
	    return ( f_dg_sourcestring_idname ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_idname ) ;
    return ( f_dummy_dg_idname ) ;
}


/* DECODE DG_IDNAME_LIST */

dg_idname_list d_dg_idname_list
    PROTO_Z ()
{
    int i, n ;
    dg_idname_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_idname_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_idname e ;
	e = d_dg_idname () ;
	temp = add_dg_idname_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_IDNAME_OPTION */

dg_idname_option d_dg_idname_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_idname e ;
	e = d_dg_idname () ;
	return ( yes_dg_idname_option ( e ) ) ;
    }
    return ( no_dg_idname_option ) ;
}


/* DECODE DG_LIST */

dg_list d_dg_list
    PROTO_Z ()
{
    int i, n ;
    dg_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg e ;
	e = d_dg () ;
	temp = add_dg_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_MACRO */

dg_macro d_dg_macro
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_function_macro : {
	    dg_sourcepos p0 ;
	    dg_idname p1 ;
	    dg_idname_list p2 ;
	    string p3 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_idname () ;
	    p2 = d_dg_idname_list () ;
	    p3 = d_string () ;
	    return ( f_dg_function_macro ( p0, p1, p2, p3 ) ) ;
	}
	case e_dg_include_macro : {
	    dg_sourcepos p0 ;
	    dg_filename p1 ;
	    dg_macro_list p2 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_filename () ;
	    p2 = d_dg_macro_list () ;
	    return ( f_dg_include_macro ( p0, p1, p2 ) ) ;
	}
	case e_dg_object_macro : {
	    dg_sourcepos p0 ;
	    dg_idname p1 ;
	    string p2 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_idname () ;
	    p2 = d_string () ;
	    return ( f_dg_object_macro ( p0, p1, p2 ) ) ;
	}
	case e_dg_undef_macro : {
	    dg_sourcepos p0 ;
	    dg_idname p1 ;
	    p0 = d_dg_sourcepos () ;
	    p1 = d_dg_idname () ;
	    return ( f_dg_undef_macro ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_macro ) ;
    return ( f_dummy_dg_macro ) ;
}


/* DECODE DG_MACRO_LIST */

dg_macro_list d_dg_macro_list
    PROTO_Z ()
{
    int i, n ;
    dg_macro_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_macro_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_macro e ;
	e = d_dg_macro () ;
	temp = add_dg_macro_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_NAME */

dg_name d_dg_name
    PROTO_Z ()
{
    int code = get_big_code ( 5 ) ;
    switch ( code ) {
	case e_dg_name_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_dg_name_apply_token ( p0, p1 ) ) ;
	}
	case e_dg_tag_name : {
	    dg_tag p0 ;
	    dg_name p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_name () ;
	    return ( f_dg_tag_name ( p0, p1 ) ) ;
	}
	case e_dg_constant_name : {
	    dg_name p0 ;
	    p0 = d_dg_name () ;
	    return ( f_dg_constant_name ( p0 ) ) ;
	}
	case e_dg_entry_family_name : {
	    dg_name p0 ;
	    dg_dim p1 ;
	    p0 = d_dg_name () ;
	    p1 = d_dg_dim () ;
	    return ( f_dg_entry_family_name ( p0, p1 ) ) ;
	}
	case e_dg_entry_name : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    dg_type p2 ;
	    dg_accessibility_option p3 ;
	    dg_dim_option p4 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_dg_type () ;
	    p3 = d_dg_accessibility_option () ;
	    p4 = d_dg_dim_option () ;
	    return ( f_dg_entry_name ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_dg_inlined_name : {
	    dg_name p0 ;
	    dg_tag p1 ;
	    p0 = d_dg_name () ;
	    p1 = d_dg_tag () ;
	    return ( f_dg_inlined_name ( p0, p1 ) ) ;
	}
	case e_dg_is_spec_name : {
	    dg_name p0 ;
	    bool_option p1 ;
	    p0 = d_dg_name () ;
	    p1 = d_bool_option () ;
	    return ( f_dg_is_spec_name ( p0, p1 ) ) ;
	}
	case e_dg_module_name : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    dg_namelist p2 ;
	    exp_option p3 ;
	    dg_tag_option p4 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_dg_namelist () ;
	    p3 = d_exp_option () ;
	    p4 = d_dg_tag_option () ;
	    return ( f_dg_module_name ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_dg_namespace_name : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    dg_namelist p2 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_dg_namelist () ;
	    return ( f_dg_namespace_name ( p0, p1, p2 ) ) ;
	}
	case e_dg_object_name : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    dg_type p2 ;
	    exp_option p3 ;
	    dg_accessibility_option p4 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_dg_type () ;
	    p3 = d_exp_option () ;
	    p4 = d_dg_accessibility_option () ;
	    return ( f_dg_object_name ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_dg_proc_name : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    dg_type p2 ;
	    exp_option p3 ;
	    dg_accessibility_option p4 ;
	    dg_virtuality_option p5 ;
	    bool p6 ;
	    dg_type_list_option p7 ;
	    dg_tag_option p8 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_dg_type () ;
	    p3 = d_exp_option () ;
	    p4 = d_dg_accessibility_option () ;
	    p5 = d_dg_virtuality_option () ;
	    p6 = d_bool () ;
	    p7 = d_dg_type_list_option () ;
	    p8 = d_dg_tag_option () ;
	    return ( f_dg_proc_name ( p0, p1, p2, p3, p4, p5, p6, p7, p8 ) ) ;
	}
	case e_dg_program_name : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    exp p2 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_dg_program_name ( p0, p1, p2 ) ) ;
	}
	case e_dg_rep_clause_name : {
	    dg_name p0 ;
	    exp p1 ;
	    p0 = d_dg_name () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_dg_rep_clause_name ( p0, p1 ) ) ;
	}
	case e_dg_spec_ref_name : {
	    dg_tag p0 ;
	    dg_name p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_name () ;
	    return ( f_dg_spec_ref_name ( p0, p1 ) ) ;
	}
	case e_dg_subunit_name : {
	    dg_tag p0 ;
	    dg_name p1 ;
	    nat p2 ;
	    dg_accessibility_option p3 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_name () ;
	    p2 = d_nat () ;
	    p3 = d_dg_accessibility_option () ;
	    return ( f_dg_subunit_name ( p0, p1, p2, p3 ) ) ;
	}
	case e_dg_type_name : {
	    dg_idname_option p0 ;
	    dg_sourcepos p1 ;
	    dg_accessibility_option p2 ;
	    dg_type_option p3 ;
	    bool p4 ;
	    bool_option p5 ;
	    dg_constraint_list_option p6 ;
	    p0 = d_dg_idname_option () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_dg_accessibility_option () ;
	    p3 = d_dg_type_option () ;
	    p4 = d_bool () ;
	    p5 = d_bool_option () ;
	    p6 = d_dg_constraint_list_option () ;
	    return ( f_dg_type_name ( p0, p1, p2, p3, p4, p5, p6 ) ) ;
	}
	case e_dg_visibility_name : {
	    dg_tag p0 ;
	    nat p1 ;
	    dg_idname_option p2 ;
	    dg_sourcepos_option p3 ;
	    dg_accessibility_option p4 ;
	    dg_type_option p5 ;
	    p0 = d_dg_tag () ;
	    p1 = d_nat () ;
	    p2 = d_dg_idname_option () ;
	    p3 = d_dg_sourcepos_option () ;
	    p4 = d_dg_accessibility_option () ;
	    p5 = d_dg_type_option () ;
	    return ( f_dg_visibility_name ( p0, p1, p2, p3, p4, p5 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_name ) ;
    return ( f_dummy_dg_name ) ;
}


/* DECODE DG_NAME_LIST */

dg_name_list d_dg_name_list
    PROTO_Z ()
{
    int i, n ;
    dg_name_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_name_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_name e ;
	e = d_dg_name () ;
	temp = add_dg_name_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_NAME_OPTION */

dg_name_option d_dg_name_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_name e ;
	e = d_dg_name () ;
	return ( yes_dg_name_option ( e ) ) ;
    }
    return ( no_dg_name_option ) ;
}


/* DECODE DG_NAMELIST */

dg_namelist d_dg_namelist
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_tag_namelist : {
	    dg_tag p0 ;
	    dg_namelist p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_namelist () ;
	    return ( f_dg_tag_namelist ( p0, p1 ) ) ;
	}
	case e_make_dg_namelist : {
	    dg_name_list p0 ;
	    p0 = d_dg_name_list () ;
	    return ( f_make_dg_namelist ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_namelist ) ;
    return ( f_dummy_dg_namelist ) ;
}


/* DECODE DG_PARAM */

dg_param d_dg_param
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_object_param : {
	    dg_idname_option p0 ;
	    dg_sourcepos_option p1 ;
	    dg_param_mode_option p2 ;
	    dg_type p3 ;
	    dg_default_option p4 ;
	    p0 = d_dg_idname_option () ;
	    p1 = d_dg_sourcepos_option () ;
	    p2 = d_dg_param_mode_option () ;
	    p3 = d_dg_type () ;
	    p4 = d_dg_default_option () ;
	    return ( f_dg_object_param ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_dg_type_param : {
	    dg_idname_option p0 ;
	    dg_sourcepos_option p1 ;
	    dg_param_list p2 ;
	    p0 = d_dg_idname_option () ;
	    p1 = d_dg_sourcepos_option () ;
	    p2 = d_dg_param_list () ;
	    return ( f_dg_type_param ( p0, p1, p2 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_param ) ;
    return ( f_dummy_dg_param ) ;
}


/* DECODE DG_PARAM_LIST */

dg_param_list d_dg_param_list
    PROTO_Z ()
{
    int i, n ;
    dg_param_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_param_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_param e ;
	e = d_dg_param () ;
	temp = add_dg_param_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_PARAM_MODE */

dg_param_mode d_dg_param_mode
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_in_mode : {
	    return ( f_dg_in_mode ) ;
	}
	case e_dg_inout_mode : {
	    return ( f_dg_inout_mode ) ;
	}
	case e_dg_out_mode : {
	    return ( f_dg_out_mode ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_param_mode ) ;
    return ( f_dummy_dg_param_mode ) ;
}


/* DECODE DG_PARAM_MODE_OPTION */

dg_param_mode_option d_dg_param_mode_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_param_mode e ;
	e = d_dg_param_mode () ;
	return ( yes_dg_param_mode_option ( e ) ) ;
    }
    return ( no_dg_param_mode_option ) ;
}


/* DECODE DG_QUALIFIER */

dg_qualifier d_dg_qualifier
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_dg_aliased_qualifier : {
	    return ( f_dg_aliased_qualifier ) ;
	}
	case e_dg_class_wide_qualifier : {
	    return ( f_dg_class_wide_qualifier ) ;
	}
	case e_dg_const_qualifier : {
	    return ( f_dg_const_qualifier ) ;
	}
	case e_dg_limited_qualifier : {
	    return ( f_dg_limited_qualifier ) ;
	}
	case e_dg_volatile_qualifier : {
	    return ( f_dg_volatile_qualifier ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_qualifier ) ;
    return ( f_dummy_dg_qualifier ) ;
}


/* DECODE DG_SOURCEPOS */

dg_sourcepos d_dg_sourcepos
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_dg_file_sourcepos : {
	    dg_filename p0 ;
	    p0 = d_dg_filename () ;
	    return ( f_dg_file_sourcepos ( p0 ) ) ;
	}
	case e_dg_global_sourcepos : {
	    return ( f_dg_global_sourcepos ) ;
	}
	case e_dg_mark_sourcepos : {
	    dg_filename p0 ;
	    nat p1 ;
	    nat p2 ;
	    p0 = d_dg_filename () ;
	    p1 = d_nat () ;
	    p2 = d_nat () ;
	    return ( f_dg_mark_sourcepos ( p0, p1, p2 ) ) ;
	}
	case e_dg_null_sourcepos : {
	    return ( f_dg_null_sourcepos ) ;
	}
	case e_dg_span_sourcepos : {
	    dg_filename p0 ;
	    nat p1 ;
	    nat p2 ;
	    dg_filename_option p3 ;
	    nat p4 ;
	    nat p5 ;
	    p0 = d_dg_filename () ;
	    p1 = d_nat () ;
	    p2 = d_nat () ;
	    p3 = d_dg_filename_option () ;
	    p4 = d_nat () ;
	    p5 = d_nat () ;
	    return ( f_dg_span_sourcepos ( p0, p1, p2, p3, p4, p5 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_sourcepos ) ;
    return ( f_dummy_dg_sourcepos ) ;
}


/* DECODE DG_SOURCEPOS_OPTION */

dg_sourcepos_option d_dg_sourcepos_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_sourcepos e ;
	e = d_dg_sourcepos () ;
	return ( yes_dg_sourcepos_option ( e ) ) ;
    }
    return ( no_dg_sourcepos_option ) ;
}


/* DECODE DG_TAG */

dg_tag d_dg_tag
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_dg_tag : {
	    tdfint p0 ;
	    p0 = d_tdfint () ;
	    return ( f_make_dg_tag ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_tag ) ;
    return ( f_dummy_dg_tag ) ;
}


/* DECODE DG_TAG_LIST */

dg_tag_list d_dg_tag_list
    PROTO_Z ()
{
    int i, n ;
    dg_tag_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_tag_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_tag e ;
	e = d_dg_tag () ;
	temp = add_dg_tag_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_TAG_OPTION */

dg_tag_option d_dg_tag_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_tag e ;
	e = d_dg_tag () ;
	return ( yes_dg_tag_option ( e ) ) ;
    }
    return ( no_dg_tag_option ) ;
}


/* DECODE DG_TYPE */

dg_type d_dg_type
    PROTO_Z ()
{
    int code = get_big_code ( 6 ) ;
    switch ( code ) {
	case e_dg_type_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_dg_type_apply_token ( p0, p1 ) ) ;
	}
	case e_dg_tag_type : {
	    dg_tag p0 ;
	    dg_type p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_type () ;
	    return ( f_dg_tag_type ( p0, p1 ) ) ;
	}
	case e_dg_address_type : {
	    dg_idname p0 ;
	    shape p1 ;
	    p0 = d_dg_idname () ;
	    p1 = d_shape () ;
	    return ( f_dg_address_type ( p0, p1 ) ) ;
	}
	case e_dg_array_type : {
	    dg_type p0 ;
	    exp p1 ;
	    bool_option p2 ;
	    dg_dim_list p3 ;
	    p0 = d_dg_type () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = d_bool_option () ;
	    p3 = d_dg_dim_list () ;
	    return ( f_dg_array_type ( p0, p1, p2, p3 ) ) ;
	}
	case e_dg_bitfield_type : {
	    dg_type p0 ;
	    bitfield_variety p1 ;
	    shape p2 ;
	    p0 = d_dg_type () ;
	    p1 = d_bitfield_variety () ;
	    p2 = d_shape () ;
	    return ( f_dg_bitfield_type ( p0, p1, p2 ) ) ;
	}
	case e_dg_boolean_type : {
	    dg_idname p0 ;
	    variety p1 ;
	    p0 = d_dg_idname () ;
	    p1 = d_variety () ;
	    return ( f_dg_boolean_type ( p0, p1 ) ) ;
	}
	case e_dg_char_type : {
	    dg_idname p0 ;
	    variety p1 ;
	    p0 = d_dg_idname () ;
	    p1 = d_variety () ;
	    return ( f_dg_char_type ( p0, p1 ) ) ;
	}
	case e_dg_class_type : {
	    dg_class_base_list p0 ;
	    dg_classmem_list p1 ;
	    dg_varpart_option p2 ;
	    dg_tag_list p3 ;
	    shape_option p4 ;
	    dg_tag_option p5 ;
	    dg_tag_option p6 ;
	    dg_idname_option p7 ;
	    dg_sourcepos_option p8 ;
	    bool p9 ;
	    dg_tag_option p10 ;
	    dg_tag_option p11 ;
	    bool p12 ;
	    bool_option p13 ;
	    p0 = d_dg_class_base_list () ;
	    p1 = d_dg_classmem_list () ;
	    p2 = d_dg_varpart_option () ;
	    p3 = d_dg_tag_list () ;
	    p4 = d_shape_option () ;
	    p5 = d_dg_tag_option () ;
	    p6 = d_dg_tag_option () ;
	    p7 = d_dg_idname_option () ;
	    p8 = d_dg_sourcepos_option () ;
	    p9 = d_bool () ;
	    p10 = d_dg_tag_option () ;
	    p11 = d_dg_tag_option () ;
	    p12 = d_bool () ;
	    p13 = d_bool_option () ;
	    return ( f_dg_class_type ( p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13 ) ) ;
	}
	case e_dg_complex_float_type : {
	    dg_idname p0 ;
	    floating_variety p1 ;
	    p0 = d_dg_idname () ;
	    p1 = d_floating_variety () ;
	    return ( f_dg_complex_float_type ( p0, p1 ) ) ;
	}
	case e_dg_enum_type : {
	    dg_enum_list p0 ;
	    dg_idname_option p1 ;
	    dg_sourcepos_option p2 ;
	    shape p3 ;
	    bool p4 ;
	    p0 = d_dg_enum_list () ;
	    p1 = d_dg_idname_option () ;
	    p2 = d_dg_sourcepos_option () ;
	    p3 = d_shape () ;
	    p4 = d_bool () ;
	    return ( f_dg_enum_type ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_dg_file_type : {
	    dg_type p0 ;
	    shape p1 ;
	    p0 = d_dg_type () ;
	    p1 = d_shape () ;
	    return ( f_dg_file_type ( p0, p1 ) ) ;
	}
	case e_dg_fixed_point_type : {
	    dg_type p0 ;
	    exp p1 ;
	    exp_option p2 ;
	    exp_option p3 ;
	    p0 = d_dg_type () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = d_exp_option () ;
	    p3 = d_exp_option () ;
	    return ( f_dg_fixed_point_type ( p0, p1, p2, p3 ) ) ;
	}
	case e_dg_float_type : {
	    dg_idname p0 ;
	    floating_variety p1 ;
	    p0 = d_dg_idname () ;
	    p1 = d_floating_variety () ;
	    return ( f_dg_float_type ( p0, p1 ) ) ;
	}
	case e_dg_floating_digits_type : {
	    dg_type p0 ;
	    exp p1 ;
	    p0 = d_dg_type () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_dg_floating_digits_type ( p0, p1 ) ) ;
	}
	case e_dg_inlined_type : {
	    dg_type p0 ;
	    dg_tag p1 ;
	    p0 = d_dg_type () ;
	    p1 = d_dg_tag () ;
	    return ( f_dg_inlined_type ( p0, p1 ) ) ;
	}
	case e_dg_integer_type : {
	    dg_idname p0 ;
	    variety p1 ;
	    p0 = d_dg_idname () ;
	    p1 = d_variety () ;
	    return ( f_dg_integer_type ( p0, p1 ) ) ;
	}
	case e_dg_is_spec_type : {
	    dg_type p0 ;
	    p0 = d_dg_type () ;
	    return ( f_dg_is_spec_type ( p0 ) ) ;
	}
	case e_dg_modular_type : {
	    dg_type p0 ;
	    exp p1 ;
	    p0 = d_dg_type () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_dg_modular_type ( p0, p1 ) ) ;
	}
	case e_dg_named_type : {
	    dg_tag p0 ;
	    p0 = d_dg_tag () ;
	    return ( f_dg_named_type ( p0 ) ) ;
	}
	case e_dg_packed_type : {
	    dg_type p0 ;
	    shape p1 ;
	    p0 = d_dg_type () ;
	    p1 = d_shape () ;
	    return ( f_dg_packed_type ( p0, p1 ) ) ;
	}
	case e_dg_pointer_type : {
	    dg_type p0 ;
	    bool_option p1 ;
	    p0 = d_dg_type () ;
	    p1 = d_bool_option () ;
	    return ( f_dg_pointer_type ( p0, p1 ) ) ;
	}
	case e_dg_proc_type : {
	    dg_param_list p0 ;
	    dg_type p1 ;
	    bool_option p2 ;
	    nat_option p3 ;
	    nat_option p4 ;
	    procprops_option p5 ;
	    p0 = d_dg_param_list () ;
	    p1 = d_dg_type () ;
	    p2 = d_bool_option () ;
	    p3 = d_nat_option () ;
	    p4 = d_nat_option () ;
	    p5 = d_procprops_option () ;
	    return ( f_dg_proc_type ( p0, p1, p2, p3, p4, p5 ) ) ;
	}
	case e_dg_ptr_memdata_type : {
	    dg_tag p0 ;
	    dg_type p1 ;
	    shape p2 ;
	    dg_tag_option p3 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_type () ;
	    p2 = d_shape () ;
	    p3 = d_dg_tag_option () ;
	    return ( f_dg_ptr_memdata_type ( p0, p1, p2, p3 ) ) ;
	}
	case e_dg_ptr_memfn_type : {
	    dg_tag p0 ;
	    dg_type p1 ;
	    shape p2 ;
	    dg_tag_option p3 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_type () ;
	    p2 = d_shape () ;
	    p3 = d_dg_tag_option () ;
	    return ( f_dg_ptr_memfn_type ( p0, p1, p2, p3 ) ) ;
	}
	case e_dg_qualified_type : {
	    dg_qualifier p0 ;
	    dg_type p1 ;
	    p0 = d_dg_qualifier () ;
	    p1 = d_dg_type () ;
	    return ( f_dg_qualified_type ( p0, p1 ) ) ;
	}
	case e_dg_reference_type : {
	    dg_type p0 ;
	    p0 = d_dg_type () ;
	    return ( f_dg_reference_type ( p0 ) ) ;
	}
	case e_dg_set_type : {
	    dg_type p0 ;
	    shape p1 ;
	    p0 = d_dg_type () ;
	    p1 = d_shape () ;
	    return ( f_dg_set_type ( p0, p1 ) ) ;
	}
	case e_dg_spec_ref_type : {
	    dg_tag p0 ;
	    dg_type p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_type () ;
	    return ( f_dg_spec_ref_type ( p0, p1 ) ) ;
	}
	case e_dg_string_type : {
	    dg_tag p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_dg_tag () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_dg_string_type ( p0, p1, p2 ) ) ;
	}
	case e_dg_struct_type : {
	    dg_classmem_list p0 ;
	    shape_option p1 ;
	    dg_idname_option p2 ;
	    dg_sourcepos_option p3 ;
	    dg_varpart_option p4 ;
	    bool p5 ;
	    bool p6 ;
	    p0 = d_dg_classmem_list () ;
	    p1 = d_shape_option () ;
	    p2 = d_dg_idname_option () ;
	    p3 = d_dg_sourcepos_option () ;
	    p4 = d_dg_varpart_option () ;
	    p5 = d_bool () ;
	    p6 = d_bool () ;
	    return ( f_dg_struct_type ( p0, p1, p2, p3, p4, p5, p6 ) ) ;
	}
	case e_dg_subrange_type : {
	    dg_type p0 ;
	    dg_bound p1 ;
	    dg_bound p2 ;
	    p0 = d_dg_type () ;
	    p1 = d_dg_bound () ;
	    p2 = d_dg_bound () ;
	    return ( f_dg_subrange_type ( p0, p1, p2 ) ) ;
	}
	case e_dg_synchronous_type : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    dg_name_list p2 ;
	    dg_tag p3 ;
	    dg_classmem_list p4 ;
	    dg_varpart_option p5 ;
	    shape_option p6 ;
	    bool p7 ;
	    dg_tag_option p8 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_dg_name_list () ;
	    p3 = d_dg_tag () ;
	    p4 = d_dg_classmem_list () ;
	    p5 = d_dg_varpart_option () ;
	    p6 = d_shape_option () ;
	    p7 = d_bool () ;
	    p8 = d_dg_tag_option () ;
	    return ( f_dg_synchronous_type ( p0, p1, p2, p3, p4, p5, p6, p7, p8 ) ) ;
	}
	case e_dg_task_type : {
	    dg_idname p0 ;
	    dg_sourcepos p1 ;
	    dg_name_list p2 ;
	    dg_tag p3 ;
	    dg_tag p4 ;
	    dg_classmem_list p5 ;
	    dg_varpart_option p6 ;
	    shape_option p7 ;
	    bool p8 ;
	    dg_tag_option p9 ;
	    p0 = d_dg_idname () ;
	    p1 = d_dg_sourcepos () ;
	    p2 = d_dg_name_list () ;
	    p3 = d_dg_tag () ;
	    p4 = d_dg_tag () ;
	    p5 = d_dg_classmem_list () ;
	    p6 = d_dg_varpart_option () ;
	    p7 = d_shape_option () ;
	    p8 = d_bool () ;
	    p9 = d_dg_tag_option () ;
	    return ( f_dg_task_type ( p0, p1, p2, p3, p4, p5, p6, p7, p8, p9 ) ) ;
	}
	case e_dg_unknown_type : {
	    shape p0 ;
	    p0 = d_shape () ;
	    return ( f_dg_unknown_type ( p0 ) ) ;
	}
	case e_dg_void_type : {
	    return ( f_dg_void_type ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_type ) ;
    return ( f_dummy_dg_type ) ;
}


/* DECODE DG_TYPE_LIST */

dg_type_list d_dg_type_list
    PROTO_Z ()
{
    int i, n ;
    dg_type_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_type_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_type e ;
	e = d_dg_type () ;
	temp = add_dg_type_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_TYPE_LIST_OPTION */

dg_type_list_option d_dg_type_list_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_type_list e ;
	e = d_dg_type_list () ;
	return ( yes_dg_type_list_option ( e ) ) ;
    }
    return ( no_dg_type_list_option ) ;
}


/* DECODE DG_TYPE_OPTION */

dg_type_option d_dg_type_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_type e ;
	e = d_dg_type () ;
	return ( yes_dg_type_option ( e ) ) ;
    }
    return ( no_dg_type_option ) ;
}


/* DECODE DG_VARIANT */

dg_variant d_dg_variant
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_dg_variant : {
	    dg_discrim_list p0 ;
	    dg_classmem_list p1 ;
	    p0 = d_dg_discrim_list () ;
	    p1 = d_dg_classmem_list () ;
	    return ( f_make_dg_variant ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_variant ) ;
    return ( f_dummy_dg_variant ) ;
}


/* DECODE DG_VARIANT_LIST */

dg_variant_list d_dg_variant_list
    PROTO_Z ()
{
    int i, n ;
    dg_variant_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_dg_variant_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	dg_variant e ;
	e = d_dg_variant () ;
	temp = add_dg_variant_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DG_VARPART */

dg_varpart d_dg_varpart
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_discrim_varpart : {
	    dg_classmem p0 ;
	    dg_variant_list p1 ;
	    p0 = d_dg_classmem () ;
	    p1 = d_dg_variant_list () ;
	    return ( f_dg_discrim_varpart ( p0, p1 ) ) ;
	}
	case e_dg_sibl_discrim_varpart : {
	    dg_tag p0 ;
	    dg_variant_list p1 ;
	    p0 = d_dg_tag () ;
	    p1 = d_dg_variant_list () ;
	    return ( f_dg_sibl_discrim_varpart ( p0, p1 ) ) ;
	}
	case e_dg_undiscrim_varpart : {
	    dg_type p0 ;
	    dg_variant_list p1 ;
	    p0 = d_dg_type () ;
	    p1 = d_dg_variant_list () ;
	    return ( f_dg_undiscrim_varpart ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_varpart ) ;
    return ( f_dummy_dg_varpart ) ;
}


/* DECODE DG_VARPART_OPTION */

dg_varpart_option d_dg_varpart_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_varpart e ;
	e = d_dg_varpart () ;
	return ( yes_dg_varpart_option ( e ) ) ;
    }
    return ( no_dg_varpart_option ) ;
}


/* DECODE DG_VIRTUALITY */

dg_virtuality d_dg_virtuality
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_dg_abstract_virtuality : {
	    return ( f_dg_abstract_virtuality ) ;
	}
	case e_dg_virtual_virtuality : {
	    return ( f_dg_virtual_virtuality ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_dg_virtuality ) ;
    return ( f_dummy_dg_virtuality ) ;
}


/* DECODE DG_VIRTUALITY_OPTION */

dg_virtuality_option d_dg_virtuality_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	dg_virtuality e ;
	e = d_dg_virtuality () ;
	return ( yes_dg_virtuality_option ( e ) ) ;
    }
    return ( no_dg_virtuality_option ) ;
}


/* DECODE DIAG_DESCRIPTOR */

diag_descriptor d_diag_descriptor
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_diag_desc_id : {
	    tdfstring p0 ;
	    sourcemark p1 ;
	    exp p2 ;
	    diag_type p3 ;
	    p0 = d_tdfstring () ;
	    p1 = d_sourcemark () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = d_diag_type () ;
	    return ( f_diag_desc_id ( p0, p1, p2, p3 ) ) ;
	}
	case e_diag_desc_struct : {
	    tdfstring p0 ;
	    sourcemark p1 ;
	    diag_type p2 ;
	    p0 = d_tdfstring () ;
	    p1 = d_sourcemark () ;
	    p2 = d_diag_type () ;
	    return ( f_diag_desc_struct ( p0, p1, p2 ) ) ;
	}
	case e_diag_desc_typedef : {
	    tdfstring p0 ;
	    sourcemark p1 ;
	    diag_type p2 ;
	    p0 = d_tdfstring () ;
	    p1 = d_sourcemark () ;
	    p2 = d_diag_type () ;
	    return ( f_diag_desc_typedef ( p0, p1, p2 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_diag_descriptor ) ;
    return ( f_dummy_diag_descriptor ) ;
}


/* DECODE DIAG_DESCRIPTOR_LIST */

diag_descriptor_list d_diag_descriptor_list
    PROTO_Z ()
{
    int i, n ;
    diag_descriptor_list temp ;
    n = small_dtdfint () ;
    temp = new_diag_descriptor_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	diag_descriptor e ;
	e = d_diag_descriptor () ;
	temp = add_diag_descriptor_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DIAG_FIELD */

diag_field d_diag_field
    PROTO_Z ()
{
    tdfstring p0 ;
    exp p1 ;
    diag_type p2 ;
    p0 = d_tdfstring () ;
    p1 = hold_check ( d_exp () ) ;
    p2 = d_diag_type () ;
    return ( f_make_diag_field ( p0, p1, p2 ) ) ;
}


/* DECODE DIAG_FIELD_LIST */

diag_field_list d_diag_field_list
    PROTO_Z ()
{
    int i, n ;
    diag_field_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_diag_field_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	diag_field e ;
	e = d_diag_field () ;
	temp = add_diag_field_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DIAG_TAG */

diag_tag d_diag_tag
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_diag_tag : {
	    tdfint p0 ;
	    p0 = d_tdfint () ;
	    return ( f_make_diag_tag ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_diag_tag ) ;
    return ( f_dummy_diag_tag ) ;
}


/* DECODE DIAG_TAGDEF */

diag_tagdef d_diag_tagdef
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_diag_tagdef : {
	    tdfint p0 ;
	    diag_type p1 ;
	    p0 = d_tdfint () ;
	    p1 = d_diag_type () ;
	    return ( f_make_diag_tagdef ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_diag_tagdef ) ;
    return ( f_dummy_diag_tagdef ) ;
}


/* DECODE DIAG_TAGDEF_LIST */

diag_tagdef_list d_diag_tagdef_list
    PROTO_Z ()
{
    int i, n ;
    diag_tagdef_list temp ;
    n = small_dtdfint () ;
    temp = new_diag_tagdef_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	diag_tagdef e ;
	e = d_diag_tagdef () ;
	temp = add_diag_tagdef_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DIAG_TQ */

diag_tq d_diag_tq
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_add_diag_const : {
	    diag_tq p0 ;
	    p0 = d_diag_tq () ;
	    return ( f_add_diag_const ( p0 ) ) ;
	}
	case e_add_diag_volatile : {
	    diag_tq p0 ;
	    p0 = d_diag_tq () ;
	    return ( f_add_diag_volatile ( p0 ) ) ;
	}
	case e_diag_tq_null : {
	    return ( f_diag_tq_null ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_diag_tq ) ;
    return ( f_dummy_diag_tq ) ;
}


/* DECODE DIAG_TYPE */

diag_type d_diag_type
    PROTO_Z ()
{
    int code = get_big_code ( 4 ) ;
    switch ( code ) {
	case e_diag_type_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_diag_type_apply_token ( p0, p1 ) ) ;
	}
	case e_diag_array : {
	    diag_type p0 ;
	    exp p1 ;
	    exp p2 ;
	    exp p3 ;
	    diag_type p4 ;
	    p0 = d_diag_type () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    p4 = d_diag_type () ;
	    return ( f_diag_array ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_diag_bitfield : {
	    diag_type p0 ;
	    nat p1 ;
	    p0 = d_diag_type () ;
	    p1 = d_nat () ;
	    return ( f_diag_bitfield ( p0, p1 ) ) ;
	}
	case e_diag_enum : {
	    diag_type p0 ;
	    tdfstring p1 ;
	    enum_values_list p2 ;
	    p0 = d_diag_type () ;
	    p1 = d_tdfstring () ;
	    p2 = d_enum_values_list () ;
	    return ( f_diag_enum ( p0, p1, p2 ) ) ;
	}
	case e_diag_floating_variety : {
	    floating_variety p0 ;
	    p0 = d_floating_variety () ;
	    return ( f_diag_floating_variety ( p0 ) ) ;
	}
	case e_diag_loc : {
	    diag_type p0 ;
	    diag_tq p1 ;
	    p0 = d_diag_type () ;
	    p1 = d_diag_tq () ;
	    return ( f_diag_loc ( p0, p1 ) ) ;
	}
	case e_diag_proc : {
	    diag_type_list p0 ;
	    bool p1 ;
	    diag_type p2 ;
	    p0 = d_diag_type_list () ;
	    p1 = d_bool () ;
	    p2 = d_diag_type () ;
	    return ( f_diag_proc ( p0, p1, p2 ) ) ;
	}
	case e_diag_ptr : {
	    diag_type p0 ;
	    diag_tq p1 ;
	    p0 = d_diag_type () ;
	    p1 = d_diag_tq () ;
	    return ( f_diag_ptr ( p0, p1 ) ) ;
	}
	case e_diag_struct : {
	    shape p0 ;
	    tdfstring p1 ;
	    diag_field_list p2 ;
	    p0 = d_shape () ;
	    p1 = d_tdfstring () ;
	    p2 = d_diag_field_list () ;
	    return ( f_diag_struct ( p0, p1, p2 ) ) ;
	}
	case e_diag_type_null : {
	    return ( f_diag_type_null ) ;
	}
	case e_diag_union : {
	    shape p0 ;
	    tdfstring p1 ;
	    diag_field_list p2 ;
	    p0 = d_shape () ;
	    p1 = d_tdfstring () ;
	    p2 = d_diag_field_list () ;
	    return ( f_diag_union ( p0, p1, p2 ) ) ;
	}
	case e_diag_variety : {
	    variety p0 ;
	    p0 = d_variety () ;
	    return ( f_diag_variety ( p0 ) ) ;
	}
	case e_use_diag_tag : {
	    diag_tag p0 ;
	    p0 = d_diag_tag () ;
	    return ( f_use_diag_tag ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_diag_type ) ;
    return ( f_dummy_diag_type ) ;
}


/* DECODE DIAG_TYPE_LIST */

diag_type_list d_diag_type_list
    PROTO_Z ()
{
    int i, n ;
    diag_type_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_diag_type_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	diag_type e ;
	e = d_diag_type () ;
	temp = add_diag_type_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE DIAG_TYPE_UNIT */

diag_type_unit d_diag_type_unit
    PROTO_Z ()
{
    tdfint p0 ;
    diag_tagdef_list p1 ;
    p0 = d_tdfint () ;
    p1 = d_diag_tagdef_list () ;
    return ( f_build_diagtype_unit ( p0, p1 ) ) ;
}


/* DECODE DIAG_UNIT */

diag_unit d_diag_unit
    PROTO_Z ()
{
    tdfint p0 ;
    diag_descriptor_list p1 ;
    p0 = d_tdfint () ;
    p1 = d_diag_descriptor_list () ;
    return ( f_build_diag_unit ( p0, p1 ) ) ;
}


/* DECODE ENUM_VALUES */

enum_values d_enum_values
    PROTO_Z ()
{
    exp p0 ;
    tdfstring p1 ;
    p0 = hold_check ( d_exp () ) ;
    p1 = d_tdfstring () ;
    return ( f_make_enum_values ( p0, p1 ) ) ;
}


/* DECODE ENUM_VALUES_LIST */

enum_values_list d_enum_values_list
    PROTO_Z ()
{
    int i, n ;
    enum_values_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_enum_values_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	enum_values e ;
	e = d_enum_values () ;
	temp = add_enum_values_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE ERROR_CODE */

error_code d_error_code
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_nil_access : {
	    return ( f_nil_access ) ;
	}
	case e_overflow : {
	    return ( f_overflow ) ;
	}
	case e_stack_overflow : {
	    return ( f_stack_overflow ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_error_code ) ;
    return ( f_dummy_error_code ) ;
}


/* DECODE ERROR_CODE_LIST */

error_code_list d_error_code_list
    PROTO_Z ()
{
    int i, n ;
    error_code_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_error_code_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	error_code e ;
	e = d_error_code () ;
	temp = add_error_code_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE ERROR_TREATMENT */

error_treatment d_error_treatment
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_errt_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_errt_apply_token ( p0, p1 ) ) ;
	}
	case e_errt_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_errt_cond ( p0, p1, p2 ) ) ;
	}
	case e_continue : {
	    return ( f_continue ) ;
	}
	case e_error_jump : {
	    label p0 ;
	    p0 = d_label () ;
	    return ( f_error_jump ( p0 ) ) ;
	}
	case e_trap : {
	    error_code_list p0 ;
	    p0 = d_error_code_list () ;
	    return ( f_trap ( p0 ) ) ;
	}
	case e_wrap : {
	    return ( f_wrap ) ;
	}
	case e_impossible : {
	    return ( f_impossible ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_error_treatment ) ;
    return ( f_dummy_error_treatment ) ;
}


/* DECODE EXP */

exp d_exp
    PROTO_Z ()
{
    int code = get_big_code ( 7 ) ;
    switch ( code ) {
	case e_exp_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_exp_apply_token ( p0, p1 ) ) ;
	}
	case e_exp_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_exp_cond ( p0, p1, p2 ) ) ;
	}
	case e_abs : {
	    error_treatment p0 ;
	    exp p1 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_abs ( p0, p1 ) ) ;
	}
	case e_add_to_ptr : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_add_to_ptr ( p0, p1 ) ) ;
	}
	case e_and : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_and ( p0, p1 ) ) ;
	}
	case e_apply_proc : {
	    shape p0 ;
	    exp p1 ;
	    exp_list p2 ;
	    exp_option p3 ;
	    p0 = d_shape () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = d_exp_list () ;
	    p3 = d_exp_option () ;
	    return ( f_apply_proc ( p0, p1, p2, p3 ) ) ;
	}
	case e_apply_general_proc : {
	    shape p0 ;
	    procprops_option p1 ;
	    exp p2 ;
	    otagexp_list p3 ;
	    callees p4 ;
	    exp p5 ;
	    p0 = d_shape () ;
	    p1 = d_procprops_option () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = d_otagexp_list () ;
	    p4 = d_callees () ;
	    start_apply_general_proc ( p0, p1, p2, p3, p4 ) ;
	    p5 = hold_check ( d_exp () ) ;
	    return ( f_apply_general_proc ( p0, p1, p2, p3, p4, p5 ) ) ;
	}
	case e_assign : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_assign ( p0, p1 ) ) ;
	}
	case e_assign_with_mode : {
	    transfer_mode p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_transfer_mode () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_assign_with_mode ( p0, p1, p2 ) ) ;
	}
	case e_bitfield_assign : {
	    exp p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_bitfield_assign ( p0, p1, p2 ) ) ;
	}
	case e_bitfield_assign_with_mode : {
	    transfer_mode p0 ;
	    exp p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_transfer_mode () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_bitfield_assign_with_mode ( p0, p1, p2, p3 ) ) ;
	}
	case e_bitfield_contents : {
	    bitfield_variety p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_bitfield_variety () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_bitfield_contents ( p0, p1, p2 ) ) ;
	}
	case e_bitfield_contents_with_mode : {
	    transfer_mode p0 ;
	    bitfield_variety p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_transfer_mode () ;
	    p1 = d_bitfield_variety () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_bitfield_contents_with_mode ( p0, p1, p2, p3 ) ) ;
	}
	case e_case : {
	    bool p0 ;
	    exp p1 ;
	    caselim_list p2 ;
	    p0 = d_bool () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = d_caselim_list () ;
	    return ( f_case ( p0, p1, p2 ) ) ;
	}
	case e_change_bitfield_to_int : {
	    variety p0 ;
	    exp p1 ;
	    p0 = d_variety () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_change_bitfield_to_int ( p0, p1 ) ) ;
	}
	case e_change_floating_variety : {
	    error_treatment p0 ;
	    floating_variety p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = d_floating_variety () ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_change_floating_variety ( p0, p1, p2 ) ) ;
	}
	case e_change_variety : {
	    error_treatment p0 ;
	    variety p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = d_variety () ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_change_variety ( p0, p1, p2 ) ) ;
	}
	case e_change_int_to_bitfield : {
	    bitfield_variety p0 ;
	    exp p1 ;
	    p0 = d_bitfield_variety () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_change_int_to_bitfield ( p0, p1 ) ) ;
	}
	case e_complex_conjugate : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_complex_conjugate ( p0 ) ) ;
	}
	case e_component : {
	    shape p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_shape () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_component ( p0, p1, p2 ) ) ;
	}
	case e_concat_nof : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_concat_nof ( p0, p1 ) ) ;
	}
	case e_conditional : {
	    label p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_label () ;
	    start_conditional ( p0 ) ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_conditional ( p0, p1, p2 ) ) ;
	}
	case e_contents : {
	    shape p0 ;
	    exp p1 ;
	    p0 = d_shape () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_contents ( p0, p1 ) ) ;
	}
	case e_contents_with_mode : {
	    transfer_mode p0 ;
	    shape p1 ;
	    exp p2 ;
	    p0 = d_transfer_mode () ;
	    p1 = d_shape () ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_contents_with_mode ( p0, p1, p2 ) ) ;
	}
	case e_current_env : {
	    return ( f_current_env () ) ;
	}
	case e_div0 : {
	    error_treatment p0 ;
	    error_treatment p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_error_treatment () ;
	    p1 = d_error_treatment () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_div0 ( p0, p1, p2, p3 ) ) ;
	}
	case e_div1 : {
	    error_treatment p0 ;
	    error_treatment p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_error_treatment () ;
	    p1 = d_error_treatment () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_div1 ( p0, p1, p2, p3 ) ) ;
	}
	case e_div2 : {
	    error_treatment p0 ;
	    error_treatment p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_error_treatment () ;
	    p1 = d_error_treatment () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_div2 ( p0, p1, p2, p3 ) ) ;
	}
	case e_env_offset : {
	    alignment p0 ;
	    alignment p1 ;
	    tag p2 ;
	    p0 = d_alignment () ;
	    p1 = d_alignment () ;
	    p2 = d_tag () ;
	    return ( f_env_offset ( p0, p1, p2 ) ) ;
	}
	case e_env_size : {
	    tag p0 ;
	    p0 = d_tag () ;
	    return ( f_env_size ( p0 ) ) ;
	}
	case e_fail_installer : {
	    string p0 ;
	    p0 = d_string () ;
	    return ( f_fail_installer ( p0 ) ) ;
	}
	case e_float_int : {
	    error_treatment p0 ;
	    floating_variety p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = d_floating_variety () ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_float_int ( p0, p1, p2 ) ) ;
	}
	case e_floating_abs : {
	    error_treatment p0 ;
	    exp p1 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_floating_abs ( p0, p1 ) ) ;
	}
	case e_floating_div : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_floating_div ( p0, p1, p2 ) ) ;
	}
	case e_floating_minus : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_floating_minus ( p0, p1, p2 ) ) ;
	}
	case e_floating_maximum : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_floating_maximum ( p0, p1, p2 ) ) ;
	}
	case e_floating_minimum : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_floating_minimum ( p0, p1, p2 ) ) ;
	}
	case e_floating_mult : {
	    error_treatment p0 ;
	    exp_list p1 ;
	    p0 = d_error_treatment () ;
	    p1 = d_exp_list () ;
	    return ( f_floating_mult ( p0, p1 ) ) ;
	}
	case e_floating_negate : {
	    error_treatment p0 ;
	    exp p1 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_floating_negate ( p0, p1 ) ) ;
	}
	case e_floating_plus : {
	    error_treatment p0 ;
	    exp_list p1 ;
	    p0 = d_error_treatment () ;
	    p1 = d_exp_list () ;
	    return ( f_floating_plus ( p0, p1 ) ) ;
	}
	case e_floating_power : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_floating_power ( p0, p1, p2 ) ) ;
	}
	case e_floating_test : {
	    nat_option p0 ;
	    error_treatment p1 ;
	    ntest p2 ;
	    label p3 ;
	    exp p4 ;
	    exp p5 ;
	    p0 = d_nat_option () ;
	    p1 = d_error_treatment () ;
	    p2 = d_ntest () ;
	    p3 = d_label () ;
	    p4 = hold_check ( d_exp () ) ;
	    p5 = hold_check ( d_exp () ) ;
	    return ( f_floating_test ( p0, p1, p2, p3, p4, p5 ) ) ;
	}
	case e_goto : {
	    label p0 ;
	    p0 = d_label () ;
	    return ( f_goto ( p0 ) ) ;
	}
	case e_goto_local_lv : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_goto_local_lv ( p0 ) ) ;
	}
	case e_identify : {
	    access_option p0 ;
	    tag p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_access_option () ;
	    p1 = d_tag () ;
	    p2 = hold_check ( d_exp () ) ;
	    start_identify ( p0, p1, p2 ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_identify ( p0, p1, p2, p3 ) ) ;
	}
	case e_ignorable : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_ignorable ( p0 ) ) ;
	}
	case e_imaginary_part : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_imaginary_part ( p0 ) ) ;
	}
	case e_initial_value : {
	    exp p0 ;
	    start_initial_value () ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_initial_value ( p0 ) ) ;
	}
	case e_integer_test : {
	    nat_option p0 ;
	    ntest p1 ;
	    label p2 ;
	    exp p3 ;
	    exp p4 ;
	    p0 = d_nat_option () ;
	    p1 = d_ntest () ;
	    p2 = d_label () ;
	    p3 = hold_check ( d_exp () ) ;
	    p4 = hold_check ( d_exp () ) ;
	    return ( f_integer_test ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_labelled : {
	    label_list p0 ;
	    exp p1 ;
	    exp_list p2 ;
	    p0 = d_label_list () ;
	    start_labelled ( p0 ) ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = d_exp_list () ;
	    return ( f_labelled ( p0, p1, p2 ) ) ;
	}
	case e_last_local : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_last_local ( p0 ) ) ;
	}
	case e_local_alloc : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_local_alloc ( p0 ) ) ;
	}
	case e_local_alloc_check : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_local_alloc_check ( p0 ) ) ;
	}
	case e_local_free : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_local_free ( p0, p1 ) ) ;
	}
	case e_local_free_all : {
	    return ( f_local_free_all () ) ;
	}
	case e_long_jump : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_long_jump ( p0, p1 ) ) ;
	}
	case e_make_complex : {
	    floating_variety p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_floating_variety () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_make_complex ( p0, p1, p2 ) ) ;
	}
	case e_make_compound : {
	    exp p0 ;
	    exp_list p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = d_exp_list () ;
	    return ( f_make_compound ( p0, p1 ) ) ;
	}
	case e_make_floating : {
	    floating_variety p0 ;
	    rounding_mode p1 ;
	    bool p2 ;
	    string p3 ;
	    nat p4 ;
	    signed_nat p5 ;
	    p0 = d_floating_variety () ;
	    p1 = d_rounding_mode () ;
	    p2 = d_bool () ;
	    p3 = d_string () ;
	    p4 = d_nat () ;
	    p5 = d_signed_nat () ;
	    return ( f_make_floating ( p0, p1, p2, p3, p4, p5 ) ) ;
	}
	case e_make_general_proc : {
	    shape p0 ;
	    procprops_option p1 ;
	    tagshacc_list p2 ;
	    tagshacc_list p3 ;
	    exp p4 ;
	    p0 = d_shape () ;
	    p1 = d_procprops_option () ;
	    p2 = d_tagshacc_list () ;
	    p3 = d_tagshacc_list () ;
	    start_make_general_proc ( p0, p1, p2, p3 ) ;
	    p4 = hold_check ( d_exp () ) ;
	    return ( f_make_general_proc ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_make_int : {
	    variety p0 ;
	    signed_nat p1 ;
	    p0 = d_variety () ;
	    p1 = d_signed_nat () ;
	    return ( f_make_int ( p0, p1 ) ) ;
	}
	case e_make_local_lv : {
	    label p0 ;
	    p0 = d_label () ;
	    return ( f_make_local_lv ( p0 ) ) ;
	}
	case e_make_nof : {
	    exp_list p0 ;
	    p0 = d_exp_list () ;
	    return ( f_make_nof ( p0 ) ) ;
	}
	case e_make_nof_int : {
	    variety p0 ;
	    string p1 ;
	    p0 = d_variety () ;
	    p1 = d_string () ;
	    return ( f_make_nof_int ( p0, p1 ) ) ;
	}
	case e_make_null_local_lv : {
	    return ( f_make_null_local_lv () ) ;
	}
	case e_make_null_proc : {
	    return ( f_make_null_proc () ) ;
	}
	case e_make_null_ptr : {
	    alignment p0 ;
	    p0 = d_alignment () ;
	    return ( f_make_null_ptr ( p0 ) ) ;
	}
	case e_make_proc : {
	    shape p0 ;
	    tagshacc_list p1 ;
	    tagacc_option p2 ;
	    exp p3 ;
	    p0 = d_shape () ;
	    p1 = d_tagshacc_list () ;
	    p2 = d_tagacc_option () ;
	    start_make_proc ( p0, p1, p2 ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_make_proc ( p0, p1, p2, p3 ) ) ;
	}
	case e_make_stack_limit : {
	    exp p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_make_stack_limit ( p0, p1, p2 ) ) ;
	}
	case e_make_top : {
	    return ( f_make_top () ) ;
	}
	case e_make_value : {
	    shape p0 ;
	    p0 = d_shape () ;
	    return ( f_make_value ( p0 ) ) ;
	}
	case e_maximum : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_maximum ( p0, p1 ) ) ;
	}
	case e_minimum : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_minimum ( p0, p1 ) ) ;
	}
	case e_minus : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_minus ( p0, p1, p2 ) ) ;
	}
	case e_move_some : {
	    transfer_mode p0 ;
	    exp p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_transfer_mode () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_move_some ( p0, p1, p2, p3 ) ) ;
	}
	case e_mult : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_mult ( p0, p1, p2 ) ) ;
	}
	case e_n_copies : {
	    nat p0 ;
	    exp p1 ;
	    p0 = d_nat () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_n_copies ( p0, p1 ) ) ;
	}
	case e_negate : {
	    error_treatment p0 ;
	    exp p1 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_negate ( p0, p1 ) ) ;
	}
	case e_not : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_not ( p0 ) ) ;
	}
	case e_obtain_tag : {
	    tag p0 ;
	    p0 = d_tag () ;
	    return ( f_obtain_tag ( p0 ) ) ;
	}
	case e_offset_add : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_offset_add ( p0, p1 ) ) ;
	}
	case e_offset_div : {
	    variety p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_variety () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_offset_div ( p0, p1, p2 ) ) ;
	}
	case e_offset_div_by_int : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_offset_div_by_int ( p0, p1 ) ) ;
	}
	case e_offset_max : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_offset_max ( p0, p1 ) ) ;
	}
	case e_offset_mult : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_offset_mult ( p0, p1 ) ) ;
	}
	case e_offset_negate : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_offset_negate ( p0 ) ) ;
	}
	case e_offset_pad : {
	    alignment p0 ;
	    exp p1 ;
	    p0 = d_alignment () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_offset_pad ( p0, p1 ) ) ;
	}
	case e_offset_subtract : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_offset_subtract ( p0, p1 ) ) ;
	}
	case e_offset_test : {
	    nat_option p0 ;
	    ntest p1 ;
	    label p2 ;
	    exp p3 ;
	    exp p4 ;
	    p0 = d_nat_option () ;
	    p1 = d_ntest () ;
	    p2 = d_label () ;
	    p3 = hold_check ( d_exp () ) ;
	    p4 = hold_check ( d_exp () ) ;
	    return ( f_offset_test ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_offset_zero : {
	    alignment p0 ;
	    p0 = d_alignment () ;
	    return ( f_offset_zero ( p0 ) ) ;
	}
	case e_or : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_or ( p0, p1 ) ) ;
	}
	case e_plus : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_plus ( p0, p1, p2 ) ) ;
	}
	case e_pointer_test : {
	    nat_option p0 ;
	    ntest p1 ;
	    label p2 ;
	    exp p3 ;
	    exp p4 ;
	    p0 = d_nat_option () ;
	    p1 = d_ntest () ;
	    p2 = d_label () ;
	    p3 = hold_check ( d_exp () ) ;
	    p4 = hold_check ( d_exp () ) ;
	    return ( f_pointer_test ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_power : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_power ( p0, p1, p2 ) ) ;
	}
	case e_proc_test : {
	    nat_option p0 ;
	    ntest p1 ;
	    label p2 ;
	    exp p3 ;
	    exp p4 ;
	    p0 = d_nat_option () ;
	    p1 = d_ntest () ;
	    p2 = d_label () ;
	    p3 = hold_check ( d_exp () ) ;
	    p4 = hold_check ( d_exp () ) ;
	    return ( f_proc_test ( p0, p1, p2, p3, p4 ) ) ;
	}
	case e_profile : {
	    nat p0 ;
	    p0 = d_nat () ;
	    return ( f_profile ( p0 ) ) ;
	}
	case e_real_part : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_real_part ( p0 ) ) ;
	}
	case e_rem0 : {
	    error_treatment p0 ;
	    error_treatment p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_error_treatment () ;
	    p1 = d_error_treatment () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_rem0 ( p0, p1, p2, p3 ) ) ;
	}
	case e_rem1 : {
	    error_treatment p0 ;
	    error_treatment p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_error_treatment () ;
	    p1 = d_error_treatment () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_rem1 ( p0, p1, p2, p3 ) ) ;
	}
	case e_rem2 : {
	    error_treatment p0 ;
	    error_treatment p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_error_treatment () ;
	    p1 = d_error_treatment () ;
	    p2 = hold_check ( d_exp () ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_rem2 ( p0, p1, p2, p3 ) ) ;
	}
	case e_repeat : {
	    label p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_label () ;
	    start_repeat ( p0 ) ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_repeat ( p0, p1, p2 ) ) ;
	}
	case e_return : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_return ( p0 ) ) ;
	}
	case e_return_to_label : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_return_to_label ( p0 ) ) ;
	}
	case e_round_with_mode : {
	    error_treatment p0 ;
	    rounding_mode p1 ;
	    variety p2 ;
	    exp p3 ;
	    p0 = d_error_treatment () ;
	    p1 = d_rounding_mode () ;
	    p2 = d_variety () ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_round_with_mode ( p0, p1, p2, p3 ) ) ;
	}
	case e_rotate_left : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_rotate_left ( p0, p1 ) ) ;
	}
	case e_rotate_right : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_rotate_right ( p0, p1 ) ) ;
	}
	case e_sequence : {
	    exp_list p0 ;
	    exp p1 ;
	    p0 = d_exp_list () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_sequence ( p0, p1 ) ) ;
	}
	case e_set_stack_limit : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_set_stack_limit ( p0 ) ) ;
	}
	case e_shape_offset : {
	    shape p0 ;
	    p0 = d_shape () ;
	    return ( f_shape_offset ( p0 ) ) ;
	}
	case e_shift_left : {
	    error_treatment p0 ;
	    exp p1 ;
	    exp p2 ;
	    p0 = d_error_treatment () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_shift_left ( p0, p1, p2 ) ) ;
	}
	case e_shift_right : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_shift_right ( p0, p1 ) ) ;
	}
	case e_subtract_ptrs : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_subtract_ptrs ( p0, p1 ) ) ;
	}
	case e_tail_call : {
	    procprops_option p0 ;
	    exp p1 ;
	    callees p2 ;
	    p0 = d_procprops_option () ;
	    p1 = hold_check ( d_exp () ) ;
	    p2 = d_callees () ;
	    return ( f_tail_call ( p0, p1, p2 ) ) ;
	}
	case e_untidy_return : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_untidy_return ( p0 ) ) ;
	}
	case e_variable : {
	    access_option p0 ;
	    tag p1 ;
	    exp p2 ;
	    exp p3 ;
	    p0 = d_access_option () ;
	    p1 = d_tag () ;
	    p2 = hold_check ( d_exp () ) ;
	    start_variable ( p0, p1, p2 ) ;
	    p3 = hold_check ( d_exp () ) ;
	    return ( f_variable ( p0, p1, p2, p3 ) ) ;
	}
	case e_xor : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_xor ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_exp ) ;
    return ( f_dummy_exp ) ;
}


/* DECODE EXP_LIST */

exp_list d_exp_list
    PROTO_Z ()
{
    int i, n ;
    exp_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_exp_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	exp e ;
	e = hold_check ( d_exp () ) ;
	temp = add_exp_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE EXP_OPTION */

exp_option d_exp_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	exp e ;
	e = hold_check ( d_exp () ) ;
	return ( yes_exp_option ( e ) ) ;
    }
    return ( no_exp_option ) ;
}


/* DECODE EXTERN_LINK */

extern_link d_extern_link
    PROTO_Z ()
{
    linkextern_list p0 ;
    p0 = d_linkextern_list () ;
    return ( f_make_extern_link ( p0 ) ) ;
}


/* DECODE EXTERN_LINK_LIST */

extern_link_list d_extern_link_list
    PROTO_Z ()
{
    int i, n ;
    extern_link_list temp ;
    n = small_dtdfint () ;
    temp = new_extern_link_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	extern_link e ;
	e = d_extern_link () ;
	temp = add_extern_link_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE EXTERNAL */

external d_external
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_string_extern : {
	    tdfident p0 ;
	    to_boundary () ;
	    p0 = d_tdfident () ;
	    return ( f_string_extern ( p0 ) ) ;
	}
	case e_unique_extern : {
	    unique p0 ;
	    to_boundary () ;
	    p0 = d_unique () ;
	    return ( f_unique_extern ( p0 ) ) ;
	}
	case e_chain_extern : {
	    tdfident p0 ;
	    tdfint p1 ;
	    to_boundary () ;
	    p0 = d_tdfident () ;
	    p1 = d_tdfint () ;
	    return ( f_chain_extern ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_external ) ;
    return ( f_dummy_external ) ;
}


/* DECODE FILENAME */

filename d_filename
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_filename_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_filename_apply_token ( p0, p1 ) ) ;
	}
	case e_make_filename : {
	    nat p0 ;
	    tdfstring p1 ;
	    tdfstring p2 ;
	    p0 = d_nat () ;
	    p1 = d_tdfstring () ;
	    p2 = d_tdfstring () ;
	    return ( f_make_filename ( p0, p1, p2 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_filename ) ;
    return ( f_dummy_filename ) ;
}


/* DECODE FLOATING_VARIETY */

floating_variety d_floating_variety
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_flvar_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_flvar_apply_token ( p0, p1 ) ) ;
	}
	case e_flvar_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_flvar_cond ( p0, p1, p2 ) ) ;
	}
	case e_flvar_parms : {
	    nat p0 ;
	    nat p1 ;
	    nat p2 ;
	    nat p3 ;
	    p0 = d_nat () ;
	    p1 = d_nat () ;
	    p2 = d_nat () ;
	    p3 = d_nat () ;
	    return ( f_flvar_parms ( p0, p1, p2, p3 ) ) ;
	}
	case e_complex_parms : {
	    nat p0 ;
	    nat p1 ;
	    nat p2 ;
	    nat p3 ;
	    p0 = d_nat () ;
	    p1 = d_nat () ;
	    p2 = d_nat () ;
	    p3 = d_nat () ;
	    return ( f_complex_parms ( p0, p1, p2, p3 ) ) ;
	}
	case e_float_of_complex : {
	    shape p0 ;
	    p0 = d_shape () ;
	    return ( f_float_of_complex ( p0 ) ) ;
	}
	case e_complex_of_float : {
	    shape p0 ;
	    p0 = d_shape () ;
	    return ( f_complex_of_float ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_floating_variety ) ;
    return ( f_dummy_floating_variety ) ;
}


/* DECODE GROUP */

group d_group
    PROTO_Z ()
{
    unit_list p0 ;
    p0 = d_unit_list () ;
    return ( f_make_group ( p0 ) ) ;
}


/* DECODE GROUP_LIST */

group_list d_group_list
    PROTO_Z ()
{
    int i, n ;
    group_list temp ;
    n = small_dtdfint () ;
    temp = new_group_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	group e ;
	e = d_group () ;
	temp = add_group_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE LABEL */

label d_label
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_label_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_label_apply_token ( p0, p1 ) ) ;
	}
	case e_make_label : {
	    tdfint p0 ;
	    p0 = d_tdfint () ;
	    return ( f_make_label ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_label ) ;
    return ( f_dummy_label ) ;
}


/* DECODE LABEL_LIST */

label_list d_label_list
    PROTO_Z ()
{
    int i, n ;
    label_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_label_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	label e ;
	e = d_label () ;
	temp = add_label_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE LINK */

link d_link
    PROTO_Z ()
{
    tdfint p0 ;
    tdfint p1 ;
    p0 = d_tdfint () ;
    p1 = d_tdfint () ;
    return ( f_make_link ( p0, p1 ) ) ;
}


/* DECODE LINK_LIST */

link_list d_link_list
    PROTO_Z ()
{
    int i, n ;
    link_list temp ;
    n = small_dtdfint () ;
    temp = new_link_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	link e ;
	e = d_link () ;
	temp = add_link_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE LINKEXTERN */

linkextern d_linkextern
    PROTO_Z ()
{
    tdfint p0 ;
    external p1 ;
    p0 = d_tdfint () ;
    p1 = d_external () ;
    return ( f_make_linkextern ( p0, p1 ) ) ;
}


/* DECODE LINKEXTERN_LIST */

linkextern_list d_linkextern_list
    PROTO_Z ()
{
    int i, n ;
    linkextern_list temp ;
    n = small_dtdfint () ;
    temp = new_linkextern_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	linkextern e ;
	e = d_linkextern () ;
	temp = add_linkextern_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE LINKINFO */

linkinfo d_linkinfo
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_static_name_def : {
	    exp p0 ;
	    tdfstring p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = d_tdfstring () ;
	    return ( f_static_name_def ( p0, p1 ) ) ;
	}
	case e_make_comment : {
	    tdfstring p0 ;
	    p0 = d_tdfstring () ;
	    return ( f_make_comment ( p0 ) ) ;
	}
	case e_make_weak_defn : {
	    exp p0 ;
	    exp p1 ;
	    p0 = hold_check ( d_exp () ) ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_make_weak_defn ( p0, p1 ) ) ;
	}
	case e_make_weak_symbol : {
	    tdfstring p0 ;
	    exp p1 ;
	    p0 = d_tdfstring () ;
	    p1 = hold_check ( d_exp () ) ;
	    return ( f_make_weak_symbol ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_linkinfo ) ;
    return ( f_dummy_linkinfo ) ;
}


/* DECODE LINKINFO_LIST */

linkinfo_list d_linkinfo_list
    PROTO_Z ()
{
    int i, n ;
    linkinfo_list temp ;
    n = small_dtdfint () ;
    temp = new_linkinfo_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	linkinfo e ;
	e = d_linkinfo () ;
	temp = add_linkinfo_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE LINKINFO_PROPS */

linkinfo_props d_linkinfo_props
    PROTO_Z ()
{
    tdfint p0 ;
    linkinfo_list p1 ;
    p0 = d_tdfint () ;
    p1 = d_linkinfo_list () ;
    return ( f_make_linkinfos ( p0, p1 ) ) ;
}


/* DECODE LINKS */

links d_links
    PROTO_Z ()
{
    link_list p0 ;
    p0 = d_link_list () ;
    return ( f_make_links ( p0 ) ) ;
}


/* DECODE LINKS_LIST */

links_list d_links_list
    PROTO_Z ()
{
    int i, n ;
    links_list temp ;
    n = small_dtdfint () ;
    temp = new_links_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	links e ;
	e = d_links () ;
	temp = add_links_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE NAT */

nat d_nat
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_nat_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_nat_apply_token ( p0, p1 ) ) ;
	}
	case e_nat_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_nat_cond ( p0, p1, p2 ) ) ;
	}
	case e_computed_nat : {
	    exp p0 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    return ( f_computed_nat ( p0 ) ) ;
	}
	case e_error_val : {
	    error_code p0 ;
	    p0 = d_error_code () ;
	    return ( f_error_val ( p0 ) ) ;
	}
	case e_make_nat : {
	    tdfint p0 ;
	    p0 = d_tdfint () ;
	    return ( f_make_nat ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_nat ) ;
    return ( f_dummy_nat ) ;
}


/* DECODE NAT_OPTION */

nat_option d_nat_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	nat e ;
	e = d_nat () ;
	return ( yes_nat_option ( e ) ) ;
    }
    return ( no_nat_option ) ;
}


/* DECODE NTEST */

ntest d_ntest
    PROTO_Z ()
{
    int code = get_big_code ( 4 ) ;
    switch ( code ) {
	case e_ntest_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_ntest_apply_token ( p0, p1 ) ) ;
	}
	case e_ntest_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_ntest_cond ( p0, p1, p2 ) ) ;
	}
	case e_equal : {
	    return ( f_equal ) ;
	}
	case e_greater_than : {
	    return ( f_greater_than ) ;
	}
	case e_greater_than_or_equal : {
	    return ( f_greater_than_or_equal ) ;
	}
	case e_less_than : {
	    return ( f_less_than ) ;
	}
	case e_less_than_or_equal : {
	    return ( f_less_than_or_equal ) ;
	}
	case e_not_equal : {
	    return ( f_not_equal ) ;
	}
	case e_not_greater_than : {
	    return ( f_not_greater_than ) ;
	}
	case e_not_greater_than_or_equal : {
	    return ( f_not_greater_than_or_equal ) ;
	}
	case e_not_less_than : {
	    return ( f_not_less_than ) ;
	}
	case e_not_less_than_or_equal : {
	    return ( f_not_less_than_or_equal ) ;
	}
	case e_less_than_or_greater_than : {
	    return ( f_less_than_or_greater_than ) ;
	}
	case e_not_less_than_and_not_greater_than : {
	    return ( f_not_less_than_and_not_greater_than ) ;
	}
	case e_comparable : {
	    return ( f_comparable ) ;
	}
	case e_not_comparable : {
	    return ( f_not_comparable ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_ntest ) ;
    return ( f_dummy_ntest ) ;
}


/* DECODE OTAGEXP */

otagexp d_otagexp
    PROTO_Z ()
{
    tag_option p0 ;
    exp p1 ;
    p0 = d_tag_option () ;
    p1 = hold_check ( d_exp () ) ;
    return ( f_make_otagexp ( p0, p1 ) ) ;
}


/* DECODE OTAGEXP_LIST */

otagexp_list d_otagexp_list
    PROTO_Z ()
{
    int i, n ;
    otagexp_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_otagexp_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	otagexp e ;
	e = d_otagexp () ;
	temp = add_otagexp_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE PROCPROPS */

procprops d_procprops
    PROTO_Z ()
{
    int code = get_big_code ( 4 ) ;
    switch ( code ) {
	case e_procprops_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_procprops_apply_token ( p0, p1 ) ) ;
	}
	case e_procprops_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_procprops_cond ( p0, p1, p2 ) ) ;
	}
	case e_add_procprops : {
	    procprops p0 ;
	    procprops p1 ;
	    p0 = d_procprops () ;
	    p1 = d_procprops () ;
	    return ( f_add_procprops ( p0, p1 ) ) ;
	}
	case e_check_stack : {
	    return ( f_check_stack ) ;
	}
	case e_inline : {
	    return ( f_inline ) ;
	}
	case e_no_long_jump_dest : {
	    return ( f_no_long_jump_dest ) ;
	}
	case e_untidy : {
	    return ( f_untidy ) ;
	}
	case e_var_callees : {
	    return ( f_var_callees ) ;
	}
	case e_var_callers : {
	    return ( f_var_callers ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_procprops ) ;
    return ( f_dummy_procprops ) ;
}


/* DECODE PROCPROPS_OPTION */

procprops_option d_procprops_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	procprops e ;
	e = d_procprops () ;
	return ( yes_procprops_option ( e ) ) ;
    }
    return ( no_procprops_option ) ;
}


/* DECODE ROUNDING_MODE */

rounding_mode d_rounding_mode
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_rounding_mode_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_rounding_mode_apply_token ( p0, p1 ) ) ;
	}
	case e_rounding_mode_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_rounding_mode_cond ( p0, p1, p2 ) ) ;
	}
	case e_round_as_state : {
	    return ( f_round_as_state ) ;
	}
	case e_to_nearest : {
	    return ( f_to_nearest ) ;
	}
	case e_toward_larger : {
	    return ( f_toward_larger ) ;
	}
	case e_toward_smaller : {
	    return ( f_toward_smaller ) ;
	}
	case e_toward_zero : {
	    return ( f_toward_zero ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_rounding_mode ) ;
    return ( f_dummy_rounding_mode ) ;
}


/* DECODE SHAPE */

shape d_shape
    PROTO_Z ()
{
    int code = get_big_code ( 4 ) ;
    switch ( code ) {
	case e_shape_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_shape_apply_token ( p0, p1 ) ) ;
	}
	case e_shape_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_shape_cond ( p0, p1, p2 ) ) ;
	}
	case e_bitfield : {
	    bitfield_variety p0 ;
	    p0 = d_bitfield_variety () ;
	    return ( f_bitfield ( p0 ) ) ;
	}
	case e_bottom : {
	    return ( f_bottom ) ;
	}
	case e_compound : {
	    exp p0 ;
	    p0 = hold_check ( d_exp () ) ;
	    return ( f_compound ( p0 ) ) ;
	}
	case e_floating : {
	    floating_variety p0 ;
	    p0 = d_floating_variety () ;
	    return ( f_floating ( p0 ) ) ;
	}
	case e_integer : {
	    variety p0 ;
	    p0 = d_variety () ;
	    return ( f_integer ( p0 ) ) ;
	}
	case e_nof : {
	    nat p0 ;
	    shape p1 ;
	    p0 = d_nat () ;
	    p1 = d_shape () ;
	    return ( f_nof ( p0, p1 ) ) ;
	}
	case e_offset : {
	    alignment p0 ;
	    alignment p1 ;
	    p0 = d_alignment () ;
	    p1 = d_alignment () ;
	    return ( f_offset ( p0, p1 ) ) ;
	}
	case e_pointer : {
	    alignment p0 ;
	    p0 = d_alignment () ;
	    return ( f_pointer ( p0 ) ) ;
	}
	case e_proc : {
	    return ( f_proc ) ;
	}
	case e_top : {
	    return ( f_top ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_shape ) ;
    return ( f_dummy_shape ) ;
}


/* DECODE SHAPE_OPTION */

shape_option d_shape_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	shape e ;
	e = d_shape () ;
	return ( yes_shape_option ( e ) ) ;
    }
    return ( no_shape_option ) ;
}


/* DECODE SIGNED_NAT */

signed_nat d_signed_nat
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_signed_nat_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_signed_nat_apply_token ( p0, p1 ) ) ;
	}
	case e_signed_nat_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_signed_nat_cond ( p0, p1, p2 ) ) ;
	}
	case e_computed_signed_nat : {
	    exp p0 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    return ( f_computed_signed_nat ( p0 ) ) ;
	}
	case e_make_signed_nat : {
	    tdfbool p0 ;
	    tdfint p1 ;
	    p0 = d_tdfbool () ;
	    p1 = d_tdfint () ;
	    return ( f_make_signed_nat ( p0, p1 ) ) ;
	}
	case e_snat_from_nat : {
	    bool p0 ;
	    nat p1 ;
	    p0 = d_bool () ;
	    p1 = d_nat () ;
	    return ( f_snat_from_nat ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_signed_nat ) ;
    return ( f_dummy_signed_nat ) ;
}


/* DECODE SORTNAME */

sortname d_sortname
    PROTO_Z ()
{
    int code = get_big_code ( 5 ) ;
    switch ( code ) {
	case e_access : {
	    return ( f_access ) ;
	}
	case e_al_tag : {
	    return ( f_al_tag ) ;
	}
	case e_alignment_sort : {
	    return ( f_alignment_sort ) ;
	}
	case e_bitfield_variety : {
	    return ( f_bitfield_variety ) ;
	}
	case e_bool : {
	    return ( f_bool ) ;
	}
	case e_error_treatment : {
	    return ( f_error_treatment ) ;
	}
	case e_exp : {
	    return ( f_exp ) ;
	}
	case e_floating_variety : {
	    return ( f_floating_variety ) ;
	}
	case e_foreign_sort : {
	    string p0 ;
	    p0 = d_string () ;
	    return ( f_foreign_sort ( p0 ) ) ;
	}
	case e_label : {
	    return ( f_label ) ;
	}
	case e_nat : {
	    return ( f_nat ) ;
	}
	case e_ntest : {
	    return ( f_ntest ) ;
	}
	case e_procprops : {
	    return ( f_procprops ) ;
	}
	case e_rounding_mode : {
	    return ( f_rounding_mode ) ;
	}
	case e_shape : {
	    return ( f_shape ) ;
	}
	case e_signed_nat : {
	    return ( f_signed_nat ) ;
	}
	case e_string : {
	    return ( f_string ) ;
	}
	case e_tag : {
	    return ( f_tag ) ;
	}
	case e_transfer_mode : {
	    return ( f_transfer_mode ) ;
	}
	case e_token : {
	    sortname p0 ;
	    sortname_list p1 ;
	    p0 = d_sortname () ;
	    p1 = d_sortname_list () ;
	    return ( f_token ( p0, p1 ) ) ;
	}
	case e_variety : {
	    return ( f_variety ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_sortname ) ;
    return ( f_dummy_sortname ) ;
}


/* DECODE SORTNAME_LIST */

sortname_list d_sortname_list
    PROTO_Z ()
{
    int i, n ;
    sortname_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_sortname_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	sortname e ;
	e = d_sortname () ;
	temp = add_sortname_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE SOURCEMARK */

sourcemark d_sourcemark
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_sourcemark : {
	    filename p0 ;
	    nat p1 ;
	    nat p2 ;
	    p0 = d_filename () ;
	    p1 = d_nat () ;
	    p2 = d_nat () ;
	    return ( f_make_sourcemark ( p0, p1, p2 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_sourcemark ) ;
    return ( f_dummy_sourcemark ) ;
}


/* DECODE STRING */

string d_string
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_string_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_string_apply_token ( p0, p1 ) ) ;
	}
	case e_string_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_string_cond ( p0, p1, p2 ) ) ;
	}
	case e_concat_string : {
	    string p0 ;
	    string p1 ;
	    p0 = d_string () ;
	    p1 = d_string () ;
	    return ( f_concat_string ( p0, p1 ) ) ;
	}
	case e_make_string : {
	    tdfstring p0 ;
	    p0 = d_tdfstring () ;
	    return ( f_make_string ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_string ) ;
    return ( f_dummy_string ) ;
}


/* DECODE STRING_LIST */

string_list d_string_list
    PROTO_Z ()
{
    int i, n ;
    string_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_string_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	string e ;
	e = d_string () ;
	temp = add_string_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE STRING_OPTION */

string_option d_string_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	string e ;
	e = d_string () ;
	return ( yes_string_option ( e ) ) ;
    }
    return ( no_string_option ) ;
}


/* DECODE TAG */

tag d_tag
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_tag_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_tag_apply_token ( p0, p1 ) ) ;
	}
	case e_make_tag : {
	    tdfint p0 ;
	    p0 = d_tdfint () ;
	    return ( f_make_tag ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_tag ) ;
    return ( f_dummy_tag ) ;
}


/* DECODE TAG_OPTION */

tag_option d_tag_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	tag e ;
	e = d_tag () ;
	return ( yes_tag_option ( e ) ) ;
    }
    return ( no_tag_option ) ;
}


/* DECODE TAGACC */

tagacc d_tagacc
    PROTO_Z ()
{
    tag p0 ;
    access_option p1 ;
    p0 = d_tag () ;
    p1 = d_access_option () ;
    return ( f_make_tagacc ( p0, p1 ) ) ;
}


/* DECODE TAGACC_OPTION */

tagacc_option d_tagacc_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	tagacc e ;
	e = d_tagacc () ;
	return ( yes_tagacc_option ( e ) ) ;
    }
    return ( no_tagacc_option ) ;
}


/* DECODE TAGDEC */

tagdec d_tagdec
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_make_id_tagdec : {
	    tdfint p0 ;
	    access_option p1 ;
	    string_option p2 ;
	    shape p3 ;
	    p0 = d_tdfint () ;
	    p1 = d_access_option () ;
	    p2 = d_string_option () ;
	    p3 = d_shape () ;
	    return ( f_make_id_tagdec ( p0, p1, p2, p3 ) ) ;
	}
	case e_make_var_tagdec : {
	    tdfint p0 ;
	    access_option p1 ;
	    string_option p2 ;
	    shape p3 ;
	    p0 = d_tdfint () ;
	    p1 = d_access_option () ;
	    p2 = d_string_option () ;
	    p3 = d_shape () ;
	    return ( f_make_var_tagdec ( p0, p1, p2, p3 ) ) ;
	}
	case e_common_tagdec : {
	    tdfint p0 ;
	    access_option p1 ;
	    string_option p2 ;
	    shape p3 ;
	    p0 = d_tdfint () ;
	    p1 = d_access_option () ;
	    p2 = d_string_option () ;
	    p3 = d_shape () ;
	    return ( f_common_tagdec ( p0, p1, p2, p3 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_tagdec ) ;
    return ( f_dummy_tagdec ) ;
}


/* DECODE TAGDEC_LIST */

tagdec_list d_tagdec_list
    PROTO_Z ()
{
    int i, n ;
    tagdec_list temp ;
    n = small_dtdfint () ;
    temp = new_tagdec_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	tagdec e ;
	e = d_tagdec () ;
	temp = add_tagdec_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE TAGDEC_PROPS */

tagdec_props d_tagdec_props
    PROTO_Z ()
{
    tdfint p0 ;
    tagdec_list p1 ;
    p0 = d_tdfint () ;
    p1 = d_tagdec_list () ;
    return ( f_make_tagdecs ( p0, p1 ) ) ;
}


/* DECODE TAGDEF */

tagdef d_tagdef
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_make_id_tagdef : {
	    tdfint p0 ;
	    string_option p1 ;
	    exp p2 ;
	    p0 = d_tdfint () ;
	    start_make_id_tagdef ( p0 ) ;
	    p1 = d_string_option () ;
	    p2 = hold_check ( d_exp () ) ;
	    return ( f_make_id_tagdef ( p0, p1, p2 ) ) ;
	}
	case e_make_var_tagdef : {
	    tdfint p0 ;
	    access_option p1 ;
	    string_option p2 ;
	    exp p3 ;
	    p0 = d_tdfint () ;
	    start_make_var_tagdef ( p0 ) ;
	    p1 = d_access_option () ;
	    p2 = d_string_option () ;
	    p3 = hold_const_check ( d_exp () ) ;
	    return ( f_make_var_tagdef ( p0, p1, p2, p3 ) ) ;
	}
	case e_common_tagdef : {
	    tdfint p0 ;
	    access_option p1 ;
	    string_option p2 ;
	    exp p3 ;
	    p0 = d_tdfint () ;
	    start_common_tagdef ( p0 ) ;
	    p1 = d_access_option () ;
	    p2 = d_string_option () ;
	    p3 = hold_const_check ( d_exp () ) ;
	    return ( f_common_tagdef ( p0, p1, p2, p3 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_tagdef ) ;
    return ( f_dummy_tagdef ) ;
}


/* DECODE TAGDEF_LIST */

tagdef_list d_tagdef_list
    PROTO_Z ()
{
    int i, n ;
    tagdef_list temp ;
    n = small_dtdfint () ;
    temp = new_tagdef_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	tagdef e ;
	e = d_tagdef () ;
	temp = add_tagdef_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE TAGDEF_PROPS */

tagdef_props d_tagdef_props
    PROTO_Z ()
{
    tdfint p0 ;
    tagdef_list p1 ;
    p0 = d_tdfint () ;
    p1 = d_tagdef_list () ;
    return ( f_make_tagdefs ( p0, p1 ) ) ;
}


/* DECODE TAGSHACC */

tagshacc d_tagshacc
    PROTO_Z ()
{
    shape p0 ;
    access_option p1 ;
    tag p2 ;
    p0 = d_shape () ;
    p1 = d_access_option () ;
    p2 = d_tag () ;
    return ( f_make_tagshacc ( p0, p1, p2 ) ) ;
}


/* DECODE TAGSHACC_LIST */

tagshacc_list d_tagshacc_list
    PROTO_Z ()
{
    int i, n ;
    tagshacc_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_tagshacc_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	tagshacc e ;
	e = d_tagshacc () ;
	temp = add_tagshacc_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE TDFIDENT_LIST */

tdfident_list d_tdfident_list
    PROTO_Z ()
{
    int i, n ;
    tdfident_list temp ;
    n = small_dtdfint () ;
    temp = new_tdfident_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	tdfident e ;
	e = d_tdfident () ;
	temp = add_tdfident_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE TDFINT_LIST */

tdfint_list d_tdfint_list
    PROTO_Z ()
{
    int i, n ;
    tdfint_list temp ;
    n = small_dtdfint () ;
    temp = new_tdfint_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	tdfint e ;
	e = d_tdfint () ;
	temp = add_tdfint_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE TOKDEC */

tokdec d_tokdec
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_tokdec : {
	    tdfint p0 ;
	    string_option p1 ;
	    sortname p2 ;
	    p0 = d_tdfint () ;
	    p1 = d_string_option () ;
	    p2 = d_sortname () ;
	    return ( f_make_tokdec ( p0, p1, p2 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_tokdec ) ;
    return ( f_dummy_tokdec ) ;
}


/* DECODE TOKDEC_LIST */

tokdec_list d_tokdec_list
    PROTO_Z ()
{
    int i, n ;
    tokdec_list temp ;
    n = small_dtdfint () ;
    temp = new_tokdec_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	tokdec e ;
	e = d_tokdec () ;
	temp = add_tokdec_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE TOKDEC_PROPS */

tokdec_props d_tokdec_props
    PROTO_Z ()
{
    tokdec_list p0 ;
    p0 = d_tokdec_list () ;
    return ( f_make_tokdecs ( p0 ) ) ;
}


/* DECODE TOKDEF */

tokdef d_tokdef
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_tokdef : {
	    tdfint p0 ;
	    string_option p1 ;
	    bitstream p2 ;
	    p0 = d_tdfint () ;
	    p1 = d_string_option () ;
	    p2 = d_bitstream () ;
	    return ( f_make_tokdef ( p0, p1, p2 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_tokdef ) ;
    return ( f_dummy_tokdef ) ;
}


/* DECODE TOKDEF_LIST */

tokdef_list d_tokdef_list
    PROTO_Z ()
{
    int i, n ;
    tokdef_list temp ;
    n = small_dtdfint () ;
    temp = new_tokdef_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	tokdef e ;
	e = d_tokdef () ;
	temp = add_tokdef_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE TOKDEF_PROPS */

tokdef_props d_tokdef_props
    PROTO_Z ()
{
    tdfint p0 ;
    tokdef_list p1 ;
    p0 = d_tdfint () ;
    p1 = d_tokdef_list () ;
    return ( f_make_tokdefs ( p0, p1 ) ) ;
}


/* DECODE TOKEN */

token d_token
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_token_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_token_apply_token ( p0, p1 ) ) ;
	}
	case e_make_tok : {
	    tdfint p0 ;
	    p0 = d_tdfint () ;
	    return ( f_make_tok ( p0 ) ) ;
	}
	case e_use_tokdef : {
	    bitstream p0 ;
	    p0 = d_bitstream () ;
	    return ( f_use_tokdef ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_token ) ;
    return ( f_dummy_token ) ;
}


/* DECODE TOKEN_DEFN */

token_defn d_token_defn
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_token_definition : {
	    sortname p0 ;
	    tokformals_list p1 ;
	    p0 = d_sortname () ;
	    p1 = d_tokformals_list () ;
	    return ( f_token_definition ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_token_defn ) ;
    return ( f_dummy_token_defn ) ;
}


/* DECODE TOKEN_OPTION */

token_option d_token_option
    PROTO_Z ()
{
    if ( getcode ( 1 ) ) {
	token e ;
	e = d_token () ;
	return ( yes_token_option ( e ) ) ;
    }
    return ( no_token_option ) ;
}


/* DECODE TOKFORMALS */

tokformals d_tokformals
    PROTO_Z ()
{
    sortname p0 ;
    tdfint p1 ;
    p0 = d_sortname () ;
    p1 = d_tdfint () ;
    return ( f_make_tokformals ( p0, p1 ) ) ;
}


/* DECODE TOKFORMALS_LIST */

tokformals_list d_tokformals_list
    PROTO_Z ()
{
    int i, n ;
    tokformals_list temp ;
    IGNORE getcode ( 1 ) ;
    n = small_dtdfint () ;
    temp = new_tokformals_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	tokformals e ;
	e = d_tokformals () ;
	temp = add_tokformals_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE TRANSFER_MODE */

transfer_mode d_transfer_mode
    PROTO_Z ()
{
    int code = get_big_code ( 3 ) ;
    switch ( code ) {
	case e_transfer_mode_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_transfer_mode_apply_token ( p0, p1 ) ) ;
	}
	case e_transfer_mode_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_transfer_mode_cond ( p0, p1, p2 ) ) ;
	}
	case e_add_modes : {
	    transfer_mode p0 ;
	    transfer_mode p1 ;
	    p0 = d_transfer_mode () ;
	    p1 = d_transfer_mode () ;
	    return ( f_add_modes ( p0, p1 ) ) ;
	}
	case e_overlap : {
	    return ( f_overlap ) ;
	}
	case e_standard_transfer_mode : {
	    return ( f_standard_transfer_mode ) ;
	}
	case e_trap_on_nil : {
	    return ( f_trap_on_nil ) ;
	}
	case e_volatile : {
	    return ( f_volatile ) ;
	}
	case e_complete : {
	    return ( f_complete ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_transfer_mode ) ;
    return ( f_dummy_transfer_mode ) ;
}


/* DECODE UNIQUE */

unique d_unique
    PROTO_Z ()
{
    tdfident_list p0 ;
    p0 = d_tdfident_list () ;
    return ( f_make_unique ( p0 ) ) ;
}


/* DECODE UNIT */

unit d_unit
    PROTO_Z ()
{
    tdfint_list p0 ;
    links_list p1 ;
    bytestream p2 ;
    p0 = d_tdfint_list () ;
    start_make_unit ( p0 ) ;
    p1 = d_links_list () ;
    p2 = d_bytestream () ;
    return ( f_make_unit ( p0, p1, p2 ) ) ;
}


/* DECODE UNIT_LIST */

unit_list d_unit_list
    PROTO_Z ()
{
    int i, n ;
    unit_list temp ;
    n = small_dtdfint () ;
    temp = new_unit_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	unit e ;
	e = d_unit () ;
	temp = add_unit_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE VARIETY */

variety d_variety
    PROTO_Z ()
{
    int code = get_big_code ( 2 ) ;
    switch ( code ) {
	case e_var_apply_token : {
	    token p0 ;
	    bitstream p1 ;
	    p0 = d_token () ;
	    p1 = d_bitstream () ;
	    return ( f_var_apply_token ( p0, p1 ) ) ;
	}
	case e_var_cond : {
	    exp p0 ;
	    bitstream p1 ;
	    bitstream p2 ;
	    p0 = hold_const_check ( d_exp () ) ;
	    p1 = d_bitstream () ;
	    p2 = d_bitstream () ;
	    return ( f_var_cond ( p0, p1, p2 ) ) ;
	}
	case e_var_limits : {
	    signed_nat p0 ;
	    signed_nat p1 ;
	    p0 = d_signed_nat () ;
	    p1 = d_signed_nat () ;
	    return ( f_var_limits ( p0, p1 ) ) ;
	}
	case e_var_width : {
	    bool p0 ;
	    nat p1 ;
	    p0 = d_bool () ;
	    p1 = d_nat () ;
	    return ( f_var_width ( p0, p1 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_variety ) ;
    return ( f_dummy_variety ) ;
}


/* DECODE VERSION */

version d_version
    PROTO_Z ()
{
    int code = get_big_code ( 1 ) ;
    switch ( code ) {
	case e_make_version : {
	    tdfint p0 ;
	    tdfint p1 ;
	    p0 = d_tdfint () ;
	    p1 = d_tdfint () ;
	    return ( f_make_version ( p0, p1 ) ) ;
	}
	case e_user_info : {
	    string p0 ;
	    p0 = d_string () ;
	    return ( f_user_info ( p0 ) ) ;
	}
    }
    decode_error ( ILLEGAL_CODE_version ) ;
    return ( f_dummy_version ) ;
}


/* DECODE VERSION_LIST */

version_list d_version_list
    PROTO_Z ()
{
    int i, n ;
    version_list temp ;
    n = small_dtdfint () ;
    temp = new_version_list ( n ) ;
    for ( i = 0 ; i < n; i++ ) {
	version e ;
	e = d_version () ;
	temp = add_version_list ( temp, e, i ) ;
    }
    return ( temp ) ;
}


/* DECODE VERSION_PROPS */

version_props d_version_props
    PROTO_Z ()
{
    version_list p0 ;
    p0 = d_version_list () ;
    return ( f_make_versions ( p0 ) ) ;
}
