C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE ENVFCT
C                       *****************
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C
C BUT : PROGRAMME DE LECTURE DE L'EMPLACEMENT ET DES NOMS DES FICHIERS
C------ NECESSAIRES AU CODE SYRTHES - 
C
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !           !    !    !                                              !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !___________!____!____!______________________________________________!
C ! /NOMFIC/  !    ! R  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT  : ININOM
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C-----------------------------------------------------------------------
C 
C PORTAGE DUTOYA
C
C***********************************************************************
C
      IMPLICIT NONE
C
      INTEGER     MMOTC1    , MMOTC2,       MMOTRA
      PARAMETER ( MMOTC1 = 4, MMOTC2 = 14 , MMOTRA = 11)
C
C***********************************************************************
C     DONNEES EN COMMON  
C***********************************************************************
C
#include "nlofes.h"
#include "fichct.h"
C
C***********************************************************************
C
C... Declarations des variables internes
C
      CHARACTER NAME*200,CHAIN*200,VARIAB*200,DIRECT*3
      CHARACTER CHAPIT(MMOTC1)*200,MOTCLE(MMOTC2)*200
      CHARACTER MOTRAY(MMOTRA)*200
      INTEGER   ICHAPI(MMOTC1),IMOTCL(MMOTC2),IMOTRA(MMOTRA)
      INTEGER   NFIC,IOS,I1,II1,I2,II2,LPOS,N1,IDEB,IFIN
C
C***********************************************************************
C
      DATA CHAPIT / 'EMPLACEMENT DES FICHIERS POUR SYRTHES',
     *              'NOM DES FICHIERS AMONT POUR SYRTHES',
     *              'NOM DES FICHIERS SUITE POUR SYRTHES',
     *              'NOM DES FICHIERS AVAL POUR SYRTHES'/
C
      DATA MOTCLE / 'AMONT :', 'SUITE :', 'AVAL :', 
     *              'GEOMETRIE SOLIDE :','DONNEES DU CALCUL :',
     *              'SUITE SOLIDE RESU :','RESU SYRTHES 1 :',
     *              'RESU SYRTHES 2 :','CHRONO SYRTHES 2 :',
     *              'MAILLAGE PEAU FLUIDE :',
     *              'RESULTATS PEAU FLUIDE :',
     *              'CHRONO PEAU FLUIDE :',
     *              'HISTORIQUE SOLIDE RESULTAT :',
     *              'STOCKAGE DES CORRESPONDANTS :' /
C
      DATA MOTRAY / 'MAILLAGE RAYONNEMENT :',
     *              'MAILLAGE DE RAYONNEMENT :',
     *              'RESULTATS DE RAYONNEMENT :',
     *              'CHRONO DE RAYONNEMENT :',
     *              'FACTEURS DE FORME RAYONNEMENT :',
     *              'DONNEES POUR LE RAYONNEMENT :',
     *              'STOCKAGE DES CORRESPONDANTS RAYONNEMENT :',
     *              'HISTORIQUE RAYONNEMENT :',
     *              'SUITE RAYONNEMENT MSTS :',
     *              'RESU RAYONNEMENT MSTS :',
     *              'RESU EPAISSEUR MSTS :' /
C
      DATA ICHAPI / 42, 40, 35, 34 /
      DATA IMOTCL /  7,7,6,   18,19,  19,16, 
     *               16,18,  22,  23,  20,  28, 29/
      DATA IMOTRA /22,25,26,23,31,29,41,24,24,23,21/
C
C     ===========================================
C     1- OUVERTURE DU FICHIER EMPLACEMENT ET NOMS
C     ===========================================
C
      NAME   = ' '
      DIRECT = ' '
      NFIC   = 98
C
C++ VERSION UNIX 
C
      NAME   = 'syrthes.env'
      DIRECT = '../'
C++
C
      CALL VERLOS ( NAME, I1, I2, LPOS )
      OPEN ( UNIT= NFIC, FILE=NAME (I1:I2), STATUS='OLD',
     1       FORM='FORMATTED',ACCESS='SEQUENTIAL',IOSTAT=IOS, ERR=99 )
C
      REWIND ( NFIC )
C
C     =========================================
C     2- LECTURE DES ENREGISTREMENTS DU FICHIER
C     =========================================
C
      IDEB = 3
      N1   = LEN ( CHAIN )
C
  10  CONTINUE
      CHAIN = ' '
      READ ( NFIC, '(A)', END=100 ) CHAIN
      IF ( CHAIN .EQ. ' ' ) GOTO 10
C
C... SAUVEGARDE SUR ECRAN OU FICHIER
C    -------------------------------
      WRITE ( NFECRA,'(A)' ) CHAIN 
C
C... LECTURE DES LIGNES DE PRESENTATION
C    ----------------------------------
      IF ( CHAIN (1:1) .EQ. '*' .OR. CHAIN (1:1) .EQ. '/') THEN
         GOTO 10
C
C... LECTURE DES EMPLACEMENTS DES FICHIERS
C    -------------------------------------
      ELSEIF ( CHAIN (1:ICHAPI(1)) .EQ. CHAPIT (1) (1:ICHAPI(1)) ) THEN
         GOTO 10
C
C     Repertoire amont
C     ~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(1)-1 ) .EQ.
     *                               MOTCLE (1) ( 1:IMOTCL (1) ) ) THEN
         RAMON  = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (1)
         VARIAB = CHAIN ( IFIN:N1 )
         IF ( VARIAB .EQ. ' ' ) VARIAB = DIRECT
C
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         RAMON ( 1:LPOS ) = VARIAB ( II1:II2 )
C
C     Repertoire suite
C     ~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(2)-1 ) .EQ. 
     *                               MOTCLE (2) ( 1:IMOTCL (2) ) ) THEN
         RSUITE = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (2)
         VARIAB = CHAIN ( IFIN:N1 )
         IF ( VARIAB .EQ. ' ' ) VARIAB = DIRECT
C
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         RSUITE ( 1:LPOS ) = VARIAB ( II1:II2 )
C
C     Repertoire aval
C     ~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(3)-1 ) .EQ. 
     *                                MOTCLE (3) ( 1:IMOTCL (3) ) ) THEN
         RAVAL  = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (3)
         VARIAB = CHAIN ( IFIN:N1 )
         IF ( VARIAB .EQ. ' ' ) VARIAB = DIRECT
C
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         RAVAL ( 1:LPOS ) = VARIAB ( II1:II2 )
C
C
C... LECTURE DES NOMS DES FICHIERS AMONT
C    -----------------------------------
      ELSEIF ( CHAIN (1:ICHAPI(2)) .EQ. CHAPIT (2) (1:ICHAPI(2)) ) THEN
         GOTO 10
C
C
C     Geometrie solide
C     ~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(4)-1 ) .EQ.  
     *                              MOTCLE (4) ( 1:IMOTCL (4) ) ) THEN 
         CTMAEF = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (4)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'geom_ef'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTMAEF( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Fichier de donnees
C     ~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(5)-1 ) .EQ.  
     *                              MOTCLE (5) ( 1:IMOTCL (5) ) ) THEN 
         CTCL = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (5)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'syrthes.data'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTCL( 1:LPOS ) = VARIAB( II1:II2 )
C
C
C     Maillage pour le rayonnement
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(1)-1 ) .EQ.  
     *                              MOTRAY (1) ( 1:IMOTRA (1) ) ) THEN 
         CTGERA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (1)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'geom_ray.sim'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTGERA( 1:LPOS ) = VARIAB( II1:II2 )
C
C
C     Donnees pour le rayonnement
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(6)-1 ) .EQ.  
     *                              MOTRAY (6) ( 1:IMOTRA (6) ) ) THEN 
         CTCLRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (6)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'syrthes.ray'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTCLRA( 1:LPOS ) = VARIAB( II1:II2 )
C
C
C... EMPLACEMENT DU FICHIER SUITE
C    ----------------------------
      ELSEIF ( CHAIN (1:ICHAPI(3)) .EQ. CHAPIT (3) (1:ICHAPI(3)) ) THEN
         GOTO 10
C
C     Fichier suite
C     ~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(6)-1 ) .EQ.  
     *                              MOTCLE (6) ( 1:IMOTCL (6) ) ) THEN 
         CTSUIT = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (6)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'suit_sol'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTSUIT( 1:LPOS ) = VARIAB( II1:II2 )
C
C
C     Stockage des correspondants
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(14)-1 ) .EQ.  
     *                              MOTCLE (14) ( 1:IMOTCL (14) ) ) THEN 
         CTCORR = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (14)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'corresp'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTCORR( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Rayonnement : facteurs de forme
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(5)-1 ) .EQ.  
     *                              MOTRAY (5) ( 1:IMOTRA (5) ) ) THEN 
         CTFFRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (5)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'fdf_ray'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTFFRA( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Stockage des correspondants pour rayonnemnt
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(7)-1 ) .EQ.  
     *                              MOTRAY (7) ( 1:IMOTRA (7) ) ) THEN 
         CTCORA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (7)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'corresp.ray'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTCORA( 1:LPOS ) = VARIAB( II1:II2 )
C
C
C
C... EMPLACEMENT DES FICHIERS RESULTATS
C    ----------------------------------
      ELSEIF ( CHAIN (1:ICHAPI(4)) .EQ. CHAPIT (4) (1:ICHAPI(4)) ) THEN
         GOTO 10
C
C     Resultat - geometrie
C     ~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(7)-1 ) .EQ.  
     *                              MOTCLE (7) ( 1:IMOTCL (7) ) ) THEN 
         CTGRF1 = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (7)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'grf1'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTGRF1( 1:LPOS ) = VARIAB( II1:II2 )
C
C
C     Resultat - Champs
C     ~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(8)-1 ) .EQ.  
     *                              MOTCLE (8) ( 1:IMOTCL (8) ) ) THEN 
         CTGRF2 = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (8)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'grf2'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTGRF2( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Resultat - Chrono
C     ~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(9)-1 ) .EQ.  
     *                              MOTCLE (9) ( 1:IMOTCL (9) ) ) THEN 
         CTGF2C = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (9)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'grf2c'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTGF2C( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Geometrie fluide couplee
C     ~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(10)-1 ) .EQ.  
     *                              MOTCLE (10) ( 1:IMOTCL (10) ) ) THEN 
         CTGEOF = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (10)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'geomf_ef'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTGEOF( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Resultat sur la peau du fluide
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(11)-1 ) .EQ.  
     *                              MOTCLE (11) ( 1:IMOTCL (11) ) ) THEN 
         CTRESF = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (11)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'resuf_ef'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTRESF( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Chrono sur la peau du fluide
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(12)-1 ) .EQ.  
     *                              MOTCLE (12) ( 1:IMOTCL (12) ) ) THEN 
         CTCHOF = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (12)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'chronof_ef'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTCHOF( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Historique - resultat
C     ~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTCL(13)-1 ) .EQ.  
     *                              MOTCLE (13) ( 1:IMOTCL (13) ) ) THEN 
         CTHISR = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTCL (13)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'hissolr'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTHISR( 1:LPOS ) = VARIAB( II1:II2 )
C 
C     Rayonnement : maillage resultat
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(2)-1 ) .EQ.  
     *                              MOTRAY (2) ( 1:IMOTRA (2) ) ) THEN 
         CTRGRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (2)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'resu_ray.geom'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTRGRA( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Rayonnement : resultat
C     ~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(3)-1 ) .EQ.  
     *                              MOTRAY (3) ( 1:IMOTRA (3) ) ) THEN 
         CTRRRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (3)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'resu_ray'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTRRRA( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Rayonnement : chronologique
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(4)-1 ) .EQ.  
     *                              MOTRAY (4) ( 1:IMOTRA (4) ) ) THEN 
         CTRCRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (4)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'chrono_ray'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTRCRA( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Rayonnement : historiques
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(8)-1 ) .EQ.  
     *                              MOTRAY (8) ( 1:IMOTRA (8) ) ) THEN 
         CTHIRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (8)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'histo_ray'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTHIRA( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Fichier suite rayonnement msts
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(9)-1 ) .EQ.  
     *                              MOTRAY (9) ( 1:IMOTRA (9) ) ) THEN 
         CTSMRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (9)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'suit_ray_msts'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTSMRA( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Fichier resu rayonnement msts
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(10)-1 ) .EQ.  
     *                              MOTRAY (10) ( 1:IMOTRA (10) ) ) THEN 
         CTRMRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (10)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'resu_ray_msts'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTRMRA( 1:LPOS ) = VARIAB( II1:II2 )
C
C     Fichier resu epaisseur msts
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      ELSEIF ( CHAIN ( IDEB:IDEB+IMOTRA(11)-1 ) .EQ.  
     *                              MOTRAY (11) ( 1:IMOTRA (11) ) ) THEN 
         CTEMRA = ' '
         VARIAB = ' '
         IFIN   = IDEB + IMOTRA (11)
         VARIAB = CHAIN ( IFIN:N1 )             
         IF ( VARIAB .EQ. ' ' ) VARIAB = 'resu_epai_msts'
         CALL VERLOS ( VARIAB, II1, II2, LPOS )
         CTEMRA( 1:LPOS ) = VARIAB( II1:II2 )
C
      ELSE
         CALL VERLOS ( CHAIN, II1, II2, LPOS )
         WRITE ( NFECRA,8888 ) NAME (I1:I2), CHAIN (II1:II2)
      ENDIF
C
C
      GOTO 10
C
C------------------------
C FIN DE L'ENREGISTREMENT
C------------------------
C
 100  CONTINUE
      WRITE ( NFECRA,* )
      CLOSE ( NFIC )
      RETURN
C
C-------------------
C ERREUR D'OUVERTURE
C-------------------
C
   99 CONTINUE
      WRITE ( NFECRA,9999 ) NAME ( I1:I2 )
      STOP
C
C-------
C FORMAT
C-------
C
 8888 FORMAT ( 1X,'%% ERREUR DANS FICHIER',1X,A,/,
     * 4X,'LIGNE INCONNUE :',1X,A )
 9999 FORMAT ( /,1X,'%% ERREUR D''OUVERTURE SUR LE FICHIER :',1X,A,/ )
C
C----
C FIN
C----
C
      END
