/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RPVIEWTREE_H
#define _SC_RPVIEWTREE_H

// sc
#include "TreeView.h"
#include "RpViewState.h"
#include "svn/DirEntryTypes.h"
#include "util/String.h"
class RpViewEntryData;
class RpViewTreeItemModel;
class RpViewTreeProxyModel;
class RpSelection;
class ActionStorage;
class DragInfo;

// qt
class Q3PopupMenu;


class RpViewTree : public TreeView
{
  typedef TreeView super;
  Q_OBJECT

public:
  RpViewTree( const sc::String& root, RpViewState* state, ActionStorage* as, QWidget* parent );
  ~RpViewTree();

public slots:
  /** remove old info.. */
  void updateOld( const sc::String&, const svn::DirEntries& );
  /** ..add new info    */
  void updateNew( const sc::String&, const svn::DirEntries& );

  /** change the current dir */
  void setCurrentDir( const sc::String& newCurrent );
  /** refresh the view, honoring any option changes */
  void refresh();

  // Q.. overwrites
  void contextMenuEvent( QContextMenuEvent* e );
  /** update actions after selection change */
  void selectionChanged( const QItemSelection& selected, const QItemSelection& deselected );

  void mouseDoubleClickEvent( QMouseEvent* e );
  /** Rename the current item to @a text. */
  void renameItem( const QString& text );
  void storeState( const QModelIndex& index );

  void showEvent( QShowEvent* );
  void mousePressEvent( QMouseEvent* e );
  void mouseMoveEvent( QMouseEvent* e );
  void dragEnterEvent( QDragEnterEvent* e );
  void dragMoveEvent( QDragMoveEvent* e );
  void dragLeaveEvent( QDragLeaveEvent* e );
  void dropEvent( QDropEvent* e );
  void timerEvent( QTimerEvent* e );

signals:
  /** signal move item, set base if to is basename, else dirname is asumed */
  void move( const sc::String& to, bool base );
  void copy( const sc::String& to );
  
  /** notify current dir change */
  void currentChanged( const sc::String& );
  void selectionChanged( const RpSelection& );

private:
  void updateMenu( const RpSelection& sel );
  void getSelection( svn::DirEntries& statuss );
  QMimeData* mimeData( const QModelIndexList& list );
  void restoreState( const QModelIndex& index );
  void setChildsExpanded( const QModelIndex& index );

  RpViewEntryData*      _itemData;
public: // fixme
  RpViewTreeItemModel*  _itemModel;
private:
  RpViewTreeProxyModel* _proxyModel;

  RpViewState*          _state;

  ActionStorage*        _actions;
  Q3PopupMenu*          _menu;
};

#endif // _SC_RPVIEWTREE_H
