# Release Notes v0.9.0 : Fault Tree Preprocessing Techniques

This release adds more fault tree preprocessing techniques
that simplify a fault tree before the analysis.
Depending on the structure of the fault trees,
the observed gain in the analysis speed ranges from none to 50x.


## Major Changes

- Boolean optimization

    * Failure propagation
    * Redundancy detection

- Merging common arguments for gates

- Multiple definition detection for gates

- The Shannon decomposition for common nodes

- Distributivity detection

- Grouping non-module nodes into modules

- Recursive normalization of K-out-of-N gates


## Other Additions

- Optional link against TCMalloc (20-30% speed gain)

- Capability to print the fault tree in preprocessing (the shorthand format)

- NULL gates in the shorthand format

- "--gates" argument for the fault tree generator script

- Semantic Linefeeds for documentation source texts


## Bug Fixes

- Crash on a NULL or NOT gate top event with a single non-gate child.

- Incorrect warning when no MCS is found, which indicates NULL
  (guaranteed success or prob(top) = 0).


## Since v0.8.0

- 189 commits resulted in
  156 files changed, 10478 insertions(+), 4998 deletions(-)
