#! /usr/bin/env python

"""ex-ior.py - Plugging in CORBA alarm actions via the IOR string

Thi Python script implements an example alarm action.  If you run this
script, it will output an IOR string and then just start sleeping.
Fill in this string into the corresponding field of the "action" tab
in a timer's properties dialog.  The timer then will call the
'Deliver' action below."""

import CORBA, SandUhr, SandUhr__POA

class Wecker(SandUhr__POA.AlarmAction):
    def __init__(self):
        self.NeedsPopup = CORBA.FALSE

    def Attach(self, timer):
        pass

    def Detach(self, timer):
        orb.shutdown(1)

    def Deliver(self, timespec, message):
        print message

orb = CORBA.ORB_init()
poa = orb.resolve_initial_references("RootPOA")

ref = Wecker()._this()
print orb.object_to_string(ref)

poa.the_POAManager.activate()
orb.run()
