
/*
 * Osmo - a handy personal organizer
 *
 * Copyright (C) 2007 Tomasz Maka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "stock_icons.h"
#include "i18n.h"
#include "stock_icons_data.h"

/*------------------------------------------------------------------------------*/

void
osmo_register_theme_icons() {

gint i;

gchar * osmo_stock_items[] = {

    OSMO_STOCK_BUTTON_ADD,
    OSMO_STOCK_BUTTON_CLEAR,
    OSMO_STOCK_BUTTON_CLOSE,
    OSMO_STOCK_BUTTON_CANCEL,
    OSMO_STOCK_BUTTON_JUMPTO,
    OSMO_STOCK_BUTTON_EDIT,
    OSMO_STOCK_BUTTON_DOWN,
    OSMO_STOCK_BUTTON_INFO,
    OSMO_STOCK_BUTTON_INSERT_TIMELINE,
    OSMO_STOCK_BUTTON_NEXT_YEAR,
    OSMO_STOCK_BUTTON_NO,
    OSMO_STOCK_BUTTON_OK,
    OSMO_STOCK_BUTTON_OPEN,
    OSMO_STOCK_BUTTON_PREV_YEAR,
    OSMO_STOCK_BUTTON_REMOVE,
    OSMO_STOCK_BUTTON_SELECT_COLOR,
    OSMO_STOCK_BUTTON_SELECT_DATE,
    OSMO_STOCK_BUTTON_SELECT_FONT,
    OSMO_STOCK_BUTTON_TODAY,
    OSMO_STOCK_BUTTON_YES,

    OSMO_STOCK_SYSTRAY_NORMAL,
    OSMO_STOCK_SYSTRAY_NOTE,
    OSMO_STOCK_SYSTRAY_MENU_CALENDAR,

    OSMO_STOCK_BACKUP,
    OSMO_STOCK_RESTORE,

    OSMO_STOCK_OPEN_URL,

    OSMO_STOCK_ABOUT,
    OSMO_STOCK_CALENDAR,
    OSMO_STOCK_CLOSE,
    OSMO_STOCK_CALCULATOR,
    OSMO_STOCK_EDIT_NOTE,

#ifdef CONTACTS_ENABLED
    OSMO_STOCK_CONTACTS_ADD,
    OSMO_STOCK_CONTACTS_BIRTHDAYS,
    OSMO_STOCK_CONTACTS_EDIT,
    OSMO_STOCK_CONTACTS_EXPORT,
    OSMO_STOCK_CONTACTS_IMPORT,
    OSMO_STOCK_CONTACTS_REMOVE,
    OSMO_STOCK_BUTTON_CONTACTS_EXPORT,
    OSMO_STOCK_BUTTON_CONTACTS_IMPORT,
    OSMO_STOCK_CONTACTS,
    OSMO_STOCK_SYSTRAY_BIRTHDAY,
    OSMO_STOCK_SYSTRAY_MENU_CONTACTS,
#endif /* CONTACTS_ENABLED */

#ifdef NOTES_ENABLED
    OSMO_STOCK_EDITOR_BOLD,
    OSMO_STOCK_EDITOR_CLEAR,
    OSMO_STOCK_EDITOR_FIND,
    OSMO_STOCK_EDITOR_HIGHLIGHT,
    OSMO_STOCK_EDITOR_INFO,
    OSMO_STOCK_EDITOR_INSERT_DATE_TIME,
    OSMO_STOCK_EDITOR_INSERT_SEPARATOR,
    OSMO_STOCK_EDITOR_ITALIC,
    OSMO_STOCK_EDITOR_SAVE,
    OSMO_STOCK_EDITOR_SPELL_CHECKER,
    OSMO_STOCK_EDITOR_STRIKETHROUGH,
    OSMO_STOCK_EDITOR_UNDERLINE,
    OSMO_STOCK_NOTES_ADD,
    OSMO_STOCK_NOTES_EDIT,
    OSMO_STOCK_NOTES_REMOVE,
    OSMO_STOCK_NOTES,
    OSMO_STOCK_SYSTRAY_MENU_NOTES,
#endif /* NOTES_ENABLED */

    OSMO_STOCK_EDITOR_BOLD_S,
    OSMO_STOCK_EDITOR_HIGHLIGHT_S,
    OSMO_STOCK_EDITOR_ITALIC_S,
    OSMO_STOCK_EDITOR_STRIKETHROUGH_S,
    OSMO_STOCK_EDITOR_UNDERLINE_S,

    OSMO_STOCK_FULLYEAR,
    OSMO_STOCK_HELP,
    OSMO_STOCK_INFO_HELP,
    OSMO_STOCK_JUMPTO,
    OSMO_STOCK_LICENSE,
    OSMO_STOCK_LIST_INVALID,
    OSMO_STOCK_LIST_VALID,
    OSMO_STOCK_NEXT_DAY,
    OSMO_STOCK_NEXT_MONTH,
    OSMO_STOCK_NEXT_YEAR,
    OSMO_STOCK_PREFERENCES,
    OSMO_STOCK_PREV_DAY,
    OSMO_STOCK_PREV_MONTH,
    OSMO_STOCK_PREV_YEAR,

#ifdef TASKS_ENABLED
    OSMO_STOCK_TASKS_ADD,
    OSMO_STOCK_TASKS_EDIT,
    OSMO_STOCK_TASKS_REMOVE,
    OSMO_STOCK_TASKS_IMPORT,
    OSMO_STOCK_TASKS_EXPORT,
    OSMO_STOCK_TASKS_PREV_DATE,
    OSMO_STOCK_TASKS_NEXT_DATE,
    OSMO_STOCK_TASKS,
    OSMO_STOCK_SYSTRAY_TASK,
    OSMO_STOCK_SYSTRAY_MENU_TASKS,
#endif /* TASKS_ENABLED */

    OSMO_STOCK_TODAY,

#ifdef PRINTING_SUPPORT
    OSMO_STOCK_PRINT,
#endif /* PRINTING_SUPPORT */

    OSMO_STOCK_TYPE_NORMAL,
    OSMO_STOCK_TYPE_ENCRYPTED,
    OSMO_STOCK_TYPE_RECURRENT
};

const guint8 *osmo_stock_item_data[] = {

    osmo_stock_button_add,
    osmo_stock_button_clear,
    osmo_stock_button_close,
    osmo_stock_button_cancel,
    osmo_stock_button_jumpto,
    osmo_stock_button_edit,
    osmo_stock_button_down,
    osmo_stock_button_info,
    osmo_stock_button_insert_timeline,
    osmo_stock_button_next_year,
    osmo_stock_button_no,
    osmo_stock_button_ok,
    osmo_stock_button_open,
    osmo_stock_button_prev_year,
    osmo_stock_button_remove,
    osmo_stock_button_select_color,
    osmo_stock_button_select_date,
    osmo_stock_button_select_font,
    osmo_stock_button_today,
    osmo_stock_button_yes,

    osmo_stock_systray_normal,
    osmo_stock_systray_note,
    osmo_stock_systray_menu_calendar,

    osmo_stock_backup,
    osmo_stock_restore,
    
    osmo_stock_open_url,
    
    osmo_stock_about,
    osmo_stock_calendar,
    osmo_stock_close,
    osmo_stock_calculator,
    osmo_stock_edit_note,

#ifdef CONTACTS_ENABLED
    osmo_stock_contacts_add,
    osmo_stock_contacts_birthdays,
    osmo_stock_contacts_edit,
    osmo_stock_contacts_export,
    osmo_stock_contacts_import,
    osmo_stock_contacts_remove,
    osmo_stock_button_contacts_export,
    osmo_stock_button_contacts_import,
    osmo_stock_contacts,
    osmo_stock_systray_birthday,
    osmo_stock_systray_menu_contacts,
#endif /* CONTACTS_ENABLED */

#ifdef NOTES_ENABLED
    osmo_stock_editor_bold,
    osmo_stock_editor_clear,
    osmo_stock_editor_find,
    osmo_stock_editor_highlight,
    osmo_stock_editor_info,
    osmo_stock_editor_insert_date_time,
    osmo_stock_editor_insert_separator,
    osmo_stock_editor_italic,
    osmo_stock_editor_save,
    osmo_stock_editor_spell_checker,
    osmo_stock_editor_strikethrough,
    osmo_stock_editor_underline,
    osmo_stock_notes_add,
    osmo_stock_notes_edit,
    osmo_stock_notes_remove,
    osmo_stock_notes,
    osmo_stock_systray_menu_notes,
#endif  /* NOTES_ENABLED */

    osmo_stock_editor_bold_s,
    osmo_stock_editor_highlight_s,
    osmo_stock_editor_italic_s,
    osmo_stock_editor_strikethrough_s,
    osmo_stock_editor_underline_s,
 
    osmo_stock_fullyear,
    osmo_stock_help,
    osmo_stock_info_help,
    osmo_stock_jumpto,
    osmo_stock_license,
    osmo_stock_list_invalid,
    osmo_stock_list_valid,
    osmo_stock_next_day,
    osmo_stock_next_month,
    osmo_stock_next_year,
    osmo_stock_preferences,
    osmo_stock_prev_day,
    osmo_stock_prev_month,
    osmo_stock_prev_year,
 
#ifdef TASKS_ENABLED
    osmo_stock_tasks_add,
    osmo_stock_tasks_edit,
    osmo_stock_tasks_remove,
    osmo_stock_tasks_import,
    osmo_stock_tasks_export,
    osmo_stock_tasks_prev_date,
    osmo_stock_tasks_next_date,
    osmo_stock_tasks,
    osmo_stock_systray_task,
    osmo_stock_systray_menu_tasks,
#endif  /* TASKS_ENABLED */

    osmo_stock_today,
#ifdef PRINTING_SUPPORT
    osmo_stock_print,
#endif /* PRINTING_SUPPORT */

    osmo_stock_type_normal,
    osmo_stock_type_encrypted,
    osmo_stock_type_recurrent
};

    for(i = 0; i < G_N_ELEMENTS(osmo_stock_item_data); i++) {
		GdkPixbuf *pixbuf = gdk_pixbuf_new_from_inline(-1, osmo_stock_item_data[i], FALSE, NULL);
        gint h = gdk_pixbuf_get_height (pixbuf);
        gtk_icon_theme_add_builtin_icon(osmo_stock_items[i], h, pixbuf);
        g_object_unref(pixbuf);
    }

}

/*------------------------------------------------------------------------------*/


