<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
<xsl:output method="html" encoding="UTF-8" indent="yes" doctype-public="-//W3C//DTD HTML 4.0//EN" />

<xsl:template match="code">
  <p><xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="/faq">
  <html><head>
  <link REL="SHORTCUT ICON" HREF="http://www.nordugrid.org/favicon.ico" />
  <link REL="STYLESHEET" TYPE="text/css" HREF="http://www.nordugrid.org/styles/nordugrid.css" />
  <title>NorduGrid | FAQ</title>
</head>

<body class="LONG">
  <div class="MAIN">
    <h1 class="TITLE">NorduGrid FAQ</h1>
        
    <!-- Table of contents -->
    
    <xsl:for-each select='section'>
      
      <h2>
        <a>
          <xsl:attribute name="href">#<xsl:number level='single' count='section' /></xsl:attribute>
          <xsl:number level='single' count='section'/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="title"/>
        </a>
      </h2>
      
      <dl>
        <xsl:for-each select="entry">
          <dt>
            <xsl:text> </xsl:text>
            <a>
              <xsl:attribute name="href">#<xsl:number level='single' count='section' />.<xsl:number level='single' count='entry'/></xsl:attribute>
              <xsl:number level='single' count='section' />.<xsl:number level='single' count='entry'/>
              <xsl:text> </xsl:text>
              <xsl:value-of select="header"/>
            </a>
          </dt>
        </xsl:for-each>
      </dl>
      
    </xsl:for-each>
    
    <hr/>
    
    <!-- Contents -->
    
    <xsl:for-each select='section'>
      
      <!-- Section title -->
      <h2>
        <a>
          <xsl:attribute name="id"><xsl:number level='single' count='section' /></xsl:attribute>
          <xsl:number level='single' count='section' />
          <xsl:text> </xsl:text>
          <xsl:value-of select="title"/>
        </a>
      </h2>
      
      
      <xsl:for-each select="entry">

            <h3>
              <xsl:attribute name="id"><xsl:number level='single' count='section' />.<xsl:number level='single' count='entry'/></xsl:attribute>
              <xsl:number level='single' count='section' />.<xsl:number level='single' count='entry'/>
              <xsl:text> </xsl:text>
              <xsl:value-of select="header"/>
            </h3>
            <div>
              <xsl:copy-of select="body"/>
            </div>
        
      </xsl:for-each>
      
    </xsl:for-each>
    
  </div>
  <div ID="foot">
  </div>
  <nolayer>
    <object data="http://www.nordugrid.org/styles/ngfooter.html" width="100%"/>
  </nolayer>
</body>
</html>

</xsl:template>


</xsl:stylesheet>
