/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.reporting.collation;

import com.jcoverage.coverage.reporting.collation.FieldHelper;
import com.jcoverage.coverage.reporting.collation.JavaFileLine;
import com.jcoverage.coverage.reporting.collation.JavaFilePage;
import com.jcoverage.coverage.reporting.collation.PackageSummaryPage;
import com.jcoverage.reporting.AbstractLine;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ReportSummaryPackageLine
extends AbstractLine
implements Line {
    static Logger logger = Logger.getLogger((Class)(class$com$jcoverage$coverage$reporting$collation$ReportSummaryPackageLine == null ? (class$com$jcoverage$coverage$reporting$collation$ReportSummaryPackageLine = ReportSummaryPackageLine.class$("com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine")) : class$com$jcoverage$coverage$reporting$collation$ReportSummaryPackageLine));
    public static Column COLUMN_PACKAGE_NAME = new Column("packagename", class$java$lang$String == null ? (class$java$lang$String = ReportSummaryPackageLine.class$("java.lang.String")) : class$java$lang$String);
    public static Column COLUMN_TOTAL_LINES = new Column("lines", class$java$lang$Integer == null ? (class$java$lang$Integer = ReportSummaryPackageLine.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static Column COLUMN_AVERAGE_COVERAGE = new Column("", class$java$lang$Double == null ? (class$java$lang$Double = ReportSummaryPackageLine.class$("java.lang.Double")) : class$java$lang$Double);
    public static Column COLUMN_AVERAGE_COVERAGE_PERCENT = new Column("%line", class$java$lang$Integer == null ? (class$java$lang$Integer = ReportSummaryPackageLine.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static Column COLUMN_BRANCH_AVERAGE_COVERAGE = new Column("", class$java$lang$Double == null ? (class$java$lang$Double = ReportSummaryPackageLine.class$("java.lang.Double")) : class$java$lang$Double);
    public static Column COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT = new Column("%branch", class$java$lang$Integer == null ? (class$java$lang$Integer = ReportSummaryPackageLine.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static Column COLUMN_TOTAL_JAVAFILES = new Column("files", class$java$lang$Integer == null ? (class$java$lang$Integer = ReportSummaryPackageLine.class$("java.lang.Integer")) : class$java$lang$Integer);
    static /* synthetic */ Class class$com$jcoverage$coverage$reporting$collation$ReportSummaryPackageLine;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public Page instantiateDetailPage() {
        return new PackageSummaryPage();
    }

    public Object getField(Column column) {
        Object o = super.getField(column);
        if (column.equals(COLUMN_TOTAL_LINES)) {
            this.getDetailPage().getLines(PackageSummaryPage.CATEGORY_JAVAFILES);
            return new Integer(this.getSourceLinesCount());
        }
        if (column.equals(COLUMN_AVERAGE_COVERAGE)) {
            return new Double(this.getAverageLineCoverageRate());
        }
        if (column.equals(COLUMN_AVERAGE_COVERAGE_PERCENT)) {
            return new Integer(FieldHelper.toPercent(this.getAverageLineCoverageRate()));
        }
        if (column.equals(COLUMN_BRANCH_AVERAGE_COVERAGE)) {
            return new Double(this.getAverageBranchCoverageRate());
        }
        if (column.equals(COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT)) {
            return new Integer(FieldHelper.toPercent(this.getAverageBranchCoverageRate()));
        }
        if (column.equals(COLUMN_TOTAL_JAVAFILES)) {
            return new Integer(this.getDetailPage().getLines(PackageSummaryPage.CATEGORY_JAVAFILES).size());
        }
        return o;
    }

    public int getSourceLinesCount() {
        int totalLines = 0;
        Iterator it = this.getDetailPage().getLines(PackageSummaryPage.CATEGORY_JAVAFILES).iterator();
        while (it.hasNext()) {
            totalLines += ((Integer)((Line)it.next()).getField(JavaFileLine.COLUMN_SOURCE_LINES)).intValue();
        }
        return totalLines;
    }

    public double getAverageLineCoverageRate() {
        int totalLines = 0;
        int coveredLines = 0;
        Iterator it = this.getDetailPage().getLines(PackageSummaryPage.CATEGORY_JAVAFILES).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            int sourceLineCount = (Integer)line.getField(JavaFileLine.COLUMN_SOURCE_LINES);
            totalLines += sourceLineCount;
            double rate = ((JavaFilePage)line.getDetailPage()).getLineCoverageRate();
            coveredLines += (int)((double)sourceLineCount * rate);
        }
        if (totalLines == 0) {
            return 1.0;
        }
        return (double)coveredLines / (double)totalLines;
    }

    public double getAverageBranchCoverageRate() {
        if (this.getDetailPage().getLines(PackageSummaryPage.CATEGORY_JAVAFILES).isEmpty()) {
            return 1.0;
        }
        double total = 0.0;
        Iterator it = this.getDetailPage().getLines(PackageSummaryPage.CATEGORY_JAVAFILES).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            total += ((Double)line.getField(JavaFileLine.COLUMN_BRANCH_COVERAGE)).doubleValue();
        }
        return total / (double)this.getDetailPage().getLines(PackageSummaryPage.CATEGORY_JAVAFILES).size();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

