!
!  aperture photometry
!
!  Copyright © 2010-17 F.Hroch (hroch@physics.muni.cz)
!
!  This file is part of Munipack.
!
!  Munipack is free software: you can redistribute it and/or modify
!  it under the terms of the GNU General Public License as published by
!  the Free Software Foundation, either version 3 of the License, or
!  (at your option) any later version.
!
!  Munipack is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU General Public License for more details.
!
!  You should have received a copy of the GNU General Public License
!  along with Munipack.  If not, see <http://www.gnu.org/licenses/>.


program aphot

  use fitsio
  use fitsaphot
  use mdaofotometr

  implicit none

  character(len=4*FLEN_FILENAME) :: record,key,val
  character(len=FLEN_FILENAME) :: outname, file,backup, output = ''
  real, dimension(:), allocatable :: apertures
  real, dimension(2) :: ring
  logical :: verbose = .false., plog = .false.
  integer :: i,eq,status,naper

  ! we predefine radii of apertures as the logarithmic spiral,
  ! pitch 9.84 deg, apertures(1) = 1, .. apertures(12) = 20
  allocate(apertures(12))
  forall( i = 1:size(apertures) )
     apertures(i) = exp(0.17338*((i-1)*1.570796327))
  end forall
  ring = (/20.0, 30.0/)

  do
     read(*,'(a)',end=20) record

     eq = index(record,'=')
     if( eq == 0 ) stop 'Improper input.'
     key = record(:eq-1)
     val = record(eq+1:)

     if( key == 'VERBOSE' ) then

        read(val,*) verbose

     else if( key == 'PIPELOG' ) then

        read(val,*) plog

     else if( key == 'NAPERTURES' ) then

        read(val,*) naper
        deallocate(apertures)
        allocate(apertures(naper))

     else if( key == 'APERTURES' ) then

        read(val,*) apertures

     else if( key == 'RING' ) then

        read(val,*) ring

     else if( key == 'FILE' ) then

        read(val,*) file, backup, output

        status = 0
        call fitsback(file,backup,output,.false.,outname,status)
        call faphot(outname,apertures,ring,verbose,plog)

     end if

  end do

20 continue

  deallocate(apertures)

  stop 0

end program aphot
